#!/usr/bin/python3.5

import sys
import scipy
import numpy as np
import matplotlib
matplotlib.use('TkAgg') 
import matplotlib.pyplot as plt
import pylab
import time as tim

    #grid and array
tmax = 10.0
dt = 0.01
time = np.arange(0.0, tmax, dt)
lambd = 100.0

# du/dt = -lambda * (u -sin (t))
# initial conditions
u = np.zeros(len(time))
u[0] = 1.0

for i in range (len(time)-1):
    dudt = -lambd * (u [i] - np.sin (time[i]))
    u [i+1] = u [i]  + dt * dudt

plt.ion()
plt.clf()
plt.xlabel ('t')
plt.ylabel ('u')
c1, = plt.plot(time,u,label='numerical solution')
c2, = plt.plot(time,np.sin(time),ls='dashed',label=r'$\sin t$')
plt.legend(handles=[c1,c2])
plt.draw()
plt.show(block = True)

        
        
