#/usr/bin/ipython3 --pylab

#if __name__ == "__main__":

import sys
import scipy
import numpy as np
import matplotlib
matplotlib.use('TkAgg') 
import matplotlib.pyplot as plt
import pylab
import time as tim

    #grid and array
tmax = 10.0
dt = 0.2
time = np.arange(0.0, tmax, dt)
lambd = 100.0

# du/dt = -lambda * (u -sin (t))
# initial conditions
u = np.zeros(len(time))
u[0] = 1.0


for i in range (len(time)-1):
# Equation to solve:
# du/dt = - lambda * (u+du-sin(t)) 
# du * (1/dt+lambda) = - lambda * (u-sin(t))
    du = -lambd * (u [i] - np.sin (time[i+1])) / (1/dt + lambd)
    u [i+1] = u [i]  + du

plt.ion()
plt.clf()
plt.xlabel ('x')
plt.ylabel ('u')
plt.plot(time,u)
plt.plot(time,np.sin(time),ls='dashed')
plt.draw()
plt.show(block = True)

        
        
