(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    312796,       7530]
NotebookOptionsPosition[    307002,       7428]
NotebookOutlinePosition[    307470,       7445]
CellTagsIndexPosition[    307427,       7442]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"matthewsPhi", "[", 
     RowBox[{"predict_", ",", "actual_"}], "]"}], ":=", 
    RowBox[{"Block", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"n", "=", 
         RowBox[{"Length", "[", "predict", "]"}]}], ",", 
        RowBox[{"TP", "=", "0"}], ",", 
        RowBox[{"FP", "=", "0"}], ",", 
        RowBox[{"FN", "=", "0"}], ",", 
        RowBox[{"TN", "=", "0"}]}], "}"}], "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "establish", " ", "confusion", " ", "matrix", " ", "of", " ", "TP"}], 
        ",", " ", "FP", ",", " ", "FN", ",", " ", "TN"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"predict", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "1"}], "&&", 
             RowBox[{
              RowBox[{"actual", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "1"}]}], ",", 
            RowBox[{"TP", "=", 
             RowBox[{"TP", "+", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"predict", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "1"}], "&&", 
             RowBox[{
              RowBox[{"actual", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
            RowBox[{"FP", "=", 
             RowBox[{"FP", "+", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"predict", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
             RowBox[{
              RowBox[{"actual", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "1"}]}], ",", 
            RowBox[{"FN", "=", 
             RowBox[{"FN", "+", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"predict", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
             RowBox[{
              RowBox[{"actual", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}]}], ",", 
            RowBox[{"TN", "=", 
             RowBox[{"TN", "+", "1"}]}]}], "]"}]}], "\[IndentingNewLine]", 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"MatrixForm", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"TP", ",", "FP"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"FN", ",", "TN"}], "}"}]}], "}"}], "]"}], "]"}], ";"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"TP", " ", "TN"}], "-", 
           RowBox[{"FP", " ", "FN"}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"TP", "+", "FP"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"TP", "+", "FN"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"TN", "+", "FP"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"TN", "+", "FN"}], ")"}]}], "]"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"confusion", "[", 
    RowBox[{"actual_", ",", "predict_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "tt", ",", "kmax", ",", "kmin", ",", "k", ",", "i", ",", "res", ",", 
       "add"}], "}"}], ",", 
     RowBox[{
      RowBox[{"tt", "=", 
       RowBox[{"Tally", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"actual", ",", "predict"}], "}"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"kmax", "=", 
       RowBox[{"Max", "[", "actual", "]"}]}], ";", 
      RowBox[{"kmin", "=", 
       RowBox[{"Min", "[", "actual", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "Just", " ", "to", " ", "normalize", " ", "the", " ", "category", " ",
          "names", " ", "to", " ", "1"}], ",", "..", ",", 
        RowBox[{"k", ";", "\[IndentingNewLine]", 
         RowBox[{"e", ".", "g", "."}]}], ",", 
        RowBox[{
         RowBox[{
         "the", " ", "classes", " ", "could", " ", "have", " ", "been", " ", 
          "called", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], " ", "in", " ", "a", " ", "binary",
           " ", "classification"}], ";", 
         RowBox[{
         "but", " ", "want", " ", "to", " ", "rename", " ", "those", " ", 
          "to", " ", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], " ", "to", " ", "conform", " ", 
          "to", " ", "the", " ", "counter", " ", "in", " ", "matrices"}]}]}], 
       "*)"}], 
      RowBox[{"k", "=", 
       RowBox[{"kmax", "-", "kmin", "+", "1"}]}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"add", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"1", "-", "kmin"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tt", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", "add"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ")"}], "&"}], "/@", 
        "tt"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"res", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "k"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "k"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "<=", 
            RowBox[{"tt", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1", ",", "1"}], "]"}], "]"}], "<=", "k"}], "&&", 
           RowBox[{"1", "<=", 
            RowBox[{"tt", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "<=", "k"}]}], 
          ",", 
          RowBox[{
           RowBox[{"res", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"tt", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"tt", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}]}], "]"}], 
            "]"}], "=", 
           RowBox[{"tt", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"Length", "[", "tt", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "res", "]"}], ";"}]}], "]"}]}], ";"}]}], "Input",\

 CellChangeTimes->{{3.8510104433030453`*^9, 3.851010450471455*^9}, {
  3.851014623785575*^9, 3.851014624529045*^9}, {3.851014987979063*^9, 
  3.85101499021281*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"15c9569f-f7ea-4672-957a-57f76fc7eb1a"],

Cell["Read in the CY3 in Weighted Projective CP4", "Text",
 CellChangeTimes->{{3.851010875368285*^9, 3.851010898024353*^9}},
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"4d6922f5-c420-48d5-8527-cd4f9b1ee34f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cy3", "=", 
  RowBox[{"<<", "WP4CY3.math"}]}]], "Input",
 CellChangeTimes->{{3.851010833251286*^9, 3.8510108515039673`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"48854ceb-23ab-4001-aae5-18fa04e2d620"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
             ",", 
             RowBox[{"-", "200"}], ",", "1", ",", "101"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "2"}], "}"}], 
             ",", 
             RowBox[{"-", "204"}], ",", "1", ",", "103"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "3"}], "}"}], 
             ",", 
             RowBox[{"-", "240"}], ",", "2", ",", "122"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2"}], "}"}], 
             ",", 
             RowBox[{"-", "186"}], ",", "2", ",", "95"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "4"}], "}"}], 
             ",", 
             RowBox[{"-", "296"}], ",", "1", ",", "149"}], "}"}], ",", 
           TemplateBox[{"7546"},
            "OutputSizeLimit`Skeleton"], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"28", ",", "41", ",", "414", ",", "966", ",", "1449"}], 
              "}"}], ",", "804", ",", "416", ",", "14"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"36", ",", "41", ",", "421", ",", "996", ",", "1494"}], 
              "}"}], ",", "960", ",", "491", ",", "11"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"36", ",", "41", ",", "462", ",", "1078", ",", "1617"}],
               "}"}], ",", "900", ",", "462", ",", "12"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"41", ",", "42", ",", "498", ",", "1162", ",", "1743"}],
               "}"}], ",", "960", ",", "491", ",", "11"}], "}"}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 4, 27201539309432565579, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 4, 27201539309432565579, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 4, 27201539309432565579, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[27201539309432565579 === $SessionID, 
   Out[4], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.851010852344726*^9, 3.851142092737134*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"93353efa-16fa-49f5-bdcd-c7b6e024833e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting up Data", "Section",
 CellChangeTimes->{{3.85101361916862*^9, 
  3.851013641167673*^9}},ExpressionUUID->"c7c14a98-78ce-4410-9b32-\
db04338e2960"],

Cell["Distribution of H11 and H21", "Text",
 CellChangeTimes->{{3.8510109242853928`*^9, 
  3.8510109622602367`*^9}},ExpressionUUID->"0f19135b-9207-4186-a082-\
19752c640881"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", "3", "]"}], "]"}], "&"}], "/@", "cy3"}], "]"}]], "Input",
 CellChangeTimes->{{3.851011005641926*^9, 3.851011069914721*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"4bce5f15-fb1e-4360-8b26-9137ddd3cecd"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.476], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.476], Thickness[Small]}], RectangleBox[{0., 0}, {10., 261.},
      RoundingRadius->0], RectangleBox[{10., 0}, {20., 685.},
      RoundingRadius->0], RectangleBox[{20., 0}, {30., 793.},
      RoundingRadius->0], RectangleBox[{30., 0}, {40., 736.},
      RoundingRadius->0], RectangleBox[{40., 0}, {50., 602.},
      RoundingRadius->0], RectangleBox[{50., 0}, {60., 559.},
      RoundingRadius->0], RectangleBox[{60., 0}, {70., 518.},
      RoundingRadius->0], RectangleBox[{70., 0}, {80., 426.},
      RoundingRadius->0], RectangleBox[{80., 0}, {90., 412.},
      RoundingRadius->0], RectangleBox[{90., 0}, {100., 362.},
      RoundingRadius->0], RectangleBox[{100., 0}, {110., 304.},
      RoundingRadius->0], RectangleBox[{110., 0}, {120., 262.},
      RoundingRadius->0], RectangleBox[{120., 0}, {130., 260.},
      RoundingRadius->0], RectangleBox[{130., 0}, {140., 165.},
      RoundingRadius->0], RectangleBox[{140., 0}, {150., 204.},
      RoundingRadius->0], RectangleBox[{150., 0}, {160., 145.},
      RoundingRadius->0], RectangleBox[{160., 0}, {170., 124.},
      RoundingRadius->0], RectangleBox[{170., 0}, {180., 109.},
      RoundingRadius->0], RectangleBox[{180., 0}, {190., 79.},
      RoundingRadius->0], RectangleBox[{190., 0}, {200., 83.},
      RoundingRadius->0], RectangleBox[{200., 0}, {210., 55.},
      RoundingRadius->0], RectangleBox[{210., 0}, {220., 58.},
      RoundingRadius->0], RectangleBox[{220., 0}, {230., 62.},
      RoundingRadius->0], RectangleBox[{230., 0}, {240., 32.},
      RoundingRadius->0], RectangleBox[{240., 0}, {250., 27.},
      RoundingRadius->0], RectangleBox[{250., 0}, {260., 43.},
      RoundingRadius->0], RectangleBox[{260., 0}, {270., 27.},
      RoundingRadius->0], RectangleBox[{270., 0}, {280., 26.},
      RoundingRadius->0], RectangleBox[{280., 0}, {290., 18.},
      RoundingRadius->0], RectangleBox[{290., 0}, {300., 17.},
      RoundingRadius->0], RectangleBox[{300., 0}, {310., 19.},
      RoundingRadius->0], RectangleBox[{310., 0}, {320., 8.},
      RoundingRadius->0], RectangleBox[{320., 0}, {330., 13.},
      RoundingRadius->0], RectangleBox[{330., 0}, {340., 12.},
      RoundingRadius->0], RectangleBox[{340., 0}, {350., 8.},
      RoundingRadius->0], RectangleBox[{350., 0}, {360., 4.},
      RoundingRadius->0], RectangleBox[{370., 0}, {380., 11.},
      RoundingRadius->0], RectangleBox[{380., 0}, {390., 5.},
      RoundingRadius->0], RectangleBox[{410., 0}, {420., 7.},
      RoundingRadius->0], RectangleBox[{430., 0}, {440., 3.},
      RoundingRadius->0], RectangleBox[{460., 0}, {470., 7.},
      RoundingRadius->0], RectangleBox[{490., 0}, {500., 4.},
      RoundingRadius->
       0]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6., 0},
  BaseStyle->{FontFamily -> "Arial"},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{0, 300}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.851011025106715*^9, 3.851011070364255*^9}},
 CellLabel->"Out[24]=",ExpressionUUID->"6d056553-3bbe-4ac6-a918-ebe7984a6aaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "&"}], "/@", "cy3"}], "]"}]], "Input",
 CellChangeTimes->{{3.851011077739057*^9, 3.8510110779582357`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"4c2c1aaa-a0f7-4bb7-b3f6-e82574577346"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.5389999999999999], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.5389999999999999], Thickness[Small]}], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{0., 0}, {10., 725.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{31.15832666132907, 
           46.916247283541125`}, {-11.679634598241975`, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 725]& ,
        TagBoxNote->"725"],
       StyleBox["725", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[725, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{10., 0}, {20., 1334.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{46.416247283541125`, 
           62.17416790575318}, {-99.25867538293922, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1334]& ,
        TagBoxNote->"1334"],
       StyleBox["1334", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1334, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{20., 0}, {30., 1104.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{61.67416790575318, 
           77.43208852796523}, {-66.18284717196981, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1104]& ,
        TagBoxNote->"1104"],
       StyleBox["1104", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1104, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{30., 0}, {40., 847.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{76.93208852796523, 
           92.69000915017729}, {-29.2242043449301, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 847]& ,
        TagBoxNote->"847"],
       StyleBox["847", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[847, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{40., 0}, {50., 611.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{92.19000915017729, 107.94792977238934`}, {
           4.714471558499369, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 611]& ,
        TagBoxNote->"611"],
       StyleBox["611", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[611, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{50., 0}, {60., 490.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{107.44792977238934`, 123.2058503946014}, {
           22.11523335644415, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 490]& ,
        TagBoxNote->"490"],
       StyleBox["490", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[490, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{60., 0}, {70., 437.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{122.7058503946014, 138.46377101681344`}, {
           29.73705463984144, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 437]& ,
        TagBoxNote->"437"],
       StyleBox["437", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[437, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{70., 0}, {80., 339.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{137.96377101681344`, 153.7216916390255}, {
           43.83023361668927, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 339]& ,
        TagBoxNote->"339"],
       StyleBox["339", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[339, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{80., 0}, {90., 297.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{153.2216916390255, 168.97961226123755`}, {
           49.87016746390977, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 297]& ,
        TagBoxNote->"297"],
       StyleBox["297", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[297, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{90., 0}, {100., 246.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{168.47961226123755`, 184.2375328834496}, {
           57.20437284982038, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 246]& ,
        TagBoxNote->"246"],
       StyleBox["246", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[246, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{100., 0}, {110., 191.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{183.7375328834496, 199.49545350566166`}, {
           65.11381003070437, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 191]& ,
        TagBoxNote->"191"],
       StyleBox["191", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[191, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{110., 0}, {120., 168.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{198.99545350566166`, 214.7533741278737}, {
           68.4213928518013, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 168]& ,
        TagBoxNote->"168"],
       StyleBox["168", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[168, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{120., 0}, {130., 139.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{214.2533741278737, 230.01129475008577`}, {
           72.59182336535832, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 139]& ,
        TagBoxNote->"139"],
       StyleBox["139", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[139, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{130., 0}, {140., 96.}, "RoundingRadius" -> 0]},
          ImageSizeCache->{{229.51129475008577`, 245.26921537229782`}, {
           78.77556516132216, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 96]& ,
        TagBoxNote->"96"],
       StyleBox["96", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[96, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{140., 0}, {150., 109.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{244.76921537229782`, 260.5271359945099}, {
           76.90606182765868, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 109]& ,
        TagBoxNote->"109"],
       StyleBox["109", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[109, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{150., 0}, {160., 69.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{260.0271359945099, 275.78505661672193`}, {
           82.65837977739248, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 69]& ,
        TagBoxNote->"69"],
       StyleBox["69", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[69, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{160., 0}, {170., 62.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{275.28505661672193`, 291.042977238934}, {
           83.66503541859589, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 62]& ,
        TagBoxNote->"62"],
       StyleBox["62", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[62, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{170., 0}, {180., 50.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{290.542977238934, 306.30089786114604`}, {
           85.39073080351604, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 50]& ,
        TagBoxNote->"50"],
       StyleBox["50", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[50, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{180., 0}, {190., 34.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{305.80089786114604`, 321.5588184833581}, {
           87.69165798340956, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 34]& ,
        TagBoxNote->"34"],
       StyleBox["34", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[34, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{190., 0}, {200., 31.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{321.0588184833581, 336.81673910557015`}, {
           88.1230818296396, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 31]& ,
        TagBoxNote->"31"],
       StyleBox["31", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[31, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{200., 0}, {210., 22.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{336.31673910557015`, 352.0746597277822}, {
           89.4173533683297, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 22]& ,
        TagBoxNote->"22"],
       StyleBox["22", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[22, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{210., 0}, {220., 15.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{351.5746597277822, 367.33258034999426`}, {
           90.42400900953312, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 15]& ,
        TagBoxNote->"15"],
       StyleBox["15", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[15, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{220., 0}, {230., 27.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{366.83258034999426`, 382.5905009722063}, {
           88.69831362461298, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 27]& ,
        TagBoxNote->"27"],
       StyleBox["27", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[27, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{230., 0}, {240., 17.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{382.0905009722063, 397.84842159441837`}, {
           90.13639311204643, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 17]& ,
        TagBoxNote->"17"],
       StyleBox["17", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[17, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{240., 0}, {250., 12.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{397.34842159441837`, 413.1063422166304}, {
           90.85543285576315, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 12]& ,
        TagBoxNote->"12"],
       StyleBox["12", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[12, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{250., 0}, {260., 28.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{412.6063422166304, 428.3642628388425}, {
           88.55450567586963, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 28]& ,
        TagBoxNote->"28"],
       StyleBox["28", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[28, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{260., 0}, {270., 11.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{427.8642628388425, 443.62218346105453`}, {
           90.9992408045065, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 11]& ,
        TagBoxNote->"11"],
       StyleBox["11", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[11, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{270., 0}, {280., 9.}, "RoundingRadius" -> 0]},
          ImageSizeCache->{{443.12218346105453`, 458.8801040832666}, {
           91.28685670199319, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 9]& ,
        TagBoxNote->"9"],
       StyleBox["9", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[9, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{280., 0}, {290., 8.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{458.3801040832666, 474.13802470547864`}, {
           91.43066465073653, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 8]& ,
        TagBoxNote->"8"],
       StyleBox["8", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[8, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{290., 0}, {300., 3.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{473.63802470547864`, 489.3959453276907}, {
           92.14970439445327, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 3]& ,
        TagBoxNote->"3"],
       StyleBox["3", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[3, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{300., 0}, {310., 6.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{488.8959453276907, 504.65386594990275`}, {
           91.71828054822323, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 6]& ,
        TagBoxNote->"6"],
       StyleBox["6", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[6, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{310., 0}, {320., 3.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{504.15386594990275`, 519.9117865721148}, {
           92.14970439445327, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 3]& ,
        TagBoxNote->"3"],
       StyleBox["3", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[3, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{320., 0}, {330., 2.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{519.4117865721148, 535.169707194327}, {
           92.29351234319661, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 2]& ,
        TagBoxNote->"2"],
       StyleBox["2", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[2, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{330., 0}, {340., 3.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{534.669707194327, 550.4276278165389}, {
           92.14970439445327, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 3]& ,
        TagBoxNote->"3"],
       StyleBox["3", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[3, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{340., 0}, {350., 2.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{549.9276278165389, 565.685548438751}, {
           92.29351234319661, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 2]& ,
        TagBoxNote->"2"],
       StyleBox["2", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[2, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{350., 0}, {360., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{565.185548438751, 580.943469060963}, {
           92.43732029193995, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{370., 0}, {380., 3.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{595.7013896831751, 611.4593103053871}, {
           92.14970439445327, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 3]& ,
        TagBoxNote->"3"],
       StyleBox["3", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[3, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{380., 0}, {390., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{610.9593103053871, 626.7172309275992}, {
           92.43732029193995, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{410., 0}, {420., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{656.7330721720233, 672.4909927942354}, {
           92.43732029193995, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{460., 0}, {470., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{733.0226752830836, 748.7805959052956}, {
           92.43732029193995, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{490., 0}, {500., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{778.7964371497197, 794.5543577719318}, {
           92.43732029193995, 93.0811282406833}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], 
       "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-4.2, 0},
  BaseStyle->{FontFamily -> "Arial"},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{0, 210}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8510110782309093`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"18f61689-7756-4fa1-97fd-7fe337ee59a4"]
}, Open  ]],

Cell["Distribution of Euler number", "Text",
 CellChangeTimes->{{3.8510111146316957`*^9, 
  3.8510111351862907`*^9}},ExpressionUUID->"a203c468-9dc3-427b-9245-\
155d5dd601c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "cy3"}], "]"}]], "Input",
 CellChangeTimes->{{3.851011111012721*^9, 3.851011126950657*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"921b3c21-a5ee-47e5-8dad-e9d672908669"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
    Opacity[0.5459999999999999], Thickness[Small]}], {}, 
    {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], EdgeForm[{
     Opacity[0.5459999999999999], Thickness[Small]}], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-1000., 0}, {-900., 1.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{31.083333333333314`, 47.41666666666663}, {
           88.95161613083789, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1]& ,
        TagBoxNote->"1"],
       StyleBox["1", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-900., 0}, {-800., 2.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{46.91666666666663, 63.24999999999997}, {
           88.86516159287295, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 2]& ,
        TagBoxNote->"2"],
       StyleBox["2", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[2, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-800., 0}, {-700., 4.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{62.74999999999997, 79.0833333333333}, {
           88.69225251694306, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 4]& ,
        TagBoxNote->"4"],
       StyleBox["4", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[4, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-700., 0}, {-600., 8.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{78.5833333333333, 94.91666666666663}, {
           88.34643436508327, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 8]& ,
        TagBoxNote->"8"],
       StyleBox["8", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[8, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-600., 0}, {-500., 19.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{94.41666666666663, 110.74999999999997`}, {
           87.39543444746884, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 19]& ,
        TagBoxNote->"19"],
       StyleBox["19", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[19, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-500., 0}, {-400., 53.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{110.24999999999997`, 126.5833333333333}, {
           84.45598015666064, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 53]& ,
        TagBoxNote->"53"],
       StyleBox["53", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[53, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-400., 0}, {-300., 101.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{126.0833333333333, 142.41666666666663`}, {
           80.30616233434318, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 101]& ,
        TagBoxNote->"101"],
       StyleBox["101", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[101, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-300., 0}, {-200., 309.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{141.91666666666663`, 158.24999999999997`}, {
           62.32361843763416, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 309]& ,
        TagBoxNote->"309"],
       StyleBox["309", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[309, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-200., 0}, {-100., 759.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{157.74999999999997`, 174.0833333333333}, {
           23.419076353407917`, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 759]& ,
        TagBoxNote->"759"],
       StyleBox["759", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[759, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{-100., 0}, {0., 1452.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{173.5833333333333, 
           189.91666666666663`}, {-36.49391845630049, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1452]& ,
        TagBoxNote->"1452"],
       StyleBox["1452", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1452, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{0., 0}, {100., 2193.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{189.41666666666663`, 
           205.74999999999997`}, {-100.55673108832636`, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 2193]& ,
        TagBoxNote->"2193"],
       StyleBox["2193", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[2193, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{100., 0}, {200., 1275.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{205.24999999999997`, 
           221.5833333333333}, {-21.19146523650484, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 1275]& ,
        TagBoxNote->"1275"],
       StyleBox["1275", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[1275, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{200., 0}, {300., 722.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{221.0833333333333, 237.41666666666663`}, {
           26.617894258110965`, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 722]& ,
        TagBoxNote->"722"],
       StyleBox["722", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[722, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{300., 0}, {400., 326.}, "RoundingRadius" -> 0]},
          ImageSizeCache->{{236.91666666666663`, 253.24999999999994`}, {
           60.85389129223006, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 326]& ,
        TagBoxNote->"326"],
       StyleBox["326", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[326, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{400., 0}, {500., 175.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{252.74999999999994`, 269.08333333333326`}, {
           73.90852652493709, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 175]& ,
        TagBoxNote->"175"],
       StyleBox["175", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[175, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{500., 0}, {600., 82.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{268.58333333333326`, 284.91666666666663`}, {
           81.94879855567717, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 82]& ,
        TagBoxNote->"82"],
       StyleBox["82", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[82, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{600., 0}, {700., 37.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{284.41666666666663`, 300.74999999999994`}, {
           85.8392527640998, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 37]& ,
        TagBoxNote->"37"],
       StyleBox["37", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[37, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{700., 0}, {800., 16.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{300.24999999999994`, 316.58333333333326`}, {
           87.65479806136369, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 16]& ,
        TagBoxNote->"16"],
       StyleBox["16", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[16, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{800., 0}, {900., 10.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{316.08333333333326`, 332.41666666666663`}, {
           88.17352528915337, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 10]& ,
        TagBoxNote->"10"],
       StyleBox["10", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[10, {}], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       TagBox[
        TagBox[
         DynamicBox[{
           FEPrivate`If[
            CurrentValue["MouseOver"], 
            EdgeForm[{
              GrayLevel[0.5], 
              AbsoluteThickness[1.5], 
              Opacity[0.66]}], {}, {}], 
           RectangleBox[{900., 0}, {1000., 11.}, "RoundingRadius" -> 0]},
          
          ImageSizeCache->{{331.91666666666663`, 348.24999999999994`}, {
           88.08707075118842, 89.53807066880285}}],
         "DelayedMouseEffectStyle"],
        StatusArea[#, 11]& ,
        TagBoxNote->"11"],
       StyleBox["11", {}, StripOnInput -> False]],
      Annotation[#, 
       Style[11, {}], 
       "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-1040., 0},
  BaseStyle->{FontFamily -> "Arial"},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  PlotRange->{{-1000., 1000.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.851011127182396*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"2d79a655-5987-4d69-9706-f2c9442cdbd0"]
}, Open  ]],

Cell["\<\
Create LABELED Binary Data :
5-vector ->  1 if h11 >= 50; 5-vector -> 0 if h11 < 50\
\>", "Text",
 CellChangeTimes->{{3.851011143434594*^9, 3.851011187041383*^9}, 
   3.851011249572154*^9},ExpressionUUID->"f0035f8d-2f0e-4c60-9b71-\
23b9d7a02a75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ddd", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"cy3", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}], "\[Rule]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"cy3", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "3"}], "]"}], "]"}], ">=", "50"}], ",", "1", ",", 
       "0"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "cy3", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851011224509891*^9, 3.851011264276587*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"9bd2b978-5920-4fb7-bbb6-bd5797b9092f"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "2"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "3"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "4"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "3"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "2", ",", "2", ",", "2"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "4"}], "}"}], 
            "\[Rule]", "0"}], ",", 
           TemplateBox[{"7540"},
            "OutputSizeLimit`Skeleton"], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"21", ",", "41", ",", "372", ",", "868", ",", "1302"}], 
             "}"}], "\[Rule]", "1"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"31", ",", "41", ",", "391", ",", "926", ",", "1389"}], 
             "}"}], "\[Rule]", "1"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"31", ",", "42", ",", "396", ",", "938", ",", "1407"}], 
             "}"}], "\[Rule]", "1"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"28", ",", "41", ",", "414", ",", "966", ",", "1449"}], 
             "}"}], "\[Rule]", "1"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"36", ",", "41", ",", "421", ",", "996", ",", "1494"}], 
             "}"}], "\[Rule]", "1"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"36", ",", "41", ",", "462", ",", "1078", ",", "1617"}], 
             "}"}], "\[Rule]", "1"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"41", ",", "42", ",", "498", ",", "1162", ",", "1743"}], 
             "}"}], "\[Rule]", "1"}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{59., {2., 8.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{51., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 9, 27201539309432565579, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{56., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 9, 27201539309432565579, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{42., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 9, 27201539309432565579, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{77., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[27201539309432565579 === $SessionID, 
   Out[9], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.851011264757782*^9, 3.8511425171379642`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"b04743dc-5ac7-4b5d-8fab-c8531e878289"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "ddd"}], "]"}]], "Input",
 CellChangeTimes->{{3.851011290842176*^9, 3.851011299064657*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"60f434d4-5f36-4465-b0ad-89964e66973f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "3077"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4478"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.851011299462825*^9, 3.851142520294724*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"7edfc5b2-9361-41e4-a11d-49d228a3669d"]
}, Open  ]],

Cell["Split in Training and Test Set", "Text",
 CellChangeTimes->{{3.851011355455987*^9, 
  3.851011370334544*^9}},ExpressionUUID->"352d6c36-20fe-4311-8904-\
3858cad45932"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"trainingSet", "=", 
   RowBox[{"RandomSample", "[", 
    RowBox[{"ddd", ",", "2000"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"testSet", "=", 
   RowBox[{"Complement", "[", 
    RowBox[{"ddd", ",", "trainingSet"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"valSet", "=", 
   RowBox[{"RandomSample", "[", 
    RowBox[{"testSet", ",", "500"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.851011373519202*^9, 3.851011457979454*^9}, {
  3.8510115632287416`*^9, 3.851011564088056*^9}, {3.851142488154171*^9, 
  3.851142488612711*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"88275639-ab57-4233-b14d-8699cf8426ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Classifier", "Section",
 CellChangeTimes->{{3.851013667384734*^9, 
  3.851013678416851*^9}},ExpressionUUID->"88e5e2cb-a950-4a9e-bd20-\
f13cff8d974b"],

Cell["Create MLP :  Forward - feed NN Classifier", "Text",
 CellChangeTimes->{{3.851012748125457*^9, 
  3.8510127591192904`*^9}},ExpressionUUID->"c7131038-8fda-4d26-a2d8-\
8711559bc755"],

Cell[BoxData[
 RowBox[{
  RowBox[{"net", "=", 
   RowBox[{"NetChain", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"LinearLayer", "[", "100", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ElementwiseLayer", "[", "LogisticSigmoid", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ElementwiseLayer", "[", "Tanh", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LinearLayer", "[", "2", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"SoftmaxLayer", "[", "]"}]}], "\[IndentingNewLine]", "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Input\>\"", "\[Rule]", 
      RowBox[{"{", "5", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Output\>\"", "->", 
      RowBox[{"NetDecoder", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<Class\>\"", ",", 
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "1"}], "]"}]}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851012124605146*^9, 3.851012128686284*^9}, {
  3.851012625184699*^9, 3.851012654553574*^9}, {3.851012685345866*^9, 
  3.851012707397634*^9}, {3.851012920649885*^9, 3.851012950170767*^9}, {
  3.8510132340212097`*^9, 3.851013361042761*^9}, {3.8510134027874937`*^9, 
  3.8510134156977873`*^9}, {3.851013454515264*^9, 3.851013481671134*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"ddd6e5ed-813a-4d2b-8bcc-d40054b2d8a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", 
  RowBox[{"net", ",", "\"\<FullSummaryGraphic\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.851014201208857*^9, 3.851014218522237*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"0640c3e6-2efb-4542-8ea0-ff9a5ac0fefc"],

Cell[BoxData[
 GraphicsBox[{{
    StyleBox[{
      InsetBox["\<\"Input\"\>", 
       Offset[{0, -7}, {-5.999999999999998, 1.6076938217470707*^-7}], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"1\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-4.999999999999998, 
         1.339744851455892*^-7}], 
        Offset[{0, -13.5}, {-4.999999999999998, 1.339744851455892*^-7}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"2\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}], 
        Offset[{0, -13.5}, {-3.9999999999999987`, 1.0717958811647137`*^-7}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"3\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-2.999999999999999, 
         8.038469108735353*^-8}], 
        Offset[{0, -13.5}, {-2.999999999999999, 8.038469108735353*^-8}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"4\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-1.9999999999999993`, 
         5.3589794058235685`*^-8}], 
        Offset[{0, -13.5}, {-1.9999999999999993`, 5.3589794058235685`*^-8}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"5\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-0.9999999999999997, 
         2.6794897029117842`*^-8}], 
        Offset[{0, -13.5}, {-0.9999999999999997, 2.6794897029117842`*^-8}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"Output\"\>", Offset[{0, -7}, {0., 0.}], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}]},
     StripOnInput->False,
     FontColor->GrayLevel[0.5]], 
    StyleBox[{
      InsetBox["\<\"5\"\>", 
       Offset[{1.473719336601482*^-7, 5.499999999999999}, \
{-5.4499999999999975, 1.4603218880869225*^-7}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117856`*^-8}], 
      InsetBox["\<\"100\"\>", 
       Offset[{1.4737193366014812*^-7, 5.499999999999999}, \
{-4.449999999999998, 1.192372917795744*^-7}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117842`*^-8}], 
      InsetBox["\<\"100\"\>", 
       Offset[{1.4737193366014812*^-7, 5.499999999999999}, \
{-3.449999999999999, 9.244239475045655*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117842`*^-8}], 
      InsetBox["\<\"100\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-2.4499999999999993, 6.564749772133872*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.679489702911785*^-8}], 
      InsetBox["\<\"2\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-1.4499999999999993, 3.885260069222087*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999999, -2.679489702911785*^-8}], 
      InsetBox["\<\"2\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-0.4499999999999998, 1.2057703663103027*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999999, -2.679489702911785*^-8}]},
     StripOnInput->False,
     FontSize->8,
     FontWeight->"Thin",
     FontColor->GrayLevel[0.7]]}, 
   {GrayLevel[0.7], 
    TagBox[
     TooltipBox[
      LineBox[{{-5.999999999999998, 
       1.6076938217470707`*^-7}, {-4.999999999999998, 1.339744851455892*^-7}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 5\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Input\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    
                    Offset[{0, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 5\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Input", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  
                  Offset[{0, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-4.999999999999998, 
       1.339744851455892*^-7}, {-3.9999999999999987`, 
       1.0717958811647137`*^-7}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-3.9999999999999987`, 
       1.0717958811647137`*^-7}, {-2.999999999999999, 8.038469108735353*^-8}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-2.999999999999999, 
       8.038469108735353*^-8}, {-1.9999999999999993`, 
       5.3589794058235685`*^-8}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-1.9999999999999993`, 
       5.3589794058235685`*^-8}, {-0.9999999999999997, 
       2.6794897029117842`*^-8}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 2\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 2\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 0.}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 2\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    Offset[{0, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Output\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 2\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  Offset[{0, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Output"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ]}, {
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-5.4499999999999975, 1.4603218880869225*^-7}, {-0.25, 0}, Offset[8], {
       1., -2.6794897029117862`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 5\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Input\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    
                    Offset[{0, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 5\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Input", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  
                  Offset[{0, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-4.449999999999998, 1.192372917795744*^-7}, {-0.25, 0}, Offset[8], {
       0.9999999999999996, -2.6794897029117836`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-3.449999999999999, 9.244239475045655*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999996, -2.6794897029117836`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-2.4499999999999993, 6.564749772133872*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999998, -2.679489702911785*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-1.4499999999999993, 3.885260069222087*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999997, -2.6794897029117842`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 2\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 2\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-0.4499999999999998, 1.2057703663103027*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999997, -2.6794897029117842`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 2\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    Offset[{0, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Output\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 2\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  Offset[{0, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Output"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ]}, 
   {EdgeForm[AbsoluteThickness[1]], 
    StyleBox[{
      {GrayLevel[0.85], EdgeForm[GrayLevel[0.5]], 
       DiskBox[{-5.999999999999998, 1.6076938217470707*^-7}, 
        Offset[{2., 2.}, {0., 0.}]]}, 
      {EdgeForm[RGBColor[0.881, 0.65, 0.65]], FaceForm[RGBColor[
       0.9206666666666666, 0.7666666666666667, 0.7666666666666667]], 
       RectangleBox[NCache[
        Offset[{Rational[-21, 2], Rational[-21, 2]}, {-4.999999999999998, 
          1.339744851455892*^-7}], 
         Offset[{-10.5, -10.5}, {-4.999999999999998, 1.339744851455892*^-7}]],
         NCache[Offset[{
          Rational[21, 2], Rational[21, 2]}, {-4.999999999999998, 
          1.339744851455892*^-7}], 
         Offset[{10.5, 10.5}, {-4.999999999999998, 1.339744851455892*^-7}]]], 
       InsetBox[
        GraphicsBox[
         GraphicsComplexBox[{{0.1, 0}, {-0.3, 1}, {0.5, 1}, {1.3, 1}, {
           0.9, 0}}, {
           {Opacity[0.2], 
            LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 2}, {5, 3}, {5, 4}}]}, 
           {GrayLevel[0.33], AbsolutePointSize[3.5], 
            PointBox[{1, 5, 2, 3, 4}]}}],
         ImageSize->18], {-4.999999999999998, 1.339744851455892*^-7}]}, 
      {EdgeForm[GrayLevel[0.85]], FaceForm[RGBColor[0.9, 0.9, 0.9]], 
       DiskBox[{-3.9999999999999987, 1.0717958811647137*^-7}, Offset[
        11.666666666666668]], InsetBox[
        FormBox[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm2toFFcUx7faRtNnrMVa+ggtCCr6RUkb/ZI0FF9UaFPGap479965oYjR
rkZtPzRSELFgIbSljZVWXWcmqFA/hFIfoEFUJLH91Ar2Qy2ljYigqTGEvvR/
NpuwOzub3e0+5q47f7i7O7szy5nfnnPPfZx9kW2sl1MCgcDm6Xio17e9Ggrp
771VgQOtffM7be2GWNm+xWgzQtVsKt5chPYG2oMB5bXaawOKXD6/7OTzy04F
5ce59bQQ4WrO7bcNbr0rhL3bEPZXeH0Mr88Y3P4Bxz+jDRbSriyUN37BoDmH
c1MHk8/B4zzakDR67qbb8mVXjpUzfpqmTRXCXA4/+gLMfsuEVSnzQzw+h/jb
STGXLbNS4iebD7xgGPZeKey/0mUCxn9SH4drvhHC+gS++j6eDfSH9Wi1Mhhe
RHEvG8PP5PIm86iM+bW2fj0dDHaAxUgKVsNSWMdx7geGbq9sadn/bD5uwGNl
xA/54GX4zuWk3IR9C7G8j/pBTessy5fRCiltfjTegE/9ncTXriAWpXy9++F8
GqugUvJbsaJrGuLQTMLtmsEsRrm3EMYqqEn5Sa37CTDqc2WH3NHYGH68UIYq
qqT8OP/ySbAbcPG5m+gH/XnfmFw5IMdWRMYZifnhsq6bLxXaSIWVwK+p6eAj
NN9yYXe2ocGc4YWRCiuOH+UBcOpNjFnrVAnm1nQUx4/m+i79XZ+m7Sn3ykDF
NcEP86gNLuwGGNv3mJcGKq4IP0M3XwOrfxzsriKPzPbaQMW1mrFDlWB1w8Fu
SNfD8702TnWVlZXXI19ccrD7F+O7VV7bVgxaupSdTBincHu713YVgyQ3xfJl
HXHshLCPem1XMYjWKRGno3H8MLfwc21qjc1rrV+I2Tg/sLzt54t01DkFY+Tv
xn1ugh8z13ptWTGI9nli+7sIP2F3eW1XMQjzizXOXFtbs/5Hubj7Ia9tU11C
mIsT9nuE/UdFxfMtXtumuqLzi0HHGHmUMXNJwK9/mVTNzQdmItf+5IxbjPOC
0VN8fklEexPws34XdrtjTvP5uSi6/n7BZR20Bx8/EHOqz88hWnOC333vspZ3
gvYiHaf7/GIkg4cW0rpdYsxa52hfw+USn19UBrObMSa5477+/umjSS4reX7w
q1lS9BxOUo/Sm2Lfp2T5UR0UcmmIanbc2OGzz9Koqyg5fpH1E25tRVz+nqQm
ZSRmfJdKJcEvUofCzLW0vklzh0lq7vo5t+dl8NX3HT+qm2Ps4ALJ7Qbw+hhM
Ljr3xtzq7pBjN9XUdGb6lx3l+VH/TnNQ8gsjGK7CfdahvUl1X+DTgVj8CHzC
GNuepnXNlKzi/W2YrpfrzKf+p3nK80uXRSYtWq/YkYN6lKLgR+uU2ba62var
r1Q1HamsrAoFxu47F+3DHH5XPlrG/gff+g/92a+I8W+lsHZRrFMfkJtfM0HK
+x94XCcetL9F+THSz3HrGI7343kP7bfS/3Qks5fJVnMujesKaJ7y/BSXzy87
+fzuc90D7bU4NA==
            "], {{0, 25.}, {40., 0}}, {0, 255},
            ColorFunction->RGBColor,
            ImageResolution->144.],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
            Automatic],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->20,
          ImageSizeRaw->{40., 25.},
          PlotRange->{{0, 40.}, {0, 25.}}],
         TraditionalForm], {-3.9999999999999987, 1.0717958811647137*^-7}]}, 
      {EdgeForm[GrayLevel[0.85]], FaceForm[RGBColor[0.9, 0.9, 0.9]], 
       DiskBox[{-2.999999999999999, 8.038469108735353*^-8}, Offset[
        11.666666666666668]], InsetBox[
        FormBox[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm1toVEcYxzeahrRqES0VaSK1FaEvWpuCxVqlrYkXmnrjSGuuOzNnUlGj
JhFbUAJ9EYVQUB8aFJpsPDMq6kNR+lJtn8QqaAu9V9rSgrUPxfrg/fr/NkaS
zewteznj7vnDBLI55+S/P75vZr6ZOVPZhhVyVCgUai/HjxXhLW+2tYU/Wjke
vzit7WtaWl2xuLXDbXHbXmOj8eEraMvQSkOBCly1fhtwnM4yIfR0ztUil3st
UqiPpdB7/faVovLKr6nps/FCeAsl19tcoY64XP3iCn1Hugfux7Z8+spAOebX
OYqx/fMQXzvA6RzaXROrgN9QIcaqhFC7wetSqryKnZ/jOKORl6sRa2fS4QTG
91yu/0Y+f4V+r4f6P7D/IFu+cqxs8CtxmW7A976QEiuhvwPjTyX3BGPq1fr6
yJgsePBLGfFzm/UcxM75JMwuI54iaKs43zshW8Yt0Yj4MbZvHPKtm+IpDrO7
yMVjYLac5ifZNm2R0ubH+f7Xwe6PONxuElfOI9NyYdZCpcUP/VwHGN025qpQ
XlOTfj5HPm1VSvww7y0nPuaYUz/SHC/XRi1VUn4NDb0TEXOnzPMO1UVs82HU
UiXk19ysK8HpZwO7/zj3luTLpMWKyy8c9l4wjROYr3xPf8unSYtl5Bdlh5rA
0Nd9WVfX93S+TVqsYfxkQ+8U5Oefhrg7WOBzuZFoCD/UUs+C3a/D5ya6h+pb
v0xarEf8KC9NtRg+66V1KD9NWqwoP8pLcDoRyw51vg7YJRTxKwE7ZZijHJdV
3U/4bdBy1aKu2G5gd8pxup7025ztmjFj6W7DWPET1Rx+e7Ndkuma6uqOOzFx
d8nSNYBam1rF5Jnrqhe0XZ318vL7C2s2R1v1gvYblZVVm/z2FtOsk6zrm4w6
4i+KN+I2sN6JsXap395sl+PsGUv7iAP5+ogf0xv89ma75s/vLAW7Lwb3d8QP
c5ddfnt7HBTdG4wZa+fNld8EdVlyuVztNNQWZ8rKxq7025vtklx/aNiruEBr
BSFLxzhbROOCobb4VzbqFx9eEvCLI8lVq6G2+J8xNWvQZQE/g8w5q6/KsDc3
5tKA31CV0J6YIWevCaHeMlwf8Hso+U73UxhTD5vijjH9dpzbAn4QjQfGtWOh
r4DpGwluLXp+LvPeI06GuLsYDkdmJrm9aPlxriZJceBQnHM839I+WgqPKTp+
/efV1UaaixjZcX0wjTOJRcOPuNGZTfD5PU7MXQfXtWk+tuD5UR6CSyf4/GM8
N9bP7izn+qURPL4g+QkRmQpm6zF2fp3ozH903ECdkcEaymPPj/YIaZwEK465
7z4w+S0er0HcbtK6nXzfeybDf289v/7+vq+C3olwmXqX+ihaT8L3PwoOP2Ac
uJWM1+B4w32fNDb2PJcle9bzS5VNwib0aXo3jM5tZ9leQfKj/ASzk+jb2qkv
zKG9guBH+2Fg9jlyeyvV+Xnc+7eeH71fSHMPqglo/4bGCHr/EP1hnQyr2T6f
R7SeX6DM9ACfk0aT
            "], {{0, 25.}, {40., 0}}, {0, 255},
            ColorFunction->RGBColor,
            ImageResolution->144.],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
            Automatic],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->20,
          ImageSizeRaw->{40., 25.},
          PlotRange->{{0, 40.}, {0, 25.}}],
         TraditionalForm], {-2.999999999999999, 8.038469108735353*^-8}]}, 
      {EdgeForm[RGBColor[0.881, 0.65, 0.65]], FaceForm[RGBColor[
       0.9206666666666666, 0.7666666666666667, 0.7666666666666667]], 
       RectangleBox[NCache[
        Offset[{Rational[-21, 2], Rational[-21, 2]}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}], 
         Offset[{-10.5, -10.5}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}]], NCache[
        Offset[{Rational[21, 2], Rational[21, 2]}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}], 
         Offset[{10.5, 10.5}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}]]], InsetBox[
        GraphicsBox[
         GraphicsComplexBox[{{0.1, 0}, {-0.3, 1}, {0.5, 1}, {1.3, 1}, {
           0.9, 0}}, {
           {Opacity[0.2], 
            LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 2}, {5, 3}, {5, 4}}]}, 
           {GrayLevel[0.33], AbsolutePointSize[3.5], 
            PointBox[{1, 5, 2, 3, 4}]}}],
         ImageSize->18], {-1.9999999999999993, 5.3589794058235685*^-8}]}, 
      {EdgeForm[GrayLevel[0.85]], FaceForm[RGBColor[0.9, 0.9, 0.9]], 
       DiskBox[{-0.9999999999999997, 2.6794897029117842*^-8}, Offset[
        11.666666666666668]], InsetBox[
        FormBox[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVjlIQ0EQzaEYPFCwEjxQEEQLizQSi6C5rybBxk5NDBZGiEoQRBsVQcHW
QlBQo4WChY1BEBXsPEC0ECsLEaxSxBOib2E+/OInUdyNgn/gJfs3M/t25m9m
X33vkL9fp9Fohg348PfEOqLRnrFABR66IsMD4Ugo6IqMhMKhaFuvHpOtQC1Q
oFFNNdV+y8xmc6nb7a7DUJcHOq3H4wl5vd4bn8/3wYDxMzCPfQhpBWxdcK5L
fBhPgW8aeCD+CRG84InJcryT5jFuAtLAFW9Ok8lUBt4U1n4C4hhvYVovAc+P
mE/y5sWa3ZTnCnAo5S2HvAYceWdp7TDlvQosyIGzPSiAd4l4Z4B3oFj2WxzY
djqd1QJ4x4k3CZxJ88ixj+aPeHMyQy7NWPuNOC5ZTfG9Qef4DrVvEMHLDOsH
gHvZOXoFlkXUV8G0dru9Bvk1iupPqokxq9Vank9InEq9TyQYJ7vD8Z+4yCcY
52+/4/9qqP8o3XXZEBTAm8h1Hllv5s2L/jtH2i3lcrk6HQ5HiwKqePPCdODc
pLzYma/4TvBPtLXRaCwE5y7lfWKz2UpyhHDT1vA3IO6AuPdx1xZl8OOurUnD
nlL8jpKPCG1tsVgqEXdLeSxm2BdXbc3qirhjyiOh9J5EaGv4r1HctXR3Kfhw
1dbwn6TaPmbTizy1tax2L+gb7Tl8uWlrqU+SVj1XAjvjzJentobv3hf6c1q2
T1Vbq/Zn7BM3uCCD
            "], {{0, 25.066666666666666`}, {16., 0}}, {0, 
            255},
            ColorFunction->RGBColor,
            ImageResolution->135.],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
            Automatic],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->16,
          ImageSizeRaw->{16., 25.066666666666666`},
          PlotRange->{{0, 16.}, {0, 25.066666666666666`}}],
         TraditionalForm], {-0.9999999999999997, 2.6794897029117842*^-8}]}, 
      {GrayLevel[0.85], EdgeForm[GrayLevel[0.5]], 
       DiskBox[{0., 0.}, Offset[{2., 2.}, {0., 0.}]]}},
     FontSize->10]}},
  AspectRatio->Full,
  BaseStyle->{TooltipBoxOptions -> {TooltipDelay -> 0.08}},
  ImageMargins->{{0, 0}, {0, 0}},
  ImagePadding->{{25., 26.5}, {27.499998526280667`, 15.}},
  ImageSize->{381.4999999999999, 42.500007368596684`},
  PlotRangePadding->0]], "Output",
 CellChangeTimes->{3.851014219452787*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"864acba5-4a9b-44bb-8663-301c26ad3710"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"netFull", "=", 
  RowBox[{"NetTrain", "[", "\[IndentingNewLine]", 
   RowBox[{
   "net", ",", "\[IndentingNewLine]", "trainingSet", ",", 
    "\[IndentingNewLine]", "All", ",", "\[IndentingNewLine]", 
    RowBox[{"ValidationSet", "\[Rule]", "valSet"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<ADAM\>\"", ",", 
       RowBox[{"\"\<LearningRate\>\"", "\[Rule]", 
        RowBox[{"1", "/", "1000"}]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxTrainingRounds", "\[Rule]", "100"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LossFunction", "\[Rule]", 
     RowBox[{"CrossEntropyLossLayer", "[", "\"\<Index\>\"", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.85101258379991*^9, 3.851012605484232*^9}, {
  3.8510135405985727`*^9, 3.85101358535329*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"740b1210-32d5-4168-a8a0-bd0462e9b631"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   TagBox["NetTrainResultsObject",
    "SummaryHead"], "NonInterpretableSummary"], 
  StyleBox["[", "NonInterpretableSummary"], 
  FrameBox[GridBox[{
     {
      ItemBox[
       FrameBox[
        StyleBox["\<\"NetTrain Results\"\>", "SuggestionsBarText",
         StripOnInput->False,
         FontSize->12],
        FrameMargins->{{10, 5}, {-4, 2}},
        FrameStyle->None,
        StripOnInput->False],
       Alignment->{Left, Bottom},
       Background->RGBColor[0.96, 0.96, 0.96],
       Frame->{{False, False}, {True, False}},
       FrameStyle->Opacity[0.1],
       ItemSize->{Automatic, 1},
       StripOnInput->False]},
     {
      ItemBox[
       TagBox[
        FrameBox[
         TagBox[GridBox[{
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["summary"], 
                 TextCell["summary"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["batches:"], 
                  TextCell["batches:"]], "3200"}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["rounds:"], 
                  TextCell["rounds:"]], "100"}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["time:"], 
                  TextCell["time:"]], 
                 InterpretationBox[
                  Cell["8.2s"], 
                  TextCell["8.2s"]]}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["examples/s:"], 
                  TextCell["examples/s:"]], "24916"}, "RowWithSeparators"]},
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["data"], 
                 TextCell["data"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["training examples:"], 
                  TextCell["training examples:"]], "2000"}, 
                "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["validation examples:"], 
                  TextCell["validation examples:"]], "500"}, 
                "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["processed examples:"], 
                  TextCell["processed examples:"]], "204800"}, 
                "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["skipped examples:"], 
                  TextCell["skipped examples:"]], "0"}, "RowWithSeparators"]},
              
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["method"], 
                 TextCell["method"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["ADAM"], 
                  TextCell["ADAM"]], 
                 InterpretationBox[
                  Cell["optimizer"], 
                  TextCell["optimizer"]]}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["batch size"], 
                  TextCell["batch size"]], "64"}, "RowWithSeparators"], 
               InterpretationBox[
                Cell["CPU"], 
                TextCell["CPU"]]},
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["round"], 
                 TextCell["round"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 TagBox[
                  TooltipBox[
                   InterpretationBox[
                    Cell["loss:"], 
                    TextCell["loss:"]], 
                   TagBox[
                    GridBox[{{
                    
                    TemplateBox[{"\"Measurement: \"", "\"loss\""}, 
                    "RowDefault"]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                    "Column"]], Annotation[#, 
                   Column[{
                    Row[{"Measurement: ", "loss"}]}], "Tooltip"]& ], 
                 TagBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"\"1.36\"", "\[Times]", 
                    SuperscriptBox["10", "\"-1\""]}], ShowStringCharacters -> 
                    False], 0.1364082531804486, AutoDelete -> True], 
                  ScientificForm[#, 3]& ]}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 TagBox[
                  TooltipBox[
                   InterpretationBox[
                    Cell["error:"], 
                    TextCell["error:"]], 
                   TagBox[
                    GridBox[{{
                    
                    TemplateBox[{"\"Measurement: \"", "\"ErrorRate\""}, 
                    "RowDefault"]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                    "Column"]], Annotation[#, 
                   Column[{
                    Row[{"Measurement: ", "ErrorRate"}]}], "Tooltip"]& ], 
                 InterpretationBox[
                  Cell["6.25%"], 
                  TextCell["6.25%"]]}, "RowWithSeparators"]},
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["validation"], 
                 TextCell["validation"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 TagBox[
                  TooltipBox[
                   InterpretationBox[
                    Cell["loss:"], 
                    TextCell["loss:"]], 
                   TagBox[
                    GridBox[{{
                    
                    TemplateBox[{"\"Measurement: \"", "\"loss\""}, 
                    "RowDefault"]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                    "Column"]], Annotation[#, 
                   Column[{
                    Row[{"Measurement: ", "loss"}]}], "Tooltip"]& ], 
                 TagBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"\"1.37\"", "\[Times]", 
                    SuperscriptBox["10", "\"-1\""]}], ShowStringCharacters -> 
                    False], 0.13656442057878418`, AutoDelete -> True], 
                  ScientificForm[#, 3]& ]}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 TagBox[
                  TooltipBox[
                   InterpretationBox[
                    Cell["error:"], 
                    TextCell["error:"]], 
                   TagBox[
                    GridBox[{{
                    
                    TemplateBox[{"\"Measurement: \"", "\"ErrorRate\""}, 
                    "RowDefault"]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                    "Column"]], Annotation[#, 
                   Column[{
                    Row[{"Measurement: ", "ErrorRate"}]}], "Tooltip"]& ], 
                 InterpretationBox[
                  Cell["6.40%"], 
                  TextCell["6.40%"]]}, "RowWithSeparators"]},
              "RowWithSeparators"]},
            {
             ItemBox[
              
              DynamicModuleBox[{NeuralNetworks`Private`NetTrain`index$$ = 1, 
               NeuralNetworks`Private`NetTrain`plotList$$ = {
                GeneralUtilities`TightLabeled[
                 Graphics[{
                   AbsoluteThickness[1.25], {{
                    Hue[0.083, 1., 1.], 
                    Line[CompressedData["
1:eJw1lnk81Pkfx0enblkhVJRESa5cYV6uMY5hZphDK2t12XQofrSlmi1FbYdc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                    "]]}, {}}, {{
                    Hue[0.59, 0.7, 0.75], 
                    Line[CompressedData["
1:eJwtVAk4FnkYJ1es2kgpChXlKFeHM16Rz+1z04HkqChdttCpVkVbn3RgaZVy
lEptSYpX7kiRkis5vr5jRpJrN9LuTGae/zzz/Gee+f/e93e8i4Ii3UOmiYiI
BFM3/RzR+myVGvbJkuSnXjA8XY979m+7cPT5uOUeSyn39PmNOPVdAhyVdh+X
GWrCgvnZxXt3zYAJNRnniP1vsfDkPeqNPEzuKfXPO9eCyd9/aZEvnQvhUXKH
hsVamfOUoOviRsVL423o2l/p0l+pAvx5A34ZYx049wHn9+XBi0B9MKc03eYD
SgyU9vWGLAFB/vSVPOWPDL4GZLrW+q0x7sa+EOVM1+3LwH1/yJ93FXrwzTX7
HxLhWnDoWQxn1tsefP7hwKZnETqwbDDYevbmXqbeFbDzfpDKxa5evOr1dp7W
bj3YZbzwVntaH9bYHX/6pUgfZi+18FJ25GJpaApR98QA9HcHNrk95jL9GcLT
mUl5uiQX71yvpv5YCeQF8bb51Vy8UUYDrgK9rfmvR9o+YXrXSLZRyWqw1Cz8
rL6Mx/CxBkjDkqfbq3mYqLSEatEI4rJ+9JGjPIwzNl31Ao3BWbJDKbGehzHe
bltvlJkAt7h7S6gGn+HPFM7wB36zyOMjvdtQbgavzIoKtd/xMbDg8uDqCnNY
dyv5a6qcAH1e3VGVq1wLL4dyU+MMBAzfFtBpHm9301mAtjKdh2uqLGFnj41H
jqwAVS9GU4gA18d8M8wbBKhMl9cHkLLmirLCOI/Rxwpit79jP44SoLzVgoVp
XCtQCBwZ0x8Q4MzGnIdSIetgxLHSLCtaiNIBK52iPq2DxSzpycPbhYye1qC9
0CnJ4IwQRQ87xLJ51iDMmNSuKxDiJE1PqA2IRBkOZ+QK8d+0Lbd0+DZQgC3S
ZT4CRv/10JRk7v+PnhAHiw62SQrWg1RgqQwMCZFkiVMU2YLRR919te+FyG85
P71XYAtdFSN1IgsIxi8siKy/1m30SIgfaXmELDjadES+wY/A9hOGr7V32EG2
7cy6ReYE0tWkEHYQF69/cNpqIeMvexhTaM+cSCSwQf/dpX2kPWySfb0h34TA
Fxi4oifcAfBrhQQrTIhVLjThDtC6uH9XGIdg/OgIYRs6LlwPJ/BZhBjVkiN0
GtyLGbInsGjiXOKVnU6gW3eS71JG4MME2iBOsElLM1m8kmD86wyhvH5ZtQcE
3s41cO8ecAa7ENdydqQQc6hunCNdoGRlCKdukMAs2p5fXMBEb2/sm2KC8bsr
tJmMmkapE5jGDaAc4wrnmst7+AcIrH8yuiTOmA0fcVRMksKzp+NwkA3aT6SC
YjIJJh9sePC9llOxnkCbWaxTS7+xoSVYrKC9mcDy97Iem03cgNvdtuqDkED4
643KxWg34JRXtdYmE0ye3MDusux8b0ovc13/QtFxN/DfqGZ7oprAYhre1B0S
uhvOnxgn0JhuJ8YdGlX1RXKqCCZ/7tC9N1f6znsCaXd1jrvDsF8yb/YjAu/P
NqOWB3QvP5vgUUSgXocI5TAPqPPT2bXciGTy6gFJAd6SKxxI1NlxVqFowgNE
S8Su1iwlMY+m08wToiMd07dFkLjsm2K+xiFPMLLUWzvLi2Ty7Ql+E1Giw64k
Lj6dZZ383RNG1Ry2NeuSSJnr1zpzL2CVcTQPxpCookhX4AXXYuOdj1LnT80D
L7BR7c+qmEOiEi3npBcUJhZ3/a1BYsrOYxY313pDLPvRMUEsiXNW0wn1BqlT
Km/lKPyp+eENnKaJvW80CZSrbKIc6Q0aGopBbpcJPE+555iFD0QlujwPsCNx
BqXG4yM+cJOlXVNA1Ts1b3wgztrANIDCk+4VNKr/5wMvhWYzalNIjM+7m77R
0heym9fEDiWQKP5z4PiCmtl94+MOBDOffMEKGpOzWwkU+Xn5wQ8txz/Yt0n8
H/74P6U=
                    "]]}, {
                    AbsolutePointSize[2.2777777777777777`], 
                    Hue[0.59, 0.7, 0.65], 
                    Point[CompressedData["
1:eJwtVAk4FnkYJ1es2kgpChXlKFeHM16Rz+1z04HkqChdttCpVkVbn3RgaZVy
lEptSYpX7kiRkis5vr5jRpJrN9LuTGae/zzz/Gee+f/e93e8i4Ii3UOmiYiI
BFM3/RzR+myVGvbJkuSnXjA8XY979m+7cPT5uOUeSyn39PmNOPVdAhyVdh+X
GWrCgvnZxXt3zYAJNRnniP1vsfDkPeqNPEzuKfXPO9eCyd9/aZEvnQvhUXKH
hsVamfOUoOviRsVL423o2l/p0l+pAvx5A34ZYx049wHn9+XBi0B9MKc03eYD
SgyU9vWGLAFB/vSVPOWPDL4GZLrW+q0x7sa+EOVM1+3LwH1/yJ93FXrwzTX7
HxLhWnDoWQxn1tsefP7hwKZnETqwbDDYevbmXqbeFbDzfpDKxa5evOr1dp7W
bj3YZbzwVntaH9bYHX/6pUgfZi+18FJ25GJpaApR98QA9HcHNrk95jL9GcLT
mUl5uiQX71yvpv5YCeQF8bb51Vy8UUYDrgK9rfmvR9o+YXrXSLZRyWqw1Cz8
rL6Mx/CxBkjDkqfbq3mYqLSEatEI4rJ+9JGjPIwzNl31Ao3BWbJDKbGehzHe
bltvlJkAt7h7S6gGn+HPFM7wB36zyOMjvdtQbgavzIoKtd/xMbDg8uDqCnNY
dyv5a6qcAH1e3VGVq1wLL4dyU+MMBAzfFtBpHm9301mAtjKdh2uqLGFnj41H
jqwAVS9GU4gA18d8M8wbBKhMl9cHkLLmirLCOI/Rxwpit79jP44SoLzVgoVp
XCtQCBwZ0x8Q4MzGnIdSIetgxLHSLCtaiNIBK52iPq2DxSzpycPbhYye1qC9
0CnJ4IwQRQ87xLJ51iDMmNSuKxDiJE1PqA2IRBkOZ+QK8d+0Lbd0+DZQgC3S
ZT4CRv/10JRk7v+PnhAHiw62SQrWg1RgqQwMCZFkiVMU2YLRR919te+FyG85
P71XYAtdFSN1IgsIxi8siKy/1m30SIgfaXmELDjadES+wY/A9hOGr7V32EG2
7cy6ReYE0tWkEHYQF69/cNpqIeMvexhTaM+cSCSwQf/dpX2kPWySfb0h34TA
Fxi4oifcAfBrhQQrTIhVLjThDtC6uH9XGIdg/OgIYRs6LlwPJ/BZhBjVkiN0
GtyLGbInsGjiXOKVnU6gW3eS71JG4MME2iBOsElLM1m8kmD86wyhvH5ZtQcE
3s41cO8ecAa7ENdydqQQc6hunCNdoGRlCKdukMAs2p5fXMBEb2/sm2KC8bsr
tJmMmkapE5jGDaAc4wrnmst7+AcIrH8yuiTOmA0fcVRMksKzp+NwkA3aT6SC
YjIJJh9sePC9llOxnkCbWaxTS7+xoSVYrKC9mcDy97Iem03cgNvdtuqDkED4
643KxWg34JRXtdYmE0ye3MDusux8b0ovc13/QtFxN/DfqGZ7oprAYhre1B0S
uhvOnxgn0JhuJ8YdGlX1RXKqCCZ/7tC9N1f6znsCaXd1jrvDsF8yb/YjAu/P
NqOWB3QvP5vgUUSgXocI5TAPqPPT2bXciGTy6gFJAd6SKxxI1NlxVqFowgNE
S8Su1iwlMY+m08wToiMd07dFkLjsm2K+xiFPMLLUWzvLi2Ty7Ql+E1Giw64k
Lj6dZZ383RNG1Ry2NeuSSJnr1zpzL2CVcTQPxpCookhX4AXXYuOdj1LnT80D
L7BR7c+qmEOiEi3npBcUJhZ3/a1BYsrOYxY313pDLPvRMUEsiXNW0wn1BqlT
Km/lKPyp+eENnKaJvW80CZSrbKIc6Q0aGopBbpcJPE+555iFD0QlujwPsCNx
BqXG4yM+cJOlXVNA1Ts1b3wgztrANIDCk+4VNKr/5wMvhWYzalNIjM+7m77R
0heym9fEDiWQKP5z4PiCmtl94+MOBDOffMEKGpOzWwkU+Xn5wQ8txz/Yt0n8
H/74P6U=
                    "]]}}}, Prolog -> {{
                    Text[25, 
                    Offset[{-2, -2}, {25., 0.013000000000000001`}], {1., 1.}], 
                    Text[50, 
                    Offset[{-2, -2}, {50., 0.013000000000000001`}], {1., 1.}], 
                    Text[75, 
                    Offset[{-2, -2}, {75., 0.013000000000000001`}], {1., 1.}], 
                    Text[100, 
                    Offset[{-2, -2}, {100., 0.013000000000000001`}], {1., 
                    1.}], 
                    Text[125, 
                    Offset[{-2, -2}, {125., 0.013000000000000001`}], {1., 
                    1.}], 
                    Text[150, 
                    Offset[{-2, -2}, {150., 0.013000000000000001`}], {1., 
                    1.}]}, {
                    Text[
                    Superscript[10, "-1"], 
                    Offset[{3, 0}, {0, -1.}], {-1, -1.}]}}, 
                  PlotRange -> {{0, 100.046875}, {-1.313, 
                    0.013000000000000001`}}, ImageSize -> {302, 182.}, 
                  GridLines -> {{25., 50., 75., 100., 125., 150.}, {{-2., 
                    GrayLevel[0.3001]}, {-1., 
                    GrayLevel[0.3001]}, {-1.6989700043360185`, 
                    GrayLevel[0.8501]}, {-1.5228787452803374`, 
                    GrayLevel[0.8501]}, {-1.3979400086720375`, 
                    GrayLevel[0.8501]}, {-1.301029995663981, 
                    GrayLevel[0.8501]}, {-1.2218487496163564`, 
                    GrayLevel[0.8501]}, {-1.154901959985743, 
                    GrayLevel[0.8501]}, {-1.0969100130080565`, 
                    GrayLevel[0.8501]}, {-1.045757490560675, 
                    GrayLevel[0.8501]}, {-0.6989700043360187, 
                    GrayLevel[0.8501]}, {-0.5228787452803375, 
                    GrayLevel[0.8501]}, {-0.39794000867203755`, 
                    GrayLevel[0.8501]}, {-0.30102999566398114`, 
                    GrayLevel[0.8501]}, {-0.22184874961635626`, 
                    GrayLevel[0.8501]}, {-0.1549019599857432, 
                    GrayLevel[0.8501]}, {-0.09691001300805638, 
                    GrayLevel[0.8501]}, {-0.04575749056067506, 
                    GrayLevel[0.8501]}}}, Frame -> True, Axes -> None, 
                  AspectRatio -> Full, 
                  BaseStyle -> {
                   FontFamily -> "Verdana", FontSize -> 8, FontColor -> 
                    GrayLevel[0.5], ScriptSizeMultipliers -> 0.2, 
                    ScriptMinSize -> 6}, PlotRangePadding -> None, 
                  PlotRangeClipping -> True, Background -> GrayLevel[1], 
                  FrameStyle -> GrayLevel[0.5], ImagePadding -> 1, FrameTicks -> 
                  None], {None, "loss", "rounds"}], 
                GeneralUtilities`TightLabeled[
                 Graphics[{
                   AbsoluteThickness[1.25], {{
                    Hue[0.083, 1., 1.], 
                    Line[CompressedData["
1:eJxdV31I3GUcv9YYQjKsZMqSpdPMlrmbOj1f7/G8O+9V7373u/v9AhcSa0mM
krAYMeKI/SHNPyRGSEQcFmHLzJobJjauYWssWSprWAw6YoTFiCNiSEXU+Xz8
4/P1H/n6ffm8fJ/nubPq2ZeM53Y5HI7q+xyOwm/9c8s93rC4OXX2J7eOf3G/
f7bwhx90nM67/WXHRtd8G8jfQ/33yP/tfmXN93/FOmKH2i4vQ6zuV7r/O/Tv
Qbyq42yRWi+0ryFOP6AOF8Y33ED/XlW+PQ/96RKl8b7Vce5BpflcR/3D6Eec
KVVazzfA3wd+6B8qAz7y2XLw+1rHlfvRjzj9iNJzrgK/gvPqgPp1qvCHK8B/
FPwQpyvV6Db/r3TsrOI4VwU+iCcOgi9iVY15l3WcrwafLPBqgI987DGe76hF
/6KO52rh75fw43GeX1KHeZfgT53aLj+2pOORJ9S23YuIKw9hPxd1vLoTfwH9
T3LeWc/zc/Xw8wL0PwU/0K8aoHcB+hvgD/KZw9gf+uucOA+fA98JfcDbcAo+
R7h/7Ajw5sFPxK5G+AE+E43g+5mONxuhD/iqifEnm5hfvonrA83MJ9PMfm01
w/857Pso+zd9lPk6Wpif3cL4cy3cX9SKfswfamW8hVbuL3FhH/Bz2MX4WRf0
fKrj8jbUg89IG/A/1vG1NtZf2c7+nGrn+avt8HcW++/g+nQH4290YH/Q4+xk
PmOd7FdO5F1drH+iS+y/i/1T3cCbwf67wXdn/908L+AW+3ez/1tu4H0CvYrn
mYrr04r9mFHCD8X6dvdwvbMH7wnygz2sZ0zk53sYP9fDeoo97JfLw/3HPcJf
D89b8jDfTdFf2iv872W/Tor8ZC/zW+7leXnRX+FlPgEv50e9vI+MyK94Wd+W
F+8x8jU+zMf5jvn4fJ/2sf5pH5/nmz7m7/Bzf72f+20/7/OMn/Hn/Hw/b/tZ
f1Ef4zf38bwhkR/v43kLIn+nj/mVBHhfnQHODwfwnn+k43MB1p8N8D7uinnl
Qa73Bvl+jARZ77tBnnctyPv8M8h+V4bYj0iI550KMd4HIda3Kur/CYn7H+b5
Zpj5pcPcPxNm/Rthcf8jPM8Z4XmDEbwP53H/I3x+5yOYP437H2G84ij75YqK
+x9lfRMiXoryvjejzLe0n/1X/Yx/sp/1Tor65X4+j3mRrxhgvYEBcf8HeH5m
gPFXBvh93RLzHopxf12Mz0e3yJsxxn8hJt7/GPzGvt6O8f2bEfVXxLwNkf89
xvvaHef6/XH2yxnn/fhFfjDO5+nlOOONif734uLzZqce5+266M/F+fPmXpz1
Fxt8Hg8aPN9lsL5+g/keN7BfvJevGbzPCRF/KOYtGbzPdUN8nzBY378Gn4fS
BJ/XQwnmrxKMl0qA7859SDDeGwnWN5lg/FlRv5zg9+HHBO8rL/jsMdn/CpP1
N5qsJ2By/zMm3/9RUf+myX5nRP6SyXpWRP5nU3zfMvn+7E1yfY2I25O8n1iS
9Z1IMr/TSb4PbyXZz+kk418W8U2B/1uS/XekeJ/7UuxfvYg9KX6f7BTPf1HE
Z0T/Oyn2by7Feq+m+DzeFvEfKfavyOJ5ByzW02yxfyGL8YYs5vuqxXjjon7K
Utq3nf93LD4vNyzWe8fi+/CXJb6/2My31ma+nTbjGzbzG7b5PLwu+s/ZzPe8
zfvPiviWzX7eFf27nlbPnyj8zLr/A9BAQGs=
                    "]]}, {}}, {{
                    Hue[0.59, 0.7, 0.75], 
                    Line[CompressedData["
1:eJxFVAlUjFEUHlSyE4pKJFuSCmnVe6N9b6aakqVQpLKWLcq+hpAlCVkTyjQl
E2mdRLbqWI6dklIpDg5teK/3n/t3pjPnm3u/79537/ee7oLl4pDuAoEgmPzT
75/6X4UnFteiyNBDXzeiZ2hlVOjhTUVtKEXT6O0YlUrE4spY9Zp2QLDVEyQd
funWqmX9sK50FWE8RDnbr5Nf1PBhwjadV44SOvo8V8tXx7JTLal3Xcs4PU1c
8mvCnPjiUuTZpPBoUujgJpFcZ0djEVKXHdwxKVgXd6R9r3JfUIiUm/NrqkP0
sE/NxZOKUYVc/bF4uJKkv6HsDqoJ0UrxXDIeu/TtbrBLPRdVnXX+qxyuj/cI
g2orRt9GRW/XzsmLMMDheVEJw5RyuH4N8YOz9jk/OrPRad+nw/RXGGEterwt
N1CZ05bbLXJj/Lo1NiwvKgvlL0psKM81wUT85ePfWdz5pgBOP3eXMKZC/oVC
WnAa4OR3Py+Z3THFcRF17WnfZdw8pgOO09QjRzQDvNXcctr9AnPA0RLRwguF
Ftj6vef+48tk3PwsQZ+igGIryA+SHvtmWmLNzTMT+T1OHzlIMQPibN42OFkx
imwsEzn0fhNTVoogf+SR9aQihrgWba8GA5/tRwj5akLtEUmfhBDvX5Ga3TNk
JvB7BU51W107E7uZ0Y1IuX3aAr9bjMsGr8+2EO+k41lkB/w/SfOvGNTZQZzt
3x743+TrXqrU23N+kaJGRyUyIgfg1z2PV62ud4A484sj9rfIvrcm/zp6T9fz
xRHir7ZNeTIxzAkw7SaxwQn0mL+cof4j42dHIxudob/7BUGGH8NdIF7qQQfu
AnrMj64Qz4voQY7kCnx5+4G440vdoL/svdQgblCf+dcd8NXLJuIPzTxOJadx
X+4BeuepPVt4zPzuCf0kfQokjuHxg9xfelvNvQA70+uwzgv6YffDC+rZDXTc
Na6Vjxe/6Os910IE9fCZKp0j60Wgx+6TCPjWk+fldGvj8S1a3lIMeub0ONFi
mBe7f2LQp+5608bnZw62Ih9vqGf0WkAc5g1xdl+9gW8Qtm+IvJ3PT6PjtPIB
PL5V49rYjTxm99sH9EbvPm+b0OEDesRcA8qtfSGuo0E74DF7D3xBT5Ous9MX
+IlLN9tcnCGB/KGm9IZKYD7s/ZDAPAYpKokjJcCPJ+7ZbOMH+v3INm7G8pi9
N36Q36u6vmLMPz+otzMtI3k28sdUXSTPQEpdD44/5LP3yR/yBV1/s0D/Pz8j
HAw=
                    "]]}, {
                    AbsolutePointSize[2.2777777777777777`], 
                    Hue[0.59, 0.7, 0.65], 
                    Point[CompressedData["
1:eJxFVAlUjFEUHlSyE4pKJFuSCmnVe6N9b6aakqVQpLKWLcq+hpAlCVkTyjQl
E2mdRLbqWI6dklIpDg5teK/3n/t3pjPnm3u/79537/ee7oLl4pDuAoEgmPzT
75/6X4UnFteiyNBDXzeiZ2hlVOjhTUVtKEXT6O0YlUrE4spY9Zp2QLDVEyQd
funWqmX9sK50FWE8RDnbr5Nf1PBhwjadV44SOvo8V8tXx7JTLal3Xcs4PU1c
8mvCnPjiUuTZpPBoUujgJpFcZ0djEVKXHdwxKVgXd6R9r3JfUIiUm/NrqkP0
sE/NxZOKUYVc/bF4uJKkv6HsDqoJ0UrxXDIeu/TtbrBLPRdVnXX+qxyuj/cI
g2orRt9GRW/XzsmLMMDheVEJw5RyuH4N8YOz9jk/OrPRad+nw/RXGGEterwt
N1CZ05bbLXJj/Lo1NiwvKgvlL0psKM81wUT85ePfWdz5pgBOP3eXMKZC/oVC
WnAa4OR3Py+Z3THFcRF17WnfZdw8pgOO09QjRzQDvNXcctr9AnPA0RLRwguF
Ftj6vef+48tk3PwsQZ+igGIryA+SHvtmWmLNzTMT+T1OHzlIMQPibN42OFkx
imwsEzn0fhNTVoogf+SR9aQihrgWba8GA5/tRwj5akLtEUmfhBDvX5Ga3TNk
JvB7BU51W107E7uZ0Y1IuX3aAr9bjMsGr8+2EO+k41lkB/w/SfOvGNTZQZzt
3x743+TrXqrU23N+kaJGRyUyIgfg1z2PV62ud4A484sj9rfIvrcm/zp6T9fz
xRHir7ZNeTIxzAkw7SaxwQn0mL+cof4j42dHIxudob/7BUGGH8NdIF7qQQfu
AnrMj64Qz4voQY7kCnx5+4G440vdoL/svdQgblCf+dcd8NXLJuIPzTxOJadx
X+4BeuepPVt4zPzuCf0kfQokjuHxg9xfelvNvQA70+uwzgv6YffDC+rZDXTc
Na6Vjxe/6Os910IE9fCZKp0j60Wgx+6TCPjWk+fldGvj8S1a3lIMeub0ONFi
mBe7f2LQp+5608bnZw62Ih9vqGf0WkAc5g1xdl+9gW8Qtm+IvJ3PT6PjtPIB
PL5V49rYjTxm99sH9EbvPm+b0OEDesRcA8qtfSGuo0E74DF7D3xBT5Ous9MX
+IlLN9tcnCGB/KGm9IZKYD7s/ZDAPAYpKokjJcCPJ+7ZbOMH+v3INm7G8pi9
N36Q36u6vmLMPz+otzMtI3k28sdUXSTPQEpdD44/5LP3yR/yBV1/s0D/Pz8j
HAw=
                    "]]}}}, Prolog -> {{
                    Text[25, 
                    Offset[{-2, -2}, {25., 0.6565}], {1., 1.}], 
                    Text[50, 
                    Offset[{-2, -2}, {50., 0.6565}], {1., 1.}], 
                    Text[75, 
                    Offset[{-2, -2}, {75., 0.6565}], {1., 1.}], 
                    Text[100, 
                    Offset[{-2, -2}, {100., 0.6565}], {1., 1.}], 
                    Text[125, 
                    Offset[{-2, -2}, {125., 0.6565}], {1., 1.}], 
                    Text[150, 
                    Offset[{-2, -2}, {150., 0.6565}], {1., 1.}]}, {
                    Text[
                    PercentForm[0.], 
                    Offset[{3, 0}, {0, 0.}], {-1, -1.}], 
                    Text[
                    PercentForm[0.2], 
                    Offset[{3, 0}, {0, 0.2}], {-1, -1.}], 
                    Text[
                    PercentForm[0.4], 
                    Offset[{3, 0}, {0, 0.4}], {-1, -1.}], 
                    Text[
                    PercentForm[0.6], 
                    Offset[{3, 0}, {0, 0.6}], {-1, -1.}]}}, 
                  PlotRange -> {{0, 100.046875}, {-0.006500000000000001, 
                    0.6565}}, ImageSize -> {302, 182.}, 
                  GridLines -> {{25., 50., 75., 100., 125., 150.}, {{0., 
                    GrayLevel[0.8501]}, {0.05, 
                    GrayLevel[0.8501]}, {0.1, 
                    GrayLevel[0.8501]}, {0.15, 
                    GrayLevel[0.8501]}, {0.2, 
                    GrayLevel[0.8501]}, {0.2, 
                    GrayLevel[0.8501]}, {0.25, 
                    GrayLevel[0.8501]}, {0.3, 
                    GrayLevel[0.8501]}, {0.35, 
                    GrayLevel[0.8501]}, {0.4, 
                    GrayLevel[0.8501]}, {0.4, 
                    GrayLevel[0.8501]}, {0.45, 
                    GrayLevel[0.8501]}, {0.5, 
                    GrayLevel[0.8501]}, {0.55, 
                    GrayLevel[0.8501]}, {0.6, 
                    GrayLevel[0.8501]}, {0.6, 
                    GrayLevel[0.8501]}, {0.65, 
                    GrayLevel[0.8501]}, {0.7, 
                    GrayLevel[0.8501]}, {0.75, 
                    GrayLevel[0.8501]}, {0.8, 
                    GrayLevel[0.8501]}, {0., 
                    GrayLevel[0.3001]}, {0.2, 
                    GrayLevel[0.3001]}, {0.4, 
                    GrayLevel[0.3001]}, {0.6, 
                    GrayLevel[0.3001]}, {0.8, 
                    GrayLevel[0.3001]}}}, Frame -> True, Axes -> None, 
                  AspectRatio -> Full, 
                  BaseStyle -> {
                   FontFamily -> "Verdana", FontSize -> 8, FontColor -> 
                    GrayLevel[0.5], ScriptSizeMultipliers -> 0.2, 
                    ScriptMinSize -> 6}, PlotRangePadding -> None, 
                  PlotRangeClipping -> True, Background -> GrayLevel[1], 
                  FrameStyle -> GrayLevel[0.5], ImagePadding -> 1, FrameTicks -> 
                  None], {None, "error rate", "rounds"}]}}, 
               TagBox[GridBox[{
                  {
                   DynamicBox[ToBoxes[
                    Grid[{{
                    Button[
                    MouseAppearance[
                    Style["\:2039", FontColor :> If[
                    CurrentValue["MouseOver"], 
                    RGBColor[0.27, 0.54, 0.79], 
                    GrayLevel[0.25]], FontFamily -> "MS Gothic", FontSize -> 
                    14, FontWeight -> "Thin"], "LinkHand"], 
                    NeuralNetworks`Private`NetTrain`index$$ = 
                    Mod[NeuralNetworks`Private`NetTrain`index$$ - 1, 2, 1], 
                    Appearance -> None], 
                    Dynamic[
                    Part[{
                    Tooltip["loss", 
                    Column[{
                    Row[{"Measurement: ", "loss"}]}]], 
                    Tooltip["error rate", 
                    Column[{
                    Row[{"Measurement: ", "ErrorRate"}]}]]}, 
                    NeuralNetworks`Private`NetTrain`index$$], 
                    TrackedSymbols :> {
                    NeuralNetworks`Private`NetTrain`index$$}], 
                    Button[
                    MouseAppearance[
                    Style["\:203a", FontColor :> If[
                    CurrentValue["MouseOver"], 
                    RGBColor[0.27, 0.54, 0.79], 
                    GrayLevel[0.25]], FontFamily -> "MS Gothic", FontSize -> 
                    14, FontWeight -> "Thin"], "LinkHand"], 
                    NeuralNetworks`Private`NetTrain`index$$ = 
                    Mod[NeuralNetworks`Private`NetTrain`index$$ + 1, 2, 1], 
                    Appearance -> None]}}, ItemSize -> {{3, 20, 3}, {2}}, 
                    Alignment -> Center], StandardForm],
                    ImageSizeCache->{256., {7.9150390625, 14.0849609375}},
                    
                    TrackedSymbols:>{
                    NeuralNetworks`Private`NetTrain`index$$}]},
                  {
                   DynamicBox[ToBoxes[
                    Part[
                    NeuralNetworks`Private`NetTrain`plotList$$, 
                    NeuralNetworks`Private`NetTrain`index$$], StandardForm],
                    ImageSizeCache->{313., {94.43359375, 98.56640625}},
                    TrackedSymbols:>{NeuralNetworks`Private`NetTrain`index$$}]}
                 },
                 DefaultBaseStyle->"Column",
                 GridBoxAlignment->{"Columns" -> {{Center}}},
                 
                 GridBoxItemSize->{
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
                "Column"],
               DynamicModuleValues:>{}],
              Alignment->Center,
              StripOnInput->False], "\[SpanFromLeft]"},
            {
             ItemBox[
              StyleBox[
               RowBox[{
                GraphicsBox[{},
                 Axes->None,
                 Background->Hue[0.083, 1., 1.],
                 ImagePadding->{{0, 0}, {5, 2}},
                 ImageSize->{13, 1}], "  ", "\<\"training set\"\>", "\t", 
                GraphicsBox[{},
                 Axes->None,
                 Background->Hue[0.59, 0.7, 0.75],
                 ImagePadding->{{0, 0}, {5, 2}},
                 ImageSize->{13, 1}], "  ", "\<\"validation set\"\>"}],
               FontFamily->"Verdana",
               FontSize->8,
               FontColor->GrayLevel[0.4]],
              Alignment->Center,
              StripOnInput->False], "\[SpanFromLeft]"}
           },
           AutoDelete->False,
           ColumnsEqual->False,
           
           GridBoxAlignment->{
            "Columns" -> {Right, {Left}}, "Rows" -> {{Baseline}}},
           GridBoxDividers->{"Columns" -> {False, {
                Opacity[0.15]}, False}},
           GridBoxItemSize->{"Columns" -> {8, {26}}, "Rows" -> {{1.}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], 
               Offset[1.1199999999999999`], {
                Offset[1.75]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.8]}, 
               Offset[0.2]}}],
          "Grid"],
         FrameMargins->{{10, 10}, {10, 5}},
         FrameStyle->None,
         StripOnInput->False],
        Deploy,
        DefaultBaseStyle->"Deploy"],
       Alignment->Center,
       BaseStyle->{
        FontWeight -> "Light", FontSize -> 11, FontFamily -> 
         ".AppleSystemUIFont", NumberMarks -> False, Deployed -> False},
       StripOnInput->False]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], 
        Offset[0.8], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   Background->GrayLevel[1],
   FrameMargins->{{0, 0}, {0, 0}},
   FrameStyle->GrayLevel[0.85],
   RoundingRadius->5,
   StripOnInput->False], 
  StyleBox["]", "NonInterpretableSummary"]}]], "Output",
 CellChangeTimes->{
  3.851012614112508*^9, {3.851012691503661*^9, 3.851012711346287*^9}, {
   3.851012924792572*^9, 3.851012953766609*^9}, 3.851013292056345*^9, 
   3.8510133311475*^9, 3.851013367140524*^9, 3.8510134194945707`*^9, 
   3.851013489297063*^9, 3.851013547598187*^9, 3.851013591244503*^9, 
   3.851014235253853*^9, {3.851143017912752*^9, 3.851143035159317*^9}, 
   3.851143085000594*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"48bff3ad-c8bf-4d73-a306-6689a45d2f20"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"trainedNN", "=", 
   RowBox[{"netFull", "[", "\"\<TrainedNet\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"actual", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"testSet", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "testSet", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"predict", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"trainedNN", "[", 
      RowBox[{"testSet", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "testSet", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8510142973956137`*^9, 3.851014309622365*^9}, {
  3.851014361936099*^9, 3.851014394391403*^9}, {3.8510144516835546`*^9, 
  3.851014478279593*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"27935e91-6730-4414-9299-077014d35e9d"],

Cell["Naive Precision", "Text",
 CellChangeTimes->{{3.8510145924516487`*^9, 
  3.851014599807962*^9}},ExpressionUUID->"e097d3ad-74e6-49af-9689-\
6fc65b277758"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"actual", "-", "predict"}], ",", 
      RowBox[{
       RowBox[{"#", "==", "0"}], "&"}]}], "]"}], "]"}], "/", 
   RowBox[{"Length", "[", "actual", "]"}]}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.851014556244891*^9, 3.851014584476871*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"cf90be8d-9edf-4e52-b808-103ee0054364"],

Cell[BoxData["0.9378937893789379`"], "Output",
 CellChangeTimes->{{3.8510145673491907`*^9, 3.851014584800899*^9}, 
   3.851143266128166*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"bd89d0b6-00c2-4367-a40c-f971a3186f6c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matthewsPhi", "[", 
   RowBox[{"actual", ",", "predict"}], "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.851014640918413*^9, 3.851014648016128*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"fed8847a-4ef4-483c-999a-98c7c3af1025"],

Cell[BoxData["0.8709692770893402`"], "Output",
 CellChangeTimes->{{3.851014645502967*^9, 3.851014648442329*^9}, 
   3.851143344034894*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"56dcaf8b-db91-4e16-92be-f017bb9323a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"confusion", "[", 
   RowBox[{"actual", ",", "predict"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.851014996932404*^9, 3.851015004452363*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"e85325ed-ee04-4a37-92a0-51c4abdeaabe"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2064", "190"},
     {"155", "3146"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.851015004826632*^9, 3.851143317216938*^9},
 CellLabel->
  "Out[28]//MatrixForm=",ExpressionUUID->"48ce2e40-782a-4488-bfd9-\
11131297c18a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regressor", "Section",
 CellChangeTimes->{{3.851013653263283*^9, 
  3.851013661683322*^9}},ExpressionUUID->"7e8b99bf-e8ca-41cf-b3b3-\
31de1d4d5e97"],

Cell["Create MLP :  Forward - feed NN Regressor", "Text",
 CellChangeTimes->{{3.851011322112885*^9, 3.8510113411089983`*^9}, {
  3.851012138485075*^9, 
  3.851012140369439*^9}},ExpressionUUID->"f6c7d017-5db2-4498-b2ef-\
2673f5563f9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"net", "=", 
   RowBox[{"NetChain", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"LinearLayer", "[", "100", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ElementwiseLayer", "[", "Tanh", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LinearLayer", "[", "10", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ElementwiseLayer", "[", "Tanh", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LinearLayer", "[", "5", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"SummationLayer", "[", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<Input\>\"", "\[Rule]", 
      RowBox[{"{", "5", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.851011319798061*^9, 3.851011320916131*^9}, {
  3.851011470070384*^9, 3.8510114893530684`*^9}, {3.851011978388165*^9, 
  3.851012041970374*^9}, {3.851012102661742*^9, 3.851012109379654*^9}, {
  3.8510127994728117`*^9, 3.851012854286371*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"ecd56916-eb52-4623-8dea-6678244c4a33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", 
  RowBox[{"net", ",", "\"\<FullSummaryGraphic\>\""}], "]"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"5bdde66c-3568-4733-95d7-553153956393"],

Cell[BoxData[
 GraphicsBox[{{
    StyleBox[{
      InsetBox["\<\"Input\"\>", 
       Offset[{0, -7}, {-6.999999999999997, 1.875642792038249*^-7}], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"1\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-5.999999999999998, 
         1.6076938217470707`*^-7}], 
        Offset[{0, -13.5}, {-5.999999999999998, 1.6076938217470707`*^-7}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"2\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-4.999999999999998, 
         1.339744851455892*^-7}], 
        Offset[{0, -13.5}, {-4.999999999999998, 1.339744851455892*^-7}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"3\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-3.9999999999999987`, 
         1.0717958811647137`*^-7}], 
        Offset[{0, -13.5}, {-3.9999999999999987`, 1.0717958811647137`*^-7}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"4\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-2.999999999999999, 
         8.038469108735353*^-8}], 
        Offset[{0, -13.5}, {-2.999999999999999, 8.038469108735353*^-8}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"5\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-1.9999999999999993`, 
         5.3589794058235685`*^-8}], 
        Offset[{0, -13.5}, {-1.9999999999999993`, 5.3589794058235685`*^-8}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"6\"\>", NCache[
       Offset[{0, Rational[-27, 2]}, {-0.9999999999999997, 
         2.6794897029117842`*^-8}], 
        Offset[{0, -13.5}, {-0.9999999999999997, 2.6794897029117842`*^-8}]], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}], 
      InsetBox["\<\"Output\"\>", Offset[{0, -7}, {0., 0.}], 
       ImageScaled[{Rational[1, 2], 1.}], Automatic, {1, 0}]},
     StripOnInput->False,
     FontColor->GrayLevel[0.5]], 
    StyleBox[{
      InsetBox["\<\"5\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-6.4499999999999975, 1.728270858378101*^-7}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117852`*^-8}], 
      InsetBox["\<\"100\"\>", 
       Offset[{1.473719336601482*^-7, 5.499999999999999}, \
{-5.4499999999999975, 1.4603218880869225*^-7}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117856`*^-8}], 
      InsetBox["\<\"100\"\>", 
       Offset[{1.4737193366014812*^-7, 5.499999999999999}, \
{-4.449999999999998, 1.192372917795744*^-7}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117842`*^-8}], 
      InsetBox["\<\"10\"\>", 
       Offset[{1.4737193366014812*^-7, 5.499999999999999}, \
{-3.449999999999999, 9.244239475045655*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.6794897029117842`*^-8}], 
      InsetBox["\<\"10\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-2.4499999999999993, 6.564749772133872*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999998, -2.679489702911785*^-8}], 
      InsetBox["\<\"5\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-1.4499999999999993, 3.885260069222087*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999999, -2.679489702911785*^-8}], 
      InsetBox["\<\"\[DoubleStruckCapitalR]\"\>", 
       Offset[{1.4737193366014818*^-7, 5.499999999999999}, \
{-0.4499999999999998, 1.2057703663103027*^-8}], ImageScaled[{0.5, 0.415}], 
       Automatic, {0.9999999999999999, -2.679489702911785*^-8}]},
     StripOnInput->False,
     FontSize->8,
     FontWeight->"Thin",
     FontColor->GrayLevel[0.7]]}, 
   {GrayLevel[0.7], 
    TagBox[
     TooltipBox[
      LineBox[{{-6.999999999999997, 
       1.875642792038249*^-7}, {-5.999999999999998, 1.6076938217470707`*^-7}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 5\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Input\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    
                    Offset[{0, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 5\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Input", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  
                  Offset[{0, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-5.999999999999998, 
       1.6076938217470707`*^-7}, {-4.999999999999998, 1.339744851455892*^-7}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-4.999999999999998, 
       1.339744851455892*^-7}, {-3.9999999999999987`, 
       1.0717958811647137`*^-7}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-3.9999999999999987`, 
       1.0717958811647137`*^-7}, {-2.999999999999999, 8.038469108735353*^-8}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 10\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 10\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-2.999999999999999, 
       8.038469108735353*^-8}, {-1.9999999999999993`, 
       5.3589794058235685`*^-8}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 10\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 10\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-1.9999999999999993`, 
       5.3589794058235685`*^-8}, {-0.9999999999999997, 
       2.6794897029117842`*^-8}}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 5\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 5\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 0.}}],
      TagBox[
       GridBox[{{"\"real\""}, {
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    Offset[{0, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Output\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{"real", 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  Offset[{0, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Output"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ]}, {
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-6.4499999999999975, 1.728270858378101*^-7}, {-0.25, 0}, Offset[8], {
       0.9999999999999991, -2.6794897029117836`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 5\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Input\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    
                    Offset[{0, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 5\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Input", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  
                  Offset[{0, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-5.4499999999999975, 1.4603218880869225*^-7}, {-0.25, 0}, Offset[8], {
       1., -2.6794897029117862`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-4.449999999999998, 1.192372917795744*^-7}, {-0.25, 0}, Offset[8], {
       0.9999999999999996, -2.6794897029117836`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 100\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 100\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-3.449999999999999, 9.244239475045655*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999996, -2.6794897029117836`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 10\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 10\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-2.4499999999999993, 6.564749772133872*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999998, -2.679489702911785*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 10\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 10\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-1.4499999999999993, 3.885260069222087*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999997, -2.6794897029117842`*^-8}],
      TagBox[
       GridBox[{{
          TemplateBox[{"\[ThinSpace]", "\" \"", "\"vector\"", 
            StyleBox["\"(\[VeryThinSpace]size: 5\[VeryThinSpace])\"", 
             GrayLevel[0.5], StripOnInput -> False]}, "RowWithSeparators"]}, {
         
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"[\"", TraditionalForm], 
                    Offset[{-5, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Input\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{
        Row[{"vector", 
          Style["(\[VeryThinSpace]size: 5\[VeryThinSpace])", 
           GrayLevel[0.5]]}, " "], 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["[", 
                  Offset[{-5, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Input"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ], 
    TagBox[
     TooltipBox[InsetBox[
       GraphicsBox[
        {GrayLevel[0.7], 
         PolygonBox[{{-1., 0.3333333333333333}, {0., 
          0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 0.}, {-1., 
          0.3333333333333333}}]}], \
{-0.4499999999999998, 1.2057703663103027*^-8}, {-0.25, 0}, Offset[8], {
       0.9999999999999997, -2.6794897029117842`*^-8}],
      TagBox[
       GridBox[{{"\"real\""}, {
          StyleBox[
           TemplateBox[{"\"Output\"", 
             GraphicsBox[{{}, {
                GrayLevel[0.7], {
                 
                 LineBox[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0.,
                   0.}}]}}, {
                InsetBox[
                 GraphicsBox[
                  StyleBox[
                   
                   PolygonBox[{{-1., 0.3333333333333333}, {0., 
                    0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                    0.}, {-1., 0.3333333333333333}}], {
                    GrayLevel[0.7]}, StripOnInput -> 
                   False]], {-0.4499999999999998, 
                 1.2057703663103027`*^-8}, {-0.25, 0}, 
                 Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
                EdgeForm[
                 AbsoluteThickness[1]], FontSize -> 10, {{{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"]\"", TraditionalForm], 
                    
                    Offset[{7, 0}, {-0.9999999999999997, 
                    2.6794897029117842`*^-8}]]}}, {{
                   GrayLevel[0.85], 
                   EdgeForm[
                    GrayLevel[0.5]], 
                   DiskBox[{0., 0.}, 
                    Offset[{2, 2}]]}, {
                   GrayLevel[0.5], 
                   InsetBox[
                    FormBox["\"\"", TraditionalForm], 
                    Offset[{0, 0}, {0., 0.}]]}}}}}, 
              ImageSize -> {68.99999999999997, 15.000001473719337`}, 
              AspectRatio -> Full, PlotRangePadding -> 0, 
              ImagePadding -> {{7., 7.}, {10., 5.}}, 
              ImageMargins -> {{0, 0}, {0, 0}}, 
              BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
             "\"Output\""}, "RowDefault"], 
           GrayLevel[0.5], StripOnInput -> False]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"],
      TooltipStyle->{
       Background -> GrayLevel[0.937255], CellFrame -> 1, CellFrameColor -> 
        GrayLevel[0.85]}],
     Annotation[#, 
      Column[{"real", 
        Style[
         Row[{"Output", 
           Graphics[{{}, {
              GrayLevel[0.7], {
               
               Line[{{-0.9999999999999997, 2.6794897029117842`*^-8}, {0., 
                0.}}]}}, {
              Inset[
               Graphics[
                Style[
                 
                 Polygon[{{-1., 0.3333333333333333}, {0., 
                  0.}, {-1., -0.3333333333333333}, {-0.6666666666666666, 
                  0.}, {-1., 0.3333333333333333}}], 
                 GrayLevel[0.7]]], {-0.4499999999999998, 
               1.2057703663103027`*^-8}, {-0.25, 0}, 
               Offset[8], {0.9999999999999997, -2.6794897029117842`*^-8}]}, {
              EdgeForm[
               AbsoluteThickness[1]], FontSize -> 10, {{{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{-0.9999999999999997, 2.6794897029117842`*^-8}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["]", 
                  
                  Offset[{7, 0}, {-0.9999999999999997, 
                   2.6794897029117842`*^-8}]]}}, {{
                 GrayLevel[0.85], 
                 EdgeForm[
                  GrayLevel[0.5]], 
                 Disk[{0., 0.}, 
                  Offset[{2, 2}]]}, {
                 GrayLevel[0.5], 
                 Text["", 
                  Offset[{0, 0}, {0., 0.}]]}}}}}, 
            ImageSize -> {68.99999999999997, 15.000001473719337`}, 
            AspectRatio -> Full, PlotRangePadding -> 0, 
            ImagePadding -> {{7., 7.}, {10., 5.}}, 
            ImageMargins -> {{0, 0}, {0, 0}}, 
            BaseStyle -> {TooltipBoxOptions -> {TooltipDelay -> 0.08}}], 
           "Output"}], 
         GrayLevel[0.5]]}, Center], "Tooltip"]& ]}, 
   {EdgeForm[AbsoluteThickness[1]], 
    StyleBox[{
      {GrayLevel[0.85], EdgeForm[GrayLevel[0.5]], 
       DiskBox[{-6.999999999999997, 1.875642792038249*^-7}, 
        Offset[{2., 2.}, {0., 0.}]]}, 
      {EdgeForm[RGBColor[0.881, 0.65, 0.65]], FaceForm[RGBColor[
       0.9206666666666666, 0.7666666666666667, 0.7666666666666667]], 
       RectangleBox[NCache[
        Offset[{Rational[-21, 2], Rational[-21, 2]}, {-5.999999999999998, 
          1.6076938217470707`*^-7}], 
         Offset[{-10.5, -10.5}, {-5.999999999999998, 
          1.6076938217470707`*^-7}]], NCache[
        Offset[{Rational[21, 2], Rational[21, 2]}, {-5.999999999999998, 
          1.6076938217470707`*^-7}], 
         Offset[{10.5, 10.5}, {-5.999999999999998, 
          1.6076938217470707`*^-7}]]], InsetBox[
        GraphicsBox[
         GraphicsComplexBox[{{0.1, 0}, {-0.3, 1}, {0.5, 1}, {1.3, 1}, {
           0.9, 0}}, {
           {Opacity[0.2], 
            LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 2}, {5, 3}, {5, 4}}]}, 
           {GrayLevel[0.33], AbsolutePointSize[3.5], 
            PointBox[{1, 5, 2, 3, 4}]}}],
         ImageSize->18], {-5.999999999999998, 1.6076938217470707*^-7}]}, 
      {EdgeForm[GrayLevel[0.85]], FaceForm[RGBColor[0.9, 0.9, 0.9]], 
       DiskBox[{-4.999999999999998, 1.339744851455892*^-7}, Offset[
        11.666666666666668]], InsetBox[
        FormBox[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm1toVEcYxzeahrRqES0VaSK1FaEvWpuCxVqlrYkXmnrjSGuuOzNnUlGj
JhFbUAJ9EYVQUB8aFJpsPDMq6kNR+lJtn8QqaAu9V9rSgrUPxfrg/fr/NkaS
zewteznj7vnDBLI55+S/P75vZr6ZOVPZhhVyVCgUai/HjxXhLW+2tYU/Wjke
vzit7WtaWl2xuLXDbXHbXmOj8eEraMvQSkOBCly1fhtwnM4yIfR0ztUil3st
UqiPpdB7/faVovLKr6nps/FCeAsl19tcoY64XP3iCn1Hugfux7Z8+spAOebX
OYqx/fMQXzvA6RzaXROrgN9QIcaqhFC7wetSqryKnZ/jOKORl6sRa2fS4QTG
91yu/0Y+f4V+r4f6P7D/IFu+cqxs8CtxmW7A976QEiuhvwPjTyX3BGPq1fr6
yJgsePBLGfFzm/UcxM75JMwuI54iaKs43zshW8Yt0Yj4MbZvHPKtm+IpDrO7
yMVjYLac5ifZNm2R0ubH+f7Xwe6PONxuElfOI9NyYdZCpcUP/VwHGN025qpQ
XlOTfj5HPm1VSvww7y0nPuaYUz/SHC/XRi1VUn4NDb0TEXOnzPMO1UVs82HU
UiXk19ysK8HpZwO7/zj3luTLpMWKyy8c9l4wjROYr3xPf8unSYtl5Bdlh5rA
0Nd9WVfX93S+TVqsYfxkQ+8U5Oefhrg7WOBzuZFoCD/UUs+C3a/D5ya6h+pb
v0xarEf8KC9NtRg+66V1KD9NWqwoP8pLcDoRyw51vg7YJRTxKwE7ZZijHJdV
3U/4bdBy1aKu2G5gd8pxup7025ztmjFj6W7DWPET1Rx+e7Ndkuma6uqOOzFx
d8nSNYBam1rF5Jnrqhe0XZ318vL7C2s2R1v1gvYblZVVm/z2FtOsk6zrm4w6
4i+KN+I2sN6JsXap395sl+PsGUv7iAP5+ogf0xv89ma75s/vLAW7Lwb3d8QP
c5ddfnt7HBTdG4wZa+fNld8EdVlyuVztNNQWZ8rKxq7025vtklx/aNiruEBr
BSFLxzhbROOCobb4VzbqFx9eEvCLI8lVq6G2+J8xNWvQZQE/g8w5q6/KsDc3
5tKA31CV0J6YIWevCaHeMlwf8Hso+U73UxhTD5vijjH9dpzbAn4QjQfGtWOh
r4DpGwluLXp+LvPeI06GuLsYDkdmJrm9aPlxriZJceBQnHM839I+WgqPKTp+
/efV1UaaixjZcX0wjTOJRcOPuNGZTfD5PU7MXQfXtWk+tuD5UR6CSyf4/GM8
N9bP7izn+qURPL4g+QkRmQpm6zF2fp3ozH903ECdkcEaymPPj/YIaZwEK465
7z4w+S0er0HcbtK6nXzfeybDf289v/7+vq+C3olwmXqX+ihaT8L3PwoOP2Ac
uJWM1+B4w32fNDb2PJcle9bzS5VNwib0aXo3jM5tZ9leQfKj/ASzk+jb2qkv
zKG9guBH+2Fg9jlyeyvV+Xnc+7eeH71fSHMPqglo/4bGCHr/EP1hnQyr2T6f
R7SeX6DM9ACfk0aT
            "], {{0, 25.}, {40., 0}}, {0, 255},
            ColorFunction->RGBColor,
            ImageResolution->144.],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
            Automatic],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->20,
          ImageSizeRaw->{40., 25.},
          PlotRange->{{0, 40.}, {0, 25.}}],
         TraditionalForm], {-4.999999999999998, 1.339744851455892*^-7}]}, 
      {EdgeForm[RGBColor[0.881, 0.65, 0.65]], FaceForm[RGBColor[
       0.9206666666666666, 0.7666666666666667, 0.7666666666666667]], 
       RectangleBox[NCache[
        Offset[{Rational[-21, 2], Rational[-21, 2]}, {-3.9999999999999987`, 
          1.0717958811647137`*^-7}], 
         Offset[{-10.5, -10.5}, {-3.9999999999999987`, 
          1.0717958811647137`*^-7}]], NCache[
        Offset[{Rational[21, 2], Rational[21, 2]}, {-3.9999999999999987`, 
          1.0717958811647137`*^-7}], 
         Offset[{10.5, 10.5}, {-3.9999999999999987`, 
          1.0717958811647137`*^-7}]]], InsetBox[
        GraphicsBox[
         GraphicsComplexBox[{{0.1, 0}, {-0.3, 1}, {0.5, 1}, {1.3, 1}, {
           0.9, 0}}, {
           {Opacity[0.2], 
            LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 2}, {5, 3}, {5, 4}}]}, 
           {GrayLevel[0.33], AbsolutePointSize[3.5], 
            PointBox[{1, 5, 2, 3, 4}]}}],
         ImageSize->18], {-3.9999999999999987, 1.0717958811647137*^-7}]}, 
      {EdgeForm[GrayLevel[0.85]], FaceForm[RGBColor[0.9, 0.9, 0.9]], 
       DiskBox[{-2.999999999999999, 8.038469108735353*^-8}, Offset[
        11.666666666666668]], InsetBox[
        FormBox[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztm1toVEcYxzeahrRqES0VaSK1FaEvWpuCxVqlrYkXmnrjSGuuOzNnUlGj
JhFbUAJ9EYVQUB8aFJpsPDMq6kNR+lJtn8QqaAu9V9rSgrUPxfrg/fr/NkaS
zewteznj7vnDBLI55+S/P75vZr6ZOVPZhhVyVCgUai/HjxXhLW+2tYU/Wjke
vzit7WtaWl2xuLXDbXHbXmOj8eEraMvQSkOBCly1fhtwnM4yIfR0ztUil3st
UqiPpdB7/faVovLKr6nps/FCeAsl19tcoY64XP3iCn1Hugfux7Z8+spAOebX
OYqx/fMQXzvA6RzaXROrgN9QIcaqhFC7wetSqryKnZ/jOKORl6sRa2fS4QTG
91yu/0Y+f4V+r4f6P7D/IFu+cqxs8CtxmW7A976QEiuhvwPjTyX3BGPq1fr6
yJgsePBLGfFzm/UcxM75JMwuI54iaKs43zshW8Yt0Yj4MbZvHPKtm+IpDrO7
yMVjYLac5ifZNm2R0ubH+f7Xwe6PONxuElfOI9NyYdZCpcUP/VwHGN025qpQ
XlOTfj5HPm1VSvww7y0nPuaYUz/SHC/XRi1VUn4NDb0TEXOnzPMO1UVs82HU
UiXk19ysK8HpZwO7/zj3luTLpMWKyy8c9l4wjROYr3xPf8unSYtl5Bdlh5rA
0Nd9WVfX93S+TVqsYfxkQ+8U5Oefhrg7WOBzuZFoCD/UUs+C3a/D5ya6h+pb
v0xarEf8KC9NtRg+66V1KD9NWqwoP8pLcDoRyw51vg7YJRTxKwE7ZZijHJdV
3U/4bdBy1aKu2G5gd8pxup7025ztmjFj6W7DWPET1Rx+e7Ndkuma6uqOOzFx
d8nSNYBam1rF5Jnrqhe0XZ318vL7C2s2R1v1gvYblZVVm/z2FtOsk6zrm4w6
4i+KN+I2sN6JsXap395sl+PsGUv7iAP5+ogf0xv89ma75s/vLAW7Lwb3d8QP
c5ddfnt7HBTdG4wZa+fNld8EdVlyuVztNNQWZ8rKxq7025vtklx/aNiruEBr
BSFLxzhbROOCobb4VzbqFx9eEvCLI8lVq6G2+J8xNWvQZQE/g8w5q6/KsDc3
5tKA31CV0J6YIWevCaHeMlwf8Hso+U73UxhTD5vijjH9dpzbAn4QjQfGtWOh
r4DpGwluLXp+LvPeI06GuLsYDkdmJrm9aPlxriZJceBQnHM839I+WgqPKTp+
/efV1UaaixjZcX0wjTOJRcOPuNGZTfD5PU7MXQfXtWk+tuD5UR6CSyf4/GM8
N9bP7izn+qURPL4g+QkRmQpm6zF2fp3ozH903ECdkcEaymPPj/YIaZwEK465
7z4w+S0er0HcbtK6nXzfeybDf289v/7+vq+C3olwmXqX+ihaT8L3PwoOP2Ac
uJWM1+B4w32fNDb2PJcle9bzS5VNwib0aXo3jM5tZ9leQfKj/ASzk+jb2qkv
zKG9guBH+2Fg9jlyeyvV+Xnc+7eeH71fSHMPqglo/4bGCHr/EP1hnQyr2T6f
R7SeX6DM9ACfk0aT
            "], {{0, 25.}, {40., 0}}, {0, 255},
            ColorFunction->RGBColor,
            ImageResolution->144.],
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
            Automatic],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->20,
          ImageSizeRaw->{40., 25.},
          PlotRange->{{0, 40.}, {0, 25.}}],
         TraditionalForm], {-2.999999999999999, 8.038469108735353*^-8}]}, 
      {EdgeForm[RGBColor[0.881, 0.65, 0.65]], FaceForm[RGBColor[
       0.9206666666666666, 0.7666666666666667, 0.7666666666666667]], 
       RectangleBox[NCache[
        Offset[{Rational[-21, 2], Rational[-21, 2]}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}], 
         Offset[{-10.5, -10.5}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}]], NCache[
        Offset[{Rational[21, 2], Rational[21, 2]}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}], 
         Offset[{10.5, 10.5}, {-1.9999999999999993`, 
          5.3589794058235685`*^-8}]]], InsetBox[
        GraphicsBox[
         GraphicsComplexBox[{{0.1, 0}, {-0.3, 1}, {0.5, 1}, {1.3, 1}, {
           0.9, 0}}, {
           {Opacity[0.2], 
            LineBox[{{1, 2}, {1, 3}, {1, 4}, {5, 2}, {5, 3}, {5, 4}}]}, 
           {GrayLevel[0.33], AbsolutePointSize[3.5], 
            PointBox[{1, 5, 2, 3, 4}]}}],
         ImageSize->18], {-1.9999999999999993, 5.3589794058235685*^-8}]}, 
      {EdgeForm[GrayLevel[0.85]], FaceForm[RGBColor[0.9, 0.9, 0.9]], 
       DiskBox[{-0.9999999999999997, 2.6794897029117842*^-8}, Offset[
        11.666666666666668]], InsetBox[
        StyleBox[
         StyleBox["\<\"\[Sum]\"\>",
          StripOnInput->False,
          FontSize->12,
          FontWeight->Bold],
         StripOnInput->False,
         LineColor->GrayLevel[0.33],
         FrontFaceColor->GrayLevel[0.33],
         BackFaceColor->GrayLevel[0.33],
         GraphicsColor->GrayLevel[0.33],
         FontSize->14,
         FontColor->GrayLevel[
          0.33]], {-0.9999999999999997, 2.6794897029117842*^-8}]}, 
      {GrayLevel[0.85], EdgeForm[GrayLevel[0.5]], 
       DiskBox[{0., 0.}, Offset[{2., 2.}, {0., 0.}]]}},
     FontSize->10]}},
  AspectRatio->Full,
  BaseStyle->{TooltipBoxOptions -> {TooltipDelay -> 0.08}},
  ImageMargins->{{0, 0}, {0, 0}},
  ImagePadding->{{25., 26.5}, {27.499998526280667`, 15.}},
  ImageSize->{436.49999999999983`, 42.50000884231602},
  PlotRangePadding->0]], "Output",
 CellChangeTimes->{{3.851013984595563*^9, 3.851013990828425*^9}, 
   3.851015026056487*^9, 3.851143446970199*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"195f8812-dd80-4be8-a78e-ab2bf7e9dd4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"netFull", "=", 
  RowBox[{"NetTrain", "[", "\[IndentingNewLine]", 
   RowBox[{
   "net", ",", "\[IndentingNewLine]", "trainingSet", ",", 
    "\[IndentingNewLine]", "All", ",", "\[IndentingNewLine]", 
    RowBox[{"ValidationSet", "\[Rule]", "valSet"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<ADAM\>\"", ",", 
       RowBox[{"\"\<LearningRate\>\"", "\[Rule]", 
        RowBox[{"1", "/", "1000"}]}]}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"MaxTrainingRounds", "\[Rule]", "100"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LossFunction", "\[Rule]", 
     RowBox[{"MeanSquaredLossLayer", "[", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.851011510734783*^9, 3.851011591752263*^9}, {
  3.851011681821744*^9, 3.8510116860813513`*^9}, {3.851011849485312*^9, 
  3.8510119241155567`*^9}, {3.851011957930297*^9, 3.851011971625462*^9}, {
  3.851012046473271*^9, 3.851012052133112*^9}, {3.851012518367455*^9, 
  3.851012523188478*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"8c253d28-f8de-4f8b-9536-82a30f8bdbf1"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   TagBox["NetTrainResultsObject",
    "SummaryHead"], "NonInterpretableSummary"], 
  StyleBox["[", "NonInterpretableSummary"], 
  FrameBox[GridBox[{
     {
      ItemBox[
       FrameBox[
        StyleBox["\<\"NetTrain Results\"\>", "SuggestionsBarText",
         StripOnInput->False,
         FontSize->12],
        FrameMargins->{{10, 5}, {-4, 2}},
        FrameStyle->None,
        StripOnInput->False],
       Alignment->{Left, Bottom},
       Background->RGBColor[0.96, 0.96, 0.96],
       Frame->{{False, False}, {True, False}},
       FrameStyle->Opacity[0.1],
       ItemSize->{Automatic, 1},
       StripOnInput->False]},
     {
      ItemBox[
       TagBox[
        FrameBox[
         TagBox[GridBox[{
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["summary"], 
                 TextCell["summary"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["batches:"], 
                  TextCell["batches:"]], "3200"}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["rounds:"], 
                  TextCell["rounds:"]], "100"}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["time:"], 
                  TextCell["time:"]], 
                 InterpretationBox[
                  Cell["9.2s"], 
                  TextCell["9.2s"]]}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["examples/s:"], 
                  TextCell["examples/s:"]], "22173"}, "RowWithSeparators"]},
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["data"], 
                 TextCell["data"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["training examples:"], 
                  TextCell["training examples:"]], "2000"}, 
                "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["validation examples:"], 
                  TextCell["validation examples:"]], "500"}, 
                "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["processed examples:"], 
                  TextCell["processed examples:"]], "204800"}, 
                "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["skipped examples:"], 
                  TextCell["skipped examples:"]], "0"}, "RowWithSeparators"]},
              
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["method"], 
                 TextCell["method"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["ADAM"], 
                  TextCell["ADAM"]], 
                 InterpretationBox[
                  Cell["optimizer"], 
                  TextCell["optimizer"]]}, "RowWithSeparators"], 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 InterpretationBox[
                  Cell["batch size"], 
                  TextCell["batch size"]], "64"}, "RowWithSeparators"], 
               InterpretationBox[
                Cell["CPU"], 
                TextCell["CPU"]]},
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["round"], 
                 TextCell["round"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 TagBox[
                  TooltipBox[
                   InterpretationBox[
                    Cell["loss:"], 
                    TextCell["loss:"]], 
                   TagBox[
                    GridBox[{{
                    
                    TemplateBox[{"\"Measurement: \"", "\"loss\""}, 
                    "RowDefault"]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                    "Column"]], Annotation[#, 
                   Column[{
                    Row[{"Measurement: ", "loss"}]}], "Tooltip"]& ], 
                 TagBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"\"4.69\"", "\[Times]", 
                    SuperscriptBox["10", "\"-2\""]}], ShowStringCharacters -> 
                    False], 0.046933799258018195`, AutoDelete -> True], 
                  ScientificForm[#, 3]& ]}, "RowWithSeparators"]},
              "RowWithSeparators"]},
            {
             TemplateBox[{
               TemplateBox[{5}, "Spacer1"], 
               StyleBox[
                InterpretationBox[
                 Cell["validation"], 
                 TextCell["validation"]], 
                GrayLevel[0.4], StripOnInput -> False]},
              "RowDefault"], 
             TemplateBox[{",", "\",\"", 
               TemplateBox[{"\[ThinSpace]", "\" \"", 
                 TagBox[
                  TooltipBox[
                   InterpretationBox[
                    Cell["loss:"], 
                    TextCell["loss:"]], 
                   TagBox[
                    GridBox[{{
                    
                    TemplateBox[{"\"Measurement: \"", "\"loss\""}, 
                    "RowDefault"]}}, 
                    GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                    DefaultBaseStyle -> "Column", 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                    "Column"]], Annotation[#, 
                   Column[{
                    Row[{"Measurement: ", "loss"}]}], "Tooltip"]& ], 
                 TagBox[
                  InterpretationBox[
                   StyleBox[
                    RowBox[{"\"5.66\"", "\[Times]", 
                    SuperscriptBox["10", "\"-2\""]}], ShowStringCharacters -> 
                    False], 0.056606992816631195`, AutoDelete -> True], 
                  ScientificForm[#, 3]& ]}, "RowWithSeparators"]},
              "RowWithSeparators"]},
            {
             ItemBox[GridBox[{
                {"", 
                 ItemBox["\<\"rounds\"\>",
                  DefaultBaseStyle->"LabeledLabel"]},
                {
                 RotationBox[
                  ItemBox["\<\"loss\"\>",
                   DefaultBaseStyle->"LabeledLabel"],
                  BoxRotation->1.5708], 
                 GraphicsBox[
                  {AbsoluteThickness[1.25], {
                    {Hue[0.083, 1., 1.], LineBox[CompressedData["
1:eJw91ns8ldkaB/BNRA2dSoVJJSlGblFyzQ97s933la2IQkNRSKdS00h0jFHp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                    
                    "]]}, {}}, {
                    {Hue[0.59, 0.7, 0.75], LineBox[CompressedData["
1:eJwtlAs0VWkUxyVKD0mi6SqupEZKiChii3JRuFwXDcmrZqg8qqUaoidFMZGL
agw9vJKSvGuTZNQyScpQSeRVCvd8ZjzCnNOcs85ZZ33nW9/Ze//377/VvAMd
/SQlJCR86Yd5E80v5il7usw6mvsadVvaMfjgzxcjqsbMDLYczmnW7ML/96Wh
p9PkNI514Z3FN8tC9suCwLJm/cymbiw6lU9/WQC/ZaTHSVj3YMK3Oa8XPFSC
lKGs/nrSw/6PA2FNkUs6i3vRvv+xXf9jFQhUdgnlJveiUkH86dW+apCXHT0F
FX0o/fVhZ4efOsS+7Znvo/OZja8Bwzpppk0b+7HTT/kP+19WQs7yhqhS2y/Y
mG49KR2gCTqWaYZuZV+w6l2oe8VeLQhvb+PqOQ6w+a4BqR+ryx0UBvF356Yf
NIPWgsLRRBPPyEGs5R0vHyjRAeEHfpTW3UF8uDv509NSXWjs05MdXDHE1qcH
Bf6rVuyMHsK8jCf0iXVQI2hOLTo/hNcrmYD6cDG9lbtjaAivtJGbhg8M4N54
ZuxcRTGrx3rwClO7WrJBjDEcdbpEQ5CptFEePSjGE0Yb9evQCGaPXHh2KkiM
R4V8n+uVG0BfNzc6776Y1W8jnJvKmWo4J0ZmteORMchqLRSN0Pu77iQNGlSb
QCn3aqbUXApd/spTlX+8CRbrVbaq21Cs3qZQGSIIGremcOvst+G1NWaQvDbQ
YDSAQtXEI3REALeabVPbD1CozKTXCSCuUYwZ86DY/piDynMyNsUV4wLzJUtT
P5rD5TDVGbKFFM5ryCyc6bcZAsItovmtFM7yXLftUNdmSLskoyd5nmL7aQGh
uY5nd3yicFq4za8O3RaQ7h78SVgkxglGnt2WEKqRcyxBjeBIqleOVo8lqLbO
q53Mo9j+bwElV44we4DCwZLDLTN6t0B/ScXkgWoKP1tJ0RJtBbvQgpcX5xDs
eR0n09G7FYQZIyoRfRTLixVMcA2D0wUUvmfa02cFYbNuZwW+orD1pN7zVf48
4CRNtNTIEWSySf7EA+VbiaI1WRTLlzXw08I1jrsRrNd5denAZ2t4aknC3On6
6nDXmg8BNiCvKnM51p1gjR0juA0cGGwP+bifsDzagt1ZySbjLQQr9k6nS7KF
D3uWXtvlTbBk/EKMaN82ECU1voYpCgvPMYBsA0/O6SLxasLyux1SHonOvm+g
MDdL17H963aYGJ9XMV+bYCZdzfZAO2gofDl/djTBawyeA3Yw7htvVRxCWN7t
QWPELe+UK8HUj540MfbwQvrff5ISCD4rHVY/YeQAHvZvu3hPKLRm7HDYAYSH
Og6FcQjrDweIe5NS6+VC0HK+VdSKUQdoHapXqDhD4aPmuU4eG/gwfUGivzeP
IKQ1qiQe4YP2sGJgXwZh/cQHzb81ubX1BE20dxZNG+NDRmaVuk8pwTIm/EZH
KNIIVayi10ZMOUcdIaiNN8kzJaz/HMFcn6Nd1kkhQ9fbMUfYN1ki0/WewrsK
xvTtBGKDGx5GHQTXvpGgCXOCOYCtuS2E9asTFK8tMG6wIqjlH7uwZNwJLi86
P51bTjCbkdNYAEoSBwVqJwiuHF10SyNMAPcHolYqvqFYfwvgwWWvJt8bBJdF
X7NI+CaAkTvdieXxBGm45J6aOEO2Ardavp2gyiImA2ewKL/3bo8JYeeBM0Tw
7N3lKglymHZOOEPbyLMrr+oIJu+LNL2xSQj53v63RXR8RQPGoULYkJ8YVN1M
2PkhBI1gyb2x7wjKP35BEymE2ta6ZaIxgnE0PZGmLtA8WThpq0BQlu5G8TEX
KG+X7Z72gLDzxgX6TjbrbCogOKujt2H5lAvEysh5iAIJnsm+feUnM1eIKvxo
82c4QanvA8cVxFH5H2KWDLPzyRWI4I2lbjyFEt8vN/AR5EaYEgr/AxzQTkQ=

                    "]]}, 
                    {Hue[0.59, 0.7, 0.65], AbsolutePointSize[
                    2.2777777777777777`], PointBox[CompressedData["
1:eJwtlAs0VWkUxyVKD0mi6SqupEZKiChii3JRuFwXDcmrZqg8qqUaoidFMZGL
agw9vJKSvGuTZNQyScpQSeRVCvd8ZjzCnNOcs85ZZ33nW9/Ze//377/VvAMd
/SQlJCR86Yd5E80v5il7usw6mvsadVvaMfjgzxcjqsbMDLYczmnW7ML/96Wh
p9PkNI514Z3FN8tC9suCwLJm/cymbiw6lU9/WQC/ZaTHSVj3YMK3Oa8XPFSC
lKGs/nrSw/6PA2FNkUs6i3vRvv+xXf9jFQhUdgnlJveiUkH86dW+apCXHT0F
FX0o/fVhZ4efOsS+7Znvo/OZja8Bwzpppk0b+7HTT/kP+19WQs7yhqhS2y/Y
mG49KR2gCTqWaYZuZV+w6l2oe8VeLQhvb+PqOQ6w+a4BqR+ryx0UBvF356Yf
NIPWgsLRRBPPyEGs5R0vHyjRAeEHfpTW3UF8uDv509NSXWjs05MdXDHE1qcH
Bf6rVuyMHsK8jCf0iXVQI2hOLTo/hNcrmYD6cDG9lbtjaAivtJGbhg8M4N54
ZuxcRTGrx3rwClO7WrJBjDEcdbpEQ5CptFEePSjGE0Yb9evQCGaPXHh2KkiM
R4V8n+uVG0BfNzc6776Y1W8jnJvKmWo4J0ZmteORMchqLRSN0Pu77iQNGlSb
QCn3aqbUXApd/spTlX+8CRbrVbaq21Cs3qZQGSIIGremcOvst+G1NWaQvDbQ
YDSAQtXEI3REALeabVPbD1CozKTXCSCuUYwZ86DY/piDynMyNsUV4wLzJUtT
P5rD5TDVGbKFFM5ryCyc6bcZAsItovmtFM7yXLftUNdmSLskoyd5nmL7aQGh
uY5nd3yicFq4za8O3RaQ7h78SVgkxglGnt2WEKqRcyxBjeBIqleOVo8lqLbO
q53Mo9j+bwElV44we4DCwZLDLTN6t0B/ScXkgWoKP1tJ0RJtBbvQgpcX5xDs
eR0n09G7FYQZIyoRfRTLixVMcA2D0wUUvmfa02cFYbNuZwW+orD1pN7zVf48
4CRNtNTIEWSySf7EA+VbiaI1WRTLlzXw08I1jrsRrNd5denAZ2t4aknC3On6
6nDXmg8BNiCvKnM51p1gjR0juA0cGGwP+bifsDzagt1ZySbjLQQr9k6nS7KF
D3uWXtvlTbBk/EKMaN82ECU1voYpCgvPMYBsA0/O6SLxasLyux1SHonOvm+g
MDdL17H963aYGJ9XMV+bYCZdzfZAO2gofDl/djTBawyeA3Yw7htvVRxCWN7t
QWPELe+UK8HUj540MfbwQvrff5ISCD4rHVY/YeQAHvZvu3hPKLRm7HDYAYSH
Og6FcQjrDweIe5NS6+VC0HK+VdSKUQdoHapXqDhD4aPmuU4eG/gwfUGivzeP
IKQ1qiQe4YP2sGJgXwZh/cQHzb81ubX1BE20dxZNG+NDRmaVuk8pwTIm/EZH
KNIIVayi10ZMOUcdIaiNN8kzJaz/HMFcn6Nd1kkhQ9fbMUfYN1ki0/WewrsK
xvTtBGKDGx5GHQTXvpGgCXOCOYCtuS2E9asTFK8tMG6wIqjlH7uwZNwJLi86
P51bTjCbkdNYAEoSBwVqJwiuHF10SyNMAPcHolYqvqFYfwvgwWWvJt8bBJdF
X7NI+CaAkTvdieXxBGm45J6aOEO2Ardavp2gyiImA2ewKL/3bo8JYeeBM0Tw
7N3lKglymHZOOEPbyLMrr+oIJu+LNL2xSQj53v63RXR8RQPGoULYkJ8YVN1M
2PkhBI1gyb2x7wjKP35BEymE2ta6ZaIxgnE0PZGmLtA8WThpq0BQlu5G8TEX
KG+X7Z72gLDzxgX6TjbrbCogOKujt2H5lAvEysh5iAIJnsm+feUnM1eIKvxo
82c4QanvA8cVxFH5H2KWDLPzyRWI4I2lbjyFEt8vN/AR5EaYEgr/AxzQTkQ=

                    "]]}}},
                  AspectRatio->Full,
                  Axes->None,
                  Background->GrayLevel[1],
                  
                  BaseStyle->{
                   FontFamily -> "Verdana", FontSize -> 8, FontColor -> 
                    GrayLevel[0.5], ScriptSizeMultipliers -> 0.2, 
                    ScriptMinSize -> 6},
                  Frame->True,
                  FrameStyle->GrayLevel[0.5],
                  FrameTicks->None,
                  GridLines->{{25., 50., 75., 100., 125., 150.}, {{-2., 
                    GrayLevel[0.3001]}, {-1., 
                    GrayLevel[0.3001]}, {0., 
                    GrayLevel[0.3001]}, {1., 
                    GrayLevel[0.3001]}, {-1.6989700043360185`, 
                    GrayLevel[0.8501]}, {-1.3979400086720375`, 
                    GrayLevel[0.8501]}, {-1.2218487496163564`, 
                    GrayLevel[0.8501]}, {-1.0969100130080565`, 
                    GrayLevel[0.8501]}, {-0.6989700043360187, 
                    GrayLevel[0.8501]}, {-0.39794000867203755`, 
                    GrayLevel[0.8501]}, {-0.22184874961635626`, 
                    GrayLevel[0.8501]}, {-0.09691001300805638, 
                    GrayLevel[0.8501]}, {0.30102999566398114`, 
                    GrayLevel[0.8501]}, {0.6020599913279623, 
                    GrayLevel[0.8501]}, {0.7781512503836435, 
                    GrayLevel[0.8501]}, {0.9030899869919434, 
                    GrayLevel[0.8501]}, {1.301029995663981, 
                    GrayLevel[0.8501]}, {1.6020599913279623`, 
                    GrayLevel[0.8501]}, {1.7781512503836434`, 
                    GrayLevel[0.8501]}, {1.9030899869919433`, 
                    GrayLevel[0.8501]}}},
                  ImagePadding->1,
                  ImageSize->{302, 182.},
                  PlotRange->{{0, 100.046875}, {-1.829, 1.129}},
                  PlotRangeClipping->True,
                  PlotRangePadding->None,
                  Prolog->{{
                    InsetBox[
                    FormBox["25", TraditionalForm], 
                    Offset[{-2, -2}, {25., 1.129}], 
                    ImageScaled[{1., 1.}]], 
                    InsetBox[
                    FormBox["50", TraditionalForm], 
                    Offset[{-2, -2}, {50., 1.129}], 
                    ImageScaled[{1., 1.}]], 
                    InsetBox[
                    FormBox["75", TraditionalForm], 
                    Offset[{-2, -2}, {75., 1.129}], 
                    ImageScaled[{1., 1.}]], 
                    InsetBox[
                    FormBox["100", TraditionalForm], 
                    Offset[{-2, -2}, {100., 1.129}], 
                    ImageScaled[{1., 1.}]], 
                    InsetBox[
                    FormBox["125", TraditionalForm], 
                    Offset[{-2, -2}, {125., 1.129}], 
                    ImageScaled[{1., 1.}]], 
                    InsetBox[
                    FormBox["150", TraditionalForm], 
                    Offset[{-2, -2}, {150., 1.129}], 
                    ImageScaled[{1., 1.}]]}, {
                    InsetBox[
                    FormBox[
                    
                    TemplateBox[{"10", "\"-1\""}, "Superscript", SyntaxForm -> 
                    SuperscriptBox], TraditionalForm], 
                    Offset[{3, 0}, {0, -1.}], 
                    ImageScaled[{0, 0.}]], 
                    InsetBox[
                    FormBox["\"1\"", TraditionalForm], 
                    Offset[{3, 0}, {0, 0.}], 
                    ImageScaled[{0, 0.}]], 
                    InsetBox[
                    FormBox["\"10\"", TraditionalForm], 
                    Offset[{3, 0}, {0, 1.}], 
                    ImageScaled[{0, 0.}]]}}]}
               },
               
               BaseStyle->{
                FontFamily -> "Verdana", FontSize -> 8, FontColor -> 
                 GrayLevel[0.4]},
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "Rows" -> {{Center}}},
               GridBoxSpacings->{"Columns" -> {{0.5}}}],
              Alignment->Center,
              StripOnInput->False], "\[SpanFromLeft]"},
            {
             ItemBox[
              StyleBox[
               RowBox[{
                GraphicsBox[{},
                 Axes->None,
                 Background->Hue[0.083, 1., 1.],
                 ImagePadding->{{0, 0}, {5, 2}},
                 ImageSize->{13, 1}], "  ", "\<\"training set\"\>", "\t", 
                GraphicsBox[{},
                 Axes->None,
                 Background->Hue[0.59, 0.7, 0.75],
                 ImagePadding->{{0, 0}, {5, 2}},
                 ImageSize->{13, 1}], "  ", "\<\"validation set\"\>"}],
               FontFamily->"Verdana",
               FontSize->8,
               FontColor->GrayLevel[0.4]],
              Alignment->Center,
              StripOnInput->False], "\[SpanFromLeft]"}
           },
           AutoDelete->False,
           ColumnsEqual->False,
           
           GridBoxAlignment->{
            "Columns" -> {Right, {Left}}, "Rows" -> {{Baseline}}},
           GridBoxDividers->{"Columns" -> {False, {
                Opacity[0.15]}, False}},
           GridBoxItemSize->{"Columns" -> {8, {26}}, "Rows" -> {{1.}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], 
               Offset[1.1199999999999999`], {
                Offset[1.75]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.8]}, 
               Offset[0.2]}}],
          "Grid"],
         FrameMargins->{{10, 10}, {10, 5}},
         FrameStyle->None,
         StripOnInput->False],
        Deploy,
        DefaultBaseStyle->"Deploy"],
       Alignment->Center,
       BaseStyle->{
        FontWeight -> "Light", FontSize -> 11, FontFamily -> 
         ".AppleSystemUIFont", NumberMarks -> False, Deployed -> False},
       StripOnInput->False]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], 
        Offset[0.8], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   Background->GrayLevel[1],
   FrameMargins->{{0, 0}, {0, 0}},
   FrameStyle->GrayLevel[0.85],
   RoundingRadius->5,
   StripOnInput->False], 
  StyleBox["]", "NonInterpretableSummary"]}]], "Output",
 CellChangeTimes->{
  3.8510115836292152`*^9, 3.8510116874706593`*^9, 3.851011856542592*^9, 
   3.851011891478949*^9, 3.851011936397272*^9, 3.851011972869611*^9, 
   3.85101205375902*^9, {3.851012512320599*^9, 3.851012539570675*^9}, {
   3.851012840991475*^9, 3.8510128636926117`*^9}, 3.851014014412159*^9, 
   3.851015033701486*^9, 3.851143503252763*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"01659ff1-7cba-4b73-bf3d-f9c9894e5f7f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"trainedNN", "=", 
   RowBox[{"netFull", "[", "\"\<TrainedNet\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"actual", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"testSet", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "testSet", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"predict", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"trainedNN", "[", 
      RowBox[{"testSet", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "testSet", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.851015048548381*^9, 3.85101505558243*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"84c0c5af-638b-419b-b917-4819e5c5cc10"],

Cell["Naive Precision", "Text",
 CellChangeTimes->{{3.8510145924516487`*^9, 
  3.851014599807962*^9}},ExpressionUUID->"3636952e-cad6-4a85-95ab-\
d7ae5430a73e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"actual", "-", 
       RowBox[{"Round", "[", "predict", "]"}]}], ",", 
      RowBox[{
       RowBox[{"#", "==", "0"}], "&"}]}], "]"}], "]"}], "/", 
   RowBox[{"Length", "[", "actual", "]"}]}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.851014556244891*^9, 3.851014584476871*^9}, {
  3.851015152301115*^9, 3.851015154701827*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"15067c66-d75c-4287-b355-edbae287748c"],

Cell[BoxData["0.9353735373537354`"], "Output",
 CellChangeTimes->{{3.8510145673491907`*^9, 3.851014584800899*^9}, 
   3.851015155404277*^9, 3.8511435385239*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"0de3d6fb-9e14-4314-83e0-6cbf9cf06ee2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matthewsPhi", "[", 
   RowBox[{"actual", ",", 
    RowBox[{"Round", "[", "predict", "]"}]}], "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.851014640918413*^9, 3.851014648016128*^9}, {
  3.851015157927709*^9, 3.851015160217495*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"5bc095c0-9c1f-4253-b9bb-e813726f7dfe"],

Cell[BoxData["0.8656206651920333`"], "Output",
 CellChangeTimes->{{3.851014645502967*^9, 3.851014648442329*^9}, 
   3.851015161047638*^9, 3.851143554307523*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"c7a8b48e-f573-4f95-ac17-269b53b7c5a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"confusion", "[", 
   RowBox[{"actual", ",", 
    RowBox[{"Round", "[", "predict", "]"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.851014996932404*^9, 3.851015004452363*^9}, {
  3.851015163578868*^9, 3.8510151659034557`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"4fff9281-4c2e-49fa-990c-b2a6eebde150"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2039", "215"},
     {"144", "3157"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.851015004826632*^9, 3.85101516657819*^9, 
  3.851143558968843*^9},
 CellLabel->
  "Out[39]//MatrixForm=",ExpressionUUID->"3437d96e-342a-432e-b099-\
228cc2cada7f"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{774, 737},
WindowMargins->{{100, Automatic}, {18, Automatic}},
FrontEndVersion->"13.0 for Mac OS X ARM (64-bit) (December 2, 2021)",
StyleDefinitions->FrontEnd`FileName[{"Report"}, "StandardReport.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"4bd394eb-4add-4727-9738-e35861a1dec4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 8168, 221, 651, "Input",ExpressionUUID->"15c9569f-f7ea-4672-957a-57f76fc7eb1a"],
Cell[8729, 243, 213, 3, 34, "Text",ExpressionUUID->"4d6922f5-c420-48d5-8527-cd4f9b1ee34f"],
Cell[CellGroupData[{
Cell[8967, 250, 226, 4, 41, "Input",ExpressionUUID->"48854ceb-23ab-4001-aae5-18fa04e2d620"],
Cell[9196, 256, 11002, 281, 212, "Output",ExpressionUUID->"93353efa-16fa-49f5-bdcd-c7b6e024833e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20235, 542, 159, 3, 69, "Section",ExpressionUUID->"c7c14a98-78ce-4410-9b32-db04338e2960"],
Cell[20397, 547, 173, 3, 34, "Text",ExpressionUUID->"0f19135b-9207-4186-a082-19752c640881"],
Cell[CellGroupData[{
Cell[20595, 554, 308, 7, 41, "Input",ExpressionUUID->"4bce5f15-fb1e-4360-8b26-9137ddd3cecd"],
Cell[20906, 563, 3793, 69, 246, "Output",ExpressionUUID->"6d056553-3bbe-4ac6-a918-ebe7984a6aaa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24736, 637, 310, 7, 41, "Input",ExpressionUUID->"4c2c1aaa-a0f7-4bb7-b3f6-e82574577346"],
Cell[25049, 646, 29470, 886, 249, "Output",ExpressionUUID->"18f61689-7756-4fa1-97fd-7fe337ee59a4"]
}, Open  ]],
Cell[54534, 1535, 174, 3, 34, "Text",ExpressionUUID->"a203c468-9dc3-427b-9245-155d5dd601c3"],
Cell[CellGroupData[{
Cell[54733, 1542, 308, 7, 41, "Input",ExpressionUUID->"921b3c21-a5ee-47e5-8dad-e9d672908669"],
Cell[55044, 1551, 15003, 445, 241, "Output",ExpressionUUID->"2d79a655-5987-4d69-9706-f2c9442cdbd0"]
}, Open  ]],
Cell[70062, 1999, 256, 6, 57, "Text",ExpressionUUID->"f0035f8d-2f0e-4c60-9b71-23b9d7a02a75"],
Cell[CellGroupData[{
Cell[70343, 2009, 674, 19, 41, "Input",ExpressionUUID->"9bd2b978-5920-4fb7-bbb6-bd5797b9092f"],
Cell[71020, 2030, 11252, 289, 212, "Output",ExpressionUUID->"b04743dc-5ac7-4b5d-8fab-c8531e878289"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82309, 2324, 304, 7, 41, "Input",ExpressionUUID->"60f434d4-5f36-4465-b0ad-89964e66973f"],
Cell[82616, 2333, 320, 8, 41, "Output",ExpressionUUID->"7edfc5b2-9361-41e4-a11d-49d228a3669d"]
}, Open  ]],
Cell[82951, 2344, 172, 3, 34, "Text",ExpressionUUID->"352d6c36-20fe-4311-8904-3858cad45932"],
Cell[83126, 2349, 692, 17, 84, "Input",ExpressionUUID->"88275639-ab57-4233-b14d-8699cf8426ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83855, 2371, 155, 3, 69, "Section",ExpressionUUID->"88e5e2cb-a950-4a9e-bd20-f13cff8d974b"],
Cell[84013, 2376, 186, 3, 34, "Text",ExpressionUUID->"c7131038-8fda-4d26-a2d8-8711559bc755"],
Cell[84202, 2381, 1427, 29, 231, "Input",ExpressionUUID->"ddd6e5ed-813a-4d2b-8bcc-d40054b2d8a1"],
Cell[CellGroupData[{
Cell[85654, 2414, 263, 5, 41, "Input",ExpressionUUID->"0640c3e6-2efb-4542-8ea0-ff9a5ac0fefc"],
Cell[85920, 2421, 71276, 1626, 67, "Output",ExpressionUUID->"864acba5-4a9b-44bb-8663-301c26ad3710"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157233, 4052, 966, 20, 210, "Input",ExpressionUUID->"740b1210-32d5-4168-a8a0-bd0462e9b631"],
Cell[158202, 4074, 34311, 702, 504, "Output",ExpressionUUID->"48bff3ad-c8bf-4d73-a306-6689a45d2f20"]
}, Open  ]],
Cell[192528, 4779, 1088, 31, 84, "Input",ExpressionUUID->"27935e91-6730-4414-9299-077014d35e9d"],
Cell[193619, 4812, 159, 3, 34, "Text",ExpressionUUID->"e097d3ad-74e6-49af-9689-6fc65b277758"],
Cell[CellGroupData[{
Cell[193803, 4819, 441, 11, 41, "Input",ExpressionUUID->"cf90be8d-9edf-4e52-b808-103ee0054364"],
Cell[194247, 4832, 219, 3, 41, "Output",ExpressionUUID->"bd89d0b6-00c2-4367-a40c-f971a3186f6c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194503, 4840, 268, 5, 41, "Input",ExpressionUUID->"fed8847a-4ef4-483c-999a-98c7c3af1025"],
Cell[194774, 4847, 217, 3, 41, "Output",ExpressionUUID->"56dcaf8b-db91-4e16-92be-f017bb9323a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195028, 4855, 275, 5, 41, "Input",ExpressionUUID->"e85325ed-ee04-4a37-92a0-51c4abdeaabe"],
Cell[195306, 4862, 652, 19, 67, "Output",ExpressionUUID->"48ce2e40-782a-4488-bfd9-11131297c18a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196007, 4887, 154, 3, 69, "Section",ExpressionUUID->"7e8b99bf-e8ca-41cf-b3b3-31de1d4d5e97"],
Cell[196164, 4892, 234, 4, 34, "Text",ExpressionUUID->"f6c7d017-5db2-4498-b2ef-2673f5563f9c"],
Cell[196401, 4898, 1120, 23, 210, "Input",ExpressionUUID->"ecd56916-eb52-4623-8dea-6678244c4a33"],
Cell[CellGroupData[{
Cell[197546, 4925, 193, 3, 41, "Input",ExpressionUUID->"5bdde66c-3568-4733-95d7-553153956393"],
Cell[197742, 4930, 81132, 1856, 67, "Output",ExpressionUUID->"195f8812-dd80-4be8-a78e-ab2bf7e9dd4f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[278911, 6791, 1145, 23, 210, "Input",ExpressionUUID->"8c253d28-f8de-4f8b-9536-82a30f8bdbf1"],
Cell[280059, 6816, 23250, 497, 476, "Output",ExpressionUUID->"01659ff1-7cba-4b73-bf3d-f9c9894e5f7f"]
}, Open  ]],
Cell[303324, 7316, 985, 29, 84, "Input",ExpressionUUID->"84c0c5af-638b-419b-b917-4819e5c5cc10"],
Cell[304312, 7347, 159, 3, 34, "Text",ExpressionUUID->"3636952e-cad6-4a85-95ab-d7ae5430a73e"],
Cell[CellGroupData[{
Cell[304496, 7354, 527, 13, 41, "Input",ExpressionUUID->"15067c66-d75c-4287-b355-edbae287748c"],
Cell[305026, 7369, 239, 3, 41, "Output",ExpressionUUID->"0de3d6fb-9e14-4314-83e0-6cbf9cf06ee2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305302, 7377, 351, 7, 41, "Input",ExpressionUUID->"5bc095c0-9c1f-4253-b9bb-e813726f7dfe"],
Cell[305656, 7386, 239, 3, 41, "Output",ExpressionUUID->"c7a8b48e-f573-4f95-ac17-269b53b7c5a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[305932, 7394, 363, 8, 41, "Input",ExpressionUUID->"4fff9281-4c2e-49fa-990c-b2a6eebde150"],
Cell[306298, 7404, 676, 20, 120, "Output",ExpressionUUID->"3437d96e-342a-432e-b099-228cc2cada7f"]
}, Open  ]]
}, Open  ]]
}
]
*)

