(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    161572,       3519]
NotebookOptionsPosition[    155928,       3425]
NotebookOutlinePosition[    156288,       3441]
CellTagsIndexPosition[    156245,       3438]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Numerical solution of the Zerilli equation with a source term given by an \
infalling particle \
\>", "Title",
 CellChangeTimes->{{3.722026108833889*^9, 3.722026133002123*^9}, {
  3.722063827267627*^9, 3.722063838046527*^9}, {3.7430144054961233`*^9, 
  3.743014406101254*^9}, {3.743043391265998*^9, 
  3.7430433943509912`*^9}},ExpressionUUID->"a893aa8d-e120-4316-b312-\
36ac0a6454d4"],

Cell[BoxData[
 RowBox[{"Exit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.72198799897161*^9, 3.72198799990344*^9}, {
  3.743016558004128*^9, 
  3.7430165586531563`*^9}},ExpressionUUID->"b7cb238b-0af9-4761-b44f-\
94cf57b81ced"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "\[GreaterEqual]", "0"}], ",", 
      RowBox[{"M", ">", "0"}], ",", 
      RowBox[{"Element", "[", 
       RowBox[{"L", ",", "Integers"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "set", " ", "up", " ", "the", " ", "working", " ", 
    "directory", " ", "of", " ", "the", " ", 
    RowBox[{"notebook", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "path", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.717417827152334*^9, 3.717417827545067*^9}, {
   3.720525806525712*^9, 3.72052580687288*^9}, {3.720960445169264*^9, 
   3.72096044584095*^9}, {3.721032400106536*^9, 3.721032401314507*^9}, 
   3.722585389504361*^9, {3.724767015218999*^9, 3.724767015946599*^9}, {
   3.724767570416555*^9, 3.7247675708351393`*^9}, {3.724768211416267*^9, 
   3.72476822262503*^9}, {3.7247869373512907`*^9, 3.724786939953195*^9}, {
   3.7258011818217373`*^9, 3.725801182345151*^9}, {3.743014362739792*^9, 
   3.74301438172966*^9}, {3.7430151467686777`*^9, 
   3.7430151474379272`*^9}},ExpressionUUID->"6e6b942d-4ccd-46ce-a2a3-\
cb33cb44a2e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Load", " ", "the", " ", "equations", " ", "to", " ", "be", " ", 
     "integrated"}], ",", " ", 
    RowBox[{"which", " ", "have", " ", "been", " ", "previously", " ", 
     RowBox[{"computed", ".", " ", 
      RowBox[{"We", "'"}]}], "ll", " ", "use", " ", "\"\<Zerillir\>\"", " ", 
     RowBox[{"i", ".", "e", ".", " ", "the"}], " ", "Zerilli", " ", 
     "equation", " ", "in", " ", "the", " ", "tortoise", " ", "cooridate", 
     " ", "and", " ", "\"\<Zerilli1\>\""}], ",", " ", 
    RowBox[{
    "which", " ", "is", " ", "in", " ", "the", " ", "standard", " ", "radial",
      " ", 
     RowBox[{"coordinate", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "Polareq1", ",", "Polareq2", ",", "sH2", ",", "Zerilli1", ",", 
      "Zerilli2", ",", "Zerillir"}], "}"}], "=", 
    RowBox[{"Import", "[", "\"\<Polar_GR.m\>\"", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.722416040375257*^9, 3.7224160782335997`*^9}, {
  3.723098548806778*^9, 3.723098549341797*^9}, {3.723112569492858*^9, 
  3.723112569765655*^9}, {3.723273790403697*^9, 3.723273790636478*^9}, {
  3.7430171339377604`*^9, 3.74301713837572*^9}, {3.7430392481260433`*^9, 
  3.743039248523346*^9}, {3.743043401127863*^9, 
  3.743043474323722*^9}},ExpressionUUID->"e0198571-83a2-453d-a87c-\
851c0588e427"],

Cell[CellGroupData[{

Cell["\<\
Energy tensor coefficients for the radial plunge and master equation\
\>", "Subsection",
 CellChangeTimes->{
  3.7430436077337027`*^9, {3.7431754498299522`*^9, 
   3.74317545509853*^9}},ExpressionUUID->"5cc60782-e646-4b74-8d15-\
746e2f088b17"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "is", " ", "the", " ", "functional", " ", "form", " ", "of", 
     " ", "the", " ", "tensor", " ", "harmonic", " ", "components", " ", 
     "coefficients", " ", "for", " ", "the", " ", "stress", " ", "energy", 
     " ", 
     RowBox[{"tensor", " ", "[", 
      RowBox[{
       RowBox[{"by", " ", "Sago", " ", "et", " ", 
        RowBox[{"al", ".", "PRD"}], " ", "67"}], ",", 
       RowBox[{"10", " ", 
        RowBox[{"(", "2003", ")"}]}]}], "]"}], " ", "To", " ", "specify", " ",
      "the", " ", "particular", " ", "orbital", " ", "motion", " ", "we", " ",
      "need", " ", "to", " ", "compute", " ", "the", " ", "components", " ", 
     "of", " ", "the", " ", "particle"}], "-", 
    RowBox[{"four", " ", "velocity"}]}], " ", "*)"}], "  "}]], "Input",
 CellChangeTimes->{{3.743044511220558*^9, 
  3.743044642799118*^9}},ExpressionUUID->"3c9680ab-1470-4dba-854e-\
f69443949b06"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sourcevector", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"m", " ", "\[Gamma]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["dR", "2"], 
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", 
            RowBox[{"2", "M"}]}], ")"}], "2"]], "\[Delta]", " ", 
        "\[ScriptCapitalY]"}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "M"}], "r"]}], ")"}], "2"], 
        FractionBox["1", 
         SuperscriptBox["r", "2"]], "\[Delta]", " ", "\[ScriptCapitalY]"}], 
       ",", 
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], " ", "I", " ", "dR", 
        FractionBox["1", 
         SuperscriptBox["r", "2"]], "\[Delta]", " ", "\[ScriptCapitalY]"}], 
       ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "\[ScriptL]", 
           RowBox[{"(", 
            RowBox[{"\[ScriptL]", "+", "1"}], ")"}]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], "I", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "M"}], "r"]}], ")"}], 
        FractionBox["1", "r"], "\[Delta]", " ", "d\[ScriptCapitalY]dt"}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "\[ScriptL]", 
           RowBox[{"(", 
            RowBox[{"\[ScriptL]", "+", "1"}], ")"}]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"2", "M"}]}], ")"}], 
         RowBox[{"-", "1"}]], "dR", " ", "\[Delta]", " ", 
        "d\[ScriptCapitalY]dt"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], "\[ScriptL]", 
            RowBox[{"(", 
             RowBox[{"\[ScriptL]", "+", "1"}], ")"}]}], ")"}], 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]]}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "M"}], "r"]}], ")"}], 
        FractionBox["1", "r"], "\[Delta]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]], 
           "d\[ScriptCapitalY]d\[Phi]", " ", "d\[Theta]dt"}], "-", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], 
           "d\[ScriptCapitalY]d\[Theta]", " ", "d\[Phi]dt"}]}], ")"}]}], ",", 
       
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], "l", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"2", "M"}]}], ")"}], 
         RowBox[{"-", "1"}]], "I", " ", "dR", " ", "\[Delta]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]], 
           "d\[ScriptCapitalY]d\[Phi]", " ", "d\[Theta]dt"}], "-", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], 
           "d\[ScriptCapitalY]d\[Theta]", " ", "d\[Phi]dt"}]}], ")"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], "\[ScriptL]", 
            RowBox[{"(", 
             RowBox[{"\[ScriptL]", "+", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"\[ScriptL]", "-", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"\[ScriptL]", "+", "2"}], ")"}]}], ")"}], 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}]]}], "I", " ", "\[Delta]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["d\[Theta]dt", "2"], "-", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
              SuperscriptBox["d\[Phi]dt", "2"]}]}], ")"}], 
           FractionBox["1", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]], "X"}], "-", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "d\[Theta]dt", " ", 
           "d\[Phi]dt", " ", "W"}]}], ")"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "\[ScriptL]", 
           RowBox[{"(", 
            RowBox[{"\[ScriptL]", "+", "1"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"\[ScriptL]", "-", "1"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"\[ScriptL]", "+", "2"}], ")"}]}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], " ", "\[Delta]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d\[Theta]dt", " ", "d\[Phi]dt", " ", "X"}], "+", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["d\[Theta]dt", "2"], "-", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
              SuperscriptBox["d\[Phi]dt", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
       RowBox[{
        FractionBox["\[Delta]", 
         RowBox[{"Sqrt", "[", "2", "]"}]], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["d\[Theta]dt", "2"], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
           SuperscriptBox["d\[Phi]dt", "2"]}]}], ")"}], 
        "\[ScriptCapitalY]"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743044440520185*^9, 
  3.7430444682853613`*^9}},ExpressionUUID->"cc45a341-a663-4d4e-b5d5-\
abe2d04a01ac"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"u0", ",", "ur", ",", "u"}], "]"}]], "Input",ExpressionUUID->\
"6065a17e-9b48-4e67-acca-63ccb4093222"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Background", " ", "metric"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"g", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", 
             RowBox[{"M", "/", "r"}]}]}], ")"}]}], ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox["1", 
          RowBox[{"1", "-", 
           RowBox[{"2", 
            RowBox[{"M", "/", "r"}]}]}]], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         SuperscriptBox["r", "2"], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         RowBox[{
          SuperscriptBox["r", "2"], 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Components", " ", "of", " ", "the", " ", "4", " ", "velocity", " ", 
     "for", " ", "the", " ", "radial", " ", "infall"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u0", "=", 
     RowBox[{"\[ScriptE]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", 
          RowBox[{"M", "/", "r"}]}]}], ")"}], 
       RowBox[{"-", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{"u0", ",", "ur", ",", "0", ",", "0"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.72659644684123*^9, 3.726596481214541*^9}, {
   3.726597086215626*^9, 3.726597106525403*^9}, {3.726641380451104*^9, 
   3.7266413888461227`*^9}, {3.7266418693446817`*^9, 3.726641871021326*^9}, 
   3.7266479266403*^9, {3.726648026255109*^9, 3.7266480506156273`*^9}, 
   3.726648128127907*^9, 3.730011391987267*^9, 3.7309023295640507`*^9, {
   3.7430436375803843`*^9, 3.743043676472248*^9}, {3.743044841810811*^9, 
   3.7430448453374233`*^9}, {3.743045016604761*^9, 
   3.7430450171410713`*^9}},ExpressionUUID->"85f1ad42-99eb-4723-8bc5-\
e562e2d790ac"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ur", "=", 
    RowBox[{"Assuming", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"r", ">", 
        RowBox[{"2", "M"}]}], "&&", 
       RowBox[{"M", ">", "0"}]}], ",", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sum", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"g", "[", 
               RowBox[{"[", 
                RowBox[{"l1", ",", "l2"}], "]"}], "]"}], 
              RowBox[{"u", "[", 
               RowBox[{"[", "l1", "]"}], "]"}], 
              RowBox[{"u", "[", 
               RowBox[{"[", "l2", "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"l1", ",", "1", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l2", ",", "1", ",", "4"}], "}"}]}], "]"}], "\[Equal]", 
           
           RowBox[{"-", "1"}]}], ",", "ur"}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dRdt", "=", 
   RowBox[{"ur", "/", "u0"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7266418426620207`*^9, 3.726641863297861*^9}, {
   3.726641904754202*^9, 3.726641927076089*^9}, {3.726642058898754*^9, 
   3.726642063550517*^9}, 3.7266479571737013`*^9, 3.726648057298748*^9, 
   3.726648517043467*^9, {3.726648554552593*^9, 3.726648571632318*^9}, 
   3.7269277989508677`*^9, 3.729510232296276*^9, 3.729510423521771*^9, {
   3.7300108150277863`*^9, 3.73001100578553*^9}, {3.730011293304051*^9, 
   3.730011304597336*^9}, 3.730011426164053*^9, 3.730902333150506*^9, {
   3.730902646387156*^9, 
   3.7309026514575253`*^9}},ExpressionUUID->"f906fc6e-de70-442e-9501-\
2a0a44620974"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "are", " ", "the", " ", "rules", " ", "for", " ", "the", 
      " ", "radial", " ", 
      RowBox[{"infall", ".", " ", "For"}], " ", "the", " ", "spherical", " ", 
      "harmonics", " ", "Y"}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["P", "l"], "[", "\[Theta]", "]"}], 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "I"}], " ", "\[ScriptM]", " ", "\[Phi]"}], "]"}]}]}], 
    ",", " ", 
    RowBox[{"where", " ", 
     SubscriptBox["P", "l"], " ", "is", " ", "the", " ", "Legendre", " ", 
     "polynomial", " ", "of", " ", "order", " ", "l"}], ",", " ", 
    RowBox[{
     RowBox[{"we", " ", "consider", " ", "the", " ", "m"}], "=", 
     RowBox[{
      RowBox[{"0", " ", 
       RowBox[{"case", ".", " ", "Note"}], " ", "also", " ", "that", " ", 
       "for", " ", "the", " ", "radial", " ", "case", " ", 
       FractionBox["d\[Phi]", "dt"]}], "=", 
      RowBox[{
       FractionBox["dy", "dt"], "=", 
       RowBox[{
        FractionBox["d\[Theta]", "dt"], "=", "0"}]}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"radialPlunge", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[ScriptCapitalY]", "\[Rule]", 
       RowBox[{
        RowBox[{"\[CapitalTheta]", "[", "\[Theta]", "]"}], 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[ScriptM]", " ", "\[Phi]"}], "]"}]}]}], 
      ",", 
      RowBox[{"\[ScriptM]", "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"\[CapitalTheta]", "[", "\[Theta]", "]"}], "\[Rule]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"2", "\[Pi]"}], "]"}]], 
        FractionBox[
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"2", "l"}], "+", "1"}], "]"}], 
         RowBox[{"Sqrt", "[", 
          RowBox[{"4", "\[Pi]"}], "]"}]]}]}], ",", 
      RowBox[{"l", "\[Rule]", "2"}], ",", 
      RowBox[{"dR", "\[Rule]", "dRdt"}], ",", 
      RowBox[{"\[Gamma]", "\[Rule]", "u0"}], ",", 
      RowBox[{"\[Delta]", "\[Rule]", 
       SuperscriptBox["dRdt", 
        RowBox[{"-", "1"}]]}], ",", 
      RowBox[{"d\[Phi]dt", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[ScriptCapitalY]dt", "\[Rule]", "0"}], ",", 
      RowBox[{"d\[Theta]dt", "\[Rule]", "0"}], ",", 
      RowBox[{"\[ScriptE]", "\[Rule]", "1"}]}], "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7260451523924026`*^9, 3.726045153202324*^9}, {
   3.726058304345402*^9, 3.726058304518106*^9}, {3.726058444894405*^9, 
   3.726058445537836*^9}, 3.7260585768941393`*^9, {3.726058639883049*^9, 
   3.726058641046632*^9}, {3.726059132525283*^9, 3.726059139287859*^9}, {
   3.726059222086035*^9, 3.726059251662856*^9}, {3.7260593278038683`*^9, 
   3.7260593502594643`*^9}, 3.7261304999449577`*^9, {3.7262198025484533`*^9, 
   3.7262198041679707`*^9}, {3.726574528206233*^9, 3.726574550479031*^9}, {
   3.726640607303609*^9, 3.7266406076094027`*^9}, 3.726640687329756*^9, {
   3.726642039645926*^9, 3.726642039946054*^9}, {3.726642194920457*^9, 
   3.726642198787622*^9}, 3.726647934437546*^9, {3.726648136399826*^9, 
   3.726648137224124*^9}, 3.726648539077652*^9, {3.72665382519517*^9, 
   3.7266538733194647`*^9}, 3.7266539065834093`*^9, {3.726927561162509*^9, 
   3.726927568313949*^9}, {3.726927640697115*^9, 3.726927667132394*^9}, {
   3.72701999590515*^9, 3.727019996258675*^9}, 3.727651143992215*^9, {
   3.7276633493197327`*^9, 3.72766334956304*^9}, {3.729510766004273*^9, 
   3.729510767979947*^9}, {3.730010767056237*^9, 3.7300107849434233`*^9}, 
   3.730528928145114*^9, {3.7317831622012663`*^9, 3.7317831845751877`*^9}, {
   3.743043671002819*^9, 3.743043686166857*^9}, {3.743043795231584*^9, 
   3.7430438238741627`*^9}, {3.7430438829218407`*^9, 
   3.7430439055064993`*^9}, {3.743043947032855*^9, 3.743043991718109*^9}, {
   3.743044661799417*^9, 3.743044670369258*^9}, {3.743044706791224*^9, 
   3.743044711028872*^9}, {3.743044885580785*^9, 3.74304496199325*^9}, {
   3.7430450383752537`*^9, 3.743045043063121*^9}, {3.74304517373002*^9, 
   3.7430451771212482`*^9}},ExpressionUUID->"07b6f48a-f048-42df-addb-\
3e776136e04a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[ScriptCapitalA]", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalA]0", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalB]0", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalB]", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalQ]0", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalQ]", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalD]", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalF]", "[", "r_", "]"}], ",", 
    RowBox[{"\[ScriptCapitalG]", "[", "r_", "]"}]}], "}"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"sourcevector", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", "\[Omega]", " ", 
       RowBox[{"T", "[", "r", "]"}]}], "]"}]}], "//.", "radialPlunge"}], "//",
    "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.743044473323038*^9, 
  3.7430445011805983`*^9}},ExpressionUUID->"c83efc69-a4d6-4531-a45a-\
4f60cea0b1cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox["5"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
        RowBox[{"T", "[", "r", "]"}]}]], " ", "m", " ", 
      SqrtBox[
       FractionBox["M", "r"]]}], 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox["5"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
        RowBox[{"T", "[", "r", "]"}]}]], " ", "m"}], 
     RowBox[{"4", " ", "\[Pi]", " ", 
      SqrtBox[
       RowBox[{"M", " ", 
        SuperscriptBox["r", "3"]}]]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["5"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
        RowBox[{"T", "[", "r", "]"}]}]], " ", "m"}], 
     RowBox[{
      RowBox[{"4", " ", "M", " ", "\[Pi]", " ", "r"}], "-", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       SuperscriptBox["r", "2"]}]}]]}], ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.743044480893961*^9, 3.743044501626997*^9}, 
   3.74304502157302*^9, 3.74304517835489*^9, 3.743045651388315*^9, 
   3.7430527443628407`*^9, 3.7430560310876303`*^9, 3.743056062703227*^9, 
   3.743236616001903*^9, 
   3.743236945373363*^9},ExpressionUUID->"d439870c-31a3-4414-8ea6-\
90d309df9724"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "is", " ", "the", " ", "master", " ", "equation", " ", 
    RowBox[{"we", "'"}], "re", " ", "going", " ", "to", " ", "integrate"}], 
   "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"master", "=", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"r", ">", "0"}], "&&", 
      RowBox[{"M", ">", "0"}]}], ",", 
     RowBox[{"Collect", "[", 
      RowBox[{"Zerilli1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Z", "''"}], "[", "r", "]"}], ",", 
         RowBox[{
          RowBox[{"Z", "'"}], "[", "r", "]"}], ",", 
         RowBox[{"Z", "[", "r", "]"}], ",", "m", ",", 
         RowBox[{
          RowBox[{"T", "'"}], "[", "r", "]"}]}], "}"}], ",", "Simplify"}], 
      "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.74301724071798*^9, {3.743030259350575*^9, 3.743030259611237*^9}, {
   3.743030626334396*^9, 3.743030633496889*^9}, {3.743039256001665*^9, 
   3.743039289773088*^9}},ExpressionUUID->"63f6b74a-d5a7-4f21-8be4-\
b9daa9adb70d"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"36", " ", 
       SuperscriptBox["M", "4"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["M", "3"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[CapitalLambda]"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[CapitalLambda]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"2", " ", "\[CapitalLambda]"}], "+", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "M", " ", 
       SuperscriptBox["r", "3"], " ", "\[CapitalLambda]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[CapitalLambda]"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[CapitalLambda]", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"], " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "\[CapitalLambda]"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[CapitalLambda]", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"Z", "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox["r", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "M"}], "+", 
       RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], "2"]}]], "+", 
  RowBox[{"m", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SqrtBox["5"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
          RowBox[{"T", "[", "r", "]"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
           SqrtBox["2"], " ", "M", " ", "\[CapitalLambda]"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["2"], " ", "r", " ", "\[CapitalLambda]"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["M", "3"], " ", "r"}]], " ", "\[Omega]"}], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"M", " ", 
             SuperscriptBox["r", "3"]}]], " ", "\[CapitalLambda]", " ", 
           "\[Omega]"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "M"}], "+", 
           RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], "2"], " ", 
        "\[Omega]"}]]}], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["10"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
         RowBox[{"T", "[", "r", "]"}]}]], " ", 
       RowBox[{
        SuperscriptBox["T", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], 
      RowBox[{
       RowBox[{"3", " ", "M"}], "+", 
       RowBox[{"r", " ", "\[CapitalLambda]"}]}]]}], ")"}]}], "+", 
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{
     SuperscriptBox["Z", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"2", " ", "M"}], "r"]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["Z", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.7430392627177687`*^9, 3.743039267167335*^9}, 
   3.743040450355714*^9, {3.7430450006343393`*^9, 3.743045023262093*^9}, 
   3.743045180318832*^9, 3.743045652350873*^9, 3.7430527465917797`*^9, 
   3.743056031274148*^9, 3.743056062830957*^9, 3.743236616131336*^9, 
   3.743236945555543*^9},ExpressionUUID->"e9ac6b2d-ffbb-4b3e-83f0-\
c0734defc555"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Ts", "[", "r_", "]"}], ":=", 
   RowBox[{"M", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["r", 
          RowBox[{"2", "M"}]], ")"}], 
        RowBox[{"3", "/", "2"}]]}], "-", 
      RowBox[{"4", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["r", 
          RowBox[{"2", "M"}]], ")"}], 
        RowBox[{"1", "/", "2"}]]}], "+", 
      RowBox[{"2", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["r", 
             RowBox[{"2", "M"}]], ")"}], 
           RowBox[{"1", "/", "2"}]], "+", "1"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["r", 
             RowBox[{"2", "M"}]], ")"}], 
           RowBox[{"1", "/", "2"}]], "-", "1"}]], "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dT", "[", "r_", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", "M"}], "r"]}], ")"}], 
      RowBox[{"-", "1"}]]}], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"2", "M"}], "r"], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]]}]}], ";"}]}], "Input",ExpressionUUID->\
"ca1a2938-c5ad-4961-9797-054067dc534c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Boundary Conditions for the homogeneous equation", "Subsection",
 CellChangeTimes->{
  3.72470087666232*^9, 3.724788628215098*^9, {3.726151403358302*^9, 
   3.7261514066276207`*^9}, {3.7430434930994463`*^9, 
   3.7430434961860743`*^9}, {3.743169195615665*^9, 3.74316920073211*^9}, {
   3.743175460894745*^9, 
   3.7431754621356*^9}},ExpressionUUID->"b03a8a0b-066c-40b4-a2a2-\
c10ee52cd8e2"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "In", " ", "this", " ", "section", " ", "I", " ", "find", " ", "the", " ", 
   "series", " ", "expansion", " ", "at", " ", "the", " ", "horizon", " ", 
   "and", " ", "at", " ", "infinity", " ", "to", " ", "start", " ", "the", 
   " ", "numerical", " ", "integration"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743039353995512*^9, 3.743039381283182*^9}, 
   3.743043599409782*^9},ExpressionUUID->"e158e823-72d6-4dba-a992-\
ae0aa5345c03"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Series", " ", "expansion", " ", "at", " ", "the", " ", 
    RowBox[{"horizon", ".", " ", "In"}], " ", "this", " ", "case", " ", "we", 
    " ", "consider", " ", "10", " ", 
    RowBox[{"coefficients", ".", " ", "You"}], " ", "can", " ", "try", " ", 
    "to", " ", "vary", " ", "to", " ", "see", " ", "the", " ", "effect"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"order", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Z", "[", "r_", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[Omega]", " ", 
          RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
        RowBox[{"b", "[", "i", "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"2", "M"}]}], ")"}], "i"]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.72441882639495*^9, 3.724418850321383*^9}, {
   3.724768181255518*^9, 3.7247681950955973`*^9}, {3.724768235179481*^9, 
   3.7247682446574717`*^9}, {3.7247682914184427`*^9, 3.724768293100586*^9}, {
   3.724768336639626*^9, 3.7247683632224617`*^9}, {3.724790890725099*^9, 
   3.724790891106776*^9}, {3.7247918943044567`*^9, 3.7247918946983356`*^9}, 
   3.725800324275676*^9, {3.725800700448306*^9, 3.725800700722814*^9}, {
   3.725801192307542*^9, 3.725801192805964*^9}, {3.7259513624476223`*^9, 
   3.725951362989707*^9}, {3.725951618479066*^9, 3.72595161859839*^9}, {
   3.7259517214207983`*^9, 3.725951724850251*^9}, {3.726159013431026*^9, 
   3.726159013722302*^9}, {3.743017192348927*^9, 3.743017201138445*^9}, 
   3.743030637098709*^9, {3.7430310642826138`*^9, 3.743031071738914*^9}, {
   3.7430393287200727`*^9, 3.743039328845504*^9}, 3.743039383135004*^9, {
   3.743040452516469*^9, 3.743040454032215*^9}, 3.7430435982129307`*^9, {
   3.7430560667216053`*^9, 
   3.7430560840734253`*^9}},ExpressionUUID->"b0ae9d26-8dfe-401e-a0f8-\
d96f9c11d895"],

Cell[BoxData[
 RowBox[{
  RowBox[{"seriesH", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"master", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"rt", "[", "r", "]"}], "\[Rule]", "0"}], ",", 
          RowBox[{"m", "\[Rule]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"rt", "'"}], "[", "r", "]"}], "\[Rule]", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              FractionBox[
               RowBox[{"2", "M"}], "r"]}], ")"}], 
            RowBox[{"-", "1"}]]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"rt", "''"}], "[", "r", "]"}], "\[Rule]", 
           RowBox[{"D", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"2", "M"}], "r"]}], ")"}], 
              RowBox[{"-", "1"}]], ",", "r"}], "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"2", "M"}], ",", 
         RowBox[{"order", "+", "2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"r", "-", 
      RowBox[{"2", "M"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743017207980054*^9, 3.743017214756978*^9}, {
  3.743017274706307*^9, 3.7430172749665003`*^9}, {3.743030104446576*^9, 
  3.743030115116406*^9}, {3.743039325827941*^9, 
  3.743039326440339*^9}},ExpressionUUID->"8936405c-674b-457e-a098-\
294d43f917f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{"i", "+", "1"}], "]"}], "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"seriesH", ",", 
            RowBox[{"r", "-", 
             RowBox[{"2", "M"}]}], ",", "i"}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"b", "[", 
          RowBox[{"i", "+", "1"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", 
      RowBox[{"order", "-", "1"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.743018091827241*^9},ExpressionUUID->"aa791daf-1cba-4840-8ae2-\
c4073da968d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ZH", "[", "r_", "]"}], "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "\[Omega]", " ", 
         RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
       RowBox[{"b", "[", "i", "]"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "-", 
          RowBox[{"2", "M"}]}], ")"}], "i"]}], "//.", 
      RowBox[{
       RowBox[{"rt", "[", "r", "]"}], "\[Rule]", 
       RowBox[{"r", "+", 
        RowBox[{"2", "M", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           FractionBox["r", 
            RowBox[{"2", "M"}]], "-", "1"}], "]"}]}]}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{
  3.743031035032631*^9, {3.743039511233699*^9, 
   3.7430395119027357`*^9}},ExpressionUUID->"331aa690-4ffe-4ba7-9d82-\
f8c52774f281"],

Cell[BoxData[
 RowBox[{"Clear", "[", "Z", "]"}]], "Input",
 CellChangeTimes->{{3.726159082257277*^9, 3.72615908394706*^9}, {
   3.743017361585918*^9, 3.7430173630986967`*^9}, 3.7430180996624527`*^9, {
   3.743031037361425*^9, 3.7430310392483683`*^9}, {3.743052755190703*^9, 
   3.743052755710794*^9}},ExpressionUUID->"66bf3b95-e049-4d69-b9e1-\
e3bb4e4fcac7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Series", " ", "expansion", " ", "at", " ", "infinity"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Z", "[", "r_", "]"}], ":=", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Omega]", " ", 
         RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
       RowBox[{"c", "[", "i", "]"}], 
       FractionBox["1", 
        SuperscriptBox["r", "i"]]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.7232088203906927`*^9, 3.723208870411315*^9}, {
   3.7232089021147842`*^9, 3.723208907881666*^9}, {3.7232089545586042`*^9, 
   3.723208954938642*^9}, {3.723211765365138*^9, 3.7232117710716257`*^9}, 
   3.7232320213644257`*^9, {3.723268670036603*^9, 3.723268672353324*^9}, {
   3.72327352884249*^9, 3.723273530944786*^9}, {3.723273646709928*^9, 
   3.72327366779589*^9}, {3.723273747635375*^9, 3.723273752190074*^9}, {
   3.723273877270441*^9, 3.723273897639797*^9}, 3.723273976915277*^9, {
   3.7233193697198763`*^9, 3.723319370222378*^9}, {3.723323564838928*^9, 
   3.7233235766393557`*^9}, {3.724418890295128*^9, 3.7244189065680647`*^9}, {
   3.724420181875193*^9, 3.724420181921259*^9}, {3.724421336849634*^9, 
   3.724421336963005*^9}, {3.72475439412987*^9, 3.724754394209181*^9}, {
   3.724768171802198*^9, 3.724768202519023*^9}, {3.72476825480882*^9, 
   3.724768273400465*^9}, {3.724768322326231*^9, 3.724768374463746*^9}, {
   3.724769529277561*^9, 3.7247695305042887`*^9}, {3.724769982903966*^9, 
   3.72476998303477*^9}, {3.724770096536563*^9, 3.7247700966410637`*^9}, {
   3.725951631908907*^9, 3.725951631991503*^9}, {3.725951727369562*^9, 
   3.725951727844051*^9}, {3.726159075863649*^9, 3.726159088466996*^9}, {
   3.743017370945675*^9, 3.74301737253685*^9}, 3.743031042118396*^9, {
   3.743039340068426*^9, 3.743039340592225*^9}, 3.743039385735318*^9, 
   3.743043589778413*^9},ExpressionUUID->"df696704-d574-4d68-b729-\
1f189daea8c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"series\[Infinity]", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"master", "//.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"rt", "[", "r", "]"}], "\[Rule]", "0"}], ",", 
            RowBox[{"m", "\[Rule]", "0"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"rt", "'"}], "[", "r", "]"}], "\[Rule]", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"2", "M"}], "r"]}], ")"}], 
              RowBox[{"-", "1"}]]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"rt", "''"}], "[", "r", "]"}], "\[Rule]", 
             RowBox[{"D", "[", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  FractionBox[
                   RowBox[{"2", "M"}], "r"]}], ")"}], 
                RowBox[{"-", "1"}]], ",", "r"}], "]"}]}]}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "\[Infinity]", ",", 
          RowBox[{"order", "+", "2"}]}], "}"}]}], "]"}], "]"}], ",", "r", ",",
      "Simplify"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743017381542041*^9, 3.743017385131069*^9}, {
  3.743031092616909*^9, 3.743031095469961*^9}, {3.743039346669862*^9, 
  3.743039347332695*^9}},ExpressionUUID->"320b975f-afb8-4e6e-8f42-\
f28537b57af3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"i", "-", "1"}], "]"}], "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"series\[Infinity]", ",", "r", ",", 
            RowBox[{"-", "i"}]}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"c", "[", 
          RowBox[{"i", "-", "1"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "order"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.743017390116887*^9, 
  3.743017390585949*^9}},ExpressionUUID->"509d1bc7-427c-492e-b3ca-\
8721e8487c41"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Z\[Infinity]", "[", "r_", "]"}], "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Omega]", " ", 
         RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
       RowBox[{"c", "[", "i", "]"}], 
       FractionBox["1", 
        SuperscriptBox["r", "i"]]}], "//.", 
      RowBox[{
       RowBox[{"rt", "[", "r", "]"}], "\[Rule]", 
       RowBox[{"r", "+", 
        RowBox[{"2", "M", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           FractionBox["r", 
            RowBox[{"2", "M"}]], "-", "1"}], "]"}]}]}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", 
       RowBox[{"order", "-", "1"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743031121639982*^9, 3.74303112344582*^9}, 
   3.743039508562723*^9},ExpressionUUID->"b147c48b-11b7-4902-9b8d-\
f50a917414fd"],

Cell[BoxData[
 RowBox[{"Clear", "[", "Z", "]"}]], "Input",ExpressionUUID->"d778f676-b3d7-4305-ac91-4d93b55bc0b2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerical routine for the integration", "Subsection",
 CellChangeTimes->{
  3.7430435065571537`*^9},ExpressionUUID->"a7516cdf-297d-4aff-afe5-\
d6a150f3df01"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "defines", " ", "the", " ", "function", " ", "T", 
    RowBox[{"(", "r", ")"}], " ", "and", " ", "its", " ", "first", " ", 
    "derivative"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Ts", "[", "r_", "]"}], ":=", 
     RowBox[{"M", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["4", "3"]}], 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["r", 
            RowBox[{"2", "M"}]], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"4", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["r", 
            RowBox[{"2", "M"}]], ")"}], 
          RowBox[{"1", "/", "2"}]]}], "+", 
        RowBox[{"2", 
         RowBox[{"Log", "[", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              FractionBox["r", 
               RowBox[{"2", "M"}]], ")"}], 
             RowBox[{"1", "/", "2"}]], "+", "1"}], 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              FractionBox["r", 
               RowBox[{"2", "M"}]], ")"}], 
             RowBox[{"1", "/", "2"}]], "-", "1"}]], "]"}]}]}], ")"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dT", "[", "r_", "]"}], "=", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "M"}], "r"]}], ")"}], 
        RowBox[{"-", "1"}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"2", "M"}], "r"], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.724588936784192*^9, 3.724588937135665*^9}, 
   3.724588967292835*^9, {3.724592277392919*^9, 3.724592277525737*^9}, {
   3.7245963921744213`*^9, 3.7245964403787813`*^9}, {3.724596479331489*^9, 
   3.72459648357374*^9}, {3.724665852101824*^9, 3.724665866064193*^9}, {
   3.724666024314698*^9, 3.724666026625038*^9}, {3.72466674462097*^9, 
   3.724666746429697*^9}, 3.724666836719058*^9, 3.7247462241856203`*^9, {
   3.724768021008502*^9, 3.724768021874962*^9}, {3.724768382627686*^9, 
   3.724768386168751*^9}, {3.743039397570908*^9, 3.743039425694873*^9}, {
   3.743043585669516*^9, 
   3.743043586192927*^9}},ExpressionUUID->"aec8c4ea-8dfb-47d1-aedb-\
606c48da398e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Source", " ", "term"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"\[ScriptCapitalS]", "=", 
   RowBox[{
    RowBox[{"-", "m"}], " ", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"Zerillir", ",", "m"}], "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.7430175616583643`*^9, {3.743039427043767*^9, 3.743039438953926*^9}, 
   3.743040466633399*^9, 3.743041336849598*^9, 
   3.743043580424882*^9},ExpressionUUID->"5808347c-4dba-4835-9f63-\
21503c0aff9a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox["5"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
      RowBox[{"T", "[", "r", "]"}]}]], " ", "m", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", "M", " ", "\[CapitalLambda]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox["2"], " ", "r", " ", "\[CapitalLambda]"}], "+", 
      RowBox[{"6", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["M", "3"], " ", "r"}]], " ", "\[Omega]"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"M", " ", 
         SuperscriptBox["r", "3"]}]], " ", "\[CapitalLambda]", " ", 
       "\[Omega]"}], "-", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "M"}], "+", 
         RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], " ", "\[Omega]", 
       " ", 
       RowBox[{
        SuperscriptBox["T", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], 
   RowBox[{"r", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "M"}], "+", 
       RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], "2"], " ", 
    "\[Omega]"}]]}]], "Output",
 CellChangeTimes->{
  3.7430175620778*^9, 3.74301800497571*^9, 3.743018112549242*^9, 
   3.743031134711548*^9, 3.7430313388374033`*^9, {3.7430394345896463`*^9, 
   3.743039439925787*^9}, {3.743040464428465*^9, 3.743040467553452*^9}, 
   3.743041337417046*^9, 3.743045190379889*^9, 3.743045884331539*^9, 
   3.74305276639721*^9, 3.743056089084515*^9, 
   3.7432369533788347`*^9},ExpressionUUID->"e89558a3-5b53-46a4-9bfb-\
6970ad7e18cb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"\[CapitalOmega]_", ",", "l_", ",", "r2_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[CapitalLambda]", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"l", 
           RowBox[{"(", 
            RowBox[{"l", "+", "1"}], ")"}]}], "-", "2"}], ")"}], "/", "2"}]}],
       ",", "dEd\[Sigma]", ",", "Aout", ",", "S", ",", 
      RowBox[{"\[Omega]", "=", "\[CapitalOmega]"}], ",", "r", ",", 
      RowBox[{"M", "=", "1"}], ",", "m", ",", "r1", ",", 
      RowBox[{"\[Epsilon]", "=", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], ",", "eq", ",", "eqS", ",", "ZHI", ",", "dZHI",
       ",", "b0", ",", "c0", ",", "Z\[Infinity]I", ",", "dZ\[Infinity]I", ",",
       "Z", ",", "YH", ",", "Y\[Infinity]", ",", "W", ",", "drt", ",", "T"}], 
     "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "First", " ", "find", " ", "the", " ", "homogenoeous", " ", "solution"}],
      " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eq", "=", 
      RowBox[{"master", "//.", 
       RowBox[{"m", "\[Rule]", "0"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"S", "=", 
      RowBox[{
       RowBox[{"\[ScriptCapitalS]", " ", "m"}], "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"T", "[", "r", "]"}], "\[Rule]", 
          RowBox[{"Ts", "[", "r", "]"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"T", "'"}], "[", "r", "]"}], "\[Rule]", 
          RowBox[{"dT", "[", "r", "]"}]}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"r1", "=", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Epsilon]"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Initial", " ", "conditions", " ", "to", " ", "start", " ", "the", " ", 
       "numerical", " ", "integration", " ", "at", " ", "the", " ", "horizon",
        " ", "and", " ", "at", " ", "infinity"}], "  ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ZHI", "[", "b0_", "]"}], "=", 
      RowBox[{
       RowBox[{"ZH", "[", "r1", "]"}], "//.", 
       RowBox[{
        RowBox[{"b", "[", "0", "]"}], "\[Rule]", "b0"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dZHI", "[", "b0_", "]"}], "=", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"ZH", "[", "r", "]"}], ",", "r"}], "]"}], "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "[", "0", "]"}], "\[Rule]", "b0"}], ",", 
         RowBox[{"r", "\[Rule]", "r1"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Z\[Infinity]I", "[", "c0_", "]"}], "=", 
      RowBox[{
       RowBox[{"Z\[Infinity]", "[", "r2", "]"}], "//.", 
       RowBox[{
        RowBox[{"c", "[", "0", "]"}], "\[Rule]", "c0"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dZ\[Infinity]I", "[", "c0_", "]"}], "=", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"Z\[Infinity]", "[", "r", "]"}], ",", "r"}], "]"}], "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"c", "[", "0", "]"}], "\[Rule]", "c0"}], ",", 
         RowBox[{"r", "\[Rule]", "r2"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Forward", " ", "integration", " ", "from", " ", "the", " ", 
       "horizon"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"YH", "=", " ", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"eq", "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"Z", "[", "r1", "]"}], "\[Equal]", 
            RowBox[{"ZHI", "[", "1", "]"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Z", "'"}], "[", "r1", "]"}], "\[Equal]", 
            RowBox[{"dZHI", "[", "1", "]"}]}]}], "}"}], ",", "Z", ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "r1", ",", "r2"}], "}"}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Inward", " ", "integartion", " ", "from", " ", "the", " ", "horizon"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Y\[Infinity]", "=", " ", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"eq", "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"Z", "[", "r2", "]"}], "\[Equal]", 
            RowBox[{"Z\[Infinity]I", "[", "1", "]"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Z", "'"}], "[", "r2", "]"}], "\[Equal]", 
            RowBox[{"dZ\[Infinity]I", "[", "1", "]"}]}]}], "}"}], ",", "Z", 
         ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "r2", ",", "r1"}], "}"}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"drt", "=", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", 
          RowBox[{"M", "/", "r"}]}]}], ")"}], 
       RowBox[{"-", "1"}]]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Define", " ", "the", " ", "worknskian"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"W", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Z", "[", "r", "]"}], "//.", "YH"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Z", "'"}], "[", "r", "]"}], "//.", "Y\[Infinity]"}], 
            ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Z", "[", "r", "]"}], "//.", "Y\[Infinity]"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Z", "'"}], "[", "r", "]"}], "//.", "YH"}], ")"}]}]}], 
         ")"}], "/", "drt"}], "//.", 
       RowBox[{"r", "\[Rule]", "r2"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"eqS", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Z", "[", "r", "]"}], "//.", "YH"}], ")"}], "S"}], "//.", 
       RowBox[{"m", "\[Rule]", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Integrate", " ", "the", " ", "source", " ", "equation"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Aout", "=", 
      RowBox[{
       SuperscriptBox["W", 
        RowBox[{"-", "1"}]], 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"drt", " ", "eqS"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "r1", ",", "r2"}], "}"}], ",", 
         RowBox[{"Method", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"GlobalAdaptive", ",", 
            RowBox[{"MaxErrorIncreases", "\[Rule]", "10000"}]}], "}"}]}], ",", 
         RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"PrintTemporary", "[", 
      RowBox[{
      "\"\<\[Omega] = \>\"", ",", "\[Omega]", ",", "\"\< - Aout = \>\"", ",", 
       "Aout"}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Return", " ", "the", " ", "energy", " ", "spectrum", " ", "and", " ", 
       "the", " ", "function", " ", "Z", 
       RowBox[{"(", "\[Omega]", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"dEd\[Sigma]", "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"32", "\[Pi]"}]], 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", "2"}], ")"}], "!"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "-", "2"}], ")"}], "!"}]], 
       SuperscriptBox["\[CapitalOmega]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "Aout", "]"}], "2"]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{"\[CapitalOmega]", ",", "Aout", ",", "dEd\[Sigma]"}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.724768498587306*^9, 3.7247686710795*^9}, {
   3.7247687326949244`*^9, 3.724768984785458*^9}, {3.7247694899585876`*^9, 
   3.724769516598543*^9}, {3.724769950798635*^9, 3.724770006612638*^9}, {
   3.724770062374753*^9, 3.724770083338993*^9}, {3.724770149798287*^9, 
   3.7247702088919992`*^9}, {3.724770265013832*^9, 3.7247702653632393`*^9}, {
   3.724770394372386*^9, 3.724770395258748*^9}, {3.724770500089625*^9, 
   3.724770505682715*^9}, {3.7247916382103024`*^9, 3.724791639114998*^9}, {
   3.724791974133151*^9, 3.724791977803754*^9}, {3.7247920226068773`*^9, 
   3.724792024647929*^9}, {3.7247921780534143`*^9, 3.724792178986762*^9}, 
   3.7247922408697157`*^9, {3.7247923050503893`*^9, 3.724792371017132*^9}, {
   3.724792661509844*^9, 3.724792704637842*^9}, {3.724792759076735*^9, 
   3.7247927722705193`*^9}, 3.724792831696617*^9, {3.724792886334564*^9, 
   3.724792901418271*^9}, {3.72479297490727*^9, 3.7247929932244053`*^9}, {
   3.72479310519748*^9, 3.724793107649996*^9}, {3.724793696158334*^9, 
   3.724793705953959*^9}, {3.7247937556148167`*^9, 3.724793756719881*^9}, {
   3.725109190731885*^9, 3.725109195632186*^9}, {3.725109245003395*^9, 
   3.7251092456576138`*^9}, {3.725109315176772*^9, 3.7251093232434273`*^9}, {
   3.725109428879888*^9, 3.725109457667696*^9}, {3.725202477895034*^9, 
   3.725202500121375*^9}, {3.725797100944029*^9, 3.7257971282881327`*^9}, {
   3.725797163364642*^9, 3.725797198115736*^9}, {3.725797242136516*^9, 
   3.725797257223091*^9}, {3.725797307366084*^9, 3.725797451084343*^9}, {
   3.725797633579781*^9, 3.7257976421433*^9}, {3.7257977759695597`*^9, 
   3.725797945973195*^9}, {3.7257979960998507`*^9, 3.725798044697617*^9}, {
   3.725798077359771*^9, 3.725798190424212*^9}, {3.7257982230456877`*^9, 
   3.725798223642589*^9}, {3.725798265348753*^9, 3.72579829900382*^9}, {
   3.7257983368704557`*^9, 3.725798393265017*^9}, {3.725798463507456*^9, 
   3.725798486446344*^9}, {3.72579859544333*^9, 3.725798646713793*^9}, {
   3.725798976784927*^9, 3.7257989860134563`*^9}, {3.725799572096339*^9, 
   3.725799589836933*^9}, {3.7257996354165916`*^9, 3.7257997101908484`*^9}, {
   3.7257999849448633`*^9, 3.725799998460129*^9}, {3.725800396535681*^9, 
   3.7258003968793497`*^9}, {3.725800895982051*^9, 3.7258010056470957`*^9}, {
   3.72580133004078*^9, 3.72580135988307*^9}, {3.725801406463676*^9, 
   3.725801411651352*^9}, {3.7258921885068407`*^9, 3.7258922670114594`*^9}, {
   3.725892334265792*^9, 3.725892380383306*^9}, {3.72589247832513*^9, 
   3.725892490769178*^9}, {3.725951559035853*^9, 3.725951561995089*^9}, {
   3.7259520292399883`*^9, 3.725952031113431*^9}, {3.7259523715977097`*^9, 
   3.725952373491517*^9}, {3.72595298770614*^9, 3.7259530285518217`*^9}, {
   3.725953151960245*^9, 3.725953352677723*^9}, {3.725953480583198*^9, 
   3.7259534923736143`*^9}, {3.72595459793608*^9, 3.72595469154909*^9}, {
   3.725955122133013*^9, 3.725955122411673*^9}, {3.725955368953464*^9, 
   3.725955374579615*^9}, {3.725956234214658*^9, 3.7259562544092293`*^9}, 
   3.7259564275492287`*^9, {3.72595655802597*^9, 3.725956558688135*^9}, {
   3.725956962105254*^9, 3.725956980324066*^9}, {3.725957169030012*^9, 
   3.725957199599337*^9}, {3.725957265858824*^9, 3.725957281571145*^9}, {
   3.725957438612307*^9, 3.725957453908967*^9}, {3.725957538957943*^9, 
   3.72595754573053*^9}, {3.725957684005094*^9, 3.725957715976783*^9}, {
   3.725957762316812*^9, 3.725957822838521*^9}, {3.725957875490622*^9, 
   3.725957875907555*^9}, {3.7259579440848293`*^9, 3.725957947685974*^9}, {
   3.725958003899941*^9, 3.7259580267412987`*^9}, {3.725958117888383*^9, 
   3.725958169052638*^9}, {3.725958217684476*^9, 3.725958218288598*^9}, {
   3.7260723674616213`*^9, 3.7260723850046043`*^9}, {3.726072458891646*^9, 
   3.726072537140562*^9}, {3.72607257196598*^9, 3.726072572177771*^9}, {
   3.726151385305572*^9, 3.726151385718861*^9}, {3.7261591232708693`*^9, 
   3.726159210037941*^9}, {3.726213863953673*^9, 3.726213881857132*^9}, {
   3.726214083947076*^9, 3.726214084050321*^9}, {3.7262143793648443`*^9, 
   3.726214380266157*^9}, 3.730109815377658*^9, {3.730109849631976*^9, 
   3.730109849717567*^9}, {3.730109884783886*^9, 3.7301099222663727`*^9}, {
   3.730109993669586*^9, 3.730110023175556*^9}, {3.730110680718218*^9, 
   3.730110680942313*^9}, {3.730110718856748*^9, 3.730110733624135*^9}, 
   3.730110776023671*^9, {3.730110827195953*^9, 3.730110835304528*^9}, {
   3.743018123768683*^9, 3.743018145711194*^9}, {3.74301819289469*^9, 
   3.743018210021003*^9}, {3.7430182454858227`*^9, 3.743018267436067*^9}, {
   3.743018311599687*^9, 3.7430183312343283`*^9}, {3.7430183672975197`*^9, 
   3.743018373255432*^9}, {3.743031167579401*^9, 3.7430312696967382`*^9}, {
   3.7430313329290857`*^9, 3.743031404733794*^9}, {3.7430395239771023`*^9, 
   3.743039623844244*^9}, {3.743040038485939*^9, 3.743040051714652*^9}, {
   3.743040101765561*^9, 3.743040113853709*^9}, {3.743040145677631*^9, 
   3.7430401646491547`*^9}, {3.74304048394499*^9, 3.7430405178286257`*^9}, {
   3.743040596812376*^9, 3.743040674796831*^9}, {3.74304086828794*^9, 
   3.7430409041099033`*^9}, {3.743040981244215*^9, 3.7430409955678177`*^9}, {
   3.743041060699882*^9, 3.743041060911591*^9}, {3.743041107965131*^9, 
   3.7430411086636543`*^9}, {3.743041344515197*^9, 3.743041344699745*^9}, {
   3.743043553022192*^9, 3.743043575528442*^9}, {3.743053482828905*^9, 
   3.743053517296921*^9}, {3.743053861498027*^9, 3.743053934331059*^9}, {
   3.743054299668108*^9, 3.743054300637689*^9}, {3.743056134931283*^9, 
   3.7430561585783052`*^9}, {3.743056193143025*^9, 3.743056198582944*^9}, {
   3.743056267101973*^9, 3.743056267386436*^9}, {3.743056328253923*^9, 
   3.7430563362162457`*^9}, {3.743236552458662*^9, 3.743236584565734*^9}, {
   3.7432366452139387`*^9, 3.743236672348361*^9}, {3.743236957983964*^9, 
   3.7432369709237967`*^9}},ExpressionUUID->"0cfbaa34-da18-44df-906d-\
852ab82dcad9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{"0.3", ",", "2", ",", 
   RowBox[{"1000", "/", "0.3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743040613057363*^9, 3.743040652188718*^9}, {
  3.743056271266222*^9, 3.7430562738845243`*^9}, {3.743056377404623*^9, 
  3.7430563892955093`*^9}, {3.743056433342669*^9, 
  3.743056434529963*^9}},ExpressionUUID->"f2fb2de6-2e3c-4510-9697-\
560b51bfce05"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate","slwcon",
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"",2,37,2,32458546808675058201,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.743056390015519*^9, 3.7430564352720346`*^9, {3.743236651288597*^9, 
   3.7432366739729443`*^9}, {3.743236967807474*^9, 
   3.7432369730837307`*^9}},ExpressionUUID->"1d54648c-aa58-454d-bc8d-\
b66301d6e57a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3`", ",", 
   RowBox[{
    RowBox[{"-", "0.8747148092435282`"}], "+", 
    RowBox[{"0.9388567699006962`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.035378239450024`"}], "}"}]], "Output",
 CellChangeTimes->{{3.74304060833809*^9, 3.743040679278487*^9}, {
   3.743040898290872*^9, 3.743040908672916*^9}, 3.7430413502594557`*^9, 
   3.743045197301798*^9, 3.7430527728496933`*^9, 3.743053501742416*^9, 
   3.743056095919503*^9, 3.7430562795626497`*^9, 3.7430563429599037`*^9, {
   3.7430563820579567`*^9, 3.743056401697577*^9}, 3.7430564403428373`*^9, {
   3.743236652418253*^9, 3.743236678913498*^9}, {3.743236968200633*^9, 
   3.74323697794716*^9}},ExpressionUUID->"580a8dbd-6d69-4ad2-9559-\
c807b821c52f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"\[Omega]", ",", "2", ",", 
       RowBox[{"500", "/", "\[Omega]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "0.01", ",", "0.5", ",", "0.01"}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7257985073304234`*^9, 3.72579857816532*^9}, {
   3.72579869345931*^9, 3.725798694084251*^9}, {3.7257987659424877`*^9, 
   3.7257987879729853`*^9}, 3.7257989328817472`*^9, {3.725798967139399*^9, 
   3.725798967962421*^9}, 3.725799229753242*^9, 3.725800647038714*^9, {
   3.72580103141223*^9, 3.725801031948202*^9}, {3.725801385106715*^9, 
   3.725801385444378*^9}, 3.7258923314853563`*^9, {3.725892392856716*^9, 
   3.725892393016553*^9}, {3.725892505915653*^9, 3.725892509456854*^9}, {
   3.725952057450488*^9, 3.725952057898395*^9}, {3.725952320297303*^9, 
   3.725952320753213*^9}, {3.725952432326009*^9, 3.725952432919186*^9}, {
   3.725953038858581*^9, 3.725953039074831*^9}, {3.725953365547579*^9, 
   3.725953365869282*^9}, {3.7259535387790203`*^9, 3.7259535390849733`*^9}, {
   3.725955475755569*^9, 3.725955493993338*^9}, {3.725957232052437*^9, 
   3.725957232576826*^9}, {3.72595745619275*^9, 3.7259574576993093`*^9}, {
   3.726213800409387*^9, 3.726213809289029*^9}, {3.726213938337317*^9, 
   3.726213938562071*^9}, {3.730110082167653*^9, 3.7301100824779367`*^9}, {
   3.74303984060392*^9, 3.7430398581083403`*^9}, {3.743039929560564*^9, 
   3.743039930688793*^9}, {3.7430535138080072`*^9, 3.743053522301796*^9}, {
   3.74305376987846*^9, 3.743053769992531*^9}, {3.7430542778239326`*^9, 
   3.7430542786486187`*^9}, {3.743056382279593*^9, 3.7430563939199266`*^9}, {
   3.743056440099988*^9, 3.743056448038096*^9}, 
   3.743175485919881*^9},ExpressionUUID->"d95c078b-6218-45af-8078-\
0c1f1f09622f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Export", " ", "so", " ", "you", " ", "can", " ", "use", " ", "later"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<your_results.mx\>\"", ",", "data"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7430537723448963`*^9, 
  3.743053801018807*^9}},ExpressionUUID->"0355d2c9-9273-4670-bd88-\
266c3b537d96"],

Cell[BoxData["\<\"your_results.mx\"\>"], "Output",
 CellChangeTimes->{3.743053948727512*^9, 3.743054710538371*^9, 
  3.7430567218579597`*^9, 
  3.743236869098439*^9},ExpressionUUID->"8a332758-9924-4085-bab8-\
8b4cff85c96c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "import", " ", "the", " ", "data", " ", "obtained", " ", 
     "from", " ", "the", " ", "seminal", " ", "paper", " ", "by", " ", 
     "Davis", " ", 
     RowBox[{"Phys", ".", " ", "Rev", ".", " ", "Lett", ".", " ", "27"}]}], 
    ",", " ", 
    RowBox[{"21", " ", 
     RowBox[{"(", "1971", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dE", "=", 
    RowBox[{"Import", "[", "\"\<zerilli.dat\>\"", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7430396848314743`*^9, 3.743039699196691*^9}, {
  3.7430397692770977`*^9, 
  3.7430398069428387`*^9}},ExpressionUUID->"03690767-cbcd-4ab4-a07f-\
fd417b34cfb9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Plot", " ", "and", " ", "compare", " ", "with", " ", "the", " ", 
    "original", " ", "result"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dE", ",", 
      RowBox[{"data", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", 
          RowBox[{"-", "1"}], ";;", "4"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False", ",", "False"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Lucida Grande\>\""}], ",", 
       "Italic", ",", "10", ",", 
       RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\< \>\"", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\[FilledSmallCircle]\>\"", ",", "26"}], "}"}]}], "}"}]}],
     ",", 
    RowBox[{"FrameStyle", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"16", ",", 
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"FontFamily", "->", "\"\<Lucida Grande\>\""}], ",", "Italic", 
       ",", 
       RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ",", 
    RowBox[{"FrameLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<dE/d\[Omega]\>\"", ",", "26"}], "]"}], ",", "None"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<M\[Omega]\>\"", ",", "26"}], "]"}], ",", "None"}], 
        "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Davis et al.\>\"", ",", "18"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<Your result\>\"", ",", "18"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.15", ",", "0.85"}], "}"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.", ",", "0.5"}], "}"}], 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.08"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.725951573663952*^9, 3.7259515749335003`*^9}, {
   3.726213827798477*^9, 3.726213840985426*^9}, {3.7262139085971003`*^9, 
   3.7262139253606863`*^9}, {3.726215046166108*^9, 3.7262150463066874`*^9}, {
   3.726215080984563*^9, 3.726215291009939*^9}, {3.7301103408506327`*^9, 
   3.7301103413103952`*^9}, {3.730110985739067*^9, 3.730110985946588*^9}, {
   3.730111961814014*^9, 3.730111982735468*^9}, {3.743039680472281*^9, 
   3.743039681599774*^9}, {3.743039884004706*^9, 3.743039916603087*^9}, {
   3.7430409540167828`*^9, 3.743040960053616*^9}, {3.743041392400819*^9, 
   3.7430414170194798`*^9}, {3.743043522612887*^9, 3.743043535733303*^9}, 
   3.743053643760955*^9, {3.7430547150015717`*^9, 
   3.743054729192955*^9}},ExpressionUUID->"2adc78e3-bafa-4de9-bb07-\
c92cdb6933fc"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{}, {{{}, {}, 
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.009166666666666668], AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9VAs4lWccP4mQ7CJrmbRHiko2PKsV069YapaW9UgjS5l1L6KSXMIRIYnc
cjkOCgtP0xRlUuYeHddzjZOhlMkkm3LZ+33ene95zvM+3/l+7/v+/7/LX3/f
8e89lDgcjiv5MetH0XYvlL8Ixl5zR9OV+TZ0jUdcY9CW+wGuKHy7+2j1VBZm
cF54G3io3Cc+D3e/madkHH4Kbn2CJdLxIooPgNHD87lODcWw7P7uYtKxENzm
+gtu/VCCiDDntvI/ufh4y/aJhd53YP86ZofP0nBYsweU4fpc22UnlSIx21dj
6fLAckzrT46dlEejdHHYS4fSCsDJ5df7gzFAjayE61+J6qnisyM3Y9Et14jP
D3mAQQcGeRku1uufiwseojmitYt8gjDb02qusApvpMJgb9srEFud2ZW3uhr8
/bdeeJckQCu0soG/qQbcjKZfHnck4ts6VatUx1rs73h2yHgsCUnTsYHvLOpQ
1WbsodOTDMMdKtlxFvVwH3ImN6VgW8vl3VM2DagczPhqVftVDL2sXGdg14hs
g7KJ8NFU8P816y9a9gjlKlraqEmD7ADneLByE2aOT4dR5oWbTweaYE5QvaEZ
tN9mqBUscv7Jkkf5eowur8iY3hEeZLYMQwJIdP2JVJk4q120+amfADlMm9mZ
UNfN+HFFowBbv7yw0a0vE7nPt3w2rd+C0cl23wFDPgqipKSCFvitubHeyYWP
Oy2cLiX1VoQT1cz/4MOm8CC5qhXMrUKtLKpvK0qun6ldYZEFprrFYW34xIGp
IAv2rDHaFe8Hlhzx9bvWrsAHRpcdVh9vx+fHsmeVq2SBiEv+6cASRt40PtQI
27wbHYp62Ha0O/EsevlfmhWZ8Nyj2qzj0KnoN+idhWdzRCeYXYUiHkiRIxsf
d1LeMmi9neAxavSnU58JcZ6xn3Y68nO2bZi/V6jQh5BMnCrEbPXIT92Hrs7Y
SyDEzoCi2/uCUvBq7abNJ8aF1PfJlH8R5GkfXvv9QRJIWOYLvhah9m7pxTnD
iegZSCie5yUCg16onIgK05SVCxNEuDI2Z0/y1gQYSMfJSSKFH2/N8yKSiLB4
wSFSajzY04ZFCv/O1C2mfMZBpfqS2WkTMfJWN1kS74FBj9qJaT4vI2rS45/e
vWKE9NQm30uMpbkUU/9cor4TK/Kko7zzPZNiMV0vgniQBEGMMwOGZmoF0XhA
0nH7tRiPXJlkREGZFUYCE5tFL3vWRII0STZKoDq8gDg1Aqn9esRyEpqfcDR+
wDAjoXkLg+k9o/c1SiS0fy4SPCLcXWUS2m8o4i1m2XM1pbS/YJwj1eutldJ+
zuEoK4yU6h2IXJYWKRjXrbLxx651v9WdqpCCXXh+4LCPjOp1Gr3aevV9kNF5
5AMvXU25SayMzqsTcGQFlWEi/+9W+32e8GcH4hOwNpQcxkxMn1C9f0YYM97e
PKFz0536tYvudwNzW053F+XLGTqsYbupHxzpfOqm+O10Xsgp3g6v6qusCw/K
FfN59AhDgJziN9B8/Y+3wH/7HeJy
         "]]}}, {
       {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[6], 
        AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
          StyleBox["\<\" \"\>",
           StripOnInput->False,
           FontSize->2], {0., 0.}], CompressedData["
1:eJw9VAs41WccPkSIdpE1VtqDopKtPKsV01ssmaVlPdLIErNKN6JCIrfILZfc
Csehm4WnMaJMyuQWjuu54mQoMVmpTYl9/79v5zzP93zPOef9vu/3ey8/Pbdj
33vM4XA4LmQpkKVI1kexts+UvgjBPlOH1SvzreiejKSmYJt7Z1xQ+GbPkdrp
XMzivPEmyLPSN/kG7nyjoWgceRKug3x9yWQRxZ+B0YNz1x0bi2He911c2tFQ
lIUH8kt+KEVUhFNH5Z/h+Nhmx5S2z23YvYzf6bs0EpbsBRW4Ns962QnFaMzx
U1+6PKgSM3rvXp+QxaJ8ScSIfXkV4Oj8673ReOChtDQ8sBq108WnX9xKQJ9M
PTk/9D5G7RlkIpwtNz4VFTxAS1R7L/kLgjwvi3mCGrySCEJ8rC9CZOG/+8ba
WvD2lzzzKU2BZlh1I2/LQ4RnN//S2pWKb+tVLC471GF/1xNP49dpSJtJCHpr
Vo+aDmMPnf50GO5Uzksya4D7mBN5KQPb2xL3TFs1ono0+6tVnZcwNlK9wcC2
CXkGFVORE5fB+3fNUNGyR6hU1tTCw0xID3COhSg1Y/b6LBjlnL/1eLgZpgQ1
EJZN+22BasFip5/MuZSvVvR6R8cPvOBCas0wxId4USCRKgentYq2Pg7g4wrT
Zl4O1BZl/7iiiY9tX57f7DqYg+tPbT6b0WvDxLtOv2FDHgpiJKSCNgSsu7nR
0ZmH222cXkW1dkQS1Uz/4MGq8CB5qh3MqwLNXKpvO0qv+detMMsFU92SiA58
Ys9UkAs71hid8u8H9A/7BVztlOODYisOqU124vOjeQqVyrkg4pJfuqDPyJvJ
gyphm3uzS14P245WN57ELv9rflUOvPaqtOjYd8v7DX5r5tUS1Q3mVKGQC1Lk
i82t3ZS3bFpvN7iMGkNZ1GcCnGPsp5WF/CvbNy3YJ5DrQ0gmThVgjlr0p+5j
l2btxRdg15miMrfgDDxfv2Xr8UkB9X065V8IWeaHV3+/nwYSlgX8r4Wou1Me
N3c8Ff3DKcUa3kIwaG2lVFStzlipnSLExddz96ZvS4GBZJLcJJT7sUTDm0gi
xJKFnqTUZLC3jQvl/p2tW0T5TIJy7YU1p0xEuLG22Zx4Dwx6wlZE85mImHce
/wzsEyG0vy79bmoCzaWI+ucC9Z1InicdpV3vmRSL6B4H4kESBBH8hw3XqBbE
4j5JR9lLER65MMmIgRIrjBgmVotH+tdFgzRJDoqhMr6QODUKl4d0ieXEND+R
aPqAYUZM8xaB1XeN3lcvFdP+w5HiEeXuIhXTfsOQbKZgFz5fQvsLwVlSve56
Ce3nLI6wwkio3kG4ztIiAeO6VVaB2L3ht/qTVRKwGzcAHPYjpXqdwoCWbsMg
pHQe+cJ70XyZSYKUzqvjcGAFlWIq/+92OzcvBLIDsQesDcWHMBvTHqr3z4hg
xturHjo33alfe+l5VzCvXenrpXw5QYc1bB/1gwOdT30Uv4POCxnF2+J5Q41l
4UGZfD5PHGYIkFH8Jpqv//Fm+A8PCOJ0
         "]]}, 
       {RGBColor[0.880722, 0.611041, 0.142051], AbsolutePointSize[6], 
        AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
          StyleBox["\<\"\[FilledSmallCircle]\"\>",
           StripOnInput->False,
           FontSize->26], {0., 0.}], {{{0.01, 0.0007724656839581919}}, {{0.05,
          0.0055584924754662896`}}, {{0.09, 0.011461816774885076`}}, {{0.13, 
         0.016856868915540738`}}, {{0.17, 0.02151757264929578}}, {{
         0.21000000000000002`, 0.02684183039167252}}, {{0.25, 
         0.03161385048754016}}, {{0.29000000000000004`, 
         0.034738498634580346`}}, {{0.33, 0.03417744200286103}}, {{0.37, 
         0.025963649327837787`}}, {{0.41000000000000003`, 
         0.011851250306103409`}}, {{0.45, 0.0039208298224297075`}}, {{0.49, 
         0.0011520966104756748`}}}]}, {}}}, {}, {}, {}, {}}, InsetBox[
     TemplateBox[{
      StyleBox["\"Davis et al.\"", 18, StripOnInput -> False],StyleBox[
       "\"Your result\"", 18, StripOnInput -> False]},
      "PointLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.12692307692307694`], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 2}, {26, 2}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.12692307692307694`], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\" \"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.12692307692307694`], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], FontSize -> 2, Plain, 
                    StripOnInput -> False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {26, 2}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-1.14] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.12692307692307694`], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\"\[FilledSmallCircle]\"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.12692307692307694`], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], FontSize -> 26, Plain, 
                    StripOnInput -> False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {26, 26}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.34615384615384615`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Lucida Grande", FontSlant -> Italic, FontSize -> 10, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\" \"", ",", "2"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"\[FilledSmallCircle]\"", ",", "26"}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontFamily", "\[Rule]", "\"Lucida Grande\""}], ",", 
                 "Italic", ",", "10", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[0]"], 
                   Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                   Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False]}], 
               "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.15, 0.85}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
       StyleBox["\"dE/d\[Omega]\"", 26, StripOnInput -> False], 
       TraditionalForm], None}, {
      FormBox[
       StyleBox["\"M\[Omega]\"", 26, StripOnInput -> False], TraditionalForm],
       None}},
   FrameStyle->Directive[16, 
     GrayLevel[0], FontFamily -> "Lucida Grande", Italic, 
     AbsoluteThickness[1.1]],
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->{FontFamily -> "Lucida Grande", Italic, 10, 
     GrayLevel[0]},
   Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 0.5304}, {0., 0.04}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {0, 0}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[0.009166666666666668], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Line[CompressedData["
1:eJw9VAs4lWccP4mQ7CJrmbRHiko2PKsV069YapaW9UgjS5l1L6KSXMIRIYnc
cjkOCgtP0xRlUuYeHddzjZOhlMkkm3LZ+33ene95zvM+3/l+7/v+/7/LX3/f
8e89lDgcjiv5MetH0XYvlL8Ixl5zR9OV+TZ0jUdcY9CW+wGuKHy7+2j1VBZm
cF54G3io3Cc+D3e/madkHH4Kbn2CJdLxIooPgNHD87lODcWw7P7uYtKxENzm
+gtu/VCCiDDntvI/ufh4y/aJhd53YP86ZofP0nBYsweU4fpc22UnlSIx21dj
6fLAckzrT46dlEejdHHYS4fSCsDJ5df7gzFAjayE61+J6qnisyM3Y9Et14jP
D3mAQQcGeRku1uufiwseojmitYt8gjDb02qusApvpMJgb9srEFud2ZW3uhr8
/bdeeJckQCu0soG/qQbcjKZfHnck4ts6VatUx1rs73h2yHgsCUnTsYHvLOpQ
1WbsodOTDMMdKtlxFvVwH3ImN6VgW8vl3VM2DagczPhqVftVDL2sXGdg14hs
g7KJ8NFU8P816y9a9gjlKlraqEmD7ADneLByE2aOT4dR5oWbTweaYE5QvaEZ
tN9mqBUscv7Jkkf5eowur8iY3hEeZLYMQwJIdP2JVJk4q120+amfADlMm9mZ
UNfN+HFFowBbv7yw0a0vE7nPt3w2rd+C0cl23wFDPgqipKSCFvitubHeyYWP
Oy2cLiX1VoQT1cz/4MOm8CC5qhXMrUKtLKpvK0qun6ldYZEFprrFYW34xIGp
IAv2rDHaFe8Hlhzx9bvWrsAHRpcdVh9vx+fHsmeVq2SBiEv+6cASRt40PtQI
27wbHYp62Ha0O/EsevlfmhWZ8Nyj2qzj0KnoN+idhWdzRCeYXYUiHkiRIxsf
d1LeMmi9neAxavSnU58JcZ6xn3Y68nO2bZi/V6jQh5BMnCrEbPXIT92Hrs7Y
SyDEzoCi2/uCUvBq7abNJ8aF1PfJlH8R5GkfXvv9QRJIWOYLvhah9m7pxTnD
iegZSCie5yUCg16onIgK05SVCxNEuDI2Z0/y1gQYSMfJSSKFH2/N8yKSiLB4
wSFSajzY04ZFCv/O1C2mfMZBpfqS2WkTMfJWN1kS74FBj9qJaT4vI2rS45/e
vWKE9NQm30uMpbkUU/9cor4TK/Kko7zzPZNiMV0vgniQBEGMMwOGZmoF0XhA
0nH7tRiPXJlkREGZFUYCE5tFL3vWRII0STZKoDq8gDg1Aqn9esRyEpqfcDR+
wDAjoXkLg+k9o/c1SiS0fy4SPCLcXWUS2m8o4i1m2XM1pbS/YJwj1eutldJ+
zuEoK4yU6h2IXJYWKRjXrbLxx651v9WdqpCCXXh+4LCPjOp1Gr3aevV9kNF5
5AMvXU25SayMzqsTcGQFlWEi/+9W+32e8GcH4hOwNpQcxkxMn1C9f0YYM97e
PKFz0536tYvudwNzW053F+XLGTqsYbupHxzpfOqm+O10Xsgp3g6v6qusCw/K
FfN59AhDgJziN9B8/Y+3wH/7HeJy
          "]]}}, {{
         Directive[
          PointSize[0.009166666666666668], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6], 
          AbsolutePointSize[6]], 
         GeometricTransformation[
          Inset[
           Style[" ", FontSize -> 2], {0., 0.}], CompressedData["
1:eJw9VAs41WccPkSIdpE1VtqDopKtPKsV01ssmaVlPdLIErNKN6JCIrfILZfc
Csehm4WnMaJMyuQWjuu54mQoMVmpTYl9/79v5zzP93zPOef9vu/3ey8/Pbdj
33vM4XA4LmQpkKVI1kexts+UvgjBPlOH1SvzreiejKSmYJt7Z1xQ+GbPkdrp
XMzivPEmyLPSN/kG7nyjoWgceRKug3x9yWQRxZ+B0YNz1x0bi2He911c2tFQ
lIUH8kt+KEVUhFNH5Z/h+Nhmx5S2z23YvYzf6bs0EpbsBRW4Ns962QnFaMzx
U1+6PKgSM3rvXp+QxaJ8ScSIfXkV4Oj8673ReOChtDQ8sBq108WnX9xKQJ9M
PTk/9D5G7RlkIpwtNz4VFTxAS1R7L/kLgjwvi3mCGrySCEJ8rC9CZOG/+8ba
WvD2lzzzKU2BZlh1I2/LQ4RnN//S2pWKb+tVLC471GF/1xNP49dpSJtJCHpr
Vo+aDmMPnf50GO5Uzksya4D7mBN5KQPb2xL3TFs1ono0+6tVnZcwNlK9wcC2
CXkGFVORE5fB+3fNUNGyR6hU1tTCw0xID3COhSg1Y/b6LBjlnL/1eLgZpgQ1
EJZN+22BasFip5/MuZSvVvR6R8cPvOBCas0wxId4USCRKgentYq2Pg7g4wrT
Zl4O1BZl/7iiiY9tX57f7DqYg+tPbT6b0WvDxLtOv2FDHgpiJKSCNgSsu7nR
0ZmH222cXkW1dkQS1Uz/4MGq8CB5qh3MqwLNXKpvO0qv+detMMsFU92SiA58
Ys9UkAs71hid8u8H9A/7BVztlOODYisOqU124vOjeQqVyrkg4pJfuqDPyJvJ
gyphm3uzS14P245WN57ELv9rflUOvPaqtOjYd8v7DX5r5tUS1Q3mVKGQC1Lk
i82t3ZS3bFpvN7iMGkNZ1GcCnGPsp5WF/CvbNy3YJ5DrQ0gmThVgjlr0p+5j
l2btxRdg15miMrfgDDxfv2Xr8UkB9X065V8IWeaHV3+/nwYSlgX8r4Wou1Me
N3c8Ff3DKcUa3kIwaG2lVFStzlipnSLExddz96ZvS4GBZJLcJJT7sUTDm0gi
xJKFnqTUZLC3jQvl/p2tW0T5TIJy7YU1p0xEuLG22Zx4Dwx6wlZE85mImHce
/wzsEyG0vy79bmoCzaWI+ucC9Z1InicdpV3vmRSL6B4H4kESBBH8hw3XqBbE
4j5JR9lLER65MMmIgRIrjBgmVotH+tdFgzRJDoqhMr6QODUKl4d0ieXEND+R
aPqAYUZM8xaB1XeN3lcvFdP+w5HiEeXuIhXTfsOQbKZgFz5fQvsLwVlSve56
Ce3nLI6wwkio3kG4ztIiAeO6VVaB2L3ht/qTVRKwGzcAHPYjpXqdwoCWbsMg
pHQe+cJ70XyZSYKUzqvjcGAFlWIq/+92OzcvBLIDsQesDcWHMBvTHqr3z4hg
xturHjo33alfe+l5VzCvXenrpXw5QYc1bB/1gwOdT30Uv4POCxnF2+J5Q41l
4UGZfD5PHGYIkFH8Jpqv//Fm+A8PCOJ0
          "]]}, {
         Directive[
          PointSize[0.009166666666666668], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6], 
          AbsolutePointSize[6]], 
         GeometricTransformation[
          Inset[
           Style["\[FilledSmallCircle]", FontSize -> 26], {0., 0.}], {{{0.01, 
          0.0007724656839581919}}, {{0.05, 0.0055584924754662896`}}, {{0.09, 
          0.011461816774885076`}}, {{0.13, 0.016856868915540738`}}, {{0.17, 
          0.02151757264929578}}, {{0.21000000000000002`, 
          0.02684183039167252}}, {{0.25, 0.03161385048754016}}, {{
          0.29000000000000004`, 0.034738498634580346`}}, {{0.33, 
          0.03417744200286103}}, {{0.37, 0.025963649327837787`}}, {{
          0.41000000000000003`, 0.011851250306103409`}}, {{0.45, 
          0.0039208298224297075`}}, {{0.49, 
          0.0011520966104756748`}}}]}, {}}}, {}, {}, {}, {}}, {
     DisplayFunction -> Identity, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}}, AxesOrigin -> {0, 0}, 
      PlotRange -> {{0, 0.5304}, {0., 0.04}}, PlotRangeClipping -> True, 
      ImagePadding -> All, DisplayFunction -> Identity, AspectRatio -> 
      GoldenRatio^(-1), Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
         Style["dE/d\[Omega]", 26], None}, {
         Style["M\[Omega]", 26], None}}, FrameStyle -> Directive[16, 
        GrayLevel[0], FontFamily -> "Lucida Grande", Italic, 
        AbsoluteThickness[1.1]], 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> 600, 
      LabelStyle -> {FontFamily -> "Lucida Grande", Italic, 10, 
        GrayLevel[0]}, 
      Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {{0, 0.5304}, {0., 0.04}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      PointLegend[{
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        Directive[
         PointSize[0.009166666666666668], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]]}, {
        Style["Davis et al.", 18], 
        Style["Your result", 18]}, 
       LegendMarkers -> {{" ", 2}, {"\[FilledSmallCircle]", 26}}, 
       Joined -> {True, False}, 
       LabelStyle -> {FontFamily -> "Lucida Grande", Italic, 10, 
         GrayLevel[0]}, LegendLayout -> "Column"]], {{0.15, 0.85}}, 
     Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.725953599612053*^9, 3.725955354855295*^9, 3.7259563982094*^9, 
   3.725956551361567*^9, 3.725956953315666*^9, 3.7259571587380466`*^9, 
   3.725957427194881*^9, 3.725957524644965*^9, 3.725957659861898*^9, 
   3.72595786908287*^9, 3.7259579316445637`*^9, {3.726213906203987*^9, 
   3.7262139257434807`*^9}, 3.726214051280369*^9, {3.726215039814579*^9, 
   3.7262150492665157`*^9}, {3.72621509541294*^9, 3.7262151337622013`*^9}, 
   3.726215166256917*^9, {3.726215200057818*^9, 3.726215236981886*^9}, {
   3.7262152772094603`*^9, 3.7262152917506113`*^9}, 3.730111390456421*^9, 
   3.730111944717856*^9, {3.7301119752409267`*^9, 3.73011198319034*^9}, 
   3.743039682212022*^9, 3.743039809940332*^9, 3.743039916836825*^9, 
   3.7430399717335987`*^9, {3.7430409449916143`*^9, 3.743040960616864*^9}, 
   3.743041048797798*^9, 3.743041103261795*^9, 3.7430414185181704`*^9, {
   3.7430435313636703`*^9, 3.743043536278305*^9}, 3.743045238809957*^9, 
   3.743053644336074*^9, 3.743053952284769*^9, {3.743054713034856*^9, 
   3.7430547296076803`*^9}, 3.7430567246119003`*^9, 
   3.7432368716863813`*^9},ExpressionUUID->"c6757aa7-eeb5-43b1-8214-\
750e224c09ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inversion to find the waveform in the time domain", "Subsubsection",
 CellChangeTimes->{{3.743052814494602*^9, 3.7430528350855827`*^9}, {
  3.743055499042976*^9, 
  3.743055504317577*^9}},ExpressionUUID->"160d78de-3c28-4361-89bc-\
06c9e17ecb90"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Import", " ", "Z", 
     RowBox[{"(", "\[Omega]", ")"}], " ", "previously", " ", 
     RowBox[{"computed", ".", " ", 
      RowBox[{"Note", ":", " ", 
       RowBox[{
       "we", " ", "need", " ", "more", " ", "points", " ", "to", " ", 
        "sample", " ", "Z", 
        RowBox[{"(", "\[Omega]", ")"}], " ", "with", " ", "better", " ", 
        "accuracy"}]}]}]}], ",", " ", 
    RowBox[{"but", " ", "it", " ", "takes", " ", "time"}], ",", " ", 
    RowBox[{
    "so", " ", "for", " ", "now", " ", "it", " ", "is", " ", "enough"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Aplitudes", "=", 
    RowBox[{"Import", "[", "\"\<your_results.mx\>\"", "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.743053819014402*^9, 3.743053855328924*^9}, 
   3.743053965346965*^9, {3.743055132839321*^9, 
   3.743055133245092*^9}},ExpressionUUID->"6a47f1e9-f7e1-449f-aadd-\
c993cfcb03ca"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "This", " ", "small", " ", "numerical", " ", "routine", " ", "take", " ", 
    "in", " ", "input", " ", "the", " ", "values", " ", "of", " ", "Z", 
    RowBox[{"(", "\[Omega]", ")"}], " ", "computed", " ", "previously"}], ",",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
      "the", " ", "variable", " ", "A", " ", "inside", " ", "the", " ", 
       "Module"}], ")"}], " ", "and", " ", "return", " ", "the", " ", 
     "waveform", " ", "as", " ", "a", " ", "function", " ", "of", " ", "the", 
     " ", "retarded", " ", "time", " ", "t"}], "-", 
    SubscriptBox["r", "*"]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743053536764913*^9, 
  3.743053624442127*^9}},ExpressionUUID->"7291a7a0-e0d4-479d-a90b-\
14317190a033"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wawet", "[", 
   RowBox[{"data_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"A", ",", "\[Omega]", ",", "i", ",", 
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "t", "]"}]}], ",", 
      RowBox[{"d\[Omega]", "=", 
       RowBox[{
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"A", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "data"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"\[Omega]", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "data"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", "100"}], ")"}], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sqrt", "[", 
            FractionBox["2", "\[Pi]"], "]"}]}], 
          RowBox[{"Total", "[", 
           RowBox[{"Re", "[", 
            RowBox[{"MapThread", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"#1", " ", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "I"}], " ", "#2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", "100"}], ")"}]}], 
                 "]"}], "d\[Omega]"}], "&"}], ",", 
              RowBox[{"{", 
               RowBox[{"A", ",", "\[Omega]"}], "}"}]}], "]"}], "]"}], 
           "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.7430533398540783`*^9, 3.74305334198022*^9}, {
  3.7430534574203653`*^9, 3.7430534630719013`*^9}, {3.743053528829843*^9, 
  3.743053530761806*^9}, {3.7430536661825657`*^9, 3.74305370024195*^9}, {
  3.743054800553776*^9, 3.743054808873465*^9}, {3.7430549388913527`*^9, 
  3.743054955630301*^9}, {3.7430549966998672`*^9, 3.743055021665945*^9}, {
  3.7430551580227633`*^9, 3.743055164039144*^9}, {3.7430552657834806`*^9, 
  3.7430552659080887`*^9}, {3.743055301741403*^9, 3.7430553025240307`*^9}, {
  3.743055342071268*^9, 3.743055342171834*^9}, {3.743055437863913*^9, 
  3.743055483450172*^9}, {3.74323690423178*^9, 
  3.743236905108732*^9}},ExpressionUUID->"2533500d-e237-4356-86ff-\
39ed81f42e52"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "300", ",", "1"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743053717078903*^9, 3.7430537178436747`*^9}, {
   3.743054743521346*^9, 3.743054746333434*^9}, 3.7430547977615547`*^9, {
   3.743054943320223*^9, 3.743054971952981*^9}, {3.74305500572535*^9, 
   3.743055016006534*^9}, {3.743055170002194*^9, 3.743055178996027*^9}, {
   3.7430552955836687`*^9, 3.743055305781842*^9}, {3.743055345220326*^9, 
   3.7430553452995777`*^9}, {3.7430554780172987`*^9, 
   3.743055489692939*^9}},ExpressionUUID->"5220e30e-b6c8-48a0-9503-\
4ed6731a673d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"wawet", "[", 
    RowBox[{
     RowBox[{"Aplitudes", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
     "\[CapitalDelta]t"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743053724032422*^9, 3.7430537385812197`*^9}, {
   3.743053977581567*^9, 3.743053982449596*^9}, {3.743054840024287*^9, 
   3.743054847595543*^9}, {3.743055175327261*^9, 3.743055175489998*^9}, {
   3.743055282002673*^9, 3.7430552827824087`*^9}, 
   3.743055322541589*^9},ExpressionUUID->"8f3307ae-1ccb-4cf8-b28b-\
a2f8135c033e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"h", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Lucida Grande\>\""}], ",", 
      "Italic", ",", "10", ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\< \>\"", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledSmallCircle]\>\"", ",", "26"}], "}"}]}], "}"}]}], 
   ",", 
   RowBox[{"FrameStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{"16", ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"FontFamily", "->", "\"\<Lucida Grande\>\""}], ",", "Italic", 
      ",", 
      RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<h(t)\>\"", ",", "26"}], "]"}], ",", "None"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<(t-\!\(\*SubscriptBox[\(r\), \(*\)]\))/M\>\"", ",", "26"}], 
         "]"}], ",", "None"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743055351325774*^9, 3.743055410053616*^9}, 
   3.743055461304243*^9, {3.7432368914947042`*^9, 
   3.743236896691967*^9}},ExpressionUUID->"74863431-8e61-4bb5-8141-\
2f89b73bd224"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw91XlYjWsXBvDtIB1UxlSiQciYJpVUq3midnOah713u+STIhlih0hEoaio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       "]]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[6], 
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\<\" \"\>",
         StripOnInput->False,
         FontSize->2], {0., 0.}], CompressedData["
1:eJw91Xk4lWsXBvDdqeRU0iikDKk0R4QyLFOmYpvJzN7bJn0ZGlTUVimRQlEo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       
       "]]}, {}}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      StyleBox["\"h(t)\"", 26, StripOnInput -> False], TraditionalForm], 
     None}, {
     FormBox[
      StyleBox[
      "\"(t-\\!\\(\\*SubscriptBox[\\(r\\), \\(*\\)]\\))/M\"", 26, 
       StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[16, 
    GrayLevel[0], FontFamily -> "Lucida Grande", Italic, 
    AbsoluteThickness[1.1]],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  LabelStyle->{FontFamily -> "Lucida Grande", Italic, 10, 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-100., 200.}, {-0.3352026350977148, 0.3774102327623908}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.743055357069893*^9, 3.743055410480212*^9}, {
   3.743055461616474*^9, 3.74305549164786*^9}, 3.7430567353817167`*^9, {
   3.743236883023739*^9, 
   3.7432369076935368`*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"a2304787-ffb1-4493-8587-a48742b248a3"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1107, 742},
WindowMargins->{{147, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 394, 8, 160, "Title",ExpressionUUID->"a893aa8d-e120-4316-b312-36ac0a6454d4"],
Cell[819, 25, 227, 5, 30, "Input",ExpressionUUID->"b7cb238b-0af9-4761-b44f-94cf57b81ced"],
Cell[1049, 32, 1425, 32, 115, "Input",ExpressionUUID->"6e6b942d-4ccd-46ce-a2a3-cb33cb44a2e9"],
Cell[2477, 66, 1433, 31, 115, "Input",ExpressionUUID->"e0198571-83a2-453d-a87c-851c0588e427"],
Cell[CellGroupData[{
Cell[3935, 101, 253, 6, 54, "Subsection",ExpressionUUID->"5cc60782-e646-4b74-8d15-746e2f088b17"],
Cell[4191, 109, 974, 21, 73, "Input",ExpressionUUID->"3c9680ab-1470-4dba-854e-f69443949b06"],
Cell[5168, 132, 6173, 176, 288, "Input",ExpressionUUID->"cc45a341-a663-4d4e-b5d5-abe2d04a01ac"],
Cell[11344, 310, 150, 3, 30, "Input",ExpressionUUID->"6065a17e-9b48-4e67-acca-63ccb4093222"],
Cell[11497, 315, 2257, 61, 155, "Input",ExpressionUUID->"85f1ad42-99eb-4723-8bc5-e562e2d790ac"],
Cell[13757, 378, 1827, 46, 73, "Input",ExpressionUUID->"f906fc6e-de70-442e-9501-2a0a44620974"],
Cell[15587, 426, 4199, 90, 128, "Input",ExpressionUUID->"07b6f48a-f048-42df-addb-3e776136e04a"],
Cell[CellGroupData[{
Cell[19811, 520, 996, 23, 52, "Input",ExpressionUUID->"c83efc69-a4d6-4531-a45a-4f60cea0b1cc"],
Cell[20810, 545, 1671, 46, 70, "Output",ExpressionUUID->"d439870c-31a3-4414-8ea6-90d309df9724"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22518, 596, 1077, 28, 52, "Input",ExpressionUUID->"63f6b74a-d5a7-4f21-8be4-b9daa9adb70d"],
Cell[23598, 626, 4417, 125, 70, "Output",ExpressionUUID->"e9ac6b2d-ffbb-4b3e-83f0-c0734defc555"]
}, Open  ]],
Cell[28030, 754, 1515, 54, 107, "Input",ExpressionUUID->"ca1a2938-c5ad-4961-9797-054067dc534c"]
}, Closed]],
Cell[CellGroupData[{
Cell[29582, 813, 396, 7, 38, "Subsection",ExpressionUUID->"b03a8a0b-066c-40b4-a2a2-c10ee52cd8e2"],
Cell[29981, 822, 490, 9, 52, "Input",ExpressionUUID->"e158e823-72d6-4dba-a992-ae0aa5345c03"],
Cell[30474, 833, 2168, 46, 96, "Input",ExpressionUUID->"b0ae9d26-8dfe-401e-a0f8-d96f9c11d895"],
Cell[32645, 881, 1541, 43, 47, "Input",ExpressionUUID->"8936405c-674b-457e-a098-294d43f917f2"],
Cell[34189, 926, 849, 26, 30, "Input",ExpressionUUID->"aa791daf-1cba-4840-8ae2-c4073da968d7"],
Cell[35041, 954, 976, 31, 45, "Input",ExpressionUUID->"331aa690-4ffe-4ba7-9d82-f8c52774f281"],
Cell[36020, 987, 358, 6, 30, "Input",ExpressionUUID->"66bf3b95-e049-4d69-b9e1-e3bb4e4fcac7"],
Cell[36381, 995, 2082, 40, 70, "Input",ExpressionUUID->"df696704-d574-4d68-b729-1f189daea8c2"],
Cell[38466, 1037, 1603, 43, 98, "Input",ExpressionUUID->"320b975f-afb8-4e6e-8f42-f28537b57af3"],
Cell[40072, 1082, 812, 23, 30, "Input",ExpressionUUID->"509d1bc7-427c-492e-b3ca-8721e8487c41"],
Cell[40887, 1107, 923, 27, 49, "Input",ExpressionUUID->"b147c48b-11b7-4902-9b8d-f50a917414fd"],
Cell[41813, 1136, 113, 1, 30, "Input",ExpressionUUID->"d778f676-b3d7-4305-ac91-4d93b55bc0b2"]
}, Closed]],
Cell[CellGroupData[{
Cell[41963, 1142, 163, 3, 38, "Subsection",ExpressionUUID->"a7516cdf-297d-4aff-afe5-d6a150f3df01"],
Cell[42129, 1147, 2503, 70, 131, "Input",ExpressionUUID->"aec8c4ea-8dfb-47d1-aedb-606c48da398e"],
Cell[CellGroupData[{
Cell[44657, 1221, 553, 14, 52, "Input",ExpressionUUID->"5808347c-4dba-4835-9f63-21503c0aff9a"],
Cell[45213, 1237, 1886, 51, 72, "Output",ExpressionUUID->"e89558a3-5b53-46a4-9bfb-6970ad7e18cb"]
}, Open  ]],
Cell[47114, 1291, 14724, 313, 950, "Input",ExpressionUUID->"0cfbaa34-da18-44df-906d-852ab82dcad9"],
Cell[CellGroupData[{
Cell[61863, 1608, 394, 8, 30, "Input",ExpressionUUID->"f2fb2de6-2e3c-4510-9697-560b51bfce05"],
Cell[62260, 1618, 559, 12, 24, "Message",ExpressionUUID->"1d54648c-aa58-454d-bc8d-b66301d6e57a"],
Cell[62822, 1632, 741, 14, 34, "Output",ExpressionUUID->"580a8dbd-6d69-4ad2-9559-c807b821c52f"]
}, Open  ]],
Cell[63578, 1649, 1866, 32, 30, "Input",ExpressionUUID->"d95c078b-6218-45af-8078-0c1f1f09622f"],
Cell[CellGroupData[{
Cell[65469, 1685, 400, 10, 52, "Input",ExpressionUUID->"0355d2c9-9273-4670-bd88-266c3b537d96"],
Cell[65872, 1697, 223, 4, 34, "Output",ExpressionUUID->"8a332758-9924-4085-bab8-8b4cff85c96c"]
}, Open  ]],
Cell[66110, 1704, 720, 18, 52, "Input",ExpressionUUID->"03690767-cbcd-4ab4-a07f-fd417b34cfb9"],
Cell[CellGroupData[{
Cell[66855, 1726, 3482, 87, 178, "Input",ExpressionUUID->"2adc78e3-bafa-4de9-bb07-c92cdb6933fc"],
Cell[70340, 1815, 26303, 527, 409, "Output",ExpressionUUID->"c6757aa7-eeb5-43b1-8214-750e224c09ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96680, 2347, 251, 4, 45, "Subsubsection",ExpressionUUID->"160d78de-3c28-4361-89bc-06c9e17ecb90"],
Cell[96934, 2353, 975, 24, 73, "Input",ExpressionUUID->"6a47f1e9-f7e1-449f-aadd-c993cfcb03ca"],
Cell[97912, 2379, 813, 19, 52, "Input",ExpressionUUID->"7291a7a0-e0d4-479d-a90b-14317190a033"],
Cell[98728, 2400, 2920, 74, 231, "Input",ExpressionUUID->"2533500d-e237-4356-86ff-39ed81f42e52"],
Cell[101651, 2476, 652, 12, 30, "Input",ExpressionUUID->"5220e30e-b6c8-48a0-9503-4ed6731a673d"],
Cell[102306, 2490, 650, 16, 30, "Input",ExpressionUUID->"8f3307ae-1ccb-4cf8-b28b-a2f8135c033e"],
Cell[CellGroupData[{
Cell[102981, 2510, 1758, 46, 94, "Input",ExpressionUUID->"74863431-8e61-4bb5-8141-2f89b73bd224"],
Cell[104742, 2558, 51134, 861, 399, 10039, 187, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"a2304787-ffb1-4493-8587-a48742b248a3"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

