(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    274605,       7276]
NotebookOptionsPosition[    260282,       7031]
NotebookOutlinePosition[    260641,       7047]
CellTagsIndexPosition[    260598,       7044]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Axial and Polar perturbations with a source term given by an infalling \
particle \
\>", "Title",
 CellChangeTimes->{{3.722026108833889*^9, 3.722026133002123*^9}, {
  3.722063827267627*^9, 3.722063838046527*^9}, {3.7430144054961233`*^9, 
  3.743014406101254*^9}},ExpressionUUID->"e168f81b-5a28-4bfd-8462-\
fe9e95f53356"],

Cell[BoxData[
 RowBox[{"Exit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.72198799897161*^9, 3.72198799990344*^9}, {
  3.743016558004128*^9, 
  3.7430165586531563`*^9}},ExpressionUUID->"4eaac8f0-168c-40d2-a1b3-\
23243a790dc6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "\[GreaterEqual]", "0"}], ",", 
      RowBox[{"M", ">", "0"}], ",", 
      RowBox[{"Element", "[", 
       RowBox[{"L", ",", "Integers"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "set", " ", "up", " ", "the", " ", "working", " ", 
    "directory", " ", "of", " ", "the", " ", "notebook"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "path", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.717417827152334*^9, 3.717417827545067*^9}, {
   3.720525806525712*^9, 3.72052580687288*^9}, {3.720960445169264*^9, 
   3.72096044584095*^9}, {3.721032400106536*^9, 3.721032401314507*^9}, 
   3.722585389504361*^9, {3.724767015218999*^9, 3.724767015946599*^9}, {
   3.724767570416555*^9, 3.7247675708351393`*^9}, {3.724768211416267*^9, 
   3.72476822262503*^9}, {3.7247869373512907`*^9, 3.724786939953195*^9}, {
   3.7258011818217373`*^9, 3.725801182345151*^9}, {3.743014362739792*^9, 
   3.74301438172966*^9}, {3.7430151467686777`*^9, 3.7430151474379272`*^9}, 
   3.743043716425914*^9},ExpressionUUID->"96414fa7-5495-488a-83f9-\
a390a5aa4ecb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "loads", " ", "the", " ", "package", " ", "to", " ", 
    "compute", " ", "the", " ", "needed", " ", "tensor", " ", "quantities"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"<<", "GR`"}]}]], "Input",
 CellChangeTimes->{{3.7108447343392677`*^9, 3.7108447388735943`*^9}, {
   3.7220083379171963`*^9, 3.722008338455636*^9}, {3.743014398603294*^9, 
   3.7430144000913677`*^9}, 
   3.7430391638771677`*^9},ExpressionUUID->"52bd16fd-d6b3-4f3f-83a7-\
794660fcd830"],

Cell[BoxData["\<\"Tensor-Manipulation package for General Relativity\"\>"], \
"Print",
 CellChangeTimes->{
  3.710844739315378*^9, 3.710858413197279*^9, 3.710858486319294*^9, 
   3.710875498658701*^9, 3.7109089930420837`*^9, {3.710909714822942*^9, 
   3.710909729593444*^9}, 3.710909784062955*^9, {3.710910911059141*^9, 
   3.710910941912402*^9}, 3.710912959451252*^9, {3.710913928243575*^9, 
   3.710913932789567*^9}, 3.7109139781025753`*^9, 3.710914700074437*^9, 
   3.710917869871997*^9, 3.71091925661825*^9, 3.710923663236732*^9, 
   3.710930482232594*^9, 3.7109308639305897`*^9, 3.71093682788736*^9, 
   3.710937436136754*^9, 3.710938125694181*^9, 3.7109385140613728`*^9, 
   3.710940322145585*^9, 3.710960089684945*^9, 3.710960259181744*^9, 
   3.71096063087257*^9, 3.710996690891996*^9, 3.710998017780259*^9, 
   3.7109980530815783`*^9, 3.710998106662403*^9, 3.710998156402622*^9, 
   3.710998774364602*^9, 3.71099914129547*^9, 3.711013316687335*^9, 
   3.711013535677001*^9, 3.7110148942390537`*^9, 3.712432366876275*^9, 
   3.712433329015088*^9, 3.712433486500259*^9, 3.715768103963518*^9, 
   3.715845409830398*^9, 3.71588262807726*^9, 3.715883084203133*^9, 
   3.7158831507466908`*^9, 3.715884063453348*^9, 3.716037589543442*^9, 
   3.716041409435648*^9, 3.716041586688829*^9, 3.716042236787171*^9, 
   3.716042724489435*^9, 3.716103163134172*^9, 3.716123208061068*^9, 
   3.716195774202483*^9, 3.716203787908861*^9, 3.716229439955892*^9, 
   3.716234724519266*^9, 3.7162364952813396`*^9, 3.716274200852707*^9, {
   3.7162876306392527`*^9, 3.716287642928952*^9}, 3.716458711116749*^9, {
   3.7164595845021257`*^9, 3.716459610373646*^9}, 3.7164596735938797`*^9, 
   3.7164597122383957`*^9, 3.71647405813686*^9, 3.7164746717491293`*^9, 
   3.716529578990542*^9, 3.716529633529394*^9, 3.7165342189273252`*^9, 
   3.716534619950852*^9, 3.716534734813793*^9, 3.716548105867743*^9, {
   3.716552315761684*^9, 3.7165523258220787`*^9}, {3.716571399817101*^9, 
   3.716571423078926*^9}, 3.7166177571923227`*^9, 3.7166185499174767`*^9, {
   3.716648682573002*^9, 3.716648692895338*^9}, 3.71665873586141*^9, 
   3.716662194720627*^9, 3.716706553995591*^9, 3.7167070937248077`*^9, 
   3.716714917874806*^9, 3.716719342012394*^9, {3.716789966420747*^9, 
   3.7167899788140383`*^9}, 3.7169020573650627`*^9, 3.716902221873259*^9, 
   3.716962631675804*^9, 3.71696385076618*^9, 3.7169644910084953`*^9, 
   3.716975917122826*^9, 3.716977619599522*^9, 3.716978456014071*^9, 
   3.716981064199836*^9, 3.7169853685389967`*^9, 3.717051510451823*^9, 
   3.7170519841957483`*^9, 3.717071092521749*^9, 3.717074003327711*^9, 
   3.717132888923712*^9, 3.717134122693799*^9, 3.717135759963578*^9, 
   3.7171358398320208`*^9, 3.717136251241684*^9, 3.7171377542268047`*^9, 
   3.7171378718728247`*^9, 3.7171379567133427`*^9, 3.717138699765691*^9, 
   3.717139135469267*^9, 3.717146444198229*^9, 3.7171500293093023`*^9, 
   3.717150170822575*^9, 3.717150293781459*^9, 3.717150440367343*^9, 
   3.717150473317298*^9, 3.71715103844105*^9, 3.717171650702833*^9, 
   3.717175741678699*^9, 3.7171857824269543`*^9, 3.717187113011561*^9, 
   3.7172314831239853`*^9, 3.717232951557041*^9, 3.7172335089450417`*^9, 
   3.717247935713171*^9, 3.71724804355112*^9, 3.717248565603159*^9, 
   3.717416905485021*^9, 3.717418456473103*^9, 3.717503312477106*^9, 
   3.717503410694337*^9, 3.718007696798436*^9, 3.7180168464759274`*^9, 
   3.718173523549264*^9, 3.720525808005834*^9, 3.720528054768415*^9, 
   3.720529348649117*^9, 3.720530713128083*^9, 3.720530753540514*^9, 
   3.7205315497829113`*^9, 3.720531667998118*^9, 3.720531857645668*^9, 
   3.7205319389468613`*^9, 3.720535081040428*^9, 3.7205369625878553`*^9, 
   3.72053702330365*^9, 3.720537519656448*^9, 3.720537746172947*^9, 
   3.7205379574028797`*^9, 3.720538097629486*^9, 3.720538957773849*^9, 
   3.72053919230732*^9, 3.720540339706502*^9, 3.720540514672456*^9, 
   3.720596683105389*^9, 3.72060909579107*^9, 3.720620136574809*^9, 
   3.720620755706502*^9, 3.720627922191114*^9, 3.7206282041047707`*^9, 
   3.7206289660095177`*^9, 3.720630958515176*^9, 3.72063260267811*^9, 
   3.72063442533626*^9, 3.720640745978726*^9, 3.7206810756994743`*^9, {
   3.7206837445291643`*^9, 3.720683760765832*^9}, 3.720695121696227*^9, 
   3.720704153988662*^9, 3.720707674004672*^9, 3.720712140727511*^9, 
   3.720713115735359*^9, 3.720767601010401*^9, 3.720767673913789*^9, 
   3.720767929541*^9, 3.720768046382743*^9, 3.7207680945844393`*^9, 
   3.720777511281605*^9, 3.720786033186262*^9, 3.720941038890833*^9, 
   3.720941218635153*^9, 3.720952003344808*^9, 3.7209539243728037`*^9, 
   3.720956955717176*^9, 3.720960448094158*^9, 3.720960601626824*^9, 
   3.7209606973855047`*^9, 3.720967555467087*^9, 3.720970148430612*^9, 
   3.720973828564684*^9, 3.7209742716703787`*^9, 3.721025609324436*^9, {
   3.72103096890269*^9, 3.7210309861847982`*^9}, 3.721031066844459*^9, 
   3.7210324030461197`*^9, 3.7210324404406347`*^9, 3.7210324833422422`*^9, 
   3.721032961502602*^9, 3.721033131820856*^9, 3.7210332883199*^9, 
   3.721036687087501*^9, 3.721036727436222*^9, {3.72103723410137*^9, 
   3.721037263331958*^9}, 3.721039219192274*^9, 3.72198800199181*^9, {
   3.7219972639497423`*^9, 3.721997268451149*^9}, 3.721997394623805*^9, 
   3.721997589105464*^9, 3.722000078895651*^9, 3.722000200209064*^9, 
   3.722001488715171*^9, 3.722001575838633*^9, 3.7220027578272943`*^9, 
   3.722006473755715*^9, 3.722008338958926*^9, 3.72201052530996*^9, 
   3.7220145334265013`*^9, 3.722015107234473*^9, 3.722015536207354*^9, 
   3.7220179479265623`*^9, 3.7220208479156723`*^9, 3.722022278966831*^9, 
   3.7221528909446383`*^9, 3.722153218090103*^9, 3.722330043178608*^9, 
   3.722330233689014*^9, 3.7223654304336433`*^9, 3.7223749833278913`*^9, 
   3.722415355191362*^9, 3.7224160720613537`*^9, 3.722418223336327*^9, 
   3.72242118348202*^9, 3.722421555217227*^9, 3.7224218354308577`*^9, 
   3.722585392198668*^9, 3.723112260929523*^9, 3.723113685053886*^9, 
   3.7231313930913363`*^9, {3.723210757136387*^9, 3.723210761294112*^9}, 
   3.723211605553343*^9, 3.723236156544606*^9, {3.723273446858735*^9, 
   3.723273451487385*^9}, 3.723273786137042*^9, 3.723274256895115*^9, 
   3.723307127087201*^9, 3.723313210872879*^9, 3.7233175287779617`*^9, {
   3.7233180505162697`*^9, 3.7233180546289787`*^9}, 3.723319346563766*^9, 
   3.724418624329969*^9, 3.724421151243815*^9, 3.724590710689481*^9, 
   3.7245939174856367`*^9, 3.7246971930604687`*^9, 3.7247008540974417`*^9, 
   3.724701901903233*^9, 3.7257968214991207`*^9, 3.725800282980689*^9, 
   3.725800690152671*^9, 3.7258011840903997`*^9, 3.725951355178787*^9, 
   3.7259583661925907`*^9, 3.725992369357691*^9, 3.726155906222644*^9, 
   3.730109746295979*^9, 3.730110560467577*^9, 3.732091285005109*^9, 
   3.732091760655034*^9, 3.732092258407981*^9, 3.732093259728218*^9, 
   3.732094598578483*^9, 3.732094630259261*^9, {3.732096651724737*^9, 
   3.732096661097764*^9}, 3.732099647310678*^9, 3.7321028539823236`*^9, 
   3.732106518839698*^9, 3.743013957606496*^9, 3.743014415748328*^9, 
   3.74301450624617*^9, 3.743015149932838*^9, 3.743015335183175*^9, 
   3.743015749354314*^9, 3.7430158713137817`*^9, 3.743016561641767*^9, 
   3.743017611837232*^9, 3.743018050568591*^9, 3.743018623564734*^9, 
   3.7430300716988688`*^9, 3.743030276805994*^9, 3.7430303732784443`*^9, 
   3.743030700966569*^9, 3.743039162270134*^9, 
   3.743040413605487*^9},ExpressionUUID->"d84e5235-423b-41dd-afeb-\
34d1cd98c61d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Field\[CloseCurlyQuote]s equations", "Section",
 CellChangeTimes->{{3.724597338243511*^9, 
  3.724597346132855*^9}},ExpressionUUID->"fabf640a-00b2-48d3-af84-\
61732c19ce93"],

Cell[CellGroupData[{

Cell["\<\
Tensor harmonic decomposition [For the tensor harmonics I use the definition \
of Sago et al. PRD 67, 10 (2003)]\
\>", "Subsection",
 CellChangeTimes->{{3.721996718507633*^9, 3.7219967289037027`*^9}, {
  3.722000080354898*^9, 3.7220000809081373`*^9}, {3.722026152701565*^9, 
  3.722026154138104*^9}, {3.7430139989999247`*^9, 3.743014063131216*^9}, {
  3.743039170437727*^9, 
  3.743039175834085*^9}},ExpressionUUID->"a8bd15ea-9f5d-414d-9f73-\
08a7ae5b7998"],

Cell[TextData[StyleBox["This is the general form for the set of tensorial \
harmonics",
 FontSize->18,
 FontColor->RGBColor[1, 0, 0]]], "Item",
 CellChangeTimes->{
  3.722063954596684*^9},ExpressionUUID->"181f4e91-7c05-49c6-ae47-\
ceb7a05320af"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Y", "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{
    FractionBox["I", 
     RowBox[{"Sqrt", "[", "2", "]"}]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0", ",", 
        "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Y", "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b0", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"I", " ", "r"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
         "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Phi]"}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
         "]"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Phi]"}], "]"}],
         ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    FractionBox["r", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
         "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Phi]"}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
         "]"}], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Phi]"}], "]"}],
         ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0", "=", 
   RowBox[{
    FractionBox["r", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"S\[Theta]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
        RowBox[{"S\[Phi]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S\[Theta]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0", ",", 
        "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"S\[Phi]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0", ",", 
        "0"}], "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"I", " ", "r"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"S\[Theta]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
        RowBox[{"S\[Phi]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"S\[Theta]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"S\[Phi]", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0", ",", "0"}], 
       "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"I", " ", 
       SuperscriptBox["r", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "l", 
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"l", "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"l", "+", "2"}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "2"}]]]}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"X", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"W", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"W", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], 
         RowBox[{"X", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["r", "2"], 
     RowBox[{"Sqrt", "[", "2", "]"}]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
         RowBox[{"Y", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["r", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"l", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"l", "+", "2"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"W", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
        RowBox[{"X", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"X", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], 
         RowBox[{"W", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], "}"}]}], "}"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7219967315908012`*^9, 3.721996767646525*^9}, {
   3.721996803121952*^9, 3.721996833120118*^9}, {3.722001499332003*^9, 
   3.722001500931719*^9}, {3.722014586063696*^9, 3.722014603990048*^9}, 
   3.7220155408044853`*^9, {3.72201562220982*^9, 3.722015718196847*^9}, {
   3.722017307911832*^9, 3.722017375976766*^9}, {3.722017435818725*^9, 
   3.7220176066663427`*^9}, {3.722017637221691*^9, 3.722017644898293*^9}, 
   3.722022261194623*^9},ExpressionUUID->"203f779d-ed50-4ac4-89bf-\
259d7e53999a"],

Cell[TextData[StyleBox["Stress energy - tensor",
 FontSize->18,
 FontColor->RGBColor[1, 0, 0]]], "Item",
 CellChangeTimes->{
  3.722063944948791*^9},ExpressionUUID->"6196eb92-c97c-42de-b82b-\
385984f59205"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Delta]TA", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptCapitalQ]0", "[", "r", "]"}], "c0"}], "+", 
       RowBox[{
        RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}], "c"}], "+", 
       RowBox[{
        RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}], "d"}]}], ")"}], 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "\[Omega]", " ", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]TP", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"\[ScriptCapitalA]0", "[", "r", "]"}], "a0"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], "a1"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], "a"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}], "b0"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], "b"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalG]", "[", "r", "]"}], "g"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}], "f"}]}], ")"}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Omega]", " ", "t"}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.721997197972341*^9, 3.721997297190443*^9}, {
   3.721997560941536*^9, 3.7219975841694517`*^9}, {3.722000088677917*^9, 
   3.722000091009444*^9}, {3.72200263539139*^9, 3.7220026401269712`*^9}, {
   3.7220184739630613`*^9, 3.722018541451301*^9}, 3.722018591044235*^9, {
   3.7220208056287193`*^9, 3.7220208408907433`*^9}, {3.722421167440812*^9, 
   3.7224211711318617`*^9}, {3.722585397840612*^9, 3.7225854001822433`*^9}, {
   3.7320912748540277`*^9, 3.7320912799201612`*^9}, {3.732091766552846*^9, 
   3.732091768297843*^9}},ExpressionUUID->"440e02ea-38ea-4e5d-a646-\
b57a2a7f96bd"],

Cell[TextData[StyleBox["Metric perturbations",
 FontSize->18,
 FontColor->RGBColor[1, 0, 0]]], "Item",
 CellChangeTimes->{{3.7220639072176456`*^9, 3.7220639353851967`*^9}, {
  3.7430144313374863`*^9, 
  3.743014439134701*^9}},ExpressionUUID->"d00a41e1-bd43-46a5-95a3-\
24522bb1f5c3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Delta]gA", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "l", 
             RowBox[{"(", 
              RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "2"}]], "r"]}], 
        RowBox[{"h0", "[", "r", "]"}], "c0"}], "+", 
       RowBox[{"I", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "l", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "2"}]], "r"], 
        RowBox[{"h1", "[", "r", "]"}], "c"}], "+", 
       RowBox[{
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "l", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"l", "-", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"l", "+", "2"}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "2"}]], 
         RowBox[{"2", 
          SuperscriptBox["r", "2"]}]], 
        RowBox[{"h2", "[", "r", "]"}], "d"}]}], ")"}], 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "\[Omega]", " ", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]gP", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"F", "[", "r", "]"}], 
       RowBox[{"H0", "[", "r", "]"}], "a0"}], "-", 
      RowBox[{"I", " ", 
       RowBox[{"Sqrt", "[", "2", "]"}], 
       RowBox[{"H1", "[", "r", "]"}], "a1"}], "+", 
      RowBox[{
       FractionBox[
        RowBox[{"H2", "[", "r", "]"}], 
        RowBox[{"F", "[", "r", "]"}]], "a"}], "-", 
      RowBox[{
       FractionBox["I", "r"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "l", 
          RowBox[{"(", 
           RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "2"}]], 
       RowBox[{"\[Eta]0", "[", "r", "]"}], "b0"}], "+", 
      RowBox[{
       FractionBox["1", "r"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "l", 
          RowBox[{"(", 
           RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "2"}]], 
       RowBox[{"\[Eta]1", "[", "r", "]"}], "b"}], "+", "\[IndentingNewLine]", 
      
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "l", 
          RowBox[{"(", 
           RowBox[{"l", "+", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"l", "-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"l", "+", "2"}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "2"}]], 
       RowBox[{"G", "[", "r", "]"}], "f"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], 
          RowBox[{"K", "[", "r", "]"}]}], "-", 
         RowBox[{
          FractionBox[
           RowBox[{"l", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}]}], 
           RowBox[{"Sqrt", "[", "2", "]"}]], 
          RowBox[{"G", "[", "r", "]"}]}]}], ")"}], "g"}]}], ")"}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Omega]", " ", "t"}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.722014367852685*^9, 3.722014526030262*^9}, 
   3.7224214300642776`*^9, 3.7225854026155767`*^9, 3.732091278140575*^9, 
   3.7320917711867228`*^9, {3.743015167570804*^9, 
   3.743015168015674*^9}},ExpressionUUID->"90533c90-a0cf-4f1a-8002-\
c48e900ddb20"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute the perturbed field\[CloseCurlyQuote]s equations", "Subsection",
 CellChangeTimes->{{3.7172308615739927`*^9, 3.717230868372512*^9}, 
   3.720769817593091*^9, {3.722064041335661*^9, 3.722064048440073*^9}, {
   3.743014590759817*^9, 
   3.7430145923929653`*^9}},ExpressionUUID->"8db395b1-910a-4ab1-b06d-\
6f8d63f42705"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "My", " ", "bookeeping", " ", "parameter", " ", "for", " ", "the", " ", 
   "perturbation", " ", "is", " ", "\[Epsilon]"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7430142380666924`*^9, 
  3.743014252227396*^9}},ExpressionUUID->"6c9dce83-ebb8-472c-8352-\
aaa8a06a0abe"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"S\[Epsilon]", "[", "F_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{"F", ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
    "Normal"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "=", 
    RowBox[{"{", 
     RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptG]0", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"F", "[", "r", "]"}]}], ",", "0", ",", "0", ",", "0"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        SuperscriptBox[
         RowBox[{"F", "[", "r", "]"}], 
         RowBox[{"-", "1"}]], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        SuperscriptBox["r", "2"], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", 
        RowBox[{
         SuperscriptBox["r", "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], "}"}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[ScriptG]P", "=", 
   RowBox[{"\[ScriptG]0", "+", 
    RowBox[{"\[Epsilon]", " ", "\[Delta]gP"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptG]A", "=", 
    RowBox[{"\[ScriptG]0", "+", 
     RowBox[{"\[Epsilon]", " ", "\[Delta]gA"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S\[Theta]", "[", 
      RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ",", 
     RowBox[{"S\[Phi]", "[", 
      RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}]}], "}"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Phi]"}], "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
       "]"}]}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7108585907032423`*^9, 3.710858608438038*^9}, {
   3.7108733568714447`*^9, 3.7108737103713493`*^9}, {3.7108772483821077`*^9, 
   3.7108772505896673`*^9}, {3.7108773604686737`*^9, 
   3.7108773608186398`*^9}, {3.710911048523087*^9, 3.710911049466196*^9}, {
   3.710912962864006*^9, 3.710912963095639*^9}, {3.710913063136671*^9, 
   3.7109130918704576`*^9}, {3.710913200008442*^9, 3.710913211913275*^9}, {
   3.7109139069221783`*^9, 3.7109139130579367`*^9}, {3.710919252932028*^9, 
   3.7109192547308273`*^9}, 3.715882170750845*^9, 3.7158822574448853`*^9, {
   3.7158826137401953`*^9, 3.715882619701902*^9}, 3.715884055781893*^9, {
   3.71604152178113*^9, 3.7160415697948093`*^9}, 3.716042655010754*^9, {
   3.716706554475313*^9, 3.716706566250947*^9}, {3.716706628982213*^9, 
   3.7167066330683737`*^9}, {3.7167070827515917`*^9, 3.716707101217065*^9}, {
   3.716901557087647*^9, 3.71690157108318*^9}, 3.716901696607945*^9, {
   3.716901772828326*^9, 3.71690179605061*^9}, {3.716901882553293*^9, 
   3.7169018946888638`*^9}, {3.716902213504572*^9, 3.71690223323612*^9}, {
   3.716902673146332*^9, 3.7169026778026133`*^9}, {3.717049718452731*^9, 
   3.7170497200025387`*^9}, {3.717051488252329*^9, 3.7170515059544477`*^9}, {
   3.717051596126327*^9, 3.71705161629878*^9}, {3.717051656718347*^9, 
   3.71705166216459*^9}, {3.717051929525309*^9, 3.71705195234092*^9}, {
   3.717052035550927*^9, 3.717052049854117*^9}, {3.717052447605729*^9, 
   3.717052450341289*^9}, {3.717074100292274*^9, 3.717074101545949*^9}, {
   3.717150573158684*^9, 3.717150591710085*^9}, {3.717233555525792*^9, 
   3.717233572997188*^9}, {3.717234223168067*^9, 3.717234224225257*^9}, {
   3.7172374662410593`*^9, 3.7172375332319393`*^9}, {3.717248557424576*^9, 
   3.7172485719867973`*^9}, {3.717417176476716*^9, 3.717417177090757*^9}, {
   3.7180077128777227`*^9, 3.7180077404749126`*^9}, {3.720525830195601*^9, 
   3.720525833301874*^9}, {3.720526053922454*^9, 3.720526079712504*^9}, {
   3.720526231588484*^9, 3.720526232817539*^9}, 3.720526582564312*^9, {
   3.7205269067890263`*^9, 3.720526932370109*^9}, {3.720527000412356*^9, 
   3.72052711464893*^9}, {3.7205271535283537`*^9, 3.720527197159088*^9}, {
   3.720528010441883*^9, 3.7205280483850193`*^9}, {3.720528421088567*^9, 
   3.720528422704824*^9}, {3.72052875635082*^9, 3.720528759549584*^9}, {
   3.720528831830327*^9, 3.720528902335083*^9}, {3.7205293336711397`*^9, 
   3.720529363544052*^9}, {3.720530697599987*^9, 3.720530723986101*^9}, {
   3.7205307551826277`*^9, 3.72053075799034*^9}, {3.720530959757489*^9, 
   3.720530964066114*^9}, {3.7205315121584787`*^9, 3.720531562435438*^9}, {
   3.720531653123899*^9, 3.720531662449994*^9}, {3.7205317056505947`*^9, 
   3.7205317352176247`*^9}, {3.7205318425162277`*^9, 3.720531852884438*^9}, {
   3.720531946021082*^9, 3.720531951566874*^9}, {3.72053521285625*^9, 
   3.720535215891736*^9}, {3.720537013071289*^9, 3.720537016148076*^9}, {
   3.720537064034533*^9, 3.7205370662221823`*^9}, 3.720537512317504*^9, 
   3.720537728869339*^9, {3.720538086279879*^9, 3.720538090425097*^9}, {
   3.720539268427197*^9, 3.720539285095768*^9}, {3.7205410405401917`*^9, 
   3.72054109782555*^9}, {3.720609105525333*^9, 3.720609166878462*^9}, 
   3.720614608393573*^9, 3.720627912345615*^9, 3.720628960528553*^9, {
   3.720632428696684*^9, 3.72063243122082*^9}, 3.720632682137484*^9, {
   3.720634060249433*^9, 3.720634070485189*^9}, 3.720634419163144*^9, {
   3.720635357053184*^9, 3.720635366272728*^9}, {3.720640749761742*^9, 
   3.720640750791018*^9}, 3.7206837539854794`*^9, {3.7206865966610622`*^9, 
   3.7206865985457697`*^9}, {3.7206871561617527`*^9, 3.720687162431079*^9}, {
   3.720687198841119*^9, 3.720687205172299*^9}, {3.720695110342008*^9, 
   3.7206951268872223`*^9}, {3.720704088247519*^9, 3.7207040884805593`*^9}, {
   3.720708039127782*^9, 3.720708039537127*^9}, 3.7209701623407907`*^9, {
   3.721030994248893*^9, 3.721030994472788*^9}, {3.721031027098844*^9, 
   3.721031037325766*^9}, {3.721036679445738*^9, 3.721036681259993*^9}, {
   3.7210372561682463`*^9, 3.721037256367055*^9}, {3.721988015518856*^9, 
   3.721988037259454*^9}, {3.7219890405138063`*^9, 3.7219890411005497`*^9}, {
   3.7219972848352127`*^9, 3.721997290386742*^9}, {3.722006456740663*^9, 
   3.7220064675470953`*^9}, {3.722010288407909*^9, 3.722010343190721*^9}, {
   3.722010509759205*^9, 3.7220105118321943`*^9}, {3.722014359605172*^9, 
   3.722014361898397*^9}, {3.722014852569227*^9, 3.7220148582998877`*^9}, {
   3.722014924644771*^9, 3.722014929025614*^9}, {3.7220184106706753`*^9, 
   3.722018413296976*^9}, {3.7220184549490347`*^9, 3.7220184580348177`*^9}, {
   3.7220201834467297`*^9, 3.722020184210967*^9}, {3.7220209019256687`*^9, 
   3.72202090213354*^9}, {3.722022304511468*^9, 3.722022305432836*^9}, {
   3.722026167831155*^9, 3.7220261958116903`*^9}, {3.722064053181923*^9, 
   3.7220640537586603`*^9}, 3.722152871518374*^9, {3.7221529076152477`*^9, 
   3.72215290958974*^9}},ExpressionUUID->"92e16bb5-6f1c-4ed5-9ecc-\
74cc60d7e71e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "compute", " ", "the", " ", "axial", " ", "and", " ", "polar", 
     " ", "components", " ", "of", " ", "the", " ", 
     RowBox[{"field", "'"}], "s", " ", 
     RowBox[{"euqations", ".", " ", "Due"}], " ", "the", " ", "the", " ", 
     "background", " ", "spherical", " ", "symmetry", " ", "they", " ", 
     "decouple"}], ",", " ", 
    RowBox[{"so", " ", "I", " ", "treat", " ", "them", " ", "separately"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"\[ScriptCapitalE]P", "=", 
    RowBox[{
     RowBox[{"S\[Epsilon]", "[", 
      RowBox[{"Ricci", "[", 
       RowBox[{"\[ScriptG]P", ",", "y"}], "]"}], "]"}], "-", 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{"S\[Epsilon]", "[", 
       RowBox[{"\[ScriptG]P", " ", 
        RowBox[{"RicciScalar", "[", 
         RowBox[{"\[ScriptG]P", ",", "y"}], "]"}]}], "]"}]}], "-", 
     RowBox[{"8", "\[Pi]", " ", "\[Epsilon]", " ", "\[Delta]TP"}]}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.720777552793537*^9, 3.7207775720016117`*^9}, 
   3.720941208343499*^9, 3.7209542422694073`*^9, {3.720960060640814*^9, 
   3.7209600658065023`*^9}, {3.720960464880557*^9, 3.720960466457756*^9}, {
   3.720960549762897*^9, 3.720960554250496*^9}, 3.720960684436742*^9, {
   3.720970191051552*^9, 3.720970191275523*^9}, {3.720970224260152*^9, 
   3.7209702247556562`*^9}, {3.720972536781846*^9, 3.720972541188154*^9}, {
   3.720972591537182*^9, 3.720972594088613*^9}, {3.721030421256278*^9, 
   3.721030447160956*^9}, 3.721031045400215*^9, {3.721031202100862*^9, 
   3.7210312165228233`*^9}, {3.721031577816712*^9, 3.7210315790254707`*^9}, 
   3.721033300730735*^9, {3.7210369448049726`*^9, 3.7210369537403097`*^9}, {
   3.72198804956564*^9, 3.721988049783709*^9}, {3.721989031302495*^9, 
   3.7219890602242413`*^9}, {3.7219891009684772`*^9, 
   3.7219891079806147`*^9}, {3.721989154902359*^9, 3.721989158601364*^9}, {
   3.721991141886861*^9, 3.721991144587426*^9}, 3.722000194557679*^9, {
   3.7220027733555737`*^9, 3.722002773495562*^9}, {3.722018464394287*^9, 
   3.7220184661591377`*^9}, 3.7220186069118423`*^9, {3.722020907341588*^9, 
   3.7220209075659437`*^9}, {3.722022329966258*^9, 3.722022330508526*^9}, {
   3.7220262171255817`*^9, 3.722026237156159*^9}, {3.72258545242037*^9, 
   3.722585459737831*^9}, {3.743013984506933*^9, 3.743013984666049*^9}, {
   3.743014078197111*^9, 3.743014166887443*^9}, {3.743015132588254*^9, 
   3.743015139702715*^9}, 3.743015317312641*^9, {3.74301659451224*^9, 
   3.743016595547563*^9}, {3.743018613006233*^9, 3.743018614178485*^9}, 
   3.743043724594219*^9},ExpressionUUID->"c5e6dd16-db42-4e5c-a1f7-\
a04c51102ebb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalE]A", "=", 
   RowBox[{
    RowBox[{"S\[Epsilon]", "[", 
     RowBox[{"Ricci", "[", 
      RowBox[{"\[ScriptG]A", ",", "y"}], "]"}], "]"}], "-", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"S\[Epsilon]", "[", 
      RowBox[{"\[ScriptG]A", " ", 
       RowBox[{"RicciScalar", "[", 
        RowBox[{"\[ScriptG]A", ",", "y"}], "]"}]}], "]"}]}], "-", 
    RowBox[{"8", "\[Pi]", " ", "\[Epsilon]", " ", "\[Delta]TA"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.722026244081275*^9, 3.722026252955291*^9}, {
  3.7225854635147552`*^9, 3.7225854707976913`*^9}, {3.7430139863097353`*^9, 
  3.7430139864562902`*^9}, {3.743015142813513*^9, 3.7430151435819063`*^9}, {
  3.7430165969767723`*^9, 3.743016597880558*^9}, {3.7430186172026*^9, 
  3.7430186180578623`*^9}},ExpressionUUID->"44cd571b-7c70-459e-aaa2-\
b708157d0205"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "the", " ", "Files", " ", "so", " ", "I", " ", 
    RowBox[{"don", "'"}], "t", " ", "need", " ", "to", " ", "compute", " ", 
    "them", " ", "every", " ", "time"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<field_equations_GR.m\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\[ScriptCapitalE]A", ",", "\[ScriptCapitalE]P"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.721988117902329*^9, 3.7219881365991488`*^9}, {
   3.7219891202679358`*^9, 3.721989120495283*^9}, 3.722017974686751*^9, {
   3.722018611723925*^9, 3.722018612309613*^9}, {3.722020910774428*^9, 
   3.72202091106896*^9}, {3.722022335204237*^9, 3.7220223357498837`*^9}, 
   3.72202626170255*^9, {3.722152934706562*^9, 3.722152935143446*^9}, {
   3.722153253095849*^9, 3.722153253656872*^9}, {3.722153864782675*^9, 
   3.722153872897066*^9}, {3.7223300544642477`*^9, 3.7223300546137047`*^9}, 
   3.743013988866743*^9, {3.743015372885996*^9, 3.743015373438388*^9}, 
   3.743043725863854*^9},ExpressionUUID->"eb64f440-8946-446d-889a-\
5eb313f18886"],

Cell[BoxData["\<\"field_equations_GR.m\"\>"], "Output",
 CellChangeTimes->{
  3.722153098799933*^9, 3.7223302171117983`*^9, 3.7224213525110598`*^9, 
   3.7224217556273623`*^9, 3.722422042684157*^9, 3.7225855774065104`*^9, {
   3.732091407408292*^9, 3.732091410277142*^9}, 3.732091889654402*^9, 
   3.732093268547572*^9, 3.7320947428326178`*^9, 3.743014459418605*^9, 
   3.7430146302997093`*^9, 3.743014667371482*^9, 3.743015282521696*^9, 
   3.743015457722885*^9, {3.7430155535778627`*^9, 3.7430155560173283`*^9}, 
   3.743016700127049*^9, 
   3.743018736839819*^9},ExpressionUUID->"ecec48f7-def2-49a1-9be2-\
fea6585c73a3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Separate Axial and Polar components", "Subsection",
 CellChangeTimes->{{3.72202013253967*^9, 3.722020136690909*^9}, {
  3.743015207861019*^9, 
  3.743015242501333*^9}},ExpressionUUID->"3c4eafdb-8e57-4d45-abc6-\
c5a273f4c0fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ScriptCapitalE]A", ",", "\[ScriptCapitalE]P"}], "}"}], "=", 
   RowBox[{"Import", "[", "\"\<field_equations_GR.m\>\"", "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"fed6a889-4630-4fa4-9366-b3a6b0bd8587"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "just", " ", "to", " ", "check", " ", "the", " ", 
    "background", " ", 
    RowBox[{"solution", ".", " ", "Of"}], " ", "course", " ", "I", " ", 
    "recover", " ", "Schwarzschild"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"F", "[", "r_", "]"}], "=", 
   RowBox[{
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"DSolve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"\[ScriptCapitalE]A", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
            "0"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"F", "[", "r", "]"}], ",", "r"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ",", "r", ",", 
      "Simplify"}], "]"}], "//.", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", "2"}], "M"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.721031333645987*^9, 3.721031395437334*^9}, {
   3.721031528664692*^9, 3.721031538839711*^9}, 3.7210315915469522`*^9, 
   3.7210323941640987`*^9, {3.7220016593755407`*^9, 3.7220016707166777`*^9}, 
   3.722002779562779*^9, 3.7220201626091843`*^9, {3.743015561420066*^9, 
   3.743015562077631*^9}, {3.743015875661789*^9, 
   3.7430158762977257`*^9}},ExpressionUUID->"79034a09-fee6-4e67-b4f9-\
ccdd079680e9"],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{"2", " ", "M"}], "r"]}]], "Output",
 CellChangeTimes->{{3.721031334886145*^9, 3.721031353349897*^9}, {
   3.72103138568266*^9, 3.721031396021452*^9}, 3.721031539592739*^9, 
   3.7210324116398897`*^9, 3.721032447423128*^9, 3.721032489165966*^9, 
   3.721032972399373*^9, 3.721033145750046*^9, 3.721033331899069*^9, 
   3.721038244980629*^9, 3.721039233656474*^9, 3.7219891761605453`*^9, 
   3.721997338087085*^9, 3.721997449287909*^9, 3.72199762034359*^9, 
   3.722000126283126*^9, 3.722000236930863*^9, 3.722001544001788*^9, 
   3.7220016298086557`*^9, 3.72200167097081*^9, 3.722002786474543*^9, 
   3.7220087232772818`*^9, 3.722010554812793*^9, 3.7220146630720863`*^9, 
   3.722015574063239*^9, 3.722020163769038*^9, 3.7220211441837597`*^9, 
   3.722022582244668*^9, 3.722153105152052*^9, 3.722153221115637*^9, 
   3.7223302542734632`*^9, 3.722365433644133*^9, 3.722374987154982*^9, 
   3.7224153609505253`*^9, 3.722421375956423*^9, 3.7224217749930887`*^9, 
   3.722422059175754*^9, 3.722577423800385*^9, 3.7225856216110783`*^9, 
   3.72311254186059*^9, 3.72311368676577*^9, 3.7231313941385612`*^9, 
   3.7320914203584948`*^9, 3.732091516464843*^9, 3.7320922012873096`*^9, 
   3.732093227098996*^9, 3.7320946049946537`*^9, 3.732094743006051*^9, 
   3.7320966644552402`*^9, 3.743014682062258*^9, 3.7430153006607103`*^9, 
   3.743015564127866*^9, 3.743015762143182*^9, 3.743015876674597*^9, 
   3.7430167003088503`*^9, {3.743017606876594*^9, 3.7430176152042503`*^9}, 
   3.74303038443451*^9, 
   3.743030704514819*^9},ExpressionUUID->"b2d4a6cc-d9aa-4564-a617-\
c7ea238a1e94"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Simplifications rules ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Y", "(", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], TraditionalForm]],
  ExpressionUUID->"5412c9f5-1510-40a9-922c-35ec97b16eef"],
 " "
}], "Subsubsection",
 CellChangeTimes->{{3.720768078594265*^9, 3.72076808545538*^9}, {
  3.720941043359646*^9, 
  3.720941055463934*^9}},ExpressionUUID->"133baa33-de4c-4e2e-9954-\
fbf957f0a50a"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "These", " ", "are", " ", "\"\<a lot\>\"", " ", "of", " ", "spherycal", " ",
    "harmonics", " ", "relations", " ", "which", " ", "deeply", " ", 
   "simplify", " ", "the", " ", 
   RowBox[{"euqations", "."}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7430147519860163`*^9, 
  3.7430147977285557`*^9}},ExpressionUUID->"b74164af-52e4-4c4d-b546-\
406715c9c683"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rulesY", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "l"}], 
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], 
         RowBox[{"Y", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"Cot", "[", "\[Theta]", "]"}], 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"3", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"l", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], " ", 
         RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"Y", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "l", "+", 
           SuperscriptBox["l", "2"]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
            RowBox[{
             SuperscriptBox["Y", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["Y", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["Y", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"4", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"l", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l", "+", 
           SuperscriptBox["l", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"Y", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"7", "+", "l", "+", 
              SuperscriptBox["l", "2"], "-", 
              RowBox[{"11", " ", 
               SuperscriptBox[
                RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["Y", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"2", " ", "l", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "l"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
              RowBox[{"6", " ", 
               RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
               RowBox[{"Csc", "[", "\[Theta]", "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["Y", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
               RowBox[{
                SuperscriptBox["Y", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["Y", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"2", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}]}]}], 
          ")"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "l"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "l"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "4"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rulesY2", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"X", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"W", "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "+", 
             RowBox[{"l", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "l"}], ")"}], " ", 
              RowBox[{"Y", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Y", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"W", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "-", 
          RowBox[{"l", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "l"}], ")"}], " ", 
           RowBox[{"Y", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"3", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"W", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
          RowBox[{"l", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "l"}], ")"}], " ", 
           RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"Y", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "l", "+", 
             SuperscriptBox["l", "2"], "+", 
             SuperscriptBox[
              RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["Y", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["Y", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"4", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"7", "+", 
              RowBox[{"2", " ", "l", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "l"}], ")"}]}], "-", 
              RowBox[{"11", " ", 
               SuperscriptBox[
                RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}]}], ")"}]}], " ", 
           RowBox[{"W", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", "\[Theta]", "]"}], "4"], " ", 
           RowBox[{
            SuperscriptBox["Y", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "4"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", "l", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "l"}], ")"}], " ", 
              RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
              RowBox[{"Y", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6"}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox[
                  RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["Y", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
             RowBox[{"12", " ", 
              SuperscriptBox[
               RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
              RowBox[{
               SuperscriptBox["Y", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
         RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"X", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"l", "+", 
           SuperscriptBox["l", "2"], "+", 
           SuperscriptBox[
            RowBox[{"Cot", "[", "\[Theta]", "]"}], "2"]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "3"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "4"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", "l", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"W", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "+", 
              RowBox[{"l", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "l"}], ")"}], " ", 
               RowBox[{"Y", "[", 
                RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
            RowBox[{
             SuperscriptBox["Y", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Y", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"3", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "l", "+", 
             SuperscriptBox["l", "2"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], " ", 
           RowBox[{"X", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"Csc", "[", "\[Theta]", "]"}], "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"7", " ", 
                 RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
                RowBox[{"Cos", "[", 
                 RowBox[{"3", " ", "\[Theta]"}], "]"}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["Y", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
             RowBox[{"12", " ", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Y", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "3"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Y", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "3"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}], 
         ")"}]}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rulesXW", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"Y", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
           "]"}], ",", "\[Phi]"}], "]"}]}], "-", 
       RowBox[{"2", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Cot", "[", "\[Theta]", "]"}], 
           RowBox[{"Y", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", "\[Phi]"}], 
         "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["X", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"2", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"Y", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
             "]"}], ",", "\[Phi]"}], "]"}]}], "-", 
         RowBox[{"2", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Cot", "[", "\[Theta]", "]"}], 
             RowBox[{"Y", "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", "\[Phi]"}], 
           "]"}]}]}], ",", "\[Theta]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["X", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"2", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"Y", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
             "]"}], ",", "\[Phi]"}], "]"}]}], "-", 
         RowBox[{"2", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Cot", "[", "\[Theta]", "]"}], 
             RowBox[{"Y", "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", "\[Phi]"}], 
           "]"}]}]}], ",", "\[Phi]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["X", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"2", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"D", "[", 
               RowBox[{
                RowBox[{"Y", "[", 
                 RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
                "\[Theta]"}], "]"}], ",", "\[Phi]"}], "]"}]}], "-", 
           RowBox[{"2", 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Cot", "[", "\[Theta]", "]"}], 
               RowBox[{"Y", "[", 
                RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ",", "\[Phi]"}],
              "]"}]}]}], ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], "]"}]}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"W", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"Y", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "2"}], "}"}]}], "]"}], "-", 
       RowBox[{
        RowBox[{"Cot", "[", "\[Theta]", "]"}], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
         "]"}]}], "-", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Y", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Phi]", ",", "2"}], "}"}]}], "]"}]}]}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       SuperscriptBox["W", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"Y", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", "2"}], "}"}]}], "]"}], "-", 
         RowBox[{
          RowBox[{"Cot", "[", "\[Theta]", "]"}], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"Y", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
           "]"}]}], "-", 
         RowBox[{
          FractionBox["1", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"Y", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Phi]", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
        "\[Theta]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["W", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"Y", "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Theta]", ",", "2"}], "}"}]}], "]"}], "-", 
           RowBox[{
            RowBox[{"Cot", "[", "\[Theta]", "]"}], 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"Y", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
             "]"}]}], "-", 
           RowBox[{
            FractionBox["1", 
             SuperscriptBox[
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"Y", "[", 
               RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"\[Phi]", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "\[Theta]"}], "]"}], ",", "\[Phi]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["W", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"Y", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", "2"}], "}"}]}], "]"}], "-", 
         RowBox[{
          RowBox[{"Cot", "[", "\[Theta]", "]"}], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"Y", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", "\[Theta]"}], 
           "]"}]}], "-", 
         RowBox[{
          FractionBox["1", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"Y", "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"\[Phi]", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
        "\[Phi]"}], "]"}]}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.710930640769968*^9, 3.710930641551877*^9}, {
   3.720683307593905*^9, 3.72068331214137*^9}, {3.720683367446307*^9, 
   3.720683385584107*^9}, 3.720683500504015*^9, {3.72103903892422*^9, 
   3.721039041904852*^9}},ExpressionUUID->"98e86cda-99e5-4a97-9a4b-\
67747cb95ebe"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein\[CloseCurlyQuote]s equations in the RW Gauge", "Subsubsection",
 CellChangeTimes->{{3.721031701075015*^9, 3.721031727794045*^9}, {
  3.7220202861536016`*^9, 3.722020291661962*^9}, {3.743014560298936*^9, 
  3.743014561457403*^9}},ExpressionUUID->"5e2f12fa-a10c-421c-8f3e-\
eaec701e14ee"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
    "In", " ", "this", " ", "section", " ", "I", " ", "isolate", " ", "each", 
     " ", "component", " ", "of", " ", "the", " ", "Einstein", " ", 
     RowBox[{"equations", ".", " ", "Note"}], " ", "that", " ", "I", " ", 
     "work", " ", "in", " ", "the", " ", "Regge"}], "-", 
    RowBox[{"Wheeler", " ", "Gauge"}]}], ",", " ", 
   RowBox[{
    RowBox[{"i", ".", "e", ".", " ", 
     SubscriptBox["h", "2"]}], " ", "=", " ", 
    RowBox[{
     SubscriptBox["\[Eta]", "1"], " ", "=", " ", 
     RowBox[{
      SubscriptBox["\[Eta]", "0"], " ", "=", " ", 
      RowBox[{"G", " ", "=", " ", "0."}]}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743014645031012*^9, 3.74301466076968*^9}, {
  3.7430148042415867`*^9, 3.743014879496299*^9}, {3.743014910635715*^9, 
  3.743014942366913*^9}},ExpressionUUID->"512fd927-3831-4e0c-8dc7-\
99a29c3d385d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"h2", "[", "r_", "]"}], "=", "0"}], ";"}]], "Input",
 CellChangeTimes->{{3.7219892741379833`*^9, 
  3.721989280553877*^9}},ExpressionUUID->"5d7ce6b7-eaaf-4293-8da9-\
950047738d6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]13A", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], 
      FractionBox[
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"\[ScriptCapitalE]A", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
         "1"}], "]"}], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
        RowBox[{"Csc", "[", "\[Theta]", "]"}]}]]}], "//.", 
     RowBox[{"Join", "[", 
      RowBox[{"rulesY", ",", "rulesXW"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.7209411338327217`*^9, 3.720941197082169*^9}, 
   3.720941278694029*^9, {3.720952077311315*^9, 3.720952090580276*^9}, {
   3.720952227151361*^9, 3.720952259663125*^9}, {3.720954278919271*^9, 
   3.720954283056592*^9}, 3.7209543435587263`*^9, {3.720954432902367*^9, 
   3.7209544853832693`*^9}, {3.720954515709648*^9, 3.720954526832179*^9}, {
   3.720957089003861*^9, 3.720957090751815*^9}, {3.720957184718466*^9, 
   3.720957201439645*^9}, 3.721031600979541*^9, 3.7210384147612267`*^9, 
   3.721038446840954*^9, {3.7210392377351437`*^9, 3.721039268852147*^9}, 
   3.722020165819397*^9, 3.722020215624201*^9, 3.7220206274104223`*^9, {
   3.722421411063262*^9, 3.722421420833399*^9}, 3.7224217829451303`*^9, 
   3.722585638467189*^9, 3.732091518812028*^9, 
   3.732091787169065*^9},ExpressionUUID->"9225f7c9-e838-4a5e-a0e0-\
b786871f5bef"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "M"}], "+", 
        RowBox[{"l", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}], " ", "r"}]}], ")"}], " ", 
      RowBox[{"h0", "[", "r", "]"}]}], "+", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "\[Omega]", " ", 
         RowBox[{"h1", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          SqrtBox["2"], " ", "\[Pi]", " ", 
          SuperscriptBox["r", "3"], " ", 
          RowBox[{"\[ScriptCapitalQ]0", "[", "r", "]"}]}], 
         SqrtBox[
          RowBox[{"l", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "l"}], ")"}]}]]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
            RowBox[{
             SuperscriptBox["h1", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["h0", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "r", "]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["Y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], 
  SuperscriptBox["r", "3"]]], "Output",
 CellChangeTimes->{{3.720952231338665*^9, 3.720952260230331*^9}, 
   3.720952404484288*^9, {3.720954280548893*^9, 3.7209542835736847`*^9}, {
   3.720954330707439*^9, 3.720954343830556*^9}, 3.720954429527914*^9, {
   3.720954469565823*^9, 3.720954485834437*^9}, {3.720954516330167*^9, 
   3.720954527290922*^9}, 3.720957010334963*^9, {3.720957051887394*^9, 
   3.720957091245882*^9}, {3.720957184972601*^9, 3.720957201884904*^9}, 
   3.720960535473278*^9, 3.720960660406703*^9, 3.7209607684701853`*^9, 
   3.720969766757071*^9, 3.720970399889839*^9, 3.720972432302194*^9, 
   3.720973954541622*^9, 3.720974920251561*^9, {3.721025661414811*^9, 
   3.721025677401293*^9}, {3.721031522571575*^9, 3.7210315430151787`*^9}, 
   3.7210316017163057`*^9, {3.721032428577291*^9, 3.721032448310194*^9}, 
   3.721032491100099*^9, 3.7210329743294287`*^9, 3.72103314848135*^9, 
   3.7210333340069447`*^9, 3.7210367837538843`*^9, 3.7210369040403633`*^9, 
   3.721038274923724*^9, {3.721038377705696*^9, 3.7210384473417807`*^9}, {
   3.721039248719823*^9, 3.7210392693603*^9}, 3.721989307812819*^9, {
   3.721997342368465*^9, 3.721997347919902*^9}, 3.7219974519671297`*^9, {
   3.7219976216304092`*^9, 3.721997634195003*^9}, {3.722000130264374*^9, 
   3.722000136916306*^9}, 3.722000240349493*^9, {3.722001679669779*^9, 
   3.7220016858411627`*^9}, 3.7220027971728277`*^9, 3.7220087255215816`*^9, 
   3.722010555334722*^9, 3.7220146657726173`*^9, 3.722015574565689*^9, 
   3.722020216472561*^9, 3.722020641769665*^9, 3.7220211623362217`*^9, {
   3.7220225893847322`*^9, 3.722022595956182*^9}, 3.722153134617508*^9, 
   3.7221532273137074`*^9, 3.722330263152424*^9, 3.7223654352487783`*^9, 
   3.7223749898488007`*^9, 3.7224157207837963`*^9, {3.722421392287221*^9, 
   3.72242142121949*^9}, 3.722421783584155*^9, 3.72242206240969*^9, 
   3.722577445478156*^9, {3.722585639219095*^9, 3.722585649684613*^9}, 
   3.723112543628804*^9, 3.723113688479656*^9, 3.723131396219108*^9, 
   3.732091420655641*^9, {3.73209152249562*^9, 3.732091526432222*^9}, 
   3.732092201683187*^9, 3.73209322751192*^9, 3.732094605139216*^9, 
   3.732094743400474*^9, 3.732096664964666*^9, 3.743014948553606*^9, 
   3.7430153050421867`*^9, 3.7430155710673*^9, 3.743015767467144*^9, 
   3.7430158829200563`*^9, 3.743016700863531*^9, 3.743017620605915*^9, 
   3.743030390948004*^9, 
   3.743030728259797*^9},ExpressionUUID->"9f70ec5b-4402-4b6e-8e4d-\
eded32bb8d7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]23A", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]A", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
       RowBox[{"Csc", "[", "\[Theta]", "]"}]}]], "//.", 
     RowBox[{"Join", "[", 
      RowBox[{"rulesY", ",", "rulesXW"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"h0", "''"}], "[", "r", "]"}], ",", 
      RowBox[{
       RowBox[{"h0", "'"}], "[", "r", "]"}], ",", 
      RowBox[{"h0", "[", "r", "]"}], ",", 
      RowBox[{
       RowBox[{"h1", "''"}], "[", "r", "]"}], ",", 
      RowBox[{
       RowBox[{"h1", "'"}], "[", "r", "]"}], ",", 
      RowBox[{"h1", "[", "r", "]"}], ",", 
      RowBox[{"h2", "[", "r", "]"}], ",", "\[Omega]"}], "}"}], ",", 
    "Simplify"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.721032477716654*^9, {3.7210384238010387`*^9, 3.721038430593005*^9}, 
   3.721039273145959*^9, 3.722020218764223*^9, 3.722020628898991*^9, 
   3.722421409188965*^9, 3.722585692769328*^9, 3.732091529389586*^9, 
   3.732091789372213*^9},ExpressionUUID->"5b5b58ec-a05d-4473-a617-\
7b4a5dd4c2be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
       RowBox[{"h0", "[", "r", "]"}]}], 
      RowBox[{
       RowBox[{"2", " ", "M"}], "-", "r"}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "2"}], "+", "l", "+", 
          SuperscriptBox["l", "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]]}], "-", 
       FractionBox[
        RowBox[{"r", " ", 
         SuperscriptBox["\[Omega]", "2"]}], 
        RowBox[{
         RowBox[{"4", " ", "M"}], "-", 
         RowBox[{"2", " ", "r"}]}]]}], ")"}], " ", 
     RowBox[{"h1", "[", "r", "]"}]}], "-", 
    FractionBox[
     RowBox[{"4", " ", "\[ImaginaryI]", " ", 
      SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
      RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}]}], 
     SqrtBox[
      RowBox[{"l", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "l"}], ")"}]}]]], "+", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
      RowBox[{
       SuperscriptBox["h0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], 
     RowBox[{
      RowBox[{"4", " ", "M"}], "-", 
      RowBox[{"2", " ", "r"}]}]]}], ")"}], " ", 
  RowBox[{
   SuperscriptBox["Y", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.721031608881798*^9, {3.721032428705532*^9, 3.721032448366068*^9}, 
   3.721032494035592*^9, 3.7210329744327593`*^9, 3.721033149435419*^9, 
   3.721033334791809*^9, 3.7210367856864243`*^9, 3.72103690718568*^9, 
   3.7210383818107777`*^9, {3.7210384245902348`*^9, 3.721038449055698*^9}, 
   3.7210392737369843`*^9, 3.7219893179820232`*^9, 3.721997455420787*^9, {
   3.721997623075601*^9, 3.721997634960235*^9}, 3.7220001384133873`*^9, 
   3.722000241816654*^9, 3.722001687851869*^9, 3.722002801386389*^9, 
   3.722008726350363*^9, 3.722010555465439*^9, 3.7220146672254677`*^9, 
   3.7220155748213167`*^9, 3.7220202191885567`*^9, 3.722020642484681*^9, 
   3.7220211633012247`*^9, 3.7220225965876493`*^9, 3.7221531355270987`*^9, 
   3.722153227384192*^9, 3.722330264021549*^9, 3.72236543530727*^9, 
   3.722374989940136*^9, 3.722415720843891*^9, {3.722421392374655*^9, 
   3.722421413964773*^9}, 3.7224217856189337`*^9, 3.722422062869412*^9, 
   3.722577445552527*^9, {3.722585688434744*^9, 3.722585693340869*^9}, 
   3.723112543663756*^9, 3.723113688539497*^9, 3.723131396266591*^9, 
   3.732091420713529*^9, 3.732091529691285*^9, 3.732092201722*^9, 
   3.732093227581128*^9, 3.732094605262556*^9, 3.732094743446361*^9, 
   3.7320966650362043`*^9, 3.743014953190233*^9, 3.743015329971671*^9, 
   3.743015572102014*^9, 3.7430157675338287`*^9, 3.7430158829743156`*^9, 
   3.743016700911805*^9, 3.7430176206636763`*^9, 3.74303039259343*^9, 
   3.743030729189406*^9},ExpressionUUID->"744d8e03-58a0-44a0-8391-\
8200e171996d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]33A", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]A", "[", 
         RowBox[{"[", 
          RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{
  3.721032478967218*^9, {3.721039277266432*^9, 3.72103930768966*^9}, 
   3.7220202208203287`*^9, 3.722020631290381*^9, {3.722421790874009*^9, 
   3.722421792562026*^9}, 3.722585695584799*^9, 3.732091531681271*^9, 
   3.7320917913308277`*^9},ExpressionUUID->"8953c7a4-4e4f-431c-93e9-\
a7564ebf333e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
  RowBox[{"X", "[", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
      RowBox[{"h0", "[", "r", "]"}]}], 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}]], "-", 
    FractionBox[
     RowBox[{"2", " ", "M", " ", 
      RowBox[{"h1", "[", "r", "]"}]}], 
     SuperscriptBox["r", "2"]], "-", 
    FractionBox[
     RowBox[{"8", " ", "\[ImaginaryI]", " ", 
      SqrtBox["2"], " ", "\[Pi]", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], 
     SqrtBox[
      RowBox[{"l", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", "l", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["l", "2"]}], "+", 
         SuperscriptBox["l", "3"]}], ")"}]}]]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["h1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "r"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.72103164231425*^9, {3.721032428756638*^9, 3.721032448431334*^9}, 
   3.721032495308715*^9, 3.721032974555244*^9, 3.721033150086762*^9, 
   3.72103333580833*^9, 3.721036788198133*^9, 3.721036913116984*^9, {
   3.721038388253286*^9, 3.7210383968462763`*^9}, 3.7210384512834587`*^9, {
   3.7210392782836657`*^9, 3.7210393084191723`*^9}, 3.7219893204132757`*^9, 
   3.721997457314432*^9, {3.721997624751656*^9, 3.721997637492881*^9}, 
   3.722000139561722*^9, 3.7220002433863297`*^9, 3.722001690126669*^9, 
   3.722002802168441*^9, 3.722008727409624*^9, 3.7220105558871393`*^9, 
   3.722014669400344*^9, 3.722015575239874*^9, 3.7220202218397903`*^9, {
   3.722020639542371*^9, 3.722020643220792*^9}, 3.722021164363418*^9, 
   3.72202259748622*^9, 3.7221531367334127`*^9, 3.722153227765473*^9, 
   3.722330265243454*^9, 3.722365435786758*^9, 3.722374990467619*^9, 
   3.7224157212233057`*^9, 3.722421392922206*^9, {3.722421788909071*^9, 
   3.72242179310885*^9}, 3.722422064839881*^9, 3.722577445936439*^9, {
   3.72258568978605*^9, 3.722585696157303*^9}, 3.723112544041497*^9, 
   3.723113689004154*^9, 3.723131396614615*^9, 3.7320914212962*^9, 
   3.732091532324341*^9, 3.732092202079886*^9, 3.732093227952482*^9, 
   3.7320946059486837`*^9, 3.732094743804988*^9, 3.732096665465432*^9, 
   3.743014955369506*^9, 3.743015574688003*^9, 3.743015767620469*^9, 
   3.743015883061276*^9, 3.743016701243752*^9, 3.743017621022477*^9, 
   3.743030393498331*^9, 
   3.743030730778104*^9},ExpressionUUID->"69871cdb-0760-4937-bc68-\
e974b62f8fba"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Eta]0", "[", "r_", "]"}], "=", 
   RowBox[{
    RowBox[{"\[Eta]1", "[", "r_", "]"}], "=", 
    RowBox[{
     RowBox[{"G", "[", "r_", "]"}], "=", "0"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.722020301329399*^9, 
  3.722020317855278*^9}},ExpressionUUID->"63d0ae0f-e0cc-4798-a6c1-\
a87f80be97c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]11P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]P", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.722020361002743*^9, 3.722020394653583*^9}, 
   3.7220206450633698`*^9, 3.7224217952220287`*^9, {3.722585705293881*^9, 
   3.722585706342712*^9}, 3.732091533839945*^9, 
   3.73209179360883*^9},ExpressionUUID->"78267c2c-ec20-4be5-b10c-\
5d90b25c07dd"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["r", "3"]}]], 
   RowBox[{
    RowBox[{"Y", "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "l", "+", 
         SuperscriptBox["l", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"H2", "[", "r", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "l", "+", 
         SuperscriptBox["l", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"K", "[", "r", "]"}]}], "+", 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"\[ScriptCapitalA]0", "[", "r", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H2", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "M"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["K", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{
           SuperscriptBox["K", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{{3.722020362336957*^9, 3.722020395246438*^9}, 
   3.722020645534733*^9, 3.7220211667004633`*^9, 3.72202259951768*^9, 
   3.72215313895046*^9, 3.722153227916971*^9, 3.722330267363372*^9, 
   3.722365435965208*^9, 3.7223749906806583`*^9, 3.7224157213644123`*^9, 
   3.722421393227673*^9, {3.722421798228772*^9, 3.72242180365582*^9}, 
   3.722422066753724*^9, 3.722577446118257*^9, {3.72258570248061*^9, 
   3.722585706805801*^9}, 3.72311254419698*^9, 3.723113689272133*^9, 
   3.7231313967557697`*^9, 3.732091421573124*^9, {3.732091534515976*^9, 
   3.732091536979711*^9}, 3.7320922022067623`*^9, 3.732093228201323*^9, 
   3.732094606699663*^9, 3.732094743931316*^9, 3.732096665740464*^9, 
   3.74301495875603*^9, 3.743015579339786*^9, 3.743015767707749*^9, 
   3.743015883157659*^9, 3.743016701380761*^9, 3.743017621158231*^9, 
   3.7430303952839108`*^9, 
   3.7430307319108753`*^9},ExpressionUUID->"6f580163-9b39-493d-b221-\
8632acfe86b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]12P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]P", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.722020398543481*^9, 3.722020476801038*^9}, 
   3.72202064769702*^9, 3.7224220705399113`*^9, {3.7225857103875647`*^9, 
   3.722585713530149*^9}, 3.7320915390111513`*^9, 
   3.7320917968204823`*^9},ExpressionUUID->"85916127-36c9-4ac9-97a0-\
e949b24ea540"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Y", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "l"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "\[Omega]", " ", 
         RowBox[{"H2", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "M"}], "+", "r"}], ")"}], " ", 
         "\[Omega]", " ", 
         RowBox[{"K", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SqrtBox["2"], " ", "\[Pi]", " ", 
            RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "-", 
           RowBox[{"\[Omega]", " ", 
            RowBox[{
             SuperscriptBox["K", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["r", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.722020399749403*^9, 3.72202047865418*^9}, 
   3.7220206480838423`*^9, 3.722021175127411*^9, 3.722022600237035*^9, 
   3.7221531405173397`*^9, 3.722153228165949*^9, 3.72233026895432*^9, 
   3.722365436335039*^9, 3.722374990908901*^9, 3.7224157215478687`*^9, 
   3.722421393474999*^9, 3.722422071496413*^9, 3.722577446280303*^9, {
   3.722585707935927*^9, 3.722585713896999*^9}, 3.723112544287677*^9, 
   3.723113689433827*^9, 3.723131396933975*^9, 3.7320914217003727`*^9, 
   3.732091539365937*^9, 3.732092202308153*^9, 3.732093228308782*^9, 
   3.7320946067651978`*^9, 3.732094744107808*^9, 3.7320966658736277`*^9, 
   3.743014959540132*^9, 3.7430155817736483`*^9, 3.743015767789472*^9, 
   3.743015883227462*^9, 3.743016701476266*^9, 3.743017621291046*^9, 
   3.743030395879758*^9, 
   3.7430307332534943`*^9},ExpressionUUID->"94a65827-9b0c-401a-ad29-\
c353d30c50c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]22P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]P", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.722020487009974*^9, 3.722020497747573*^9}, 
   3.722020651290503*^9, 3.72242207580907*^9, 3.722585716833741*^9, 
   3.732091541188293*^9, 
   3.7320917994321203`*^9},ExpressionUUID->"6d2db3ba-5c96-4af3-9895-\
474e3e3f6c1a"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", "r", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"]}]], 
   RowBox[{
    RowBox[{"Y", "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"l", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "l"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"H0", "[", "r", "]"}]}], "-", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
       "\[Omega]", " ", 
       RowBox[{"H1", "[", "r", "]"}]}], "-", 
      RowBox[{"4", " ", "M", " ", 
       RowBox[{"H2", "[", "r", "]"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"H2", "[", "r", "]"}]}], "+", 
      RowBox[{"4", " ", "M", " ", 
       RowBox[{"K", "[", "r", "]"}]}], "-", 
      RowBox[{"2", " ", "l", " ", "M", " ", 
       RowBox[{"K", "[", "r", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["l", "2"], " ", "M", " ", 
       RowBox[{"K", "[", "r", "]"}]}], "-", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"K", "[", "r", "]"}]}], "+", 
      RowBox[{"l", " ", "r", " ", 
       RowBox[{"K", "[", "r", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["l", "2"], " ", "r", " ", 
       RowBox[{"K", "[", "r", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"], " ", 
       RowBox[{"K", "[", "r", "]"}]}], "+", 
      RowBox[{"64", " ", 
       SuperscriptBox["M", "2"], " ", "\[Pi]", " ", "r", " ", 
       RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], "-", 
      RowBox[{"64", " ", "M", " ", "\[Pi]", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], "+", 
      RowBox[{"16", " ", "\[Pi]", " ", 
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["M", "2"], " ", 
       RowBox[{
        SuperscriptBox["H0", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], "-", 
      RowBox[{"8", " ", "M", " ", "r", " ", 
       RowBox[{
        SuperscriptBox["H0", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{
        SuperscriptBox["H0", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["M", "2"], " ", 
       RowBox[{
        SuperscriptBox["K", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], "+", 
      RowBox[{"6", " ", "M", " ", "r", " ", 
       RowBox[{
        SuperscriptBox["K", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{
        SuperscriptBox["K", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}]}]], "Output",\

 CellChangeTimes->{{3.722020490729792*^9, 3.722020498747682*^9}, 
   3.7220206516941967`*^9, 3.722021178415063*^9, 3.722022601888764*^9, 
   3.722153141106331*^9, 3.722153228512536*^9, 3.72233026977314*^9, 
   3.722365436527649*^9, 3.722374990996786*^9, 3.722415721675942*^9, 
   3.722421393607254*^9, 3.722422076203829*^9, 3.722577446430537*^9, 
   3.722585717296801*^9, 3.7231125443710537`*^9, 3.723113689531739*^9, 
   3.723131397131646*^9, 3.732091421870241*^9, 3.732091541526655*^9, 
   3.732092202531088*^9, 3.732093228418992*^9, 3.7320946072314863`*^9, 
   3.732094744199234*^9, 3.7320966659892406`*^9, 3.7430149609940767`*^9, 
   3.7430155828919764`*^9, 3.743015767874652*^9, 3.743015883305065*^9, 
   3.743016701564775*^9, 3.74301762137187*^9, 3.743030396601838*^9, 
   3.7430307345686827`*^9},ExpressionUUID->"71d882e6-58f4-4e66-a371-\
4b9b709e2323"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]13P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]P", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.7220205258922462`*^9, 3.722020563734969*^9}, {
   3.722020595606895*^9, 3.7220205992125463`*^9}, 3.722020653687887*^9, 
   3.722422079854995*^9, 3.722585719885688*^9, 3.7320915431649723`*^9, 
   3.732091801753717*^9},ExpressionUUID->"7a877874-da37-4250-bd5a-\
f9382abece52"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "M", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], 
     SuperscriptBox["r", "2"]], "+", 
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
     RowBox[{"H2", "[", "r", "]"}]}], "+", 
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
     RowBox[{"K", "[", "r", "]"}]}], "-", 
    FractionBox[
     RowBox[{"8", " ", "\[ImaginaryI]", " ", 
      SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
      RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], 
     SqrtBox[
      RowBox[{"l", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "l"}], ")"}]}]]], "+", 
    RowBox[{
     SuperscriptBox["H1", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}], "-", 
    FractionBox[
     RowBox[{"2", " ", "M", " ", 
      RowBox[{
       SuperscriptBox["H1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "r"]}], ")"}], " ", 
  RowBox[{
   SuperscriptBox["Y", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.7220205274753103`*^9, 3.722020564119276*^9}, 
   3.722020599710753*^9, 3.722020654418816*^9, 3.722021180892687*^9, 
   3.722022602719987*^9, 3.72215314200222*^9, 3.7221532286364803`*^9, 
   3.722330271452381*^9, 3.72236543672995*^9, 3.722374991122785*^9, 
   3.722415721794368*^9, 3.722421393799999*^9, 3.722422080225597*^9, 
   3.7225774465560493`*^9, 3.722585720464307*^9, 3.723112544603656*^9, 
   3.723113689719536*^9, 3.7231313973477497`*^9, 3.732091422040975*^9, 
   3.732091543572837*^9, 3.732092202729055*^9, 3.73209322859949*^9, 
   3.732094607316827*^9, 3.732094744385974*^9, 3.732096666217005*^9, 
   3.7430149616784477`*^9, 3.7430155838790703`*^9, 3.7430157679554663`*^9, 
   3.743015883359918*^9, 3.743016701871793*^9, 3.743017621698745*^9, 
   3.743030398230905*^9, 
   3.74303073537864*^9},ExpressionUUID->"4fa42de4-9809-4fc3-bd65-\
6dafb5fc6096"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]23P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]P", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "3"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{
  3.722020622167346*^9, {3.7220206570469513`*^9, 3.722020677168914*^9}, 
   3.7224220824539137`*^9, 3.722585722467966*^9, 3.732091545354087*^9, 
   3.732091803339551*^9},ExpressionUUID->"0f8bc419-5d7f-4de2-8323-\
9235a34fb962"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r"}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "M"}], "+", "r"}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
      SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", "M", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"16", " ", 
      SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], "+", 
     RowBox[{"8", " ", 
      SqrtBox["2"], " ", "\[Pi]", " ", 
      SuperscriptBox["r", "3"], " ", 
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", "M", " ", "r", " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", "M", " ", "r", " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{
      SqrtBox[
       RowBox[{"l", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["Y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.722020657455312*^9, 3.722020677555767*^9}, 
   3.7220211879361963`*^9, 3.722022604732345*^9, 3.7221531439399033`*^9, 
   3.722153228775926*^9, 3.7223302731495857`*^9, 3.7223654369482527`*^9, 
   3.722374991250596*^9, 3.7224157219211693`*^9, 3.722421393970948*^9, 
   3.722422083017968*^9, 3.722577446839295*^9, 3.722585722962776*^9, 
   3.723112544694463*^9, 3.7231136898261433`*^9, 3.723131397462854*^9, 
   3.732091422172627*^9, 3.732091545913125*^9, 3.732092202834879*^9, 
   3.7320932286973124`*^9, 3.7320946074206142`*^9, 3.732094744484867*^9, 
   3.732096666327981*^9, 3.7430149624924517`*^9, 3.743015585929454*^9, 
   3.74301576802663*^9, 3.743015883477729*^9, 3.743016701972097*^9, 
   3.743017621794717*^9, 3.743030399464507*^9, 
   3.743030736787569*^9},ExpressionUUID->"fcc459b9-4efc-4cfc-9a8f-\
7414a5d41cce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]34P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]P", "[", 
         RowBox[{"[", 
          RowBox[{"3", ",", "4"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
        "1"}], "]"}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.7220212362727222`*^9, 3.72202128823737*^9}, 
   3.722021329855991*^9, {3.722021417180347*^9, 3.722021441508898*^9}, {
   3.7220214850579033`*^9, 3.722021508335855*^9}, 3.722422085474965*^9, 
   3.722585740236422*^9, 3.732091547645689*^9, 
   3.732091805866453*^9},ExpressionUUID->"99190072-154c-4b59-8236-\
9ef74d137ad1"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"X", "[", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"H0", "[", "r", "]"}], "-", 
    RowBox[{"H2", "[", "r", "]"}], "-", 
    FractionBox[
     RowBox[{"16", " ", 
      SqrtBox["2"], " ", "\[Pi]", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
     SqrtBox[
      RowBox[{"l", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", "l", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["l", "2"]}], "+", 
         SuperscriptBox["l", "3"]}], ")"}]}]]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.722021237109706*^9, 3.7220212888205853`*^9}, 
   3.722021330259511*^9, {3.7220214194471407`*^9, 3.722021442268762*^9}, {
   3.72202148547383*^9, 3.722021508795533*^9}, 3.722022606534012*^9, 
   3.7221531450962477`*^9, 3.7221532288839197`*^9, 3.722330274927314*^9, 
   3.7223654371167727`*^9, 3.7223749913624907`*^9, 3.722415722024322*^9, 
   3.722421394217823*^9, 3.722422085964224*^9, 3.722577446951337*^9, {
   3.722585736040432*^9, 3.722585740815218*^9}, 3.723112544792862*^9, 
   3.723113689944721*^9, 3.723131397632032*^9, 3.732091422234977*^9, 
   3.73209154797073*^9, 3.732092202959605*^9, 3.732093228818046*^9, 
   3.7320946074769363`*^9, 3.7320947445984573`*^9, 3.732096666499525*^9, 
   3.743014963913331*^9, 3.7430155867720118`*^9, 3.743015768104414*^9, 
   3.743015883610091*^9, 3.743016702084601*^9, 3.743017621906596*^9, 
   3.743030401755164*^9, 
   3.7430307381022177`*^9},ExpressionUUID->"5f0b2fb6-29a6-4e99-952b-\
f0417c6b65b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalE]3344P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{
          RowBox[{"\[ScriptCapitalE]P", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "4"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
          "1"}], "]"}], "/", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"\[ScriptCapitalE]P", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "3"}], "]"}], "]"}], ",", "\[Epsilon]", ",", 
         "1"}], "]"}]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]]], "//.", 
     "rulesY2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Y", "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{
       SuperscriptBox["Y", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "}"}], ",", "Simplify"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.7220214655388727`*^9, 3.7220214663179092`*^9}, {
   3.722021585279026*^9, 3.7220216681228313`*^9}, {3.722021915464477*^9, 
   3.722021932016892*^9}, {3.722021968318565*^9, 3.722021996657634*^9}, {
   3.722022057977998*^9, 3.722022058144096*^9}, {3.722022612867284*^9, 
   3.722022638118182*^9}, 3.7224220891850147`*^9, 3.72258574370393*^9, 
   3.732091551362604*^9, 
   3.7430158008270493`*^9},ExpressionUUID->"1ee55b8c-5976-436f-b862-\
0cfb4ecb4ddd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"4", " ", "M"}], "-", 
    RowBox[{"2", " ", "r"}]}]], 
  RowBox[{
   RowBox[{"Y", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"M", "-", "r"}], ")"}], " ", "r", " ", "\[Omega]", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "l", " ", "M", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["l", "2"], " ", "M", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{"l", " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["l", "2"], " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "3"], " ", 
      SuperscriptBox["\[Omega]", "2"], " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "3"], " ", 
      SuperscriptBox["\[Omega]", "2"], " ", 
      RowBox[{"K", "[", "r", "]"}]}], "-", 
     RowBox[{"32", " ", 
      SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"\[ScriptCapitalG]", "[", "r", "]"}]}], "+", 
     RowBox[{"16", " ", 
      SqrtBox["2"], " ", "\[Pi]", " ", 
      SuperscriptBox["r", "3"], " ", 
      RowBox[{"\[ScriptCapitalG]", "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["M", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "M", " ", "r", " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"8", " ", "\[ImaginaryI]", " ", "M", " ", 
      SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
      RowBox[{
       SuperscriptBox["H1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
      RowBox[{
       SuperscriptBox["H1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["M", "2"], " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"6", " ", "M", " ", "r", " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["M", "2"], " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"12", " ", "M", " ", "r", " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["M", "2"], " ", "r", " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"8", " ", "M", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "3"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["M", "2"], " ", "r", " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"8", " ", "M", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "3"], " ", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.7220214666638317`*^9, {3.722021583254518*^9, 3.7220216706177797`*^9}, {
   3.722021924169298*^9, 3.722021932564557*^9}, {3.722021968805819*^9, 
   3.7220219972832813`*^9}, {3.722022608131514*^9, 3.7220226393619957`*^9}, 
   3.722153146684287*^9, 3.722153228985415*^9, 3.7223302759022408`*^9, 
   3.7223654372879753`*^9, 3.72237499145569*^9, 3.722415722115967*^9, 
   3.722421394326993*^9, 3.722422089576623*^9, 3.7225774470660152`*^9, 
   3.722585744661119*^9, 3.7231125449088583`*^9, 3.723113690064983*^9, 
   3.7231313977925053`*^9, 3.732091422383758*^9, 3.7320915517538643`*^9, 
   3.73209220310034*^9, 3.732093229018937*^9, 3.732094607768642*^9, 
   3.732094744733383*^9, 3.73209666684441*^9, 3.743014964767212*^9, 
   3.743015588063097*^9, 3.743015768211829*^9, 3.74301580144938*^9, 
   3.7430158837055473`*^9, 3.743016702198138*^9, 3.743017622018964*^9, 
   3.7430304027277517`*^9, 
   3.743030738841392*^9},ExpressionUUID->"06f3bc0b-94b4-46ce-a902-\
6e9e2efe32ba"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Axial perturbations \[ScriptL] \[GreaterEqual] 2", "Subsection",
 CellChangeTimes->{{3.721031280804646*^9, 3.721031285882763*^9}, {
   3.721989394454862*^9, 3.721989397997904*^9}, 3.722085352330246*^9, {
   3.722415925025346*^9, 3.722415926734522*^9}, {3.726222315292835*^9, 
   3.726222315433023*^9}},ExpressionUUID->"e30245dd-966b-4303-9a1e-\
bd2eaa7e3d3d"],

Cell[TextData[{
 StyleBox["3 master equations for 2 variables ",
  FontSize->18,
  FontColor->GrayLevel[0]],
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "0"], TraditionalForm]],
  FontSize->18,
  FontColor->GrayLevel[0],ExpressionUUID->
  "706457b4-2d1b-4201-8834-f951d38004d6"],
 StyleBox[", ",
  FontSize->18,
  FontColor->GrayLevel[0]],
 Cell[BoxData[
  FormBox[
   SubscriptBox["h", "1"], TraditionalForm]],
  FontSize->18,
  FontColor->GrayLevel[0],ExpressionUUID->
  "2ed99f55-1948-4b32-a478-78cbb8e43586"]
}], "Item",
 CellChangeTimes->{{3.722074969634474*^9, 3.722075015169786*^9}, {
  3.722079818361176*^9, 3.7220798211364117`*^9}, {3.722085378243424*^9, 
  3.722085398914728*^9}, {3.743016756671039*^9, 
  3.743016760138863*^9}},ExpressionUUID->"1f76fd98-90cc-4075-932a-\
2780fffa9ac2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1A", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"F", "[", "r", "]"}], 
           RowBox[{"-", "1"}]]}], "\[ScriptCapitalE]13A"}], ",", 
        RowBox[{
         SuperscriptBox["Y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"h0", "''"}], "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"h1", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"h1", "[", "r", "]"}], ",", 
        RowBox[{"\[ScriptCapitalQ]0", "[", "r", "]"}]}], "}"}], ",", 
      "FullSimplify"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7209572198464403`*^9, 3.720957241151536*^9}, 
   3.7209697906638317`*^9, {3.721031835620748*^9, 3.721031859500978*^9}, {
   3.7210319390303*^9, 3.72103193976722*^9}, {3.7210385136274242`*^9, 
   3.721038519123773*^9}, 3.721039362603073*^9, {3.7219894553921213`*^9, 
   3.721989457813479*^9}, {3.721989725791731*^9, 3.721989742568439*^9}, 
   3.721992253975541*^9, {3.722001212867393*^9, 3.722001215995906*^9}, {
   3.7220013002080708`*^9, 3.7220013027017317`*^9}, {3.722002318846178*^9, 
   3.7220023493836393`*^9}, {3.7220028227172832`*^9, 3.722002831586835*^9}, {
   3.722008733542445*^9, 3.722008736505877*^9}, 3.7220226510001917`*^9, {
   3.722022795844339*^9, 3.7220227977379293`*^9}, {3.7220255948639183`*^9, 
   3.722025596197205*^9}, 3.7430176303459806`*^9, 
   3.743040216620569*^9},ExpressionUUID->"536678a3-4f01-45a4-a6a9-\
7d656ce5148b"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "M"}], "+", 
      RowBox[{"l", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "l"}], ")"}], " ", "r"}]}], ")"}], " ", 
    RowBox[{"h0", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    SuperscriptBox["r", "2"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
    RowBox[{"h1", "[", "r", "]"}]}], "r"], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalQ]0", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}]}]], "+", 
  RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{
    SuperscriptBox["h1", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["h0", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{{3.7209572213334713`*^9, 3.720957241690765*^9}, 
   3.720960539807233*^9, 3.720960663322096*^9, 3.720960771236758*^9, {
   3.7209697688537683`*^9, 3.720969798426468*^9}, 3.720970403153442*^9, 
   3.7209724359838667`*^9, 3.720973956336804*^9, 3.720974922209474*^9, {
   3.7210256636443853`*^9, 3.721025678751824*^9}, {3.72103183858356*^9, 
   3.721031860519939*^9}, 3.721031940677422*^9, 3.7210324568409452`*^9, 
   3.7210325000177813`*^9, 3.7210329844674788`*^9, 3.721033188886134*^9, 
   3.721033363714795*^9, 3.721036798939597*^9, 3.721036922256166*^9, 
   3.721038529775407*^9, {3.7210393547266483`*^9, 3.721039363549987*^9}, 
   3.721989458258581*^9, {3.721989739527182*^9, 3.7219897429897738`*^9}, 
   3.721992254871928*^9, 3.7219974620132647`*^9, 3.721997639524913*^9, 
   3.7220001451041937`*^9, 3.722000246162141*^9, 3.722001216792983*^9, {
   3.722001300551968*^9, 3.722001303170933*^9}, 3.722001694538453*^9, {
   3.72200232063396*^9, 3.7220023499032707`*^9}, {3.7220028045149603`*^9, 
   3.7220028320748873`*^9}, {3.7220087300806828`*^9, 3.722008737024251*^9}, 
   3.722010557673863*^9, 3.7220146721649027`*^9, 3.722015575438176*^9, 
   3.722022651722149*^9, 3.722022798249728*^9, 3.722025600995255*^9, 
   3.722085671852701*^9, 3.7221531617860622`*^9, 3.722153232210395*^9, 
   3.722330281701877*^9, 3.7224223956453342`*^9, 3.722585767927924*^9, 
   3.723112546086677*^9, 3.7231314000079203`*^9, 3.7320914279139013`*^9, 
   3.732091572170627*^9, 3.73209220646661*^9, 3.732094607825947*^9, 
   3.732094744896883*^9, 3.743014969136244*^9, 3.7430156154409313`*^9, 
   3.7430167229835377`*^9, 3.743017637821971*^9, 
   3.7430304191890574`*^9},ExpressionUUID->"d7baddd6-3ba0-46fd-8899-\
dc6c5823481e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2A", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{"F", "[", "r", "]"}], " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"-", "\[ScriptCapitalE]23A"}], ",", 
         RowBox[{
          SuperscriptBox["Y", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"h0", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"h0", "[", "r", "]"}], ",", 
        RowBox[{"h1", "[", "r", "]"}], ",", 
        RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}]}], "}"}], ",", 
      "FullSimplify"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.72097511752831*^9, 3.7209751179829597`*^9}, {
   3.720975381257341*^9, 3.720975410840557*^9}, {3.720975469768808*^9, 
   3.720975471232862*^9}, {3.721031948168194*^9, 3.721031948518036*^9}, {
   3.721038538740823*^9, 3.7210385411854353`*^9}, 3.721039366954891*^9, {
   3.721989512880574*^9, 3.721989513648736*^9}, 3.721989553711729*^9, {
   3.721989996078114*^9, 3.721990007086938*^9}, 3.721990097592392*^9, {
   3.7219922595531054`*^9, 3.721992268653637*^9}, {3.7220023969892*^9, 
   3.722002402558775*^9}, 3.7220024470348177`*^9, {3.722002858031986*^9, 
   3.7220028595037518`*^9}, 3.7220087450909224`*^9, 3.722022654709364*^9, {
   3.722022791479435*^9, 3.722022792469059*^9}, 3.722025597850912*^9, 
   3.743017633669346*^9, 
   3.743040220154963*^9},ExpressionUUID->"2b85b2d6-f5cb-4055-a4df-\
ee74612f66c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
     RowBox[{"h0", "[", "r", "]"}]}], "r"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "l", "+", 
          SuperscriptBox["l", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "M"}], "-", "r"}], ")"}]}], 
       SuperscriptBox["r", "3"]]}], "-", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
   RowBox[{"h1", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{"l", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "l"}], ")"}]}]]], "+", 
  RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{
    SuperscriptBox["h0", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.720975118448969*^9, {3.720975388888218*^9, 3.72097541162932*^9}, 
   3.720975471808846*^9, 3.721025685381274*^9, {3.721031883287465*^9, 
   3.7210318874462347`*^9}, {3.7210319421064*^9, 3.721031951175235*^9}, 
   3.7210324572064877`*^9, 3.721032500724812*^9, 3.721032986533894*^9, 
   3.721033191640585*^9, 3.721036800621499*^9, 3.721038560065695*^9, {
   3.72103935860797*^9, 3.721039367639203*^9}, 3.721989554342424*^9, {
   3.721990003031968*^9, 3.721990011181859*^9}, 3.7219900980347843`*^9, 
   3.721992269070332*^9, 3.721997465461986*^9, 3.721997640313079*^9, 
   3.722000146093348*^9, 3.722000247003071*^9, 3.722001696766287*^9, {
   3.7220023742210207`*^9, 3.722002402962076*^9}, 3.72200244756791*^9, {
   3.722002849427187*^9, 3.722002860055793*^9}, {3.7220087423572474`*^9, 
   3.722008745864208*^9}, 3.72201055879469*^9, 3.7220146731987467`*^9, 
   3.7220155756793203`*^9, 3.722022655313046*^9, 3.7220227929972057`*^9, 
   3.722025601714161*^9, 3.722085672933516*^9, 3.722153162644945*^9, 
   3.7221532336908216`*^9, 3.722330281949016*^9, 3.7224223970949802`*^9, 
   3.722585769067665*^9, 3.7231125463088007`*^9, 3.723131400635768*^9, 
   3.7320914283771563`*^9, 3.732091572336584*^9, 3.73209220674081*^9, 
   3.732094607882866*^9, 3.732094745045566*^9, 3.74301497290401*^9, 
   3.743015616345374*^9, 3.743016724488123*^9, 3.743017638524178*^9, 
   3.743030420051339*^9},ExpressionUUID->"36f4096c-e14e-486b-bba2-\
9e495b143285"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq3A", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], 
         FractionBox["\[ScriptCapitalE]33A", 
          RowBox[{"Csc", "[", "\[Theta]", "]"}]]}], ",", 
        RowBox[{"X", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"h0", "[", "r", "]"}], ",", 
        RowBox[{"h1", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"h1", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], "}"}], ",", 
      "Simplify"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.720974492174436*^9, 3.720974524066215*^9}, {
   3.720975445320565*^9, 3.720975446304778*^9}, {3.7210319693210897`*^9, 
   3.721031972736065*^9}, {3.721033175138749*^9, 3.721033175306182*^9}, 
   3.721038583933367*^9, 3.7219896599456787`*^9, {3.722002541488933*^9, 
   3.722002571650024*^9}, 3.7220028942827873`*^9, {3.7220087489921103`*^9, 
   3.722008749819206*^9}, 3.722022656898911*^9, {3.7220227868558693`*^9, 
   3.722022788374442*^9}, 3.7220255991549397`*^9, 3.7430176361727877`*^9, 
   3.743040223844535*^9},ExpressionUUID->"5dbd577f-8420-46bb-a778-\
99552453f465"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
     RowBox[{"h0", "[", "r", "]"}]}], 
    RowBox[{
     RowBox[{"2", " ", "M"}], "-", "r"}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"h1", "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{"l", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "-", "l", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["l", "2"]}], "+", 
       SuperscriptBox["l", "3"]}], ")"}]}]]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"2", " ", "M"}], "r"]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["h1", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.720974492790002*^9, 3.720974524510017*^9}, {
   3.7209754427620897`*^9, 3.720975446878598*^9}, 3.721025687900836*^9, 
   3.721031889813501*^9, 3.721031974426243*^9, 3.721032457259903*^9, 
   3.721032501391924*^9, 3.721032987815995*^9, 3.721033197394808*^9, 
   3.7210368043409367`*^9, 3.721038585261331*^9, 3.721039381882001*^9, 
   3.721989660583395*^9, 3.7219922748723783`*^9, 3.7219974675193787`*^9, 
   3.721997640979597*^9, 3.7220001470435753`*^9, 3.722000247835698*^9, 
   3.72200169986448*^9, {3.7220025241477547`*^9, 3.722002572183942*^9}, {
   3.7220028821128263`*^9, 3.722002894755801*^9}, {3.722008747579376*^9, 
   3.722008750216032*^9}, 3.72201056046632*^9, 3.722014674768817*^9, 
   3.722015575838131*^9, 3.722022657332754*^9, 3.7220227888306923`*^9, 
   3.722025602385726*^9, 3.722085673773973*^9, 3.722153163247884*^9, 
   3.7221532342985907`*^9, 3.722330282032073*^9, 3.7224224056788692`*^9, 
   3.722585769891571*^9, 3.723112546371393*^9, 3.7231314012199497`*^9, 
   3.732091428466798*^9, 3.732091572405135*^9, 3.7320922068236637`*^9, 
   3.732094607998806*^9, 3.732094745105803*^9, 3.743014980125712*^9, 
   3.743015617054161*^9, 3.743016725115234*^9, 3.743017639133771*^9, 
   3.743030420721239*^9},ExpressionUUID->"3fffdf34-277c-4c82-83be-\
ab890cc58567"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rearrange to find the Regge-Wheeler equation", "Subsubsection",
 CellChangeTimes->{{3.7430149924078217`*^9, 3.743015002984968*^9}, {
  3.743016765194666*^9, 
  3.743016803060191*^9}},ExpressionUUID->"05fb57f9-6201-419b-bc49-\
ab41fcf545a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "Regge"}], "-", 
     RowBox[{"Wheeler", " ", "function", " ", "R"}]}], " ", "=", " ", 
    RowBox[{"h1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", 
         RowBox[{"M", "/", "r"}]}]}], ")"}], "/", "r"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"rulesRW", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"h1", "[", "r", "]"}], "\[Rule]", 
        RowBox[{"r", 
         FractionBox[
          RowBox[{"R", "[", "r", "]"}], 
          RowBox[{"F", "[", "r", "]"}]]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"h1", "'"}], "[", "r", "]"}], "\[Rule]", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"r", 
           FractionBox[
            RowBox[{"R", "[", "r", "]"}], 
            RowBox[{"F", "[", "r", "]"}]]}], ",", "r"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"h1", "''"}], "[", "r", "]"}], "\[Rule]", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"r", 
           FractionBox[
            RowBox[{"R", "[", "r", "]"}], 
            RowBox[{"F", "[", "r", "]"}]]}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "2"}], "}"}]}], "]"}]}]}], "}"}], "//", 
     "Simplify"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7219946013153563`*^9, 3.7219946254612827`*^9}, {
   3.722085404555125*^9, 3.722085406028133*^9}, {3.743017647315878*^9, 
   3.743017686780305*^9}, 
   3.743043735811769*^9},ExpressionUUID->"59ec22c5-a6bd-497d-931c-\
8dbcecd55a47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Derive", " ", "h0"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"sh0", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq3A", "//.", "rulesRW"}], ")"}], "\[Equal]", "0"}], ",", 
        RowBox[{"h0", "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"R", "'"}], "[", "r", "]"}], ",", 
       RowBox[{"R", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], "}"}], ",", 
     "Simplify"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.721994669513444*^9, 3.721994703031598*^9}, 
   3.722025606225588*^9, 3.722085408749301*^9, {3.722085465973722*^9, 
   3.7220854880471363`*^9}, {3.743015636118511*^9, 3.743015636590764*^9}, {
   3.7430176899410763`*^9, 
   3.743017694918137*^9}},ExpressionUUID->"a926918b-a06f-4c5c-b3a2-\
f2768d9109c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
     RowBox[{"R", "[", "r", "]"}]}], 
    RowBox[{"r", " ", "\[Omega]"}]]}], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", "l", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["l", "2"]}], "+", 
        SuperscriptBox["l", "3"]}], ")"}]}]], " ", "\[Omega]"}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["R", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], "\[Omega]"]}]], "Output",
 CellChangeTimes->{{3.721994674191699*^9, 3.721994703663659*^9}, 
   3.721997479790276*^9, 3.721997645083131*^9, 3.722000149581094*^9, 
   3.722000250169888*^9, 3.722001702454109*^9, 3.72200291283241*^9, 
   3.722008753274295*^9, 3.722010565802184*^9, {3.722014677808373*^9, 
   3.7220146843387623`*^9}, 3.722015576076807*^9, 3.722022661480933*^9, 
   3.722025606501112*^9, {3.722085457669219*^9, 3.722085488506959*^9}, 
   3.722085676048235*^9, 3.722153166100328*^9, 3.7221532359983263`*^9, 
   3.722330282175213*^9, 3.722422409459035*^9, 3.7225857732662153`*^9, 
   3.723112546447385*^9, 3.723131403085738*^9, 3.732091428578046*^9, 
   3.732091572499186*^9, 3.7320922069395037`*^9, 3.7320946081915216`*^9, 
   3.7320947451954412`*^9, 3.743015038473358*^9, 3.74301562072894*^9, 
   3.743016727698613*^9, 3.7430176425605307`*^9, 
   3.743030424856357*^9},ExpressionUUID->"5023a930-1574-4115-859f-\
03d473a4a46d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Second", " ", "order", " ", "equation", " ", "in", " ", 
    RowBox[{"R", ".", " ", "Note"}], " ", "that", " ", "this", " ", "is", " ",
     "in", " ", "the", " ", 
    RowBox[{"standard", " ", "'"}], 
    RowBox[{"r", "'"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"RW", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"eq2A", "//.", 
      RowBox[{"Join", "[", 
       RowBox[{"rulesRW", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"h0", "'"}], "[", "r", "]"}], "\[Rule]", 
           RowBox[{"D", "[", 
            RowBox[{"sh0", ",", "r"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"h0", "[", "r", "]"}], "\[Rule]", "sh0"}]}], "}"}]}], 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"R", "''"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"R", "'"}], "[", "r", "]"}], ",", 
       RowBox[{"R", "[", "r", "]"}]}], "}"}], ",", "Simplify"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.721994706256257*^9, 3.721994800422654*^9}, {
   3.721994856880457*^9, 3.721994882684844*^9}, {3.722010707397459*^9, 
   3.72201070761477*^9}, 3.7220256087390213`*^9, 3.722085653346218*^9, 
   3.722153171774732*^9, {3.743015639667615*^9, 3.743015647002673*^9}, {
   3.743017700128725*^9, 3.7430177264237022`*^9}, {3.743043737766931*^9, 
   3.7430437424498377`*^9}},ExpressionUUID->"8fb4fc6e-c6fd-450c-9000-\
f052f05503bb"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox["M", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "l", "+", 
         SuperscriptBox["l", "2"]}], ")"}], " ", "M", " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "l"}], "-", 
         SuperscriptBox["l", "2"], "+", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"R", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    SuperscriptBox["r", "2"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{
     SuperscriptBox["R", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], "r"], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"l", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "l"}], ")"}]}]], " ", "M", " ", 
       RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox[
           RowBox[{"l", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "l", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["l", "2"]}], "+", 
              SuperscriptBox["l", "3"]}], ")"}]}]], " ", 
          RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}]}], "-", 
         RowBox[{
          SqrtBox[
           RowBox[{"l", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "l"}], ")"}]}]], " ", "r", " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalD]", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
    SqrtBox[
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", "l", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["l", "2"]}], "+", 
        SuperscriptBox["l", "3"]}], ")"}]}]]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["R", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.721994747096107*^9, 3.721994800715406*^9}, 
   3.721994883481077*^9, 3.721997487345949*^9, 3.721997646062419*^9, 
   3.722000150315539*^9, 3.722000251663967*^9, 3.722001704113323*^9, 
   3.7220029145355988`*^9, 3.7220087546283417`*^9, 3.722010566651126*^9, 
   3.7220107095357103`*^9, 3.722014689785902*^9, 3.72201557623026*^9, 
   3.7220226624839497`*^9, 3.722025609149884*^9, {3.7220856542383757`*^9, 
   3.722085676765539*^9}, {3.7221531679370537`*^9, 3.722153172182983*^9}, 
   3.7221532373946342`*^9, 3.72233028239581*^9, 3.722422410289321*^9, 
   3.7225857746376123`*^9, 3.723112546516102*^9, 3.7231314036702433`*^9, 
   3.732091428681089*^9, 3.7320915725765038`*^9, 3.7320922070330544`*^9, 
   3.732094608248884*^9, 3.732094745271058*^9, 3.74301504090693*^9, 
   3.743015622178055*^9, 3.7430167283990602`*^9, 3.743017643269256*^9, 
   3.743017730609747*^9, 
   3.743030425887054*^9},ExpressionUUID->"44936e09-53e2-4c3f-b08a-\
d8ba6d5e5d6c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "Finally", " ", "change", " ", "to", " ", "the", " ", "tortoise", " ", 
    "coordinate", " ", "to", " ", "find", " ", "the", " ", "canonical", " ", 
    "Schroedinger"}], "-", 
   RowBox[{"like", " ", "form", " ", "of", " ", "the", " ", "equation"}]}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743015046461417*^9, 
  3.743015101262335*^9}},ExpressionUUID->"d7c28f68-88d0-4234-8cce-\
c9ad564a061b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rulesT", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"R", "''"}], "[", "r", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"F", "'"}], "[", "r", "]"}], 
          SuperscriptBox[
           RowBox[{"F", "[", "r", "]"}], "2"]]}], 
        RowBox[{
         RowBox[{"R", "'"}], "[", "\[ScriptR]", "]"}]}], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"R", "''"}], "[", "\[ScriptR]", "]"}], 
        SuperscriptBox[
         RowBox[{"F", "[", "r", "]"}], "2"]]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "'"}], "[", "r", "]"}], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"R", "'"}], "[", "\[ScriptR]", "]"}], 
       RowBox[{"F", "[", "r", "]"}]]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.721994831567932*^9, 3.7219948498610477`*^9}, {
  3.7219950050614433`*^9, 3.721995017981957*^9}, {3.7219975047010927`*^9, 
  3.721997507081675*^9}, {3.721997658303362*^9, 3.721997662391899*^9}, {
  3.721999152447032*^9, 3.721999156843233*^9}, {3.722015442260621*^9, 
  3.722015480663158*^9}, {3.722022828112565*^9, 
  3.722022841422699*^9}},ExpressionUUID->"f1f58e2d-dc03-48ed-a5fd-\
8367835c459c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RWr", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"F", "[", "r", "]"}]}], "/", "r"}], " ", "RW"}], "//.", 
     "rulesT"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "''"}], "[", "\[ScriptR]", "]"}], ",", 
      RowBox[{"R", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}], ",", 
      RowBox[{
       RowBox[{"\[ScriptCapitalD]", "'"}], "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], "}"}], ",", 
    "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.721994885195842*^9, 3.721994957394579*^9}, {
   3.721995036115924*^9, 3.721995045582704*^9}, {3.7219975126446047`*^9, 
   3.7219975153944798`*^9}, {3.721998416664843*^9, 3.721998421009903*^9}, {
   3.722001715518177*^9, 3.7220017217021933`*^9}, {3.7220029212320127`*^9, 
   3.722002928749457*^9}, {3.722022681355126*^9, 3.722022682965796*^9}, {
   3.722022802038851*^9, 3.722022845281727*^9}, 3.722085657498399*^9, {
   3.722586180032041*^9, 3.722586183722699*^9}, {3.723131425194532*^9, 
   3.723131425495296*^9}},ExpressionUUID->"7bec4c36-2bff-4876-9726-\
579404f62408"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "M"}], "-", 
          RowBox[{"l", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "l"}], ")"}], " ", "r"}]}], ")"}]}], 
       SuperscriptBox["r", "4"]]}], "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
   RowBox[{"R", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{"16", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "l"}], ")"}], " ", "l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "l"}], ")"}]}]], " ", 
    SuperscriptBox["r", "2"]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}]}]], " ", 
    SuperscriptBox["r", "2"]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{
     SuperscriptBox["\[ScriptCapitalD]", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "l"}], ")"}], " ", "l", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "l"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "l"}], ")"}]}]], " ", "r"}]], "+", 
  RowBox[{
   SuperscriptBox["R", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "\[ScriptR]", "]"}]}]], "Output",
 CellChangeTimes->{{3.7219948968817987`*^9, 3.721994957948111*^9}, {
   3.721995020929653*^9, 3.7219950459852533`*^9}, {3.7219974906997957`*^9, 
   3.7219975158196297`*^9}, {3.721997647655155*^9, 3.721997664271405*^9}, 
   3.721998421801057*^9, 3.721999158032048*^9, 3.722000152679391*^9, 
   3.722000253368516*^9, {3.722001705948938*^9, 3.722001722305066*^9}, {
   3.722002917038109*^9, 3.722002929079338*^9}, 3.722008756883168*^9, 
   3.722010569154851*^9, 3.722010711333712*^9, 3.722014693280895*^9, 
   3.722015578150754*^9, 3.72202268403008*^9, {3.7220228037614613`*^9, 
   3.722022845762827*^9}, 3.722025611998715*^9, {3.722085658278398*^9, 
   3.722085678446641*^9}, 3.722153174981501*^9, 3.7221532391331367`*^9, 
   3.722330282810356*^9, 3.722585788460994*^9, {3.7225861786270313`*^9, 
   3.722586184097447*^9}, 3.723112546832356*^9, {3.7231314060911417`*^9, 
   3.723131425807706*^9}, 3.732091429107717*^9, 3.732091572842304*^9, 
   3.732092207296464*^9, 3.732094608350094*^9, 3.732094745516836*^9, 
   3.743015043965868*^9, 3.743015624300171*^9, 3.7430167315660887`*^9, 
   3.743017733816331*^9, 
   3.7430304317184677`*^9},ExpressionUUID->"fa2ff00e-19d8-4652-9551-\
65929a09bd06"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Axial_GR.m\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"RW", ",", "sh0", ",", "RWr"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.72258614819648*^9, 3.722586163505021*^9}, {
  3.722586196102724*^9, 3.722586196267099*^9}, {3.743015629081395*^9, 
  3.743015652395598*^9}},ExpressionUUID->"cd0f69bc-6b36-46a2-88a9-\
6572c60f43e0"],

Cell[BoxData["\<\"Axial_GR.m\"\>"], "Output",
 CellChangeTimes->{
  3.7225861975112*^9, 3.723112546950136*^9, {3.723131412016296*^9, 
   3.7231314271554327`*^9}, 3.7320914292705593`*^9, 3.7320915728904753`*^9, 
   3.7320922073523617`*^9, 3.732094608416613*^9, 3.7320947455484543`*^9, 
   3.7430156295312557`*^9, 3.743016736576058*^9, 3.743017734664606*^9, 
   3.743030433348166*^9},ExpressionUUID->"f71fe644-c867-4ac1-b00b-\
c346a02141ed"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Polar perturbation \[ScriptL] \[GreaterEqual] 2", "Subsection",
 CellChangeTimes->{{3.722079789708373*^9, 3.72207979319172*^9}, {
  3.7224159230557327`*^9, 3.7224159237408247`*^9}, {3.7262223045382357`*^9, 
  3.726222312498735*^9}},ExpressionUUID->"098ef589-5353-4101-9145-\
fc17f1d0816d"],

Cell[CellGroupData[{

Cell["Master equations", "Subsubsection",
 CellChangeTimes->{{3.722105867957926*^9, 
  3.7221058948678083`*^9}},ExpressionUUID->"4385ff42-81a6-4a7d-9f6a-\
492d73ca386b"],

Cell[TextData[{
 StyleBox["7 master equations for 3 variables ",
  FontSize->18,
  FontColor->GrayLevel[0]],
 Cell[BoxData[
  FormBox[
   SubscriptBox["H", "1"], TraditionalForm]],
  FontSize->18,
  FontColor->GrayLevel[0],ExpressionUUID->
  "0a37e955-2ca4-468e-9d3f-a9c02570bafe"],
 StyleBox[", ",
  FontSize->18,
  FontColor->GrayLevel[0]],
 Cell[BoxData[
  FormBox[
   SubscriptBox["H", "2"], TraditionalForm]],
  FontSize->18,
  FontColor->GrayLevel[0],ExpressionUUID->
  "220be1b3-d65d-4cd8-8128-0109f757ed0c"],
 StyleBox[", K",
  FontSize->18,
  FontColor->GrayLevel[0]]
}], "Item",
 CellChangeTimes->{{3.722074969634474*^9, 3.722075015169786*^9}, {
  3.722079818361176*^9, 
  3.7220798211364117`*^9}},ExpressionUUID->"c0000f17-efe0-4373-9c31-\
6846ad781ac7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"-", "\[ScriptCapitalE]11P"}], ",", 
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "''"}], "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"K", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H2", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7209572198464403`*^9, 3.720957241151536*^9}, 
   3.7209697906638317`*^9, {3.721031835620748*^9, 3.721031859500978*^9}, {
   3.7210319390303*^9, 3.72103193976722*^9}, {3.7210385136274242`*^9, 
   3.721038519123773*^9}, 3.721039362603073*^9, {3.7219894553921213`*^9, 
   3.721989457813479*^9}, {3.721989725791731*^9, 3.721989742568439*^9}, 
   3.721992253975541*^9, {3.722001212867393*^9, 3.722001215995906*^9}, {
   3.7220013002080708`*^9, 3.7220013027017317`*^9}, {3.722002318846178*^9, 
   3.7220023493836393`*^9}, {3.7220028227172832`*^9, 3.722002831586835*^9}, {
   3.722008733542445*^9, 3.722008736505877*^9}, 3.7220226510001917`*^9, {
   3.722022795844339*^9, 3.7220227977379293`*^9}, {3.722025399404853*^9, 
   3.722025421742782*^9}, {3.722025526776226*^9, 3.722025537360223*^9}, 
   3.7220255716534567`*^9, 3.7220258743884373`*^9, 3.74301775227874*^9, {
   3.7430306933596497`*^9, 
   3.743030694528139*^9}},ExpressionUUID->"b804f3c3-a64d-4fd0-9357-\
be750b109b18"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Lambda]"}], ")"}], " ", 
    RowBox[{"H2", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "3"]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "3"]}]], "+", 
  RowBox[{"8", " ", "\[Pi]", " ", 
   RowBox[{"\[ScriptCapitalA]0", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{
     SuperscriptBox["H2", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "3"]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", "M"}], "-", 
      RowBox[{"3", " ", "r"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["K", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{
     SuperscriptBox["K", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]]}]], "Output",
 CellChangeTimes->{{3.7209572213334713`*^9, 3.720957241690765*^9}, 
   3.720960539807233*^9, 3.720960663322096*^9, 3.720960771236758*^9, {
   3.7209697688537683`*^9, 3.720969798426468*^9}, 3.720970403153442*^9, 
   3.7209724359838667`*^9, 3.720973956336804*^9, 3.720974922209474*^9, {
   3.7210256636443853`*^9, 3.721025678751824*^9}, {3.72103183858356*^9, 
   3.721031860519939*^9}, 3.721031940677422*^9, 3.7210324568409452`*^9, 
   3.7210325000177813`*^9, 3.7210329844674788`*^9, 3.721033188886134*^9, 
   3.721033363714795*^9, 3.721036798939597*^9, 3.721036922256166*^9, 
   3.721038529775407*^9, {3.7210393547266483`*^9, 3.721039363549987*^9}, 
   3.721989458258581*^9, {3.721989739527182*^9, 3.7219897429897738`*^9}, 
   3.721992254871928*^9, 3.7219974620132647`*^9, 3.721997639524913*^9, 
   3.7220001451041937`*^9, 3.722000246162141*^9, 3.722001216792983*^9, {
   3.722001300551968*^9, 3.722001303170933*^9}, 3.722001694538453*^9, {
   3.72200232063396*^9, 3.7220023499032707`*^9}, {3.7220028045149603`*^9, 
   3.7220028320748873`*^9}, {3.7220087300806828`*^9, 3.722008737024251*^9}, 
   3.722010557673863*^9, 3.7220146721649027`*^9, 3.722015575438176*^9, 
   3.722022651722149*^9, 3.722022798249728*^9, {3.722025405098501*^9, 
   3.722025417133354*^9}, {3.722025527639654*^9, 3.722025537749196*^9}, 
   3.722025572124007*^9, 3.722025874919979*^9, 3.722085763563897*^9, 
   3.722085833239966*^9, 3.722330288137619*^9, 3.7223654391885233`*^9, 
   3.722374993322117*^9, 3.7224157249824142`*^9, 3.722422098090797*^9, 
   3.722577460267247*^9, 3.722585799363043*^9, 3.7231125500178423`*^9, 
   3.723113692725943*^9, 3.73209143137096*^9, 3.732091557842531*^9, 
   3.732092208957388*^9, 3.732093229474577*^9, 3.7320932686416893`*^9, 
   3.732094613918785*^9, 3.732094745726432*^9, {3.7320966553408327`*^9, 
   3.732096667086772*^9}, 3.743015667243227*^9, 3.743015772418283*^9, 
   3.743015885721277*^9, 3.743016806332423*^9, {3.7430177486714373`*^9, 
   3.74301775262598*^9}, 3.743030443601316*^9, {3.743030695186119*^9, 
   3.743030711770381*^9}, 
   3.743030744309382*^9},ExpressionUUID->"1cbb1a1f-5a18-4d60-ba41-\
96c7dfaa7b79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"-", "\[ScriptCapitalE]12P"}], ",", 
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"K", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722025879007461*^9, 3.722025913879361*^9}, 
   3.7220644485714617`*^9, 3.743017756234664*^9, 
   3.743030754803385*^9},ExpressionUUID->"fe821992-b231-42fe-8bf5-\
64716d9f02f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"H1", "[", "r", "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["r", "2"]}]]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
    RowBox[{"H2", "[", "r", "]"}]}], "r"], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "M"}], "+", "r"}], ")"}], " ", "\[Omega]", 
    " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{"r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}]}]], "+", 
  RowBox[{"4", " ", "\[ImaginaryI]", " ", 
   SqrtBox["2"], " ", "\[Pi]", " ", 
   RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{
    SuperscriptBox["K", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.722025884975994*^9, 3.722025914472115*^9}, 
   3.722085764290959*^9, 3.722085833481806*^9, 3.722330288339361*^9, 
   3.722365439370924*^9, 3.7223749935316257`*^9, 3.72241572519007*^9, 
   3.72242209911203*^9, 3.722577460454372*^9, 3.722585801100706*^9, 
   3.723112550197742*^9, 3.723113692932436*^9, 3.732091431742084*^9, 
   3.732091558081952*^9, 3.7320922091436253`*^9, 3.732093229727498*^9, 
   3.732093268729352*^9, 3.7320947458374243`*^9, 3.7320966674073753`*^9, {
   3.7430156735549192`*^9, 3.743015697839313*^9}, 3.7430157733189163`*^9, 
   3.743015886312842*^9, 3.743016807417511*^9, {3.7430177494935637`*^9, 
   3.74301775659931*^9}, 3.743030444686926*^9, 
   3.743030756045577*^9},ExpressionUUID->"cd9e0b3c-4ce8-4e8d-b4db-\
a5a427fc64f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq3P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"-", "\[ScriptCapitalE]22P"}], ",", 
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"K", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H0", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"H1", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722026056636076*^9, 3.722026089002652*^9}, {
   3.722026296346549*^9, 3.722026331549396*^9}, 3.743017759635585*^9, 
   3.743030762608737*^9},ExpressionUUID->"85a1fd9b-e6b1-4da5-a81d-\
26abdc716476"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"H0", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"4", " ", "M", " ", "r"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["r", "2"]}]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"2", " ", "M"}], "-", "r"}]], "+", 
  FractionBox[
   RowBox[{"H2", "[", "r", "]"}], 
   RowBox[{"r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{"2", " ", "r", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"]}]], "+", 
  RowBox[{"8", " ", "\[Pi]", " ", 
   RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["H0", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}], "r"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"M", "-", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["K", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.722026062164599*^9, 3.722026089443578*^9}, {
   3.722026299489702*^9, 3.7220263321173697`*^9}, 3.722085765091217*^9, 
   3.7220858337813187`*^9, 3.722330288617135*^9, 3.722365439608646*^9, 
   3.7223749938327913`*^9, 3.722415725417871*^9, 3.722422100156577*^9, 
   3.722577460668991*^9, 3.722585802469474*^9, 3.723112550417904*^9, 
   3.7231136931622543`*^9, 3.732091432300009*^9, 3.732091558365882*^9, 
   3.73209220938521*^9, 3.73209322999074*^9, 3.73209326881703*^9, 
   3.7320947460733433`*^9, 3.7320966678589897`*^9, 3.7430156986977863`*^9, 
   3.743015774003628*^9, 3.743015887073455*^9, 3.743016808917521*^9, 
   3.743017760050413*^9, 3.743030445537122*^9, 
   3.7430307631555843`*^9},ExpressionUUID->"28678355-a19c-427c-b5ba-\
d9f9bb7dcdce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq4P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"2", "\[ScriptCapitalE]13P"}], ",", 
        RowBox[{
         SuperscriptBox["Y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"K", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H0", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"H1", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722026508562811*^9, 3.722026509601572*^9}, {
   3.722026547532959*^9, 3.722026577738616*^9}, 3.743017762587627*^9, 
   3.743030768837289*^9},ExpressionUUID->"d8c4c77d-bd31-4f92-accb-\
06f0770be219"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{"H2", "[", "r", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{"K", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], 
   SqrtBox["\[Lambda]"]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["H1", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], "r"]}]], "Output",
 CellChangeTimes->{
  3.722026512320862*^9, {3.722026547913773*^9, 3.722026578473102*^9}, 
   3.722085765680949*^9, 3.72208583403123*^9, 3.722330288946864*^9, 
   3.722365439818161*^9, 3.722374994106649*^9, 3.722415725615312*^9, 
   3.722422102489387*^9, 3.722577460865344*^9, 3.722585803508391*^9, 
   3.723112550635785*^9, 3.723113693391007*^9, 3.732091432886181*^9, 
   3.732091558629963*^9, 3.732092209621057*^9, 3.7320932302469597`*^9, 
   3.732093268900317*^9, 3.7320947462974663`*^9, 3.732096669177758*^9, 
   3.743015774545369*^9, 3.74301588834842*^9, 3.7430168096467113`*^9, 
   3.743017763093224*^9, 3.7430304462809677`*^9, 
   3.743030769453178*^9},ExpressionUUID->"cc3ddf2f-ff04-4203-94aa-\
d2ca1f107989"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq5P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"F", "[", "r", "]"}], "\[ScriptCapitalE]23P"}], ",", 
        RowBox[{
         SuperscriptBox["Y", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"K", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H0", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"H1", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722026712970347*^9, 3.722026740676097*^9}, {
   3.722026838319284*^9, 3.722026847581956*^9}, {3.743016810767647*^9, 
   3.743016811485588*^9}, 3.743017765568931*^9, 
   3.743030775385144*^9},ExpressionUUID->"b629654e-10a6-4c83-a21e-\
a864becaea2f"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"H0", "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{"H1", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"H2", "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   SqrtBox["\[Lambda]"]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FractionBox[
      RowBox[{"2", " ", "M"}], "r"]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H0", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox[
      RowBox[{"2", " ", "M"}], "r"]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["K", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.7220267167080803`*^9, 3.722026741495618*^9}, {
   3.722026838950981*^9, 3.722026848063284*^9}, 3.722085766341022*^9, 
   3.722085834240925*^9, 3.722330289195615*^9, 3.722365440037677*^9, 
   3.722374994334955*^9, 3.7224157258183737`*^9, 3.722422103429401*^9, 
   3.722577461047305*^9, 3.722585804540254*^9, 3.7231125508214283`*^9, 
   3.723113693569071*^9, 3.732091433465616*^9, 3.732091558850078*^9, 
   3.7320922098296947`*^9, 3.732093230846203*^9, 3.73209326898267*^9, 
   3.732094746497171*^9, 3.732096669813159*^9, 3.74301578263028*^9, 
   3.743015889065*^9, 3.743016812073882*^9, 3.743017766036085*^9, 
   3.743030446908037*^9, 
   3.743030775998947*^9},ExpressionUUID->"c49f8cd3-f0ad-49f5-bfa7-\
10e7f675896f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq6P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"2", "\[ScriptCapitalE]34P"}], ",", 
        RowBox[{"X", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"H0", "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}], ",", 
        RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], "}"}], ",", 
      "FullSimplify"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7220268797117643`*^9, 3.7220268995496883`*^9}, {
   3.7220269842932377`*^9, 3.72202698516183*^9}, {3.72206361272165*^9, 
   3.722063624815316*^9}, 3.7430177692014008`*^9, 
   3.743030783237129*^9},ExpressionUUID->"61e358da-e6df-41c2-bc3d-\
21fd69f63d1a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"H0", "[", "r", "]"}], "2"], "-", 
  FractionBox[
   RowBox[{"H2", "[", "r", "]"}], "2"], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
     "\[Lambda]"}]]]}]], "Output",
 CellChangeTimes->{
  3.722026900991498*^9, 3.722026985646213*^9, {3.722063618779977*^9, 
   3.722063625493462*^9}, 3.722085766927984*^9, 3.722085834393778*^9, 
   3.722330289353689*^9, 3.722365440120165*^9, 3.722374994423003*^9, 
   3.722415725890332*^9, 3.722422104161874*^9, 3.722577461121561*^9, 
   3.7225858053769693`*^9, 3.723112550895959*^9, 3.723113693652895*^9, 
   3.732091433661901*^9, 3.732091559042512*^9, 3.732092209915793*^9, 
   3.7320932309298067`*^9, 3.732093269079711*^9, 3.732094746577508*^9, 
   3.732096670273232*^9, 3.743015783470394*^9, 3.743015889674655*^9, 
   3.743016815367343*^9, 3.7430177695468283`*^9, 3.7430304481680307`*^9, 
   3.7430307837139597`*^9},ExpressionUUID->"50cf3fd7-139d-4ce3-9e33-\
eb951b7a3331"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq7P", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["l", "2"], "+", "l"}], "\[Equal]", "\[Lambda]"}], ",", 
    RowBox[{"Collect", "[", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{
        RowBox[{"\[ScriptCapitalE]3344P", "/", 
         SuperscriptBox["r", "2"]}], ",", 
        RowBox[{"Y", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"H1", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H1", "'"}], "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"K", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H0", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"h0", "[", "r", "]"}], ",", 
        RowBox[{
         RowBox[{"H2", "'"}], "[", "r", "]"}], ",", 
        RowBox[{"H2", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
     "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722027022445867*^9, 3.722027076885302*^9}, {
   3.7220636529419537`*^9, 3.722063790929345*^9}, 3.743017803690819*^9, {
   3.74303079273526*^9, 
   3.743030793829976*^9}},ExpressionUUID->"a398370e-b2a4-4673-9b28-\
fd6db3a3591d"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"H0", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"M", "-", "r"}], ")"}], " ", "\[Omega]", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r"}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["\[Lambda]", 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "2"]}]]}], "+", 
     FractionBox[
      RowBox[{"r", " ", 
       SuperscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}]]}], ")"}], " ", 
   RowBox[{"H2", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{"r", " ", 
    SuperscriptBox["\[Omega]", "2"], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"2", " ", "M"}], "-", "r"}]], "-", 
  RowBox[{"8", " ", 
   SqrtBox["2"], " ", "\[Pi]", " ", 
   RowBox[{"\[ScriptCapitalG]", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"M", "+", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["H0", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "-", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{
    SuperscriptBox["H1", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"M", "-", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["H2", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"M", "-", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["K", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["H0", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}], "-", 
      RowBox[{
       SuperscriptBox["K", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], ")"}]}], 
   "r"]}]], "Output",
 CellChangeTimes->{{3.72202704369352*^9, 3.722027078723989*^9}, {
   3.7220636849412737`*^9, 3.722063743549486*^9}, {3.7220637756814833`*^9, 
   3.7220637913795967`*^9}, 3.7220857680507298`*^9, 3.722085835513102*^9, 
   3.722330289846044*^9, 3.7223654405323343`*^9, 3.722374994998781*^9, 
   3.722415726323567*^9, 3.72242210534982*^9, 3.722577461547328*^9, 
   3.722585807575655*^9, 3.723112551322196*^9, 3.723113694073873*^9, 
   3.7320914344700823`*^9, 3.7320915595487947`*^9, 3.732092210645363*^9, 
   3.732093231619186*^9, 3.732093269167527*^9, 3.732094747327725*^9, 
   3.732096672241582*^9, {3.743015785257228*^9, 3.74301581157932*^9}, 
   3.743015890637611*^9, 3.743016816638089*^9, {3.743017793982752*^9, 
   3.743017804210993*^9}, 3.7430304497239017`*^9, 
   3.743030794595277*^9},ExpressionUUID->"7523e372-b713-45f5-85d7-\
0293aa1d9489"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rearrange equations", "Subsubsection",
 CellChangeTimes->{{3.722105878493471*^9, 
  3.7221058828270187`*^9}},ExpressionUUID->"d664c91a-7373-4e61-84f9-\
2587f1854be6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Solve", " ", "for", " ", "K"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"sdK", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"eq2P", "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"H1", "[", "r", "]"}], ",", 
       RowBox[{"H2", "[", "r", "]"}], ",", 
       RowBox[{"K", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "}"}], ",", 
     "FullSimplify"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.722064452615818*^9, 3.722064480072646*^9}, {
  3.722066221156817*^9, 3.722066242090887*^9}, {3.743015827912046*^9, 
  3.7430158285701113`*^9}, {3.74301589349537*^9, 
  3.743015903044816*^9}},ExpressionUUID->"93d1a78a-16ca-4ce3-8cc9-\
84cab3ede549"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Lambda]", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", "\[Omega]"}]], "+", 
  FractionBox[
   RowBox[{"H2", "[", "r", "]"}], "r"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r"}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "\[Omega]"]}]], "Output",\

 CellChangeTimes->{{3.722064461588427*^9, 3.7220644817130547`*^9}, 
   3.72206624264944*^9, 3.722085769966927*^9, 3.722085835701009*^9, 
   3.722330300192264*^9, 3.72236544059081*^9, 3.722374995071472*^9, 
   3.722415726436204*^9, 3.722422175196509*^9, 3.722577464402205*^9, 
   3.722585891122982*^9, 3.723112551448071*^9, 3.723113694194895*^9, 
   3.732091434569281*^9, 3.7320915596126423`*^9, 3.7320922107843647`*^9, 
   3.732093231731331*^9, 3.732093269304612*^9, 3.732094747373762*^9, 
   3.732096673309257*^9, {3.743015817699779*^9, 3.743015829061863*^9}, 
   3.743015918922311*^9, 3.743016819407798*^9, 3.7430178144890633`*^9, 
   3.743030455023085*^9, 
   3.743030814683416*^9},ExpressionUUID->"55e3a03e-c23d-49e1-b094-\
158ec706a66e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Solve", " ", "for", " ", 
    RowBox[{"H1", "'"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"sdH1", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"eq4P", "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"H1", "'"}], "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"H1", "[", "r", "]"}], ",", 
       RowBox[{"H2", "[", "r", "]"}], ",", 
       RowBox[{"K", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], "}"}], ",", 
     "FullSimplify"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.722064395670733*^9, 3.722064434942706*^9}, 
   3.722064484669505*^9, {3.722066196640436*^9, 3.7220662149927*^9}, {
   3.743015834623672*^9, 3.743015835058291*^9}, {3.7430159075062647`*^9, 
   3.743015910909987*^9}, 
   3.743017823008073*^9},ExpressionUUID->"7c446c9e-3820-41bb-a6f2-\
d0f171aaa361"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"2", " ", "M", " ", "r"}], "-", 
    SuperscriptBox["r", "2"]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
    RowBox[{"H2", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "M"}], "+", "r"}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "M"}], "+", "r"}]], "+", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox["\[Lambda]"]}]]}]], "Output",
 CellChangeTimes->{{3.722064392481505*^9, 3.722064436603347*^9}, 
   3.722064485528688*^9, 3.722066215454982*^9, 3.722085771229731*^9, 
   3.722085835868269*^9, 3.722330300324081*^9, 3.722365440631177*^9, 
   3.7223749951695347`*^9, 3.722415726496138*^9, 3.722422180074198*^9, 
   3.722577465316393*^9, 3.7225858919250507`*^9, 3.723112551518818*^9, 
   3.723113694262989*^9, 3.7320914346527557`*^9, 3.732091559687468*^9, 
   3.7320922109253674`*^9, 3.7320932317951937`*^9, 3.732093269393224*^9, 
   3.7320947474315042`*^9, 3.732096673454544*^9, {3.743015818644*^9, 
   3.743015835430397*^9}, 3.743015919566594*^9, 3.743016820887096*^9, 
   3.743017815391616*^9, 3.743030456903726*^9, 
   3.743030819049279*^9},ExpressionUUID->"3fb3c7d9-034e-4ba2-8ca2-\
a068c7e641bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Solve", " ", "for", " ", "H0"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"sH0", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"eq6P", "\[Equal]", "0"}], ",", 
       RowBox[{"H0", "[", "r", "]"}]}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "//", 
    "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.722066614228483*^9, 3.722066643743775*^9}, {
  3.743015837712598*^9, 3.743015838114379*^9}, {3.743015914099806*^9, 
  3.7430159212394533`*^9}},ExpressionUUID->"b0062bd7-fa25-4463-b726-\
b4b921219d57"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", "\[Lambda]"}]], 
    " ", 
    RowBox[{"H2", "[", "r", "]"}]}], "+", 
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}]}], 
  SqrtBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
    "\[Lambda]"}]]]], "Output",
 CellChangeTimes->{{3.722066630329529*^9, 3.7220666441755733`*^9}, 
   3.722085771965695*^9, 3.722085836034729*^9, 3.722330300415587*^9, 
   3.722365440643887*^9, 3.722374995274032*^9, 3.722415726545618*^9, 
   3.722422180970475*^9, 3.7225774663486843`*^9, 3.722585892702986*^9, 
   3.7231125516193733`*^9, 3.723113694359561*^9, 3.732091434721588*^9, 
   3.73209155978443*^9, 3.732092211075276*^9, 3.732093231879711*^9, 
   3.7320932695070972`*^9, 3.732094747474852*^9, 3.7320966735280867`*^9, {
   3.7430158195520782`*^9, 3.7430158384787273`*^9}, 3.743015921587254*^9, 
   3.743016822964587*^9, 3.743017819506043*^9, 3.743030458121077*^9, 
   3.743030823885838*^9},ExpressionUUID->"032860d7-6145-4c03-8158-\
ed9a9efd227e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Solve", " ", "for", " ", 
    RowBox[{"H2", "'"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"sdH2", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"eq5P", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"H0", "[", "r", "]"}], "\[Rule]", "sH0"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"H0", "'"}], "[", "r", "]"}], "\[Rule]", 
              RowBox[{"D", "[", 
               RowBox[{"sH0", ",", "r"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"K", "'"}], "[", "r", "]"}], "\[Rule]", "sdK"}]}], 
            "}"}]}], ")"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"H2", "'"}], "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"K", "[", "r", "]"}], ",", 
       RowBox[{"H2", "[", "r", "]"}], ",", 
       RowBox[{"H1", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"\[ScriptCapitalF]", "'"}], "[", "r", "]"}]}], "}"}], ",", 
     "FullSimplify"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.722066653389889*^9, 3.722066817356176*^9}, {
   3.743015840606072*^9, 3.743015863743391*^9}, {3.7430159551554537`*^9, 
   3.743015955907672*^9}, {3.743016158798524*^9, 3.743016162008328*^9}, 
   3.7430162343150806`*^9, {3.74301690718046*^9, 3.743016910579558*^9}, {
   3.743030888452108*^9, 
   3.743030888887302*^9}},ExpressionUUID->"9e5ec370-7e0e-40d7-bb7a-\
d495cb212732"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Lambda]"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", "\[Omega]"}]], "-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]"}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}]]}], ")"}], " ", 
   RowBox[{"H1", "[", "r", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"2", " ", "M"}], "-", "r"}]], "+", 
     FractionBox["2", "r"]}], ")"}], " ", 
   RowBox[{"H2", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r"}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "\[Omega]"], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   SqrtBox["\[Lambda]"]], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"M", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", "\[Lambda]"}]]}]],
   "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{
     SuperscriptBox["\[ScriptCapitalF]", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
     "\[Lambda]"}]]]}]], "Output",
 CellChangeTimes->{
  3.7220666245997677`*^9, {3.722066667152162*^9, 3.7220668178027773`*^9}, 
   3.722085772825656*^9, 3.722085836233067*^9, 3.7223303005837183`*^9, 
   3.722365440794449*^9, 3.722374995451915*^9, 3.7224157267150373`*^9, 
   3.722422181975068*^9, {3.7225774687026987`*^9, 3.72257747197602*^9}, 
   3.722585897726862*^9, 3.723112551802821*^9, 3.723113694522284*^9, 
   3.7320914349090433`*^9, 3.73209155999187*^9, 3.732092211263238*^9, 
   3.732093232076861*^9, 3.732093269590972*^9, 3.732094747661004*^9, 
   3.73209667371907*^9, 3.743015821322633*^9, {3.743015855095792*^9, 
   3.743015867173935*^9}, 3.743015931840969*^9, 3.74301598566945*^9, {
   3.743016159351327*^9, 3.74301616256021*^9}, 3.7430162380551167`*^9, 
   3.7430168245962677`*^9, 3.7430178279750967`*^9, 3.743030459881268*^9, 
   3.743030828010915*^9, {3.743030889446594*^9, 
   3.743030898977438*^9}},ExpressionUUID->"9330f2ea-af77-4928-a5ac-\
34003f28aab7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "The", " ", "following", " ", "two", " ", "are", " ", "constraints", " ", 
   "equations"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743016858055172*^9, 
  3.7430168905695343`*^9}},ExpressionUUID->"366b2e05-1190-4c7f-8eb4-\
34f4e22bf7b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"eq1P", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"H1", "'"}], "[", "r", "]"}], "\[Rule]", "sdH1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H2", "'"}], "[", "r", "]"}], "\[Rule]", "sdH2"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], "\[Rule]", "sdK"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"K", "''"}], "[", "r", "]"}], "\[Rule]", 
        RowBox[{"D", "[", 
         RowBox[{"sdK", ",", "r"}], "]"}]}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H1", "[", "r", "]"}], ",", 
      RowBox[{"H2", "[", "r", "]"}], ",", 
      RowBox[{"K", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]0", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
      RowBox[{
       RowBox[{"\[ScriptCapitalA]1", "'"}], "[", "r", "]"}]}], "}"}], ",", 
    "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722067422040393*^9, 3.722067525158897*^9}, {
   3.72206774397143*^9, 3.722067746094075*^9}, {3.7430162502604513`*^9, 
   3.743016263877248*^9}, 
   3.743030874673539*^9},ExpressionUUID->"f1d0120a-cc4e-4a76-9295-\
8234f899cac4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"8", " ", "\[Pi]", " ", 
   RowBox[{"\[ScriptCapitalA]0", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"M", "-", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox["r", "3"], " ", "\[Omega]"}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox["\[Lambda]"], " ", 
    RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox["r", "2"], " ", "\[Omega]"}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{
     SuperscriptBox["\[ScriptCapitalA]1", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox["r", "2"], " ", "\[Omega]"}]]}]], "Output",
 CellChangeTimes->{{3.722067419620288*^9, 3.722067525547203*^9}, 
   3.72206774843653*^9, 3.722085773960121*^9, 3.722085836385976*^9, 
   3.72233030066121*^9, 3.722365440861618*^9, 3.722374995680601*^9, 
   3.722415726793236*^9, 3.7224221844566813`*^9, 3.72257747360187*^9, 
   3.722585900165119*^9, 3.723112551881332*^9, 3.7231136946023397`*^9, 
   3.732091435122013*^9, 3.732091560180375*^9, 3.732092211350295*^9, 
   3.7320932321645517`*^9, 3.7320932697513847`*^9, 3.732094747793374*^9, 
   3.7320966739664373`*^9, {3.743016242488496*^9, 3.74301626423799*^9}, 
   3.743016826779564*^9, 3.743017829187036*^9, 3.743030462069418*^9, 
   3.743030834606743*^9, {3.7430308766903973`*^9, 
   3.743030901027273*^9}},ExpressionUUID->"a84a2898-5b08-4591-8967-\
0b0dc2d79670"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"F", "[", "r", "]"}], "2", 
      SuperscriptBox["r", "2"], " ", "eq3P"}], "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], "\[Rule]", "sdK"}], ",", 
       RowBox[{
        RowBox[{"H0", "[", "r", "]"}], "\[Rule]", "sH0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H0", "'"}], "[", "r", "]"}], "\[Rule]", 
        RowBox[{"D", "[", 
         RowBox[{"sH0", ",", "r"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"H2", "'"}], "[", "r", "]"}], "\[Rule]", "sdH2"}]}], "}"}]}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H1", "[", "r", "]"}], ",", 
      RowBox[{"H2", "[", "r", "]"}], ",", 
      RowBox[{"K", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}], ",", "\[Omega]"}], "}"}], 
    ",", "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722067550676127*^9, 3.722067579479747*^9}, {
  3.722067633873464*^9, 3.7220677554819927`*^9}, {3.722078004841916*^9, 
  3.722078064210795*^9}, {3.722082296566622*^9, 3.7220823034265842`*^9}, {
  3.743016308383922*^9, 3.743016322348299*^9}, {3.743030916119454*^9, 
  3.743030917352985*^9}},ExpressionUUID->"0ced29ef-52d8-46b1-82ef-\
6a86c460123c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "M", " ", "\[Lambda]"}], 
       RowBox[{
        SuperscriptBox["r", "2"], " ", "\[Omega]"}]]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]"}]}], ")"}], 
   " ", 
   RowBox[{"H1", "[", "r", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "-", 
     FractionBox[
      RowBox[{"6", " ", "M"}], "r"], "-", "\[Lambda]"}], ")"}], " ", 
   RowBox[{"H2", "[", "r", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"M", " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          RowBox[{"2", " ", "M"}], "-", "r"}]], "+", 
        FractionBox["3", "r"]}], ")"}]}], "+", "\[Lambda]", "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}], 
      RowBox[{
       RowBox[{"2", " ", "M"}], "-", "r"}]]}], ")"}], " ", 
   RowBox[{"K", "[", "r", "]"}]}], "+", 
  RowBox[{"16", " ", "\[Pi]", " ", "r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
   RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "\[Omega]"], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   SqrtBox["\[Lambda]"]], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
     "\[Lambda]"}]]]}]], "Output",
 CellChangeTimes->{{3.722067684760606*^9, 3.722067755963665*^9}, {
   3.722078005261924*^9, 3.722078064539363*^9}, {3.722082294002741*^9, 
   3.722082303938219*^9}, 3.722085774958*^9, 3.722085836688599*^9, 
   3.722330300830229*^9, 3.722365441015601*^9, 3.722374995865793*^9, 
   3.722415726963834*^9, 3.722422185472701*^9, 3.72257747451442*^9, 
   3.7225859013957357`*^9, 3.723112552058921*^9, 3.723113694824139*^9, 
   3.732091435440112*^9, 3.7320915603860817`*^9, 3.7320922115355577`*^9, 
   3.7320932323439083`*^9, 3.73209326984513*^9, 3.7320947479995527`*^9, 
   3.732096674178936*^9, 3.7430163238808947`*^9, 3.743016828096901*^9, 
   3.743017830977872*^9, 3.7430304631891108`*^9, 3.743030836311482*^9, 
   3.7430309227942333`*^9},ExpressionUUID->"bea86432-bbce-4ee9-ae5e-\
420e28a0527c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "I", " ", "remove", " ", "one", " ", "variable", " ", "in", " ", "order", 
    " ", "to", " ", "get", " ", "a", " ", "system", " ", "of", " ", "two", 
    " ", "linear", " ", "differential", " ", "equations"}], ",", " ", 
   RowBox[{"specifically", " ", "H2"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7430163349492188`*^9, 3.743016357604815*^9}, {
   3.7430169427920322`*^9, 3.743016947720887*^9}, 
   3.743043762010745*^9},ExpressionUUID->"4feaae96-7cbb-4d69-a634-\
994009c3ee03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sH2", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"C2P", "\[Equal]", "0"}], ",", 
       RowBox[{"H2", "[", "r", "]"}]}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H1", "[", "r", "]"}], ",", 
      RowBox[{"K", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], "}"}], ",", 
    "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.72206812697056*^9, 3.7220681829425993`*^9}, {
   3.7220689402462587`*^9, 3.722068944193408*^9}, 
   3.743016367212179*^9},ExpressionUUID->"0518c060-c6a1-47e4-8f04-\
c887bf0fd53c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"M", " ", "\[Lambda]"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"], " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
     RowBox[{"H1", "[", "r", "]"}]}], 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"6", " ", "M"}], "+", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
     "\[Omega]"}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}], "+", 
      RowBox[{"2", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "\[Lambda]"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", "\[Lambda]", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"16", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"6", " ", "M"}], "+", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"6", " ", "M", " ", "\[Omega]"}], "-", 
    RowBox[{"2", " ", "r", " ", "\[Omega]"}], "+", 
    RowBox[{"r", " ", "\[Lambda]", " ", "\[Omega]"}]}]], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    SqrtBox["\[Lambda]"]}]], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
     "\[Lambda]"}]]]}]], "Output",
 CellChangeTimes->{{3.7220681494806843`*^9, 3.722068183298612*^9}, 
   3.7220689839343557`*^9, 3.722078102053317*^9, 3.722085778293418*^9, 
   3.722085837486112*^9, 3.722330301007268*^9, 3.722365441183013*^9, 
   3.7223749960615*^9, 3.722415727138756*^9, 3.72242218760023*^9, 
   3.7225774817406893`*^9, 3.722585905053727*^9, 3.723112552229192*^9, 
   3.72311369511194*^9, 3.7320914356362953`*^9, 3.732091560606529*^9, 
   3.7320922117268143`*^9, 3.732093232518957*^9, 3.732093269943946*^9, 
   3.73209474817655*^9, 3.732096674361928*^9, {3.743016362986517*^9, 
   3.7430163675615377`*^9}, 3.743016833262506*^9, 3.743017833284289*^9, 
   3.743030468735752*^9, 3.7430308453683777`*^9, 
   3.743030925248253*^9},ExpressionUUID->"dc7ec035-9bed-4595-b207-\
8ecd223e0249"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "At", " ", "the", " ", "end", " ", "I", " ", "have", " ", "just", " ", 
   "two", " ", 
   RowBox[{"equations", ":", " ", 
    RowBox[{"one", " ", "for", " ", "K", 
     RowBox[{"(", "r", ")"}], " ", "and", " ", "another", " ", "one", " ", 
     "for", " ", "H1", 
     RowBox[{"(", "r", ")"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743016953004805*^9, 3.743016979968081*^9}, 
   3.7430437637017937`*^9},ExpressionUUID->"0cb6c0b1-655e-4f5d-9238-\
03dc7d67c16c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dKP", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"sdK", "//.", 
     RowBox[{
      RowBox[{"H2", "[", "r", "]"}], "\[Rule]", "sH2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H1", "[", "r", "]"}], ",", 
      RowBox[{"K", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], "}"}], ",", 
    "Simplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722068177446807*^9, 3.7220682038949423`*^9}, {
  3.722068328291645*^9, 3.7220683397244787`*^9}, {3.722068439649115*^9, 
  3.722068439821665*^9}, {3.722068948625017*^9, 3.72206896285425*^9}, {
  3.722073033359272*^9, 3.722073035653102*^9}, {3.7430163702865267`*^9, 
  3.743016380186289*^9}},ExpressionUUID->"c878273c-e584-419d-abaa-\
38743a0f3ebe"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "M", " ", "\[Lambda]"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Lambda]"}], "+", 
         SuperscriptBox["\[Lambda]", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    "\[Omega]"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox["M", "2"]}], "-", 
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", "\[Lambda]"}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"16", " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"6", " ", "M"}], "+", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    "\[Omega]"}]], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    SqrtBox["\[Lambda]"]}]], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
     "\[Lambda]"}]]]}]], "Output",
 CellChangeTimes->{
  3.722068191459323*^9, {3.7220683187287703`*^9, 3.722068340290628*^9}, 
   3.7220684401800547`*^9, 3.7220689848668833`*^9, 3.7220730367276382`*^9, 
   3.722078104208549*^9, 3.722085778848391*^9, 3.722085837834627*^9, 
   3.722330301078815*^9, 3.72236544121371*^9, 3.7223749961595697`*^9, 
   3.722415727197156*^9, 3.722422189080696*^9, 3.7225774826319838`*^9, 
   3.7225859056606627`*^9, 3.723112552297934*^9, 3.723113695465366*^9, 
   3.7320914357509203`*^9, 3.732091560681047*^9, 3.732092211847917*^9, 
   3.7320932325849752`*^9, 3.732093270033979*^9, 3.73209474822943*^9, 
   3.732096674573415*^9, {3.743016370865399*^9, 3.743016382083646*^9}, 
   3.743016834245421*^9, 3.7430178352953587`*^9, 3.743030471146022*^9, 
   3.7430309294091253`*^9},ExpressionUUID->"0af36abe-1185-4698-98d3-\
8cb8b737d350"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dH1P", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"sdH1", "//.", 
     RowBox[{
      RowBox[{"H2", "[", "r", "]"}], "\[Rule]", "sH2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"H1", "[", "r", "]"}], ",", 
      RowBox[{"K", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}], ",", 
      RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], "}"}], ",", 
    "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7220683645730247`*^9, 3.722068447779358*^9}, {
  3.722073038483552*^9, 3.7220730394372053`*^9}, {3.722078106543742*^9, 
  3.722078107172567*^9}, {3.743016386242289*^9, 
  3.743016390720546*^9}},ExpressionUUID->"1e3d1839-c675-4bd6-8d47-\
6896fafa5ed8"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["M", "2"]}], "+", 
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"3", " ", "\[Lambda]"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["M", "2"]}], "+", 
      RowBox[{"2", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", "\[Lambda]"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", "\[Lambda]", "+", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"6", " ", "M"}], "+", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"16", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "M"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}]}]}], ")"}], " ", 
    SqrtBox["\[Lambda]"]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox["\[Lambda]"]}]], "+", 
  FractionBox[
   RowBox[{"16", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Lambda]"}], ")"}], " ", 
      "\[Lambda]"}]]}]]}]], "Output",
 CellChangeTimes->{{3.722068381388527*^9, 3.722068448186193*^9}, 
   3.722068985628704*^9, 3.722073040045809*^9, 3.72207810773967*^9, {
   3.7220857801621513`*^9, 3.722085790488305*^9}, 3.722085838576975*^9, 
   3.722330301282692*^9, 3.722365441375502*^9, 3.722374996350234*^9, 
   3.722415727389271*^9, 3.722422190089711*^9, 3.722577483982171*^9, 
   3.722585906507015*^9, 3.7231125524978647`*^9, 3.723113695660947*^9, 
   3.7320914359833937`*^9, 3.732091560916834*^9, 3.732092212069269*^9, 
   3.7320932327840357`*^9, 3.732093270150859*^9, 3.732094748452219*^9, 
   3.732096674793371*^9, {3.743016387756445*^9, 3.743016391069969*^9}, 
   3.7430168360631437`*^9, 3.743017837240157*^9, 3.743030473019743*^9, 
   3.7430309310470743`*^9},ExpressionUUID->"fc384a06-0b10-407b-b2e3-\
667c08219002"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Final ODEs in Schrodinger - like form: Zerilli equation", \
"Subsubsection",
 CellChangeTimes->{{3.722106368882359*^9, 3.72210637809505*^9}, {
  3.7430169278321543`*^9, 
  3.743016934530733*^9}},ExpressionUUID->"388901a3-318c-4f8e-b52f-\
335c83e9f381"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"First", " ", "equation", " ", "for", " ", "K"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Polareq1", "=", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{"\[CapitalLambda]", "==", 
      FractionBox[
       RowBox[{"\[Lambda]", "-", "2"}], "2"]}], ",", 
     RowBox[{"Collect", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"K", "'"}], "[", "r", "]"}], "-", "dKP"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"H1", "[", "r", "]"}], ",", 
         RowBox[{"K", "[", "r", "]"}]}], "}"}], ",", "Simplify"}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.72207326898311*^9, 3.722073274836053*^9}, {
   3.722073620588581*^9, 3.722073681397552*^9}, {3.7220739542401876`*^9, 
   3.722073957403769*^9}, {3.722079590574853*^9, 3.722079602814755*^9}, {
   3.722081586061242*^9, 3.7220815922538233`*^9}, {3.7220825857345047`*^9, 
   3.7220825891025343`*^9}, 3.743017841876836*^9, {3.743039199820875*^9, 
   3.7430392167842216`*^9}},ExpressionUUID->"603b4c58-f3bc-4e12-8bec-\
ea5a6d0a4741"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "M", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[CapitalLambda]"}], ")"}]}], "+", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{"\[CapitalLambda]", "+", 
          SuperscriptBox["\[CapitalLambda]", "2"], "+", 
          RowBox[{
           SuperscriptBox["r", "2"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"H1", "[", "r", "]"}]}], 
    RowBox[{
     SuperscriptBox["r", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "M"}], "+", 
       RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], " ", "\[Omega]"}]]}], 
  "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}], "+", 
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[CapitalLambda]"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"3", " ", "M"}], "+", 
    RowBox[{"r", " ", "\[CapitalLambda]"}]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], " ", "\[Omega]"}]], 
  "+", 
  FractionBox[
   RowBox[{"8", " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "\[CapitalLambda]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", "r", " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{"\[CapitalLambda]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[CapitalLambda]"}], ")"}]}]]], "+", 
  RowBox[{
   SuperscriptBox["K", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{
  3.722073683913044*^9, 3.722073959219049*^9, 3.722078119729117*^9, {
   3.7220795946584053`*^9, 3.722079603921009*^9}, 3.722081594644517*^9, 
   3.722082049008809*^9, 3.7220825920513897`*^9, 3.722085797301416*^9, 
   3.722085843173436*^9, 3.7223303260549593`*^9, 3.722365448299518*^9, 
   3.722375003327478*^9, 3.722415737115374*^9, 3.7224222124435863`*^9, 
   3.722577493226727*^9, 3.722585911844832*^9, 3.723112559243887*^9, 
   3.723113701921537*^9, 3.732091442997735*^9, 3.732091567732347*^9, 
   3.732092218927128*^9, 3.7320932394541607`*^9, 3.732093270367269*^9, 
   3.732094755101589*^9, 3.732096681679068*^9, 3.7430164479545937`*^9, 
   3.743016839575364*^9, 3.743017839691958*^9, 3.7430178804651327`*^9, 
   3.743030478025208*^9, 
   3.7430309450405207`*^9},ExpressionUUID->"2e8b8bf8-ed7e-4dfd-a171-\
781ce7cefe57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Second", " ", "equation", " ", "for", " ", "H1"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Polareq2", "=", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{"\[CapitalLambda]", "==", 
      FractionBox[
       RowBox[{"\[Lambda]", "-", "2"}], "2"]}], ",", 
     RowBox[{"Collect", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"H1", "'"}], "[", "r", "]"}], "-", "dH1P"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"H1", "[", "r", "]"}], ",", 
         RowBox[{"K", "[", "r", "]"}]}], "}"}], ",", "Simplify"}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.722073724593664*^9, 3.72207372633319*^9}, {
   3.722073888539859*^9, 3.722073903370693*^9}, {3.722073960009119*^9, 
   3.72207396058709*^9}, {3.722077807508527*^9, 3.722077819950095*^9}, {
   3.72207960729362*^9, 3.722079618967814*^9}, 3.72208160259902*^9, {
   3.7220825666650248`*^9, 3.722082571144822*^9}, 3.7430178455589314`*^9, {
   3.743039212596521*^9, 
   3.743039220422208*^9}},ExpressionUUID->"ae07ebff-665d-4810-9652-\
1a39f01247c3"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["M", "2"]}], "-", 
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{"r", "+", 
         RowBox[{"3", " ", "r", " ", "\[CapitalLambda]"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["M", "2"]}], "+", 
      RowBox[{"4", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[CapitalLambda]"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "2"], " ", "\[CapitalLambda]"}], "+", 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"K", "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"3", " ", "M"}], "+", 
    RowBox[{"r", " ", "\[CapitalLambda]"}]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "\[CapitalLambda]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "\[CapitalLambda]"}]]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"\[CapitalLambda]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[CapitalLambda]"}], ")"}]}]]}]], "+", 
  RowBox[{
   SuperscriptBox["H1", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{
  3.722073730731695*^9, {3.722073898492461*^9, 3.722073906250638*^9}, 
   3.7220739624954453`*^9, {3.722077805478541*^9, 3.722077823082837*^9}, 
   3.722078124272084*^9, 3.7220796214364767`*^9, 3.722081605175433*^9, 
   3.72208205151836*^9, 3.722082574731028*^9, 3.722085800154686*^9, 
   3.722085846222048*^9, 3.722330329505101*^9, 3.722365450896719*^9, 
   3.72237500584531*^9, 3.722415739333859*^9, 3.722422215969891*^9, 
   3.722577505921958*^9, 3.722585915181885*^9, 3.723112561646325*^9, 
   3.723113704129676*^9, 3.732091445552479*^9, 3.7320915700825863`*^9, 
   3.732092221387611*^9, {3.7320932420505457`*^9, 3.732093270484693*^9}, 
   3.732094757379421*^9, 3.7320966840880737`*^9, 3.743016453226016*^9, 
   3.74301684409795*^9, 3.743017882098888*^9, 3.7430304804389973`*^9, 
   3.7430309492202063`*^9},ExpressionUUID->"8a866805-f830-40f6-8272-\
dbb6a6947953"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Take", " ", "thw", " ", "final", " ", "Schroedinger", " ", "like"}], "-", 
    RowBox[{
    "form", " ", "introducing", " ", "the", " ", "Zerilli", " ", 
     "function"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"\[ScriptCapitalB]b", "[", "r_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"8", "\[Pi]", " ", 
       SuperscriptBox["r", "2"], 
       RowBox[{"(", 
        RowBox[{"r", "-", 
         RowBox[{"2", "M"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
       RowBox[{"3", "M"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[CapitalLambda]"}], ")"}]}], "2"], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], 
        RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}]}], ")"}]}], "-", 
    RowBox[{"4", "\[Pi]", " ", 
     RowBox[{"Sqrt", "[", 
      FractionBox["2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
         RowBox[{"3", "M"}]}], ")"}]], "]"}], 
     FractionBox[
      RowBox[{"M", " ", "r"}], "\[Omega]"], 
     RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.722092457581401*^9, 3.722092573727304*^9}, {
   3.722103173265683*^9, 3.722103184084557*^9}, {3.722103617629771*^9, 
   3.722103623941991*^9}, {3.732091997988195*^9, 3.7320920016064796`*^9}, {
   3.7320932103288603`*^9, 3.732093215735372*^9}, {3.7320932528591948`*^9, 
   3.732093253305605*^9}, {3.743016484723291*^9, 3.743016485399626*^9}, 
   3.743016522725155*^9, {3.743039228524164*^9, 3.743039229003401*^9}, {
   3.7430437718743277`*^9, 
   3.74304377207613*^9}},ExpressionUUID->"d45bbced-6bba-4f28-a330-\
5caf9f198bfa"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C1", "[", "r_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"8", "\[Pi]"}], 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], "\[Omega]"}]], 
     RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], "+", 
    FractionBox[
     RowBox[{"\[ScriptCapitalB]b", "[", "r", "]"}], "r"], "-", 
    RowBox[{"16", "\[Pi]", " ", "r", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"\[CapitalLambda]", "+", "1"}], ")"}], " ", 
        "\[CapitalLambda]"}], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]], 
     RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.722086215919544*^9, 3.7220862757530413`*^9}, {
   3.722086317348977*^9, 3.722086326131229*^9}, 3.72208639093545*^9, {
   3.722091189095874*^9, 3.722091192079546*^9}, {3.722092247949972*^9, 
   3.7220923409432173`*^9}, 3.722092372647258*^9, 
   3.722092451872316*^9},ExpressionUUID->"9cafac55-53be-4a18-8d84-\
543a0b19361b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C2", "[", "r_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", "\[Pi]", " ", 
        SuperscriptBox["r", "2"]}], 
       RowBox[{"I", " ", "\[Omega]"}]]}], 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"\[CapitalLambda]", "+", "1"}], ")"}]}], "2"], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]], 
     FractionBox[
      RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}], 
      RowBox[{"r", "-", 
       RowBox[{"2", "M"}]}]]}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"I", " ", "r"}], 
      RowBox[{"r", "-", 
       RowBox[{"2", "M"}]}]], 
     RowBox[{"\[ScriptCapitalB]b", "[", "r", "]"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"16", "\[Pi]", " ", "I", " ", 
       SuperscriptBox["r", "3"]}], 
      RowBox[{"r", "-", 
       RowBox[{"2", "M"}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"\[CapitalLambda]", "+", "1"}], ")"}], " ", 
        "\[CapitalLambda]"}], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]], 
     RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.722086289772189*^9, 3.722086390168975*^9}, {
   3.722091193793778*^9, 3.722091195783711*^9}, {3.722092389905518*^9, 
   3.722092404835833*^9}, 
   3.7220924458570766`*^9},ExpressionUUID->"77361130-3bd6-4a9f-bb0a-\
c721c2c12f3b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rulesZ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"K", "[", "r", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"\[CapitalLambda]", 
           RowBox[{"(", 
            RowBox[{"\[CapitalLambda]", "+", "1"}], ")"}], 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"3", "\[CapitalLambda]", " ", "M", " ", "r"}], "+", 
          RowBox[{"6", 
           SuperscriptBox["M", "2"]}]}], 
         RowBox[{
          SuperscriptBox["r", "2"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
            RowBox[{"3", "M"}]}], ")"}]}]], 
        RowBox[{"Z", "[", "r", "]"}]}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{"r", "-", 
          RowBox[{"2", "M"}]}], "r"], 
        RowBox[{
         RowBox[{"Z", "'"}], "[", "r", "]"}]}], "-", 
       RowBox[{
        FractionBox[
         RowBox[{"r", 
          RowBox[{"(", 
           RowBox[{"r", "-", 
            RowBox[{"2", "M"}]}], ")"}]}], 
         RowBox[{
          RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
          RowBox[{"3", "M"}]}]], 
        RowBox[{"C1", "[", "r", "]"}]}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{"I", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"2", "M"}]}], ")"}], "2"]}], 
         RowBox[{"r", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
            RowBox[{"3", "M"}]}], ")"}]}]], 
        RowBox[{"C2", "[", "r", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"K", "'"}], "[", "r", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"\[CapitalLambda]", 
             RowBox[{"(", 
              RowBox[{"\[CapitalLambda]", "+", "1"}], ")"}], 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", "\[CapitalLambda]", " ", "M", " ", "r"}], "+", 
            RowBox[{"6", 
             SuperscriptBox["M", "2"]}]}], 
           RowBox[{
            SuperscriptBox["r", "2"], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
              RowBox[{"3", "M"}]}], ")"}]}]], 
          RowBox[{"Z", "[", "r", "]"}]}], "+", 
         RowBox[{
          FractionBox[
           RowBox[{"r", "-", 
            RowBox[{"2", "M"}]}], "r"], 
          RowBox[{
           RowBox[{"Z", "'"}], "[", "r", "]"}]}], "-", 
         RowBox[{
          FractionBox[
           RowBox[{"r", 
            RowBox[{"(", 
             RowBox[{"r", "-", 
              RowBox[{"2", "M"}]}], ")"}]}], 
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
            RowBox[{"3", "M"}]}]], 
          RowBox[{"C1", "[", "r", "]"}]}], "+", 
         RowBox[{
          FractionBox[
           RowBox[{"I", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"r", "-", 
               RowBox[{"2", "M"}]}], ")"}], "2"]}], 
           RowBox[{"r", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
              RowBox[{"3", "M"}]}], ")"}]}]], 
          RowBox[{"C2", "[", "r", "]"}]}]}], ",", "r"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"H1", "[", "r", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "I"}], " ", "\[Omega]", " ", 
        FractionBox[
         RowBox[{
          RowBox[{"\[CapitalLambda]", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", "\[CapitalLambda]", " ", "M", " ", "r"}], "-", 
          RowBox[{"3", 
           SuperscriptBox["M", "2"]}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", 
            RowBox[{"2", "M"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
            RowBox[{"3", "M"}]}], ")"}]}]], 
        RowBox[{"Z", "[", "r", "]"}]}], "-", 
       RowBox[{"I", " ", "\[Omega]", " ", "r", " ", 
        RowBox[{
         RowBox[{"Z", "'"}], "[", "r", "]"}]}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{"I", " ", "\[Omega]", " ", 
          SuperscriptBox["r", "3"]}], 
         RowBox[{
          RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
          RowBox[{"3", "M"}]}]], 
        RowBox[{"C1", "[", "r", "]"}]}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{"\[Omega]", " ", "r", 
          RowBox[{"(", 
           RowBox[{"r", "-", 
            RowBox[{"2", "M"}]}], ")"}]}], 
         RowBox[{
          RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
          RowBox[{"3", "M"}]}]], 
        RowBox[{"C2", "[", "r", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"H1", "'"}], "[", "r", "]"}], "\[Rule]", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[Omega]", " ", 
          FractionBox[
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", "\[CapitalLambda]", " ", "M", " ", "r"}], "-", 
            RowBox[{"3", 
             SuperscriptBox["M", "2"]}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", 
              RowBox[{"2", "M"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
              RowBox[{"3", "M"}]}], ")"}]}]], 
          RowBox[{"Z", "[", "r", "]"}]}], "-", 
         RowBox[{"I", " ", "\[Omega]", " ", "r", " ", 
          RowBox[{
           RowBox[{"Z", "'"}], "[", "r", "]"}]}], "+", 
         RowBox[{
          FractionBox[
           RowBox[{"I", " ", "\[Omega]", " ", 
            SuperscriptBox["r", "3"]}], 
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
            RowBox[{"3", "M"}]}]], 
          RowBox[{"C1", "[", "r", "]"}]}], "+", 
         RowBox[{
          FractionBox[
           RowBox[{"\[Omega]", " ", "r", 
            RowBox[{"(", 
             RowBox[{"r", "-", 
              RowBox[{"2", "M"}]}], ")"}]}], 
           RowBox[{
            RowBox[{"\[CapitalLambda]", " ", "r"}], "+", 
            RowBox[{"3", "M"}]}]], 
          RowBox[{"C2", "[", "r", "]"}]}]}], ",", "r"}], "]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.722074180407957*^9, 3.722074389530838*^9}, {
   3.722074545170093*^9, 3.722074610074334*^9}, {3.7220746822826233`*^9, 
   3.7220746887516403`*^9}, {3.7220747375517406`*^9, 3.7220747533519278`*^9}, 
   3.7220754375086*^9, {3.722076164475301*^9, 3.72207616810894*^9}, {
   3.722077388801*^9, 3.722077432943125*^9}, {3.7220778515474567`*^9, 
   3.722077880715076*^9}, {3.722078928961898*^9, 3.722078954214396*^9}, 
   3.722079101164535*^9, 3.722080997479847*^9, 3.722081094082453*^9, {
   3.722081218635447*^9, 3.722081232356407*^9}, {3.722083839539405*^9, 
   3.722083844716816*^9}, {3.7220839128764544`*^9, 3.722083935650793*^9}, {
   3.72208529576095*^9, 3.722085296103503*^9}, {3.7220911373119183`*^9, 
   3.722091141166253*^9}, {3.72209121567515*^9, 3.72209125439888*^9}, {
   3.7220921722968483`*^9, 3.72209221895007*^9}, {3.722093804228991*^9, 
   3.722093832569499*^9}, 3.722094003217143*^9, {3.7220942781287107`*^9, 
   3.722094312474874*^9}, 3.722103391574985*^9, {3.7231126727173977`*^9, 
   3.7231126748269978`*^9}, {3.7430305075071487`*^9, 
   3.743030539237896*^9}},ExpressionUUID->"6530f05e-8390-4056-bec8-\
76fddc0d76b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Zerilli1", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Polareq1", "//.", "rulesZ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Z", "''"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"Z", "'"}], "[", "r", "]"}], ",", 
       RowBox[{"Z", "[", "r", "]"}], ",", 
       RowBox[{"C1", "[", "r", "]"}], ",", 
       RowBox[{"C2", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"C1", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"C2", "'"}], "[", "r", "]"}]}], "}"}], ",", "Simplify"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.722074579847146*^9, 3.722074626823613*^9}, {
   3.722074703132201*^9, 3.722074716247244*^9}, {3.722074771604183*^9, 
   3.722074772172291*^9}, {3.722076281302424*^9, 3.7220762855426903`*^9}, {
   3.722077107702529*^9, 3.722077157904072*^9}, {3.722079008730913*^9, 
   3.722079059712919*^9}, {3.722079117787755*^9, 3.722079120063141*^9}, {
   3.7220794574332542`*^9, 3.722079458023574*^9}, {3.722079531259534*^9, 
   3.722079532459584*^9}, {3.722079676533901*^9, 3.722079680798176*^9}, {
   3.72208012657285*^9, 3.7220801368361187`*^9}, {3.7220802206412697`*^9, 
   3.7220802288660107`*^9}, 3.722080467248973*^9, 3.722081103734462*^9, {
   3.722081195541348*^9, 3.722081215318027*^9}, {3.72208393818515*^9, 
   3.7220839450903263`*^9}, {3.7220847838758993`*^9, 3.722084801780814*^9}, {
   3.722091147358222*^9, 3.7220911631365547`*^9}, {3.722091228084147*^9, 
   3.7220912368556223`*^9}, {3.7220926403871183`*^9, 3.722092645637363*^9}, {
   3.722093864149267*^9, 3.722093893699024*^9}, {3.7220939573084173`*^9, 
   3.722093975587535*^9}, 3.722106331227072*^9, {3.743017893627067*^9, 
   3.743017902369022*^9}, {3.7430305482868233`*^9, 3.743030550726491*^9}, {
   3.743030998753592*^9, 
   3.743030999205365*^9}},ExpressionUUID->"46277630-793e-46f8-aa0c-\
dc6061afd5dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Zerilli2", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Polareq2", "//.", "rulesZ"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Z", "''"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"Z", "'"}], "[", "r", "]"}], ",", 
       RowBox[{"Z", "[", "r", "]"}], ",", 
       RowBox[{"C1", "[", "r", "]"}], ",", 
       RowBox[{"C2", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"C1", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"C2", "'"}], "[", "r", "]"}]}], "}"}], ",", "Simplify"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.722094046482431*^9, {3.7220941572230463`*^9, 3.722094157387075*^9}, 
   3.7221063290725594`*^9, 3.743017908908083*^9, {3.743030556789645*^9, 
   3.7430305589705343`*^9}, {3.7430309965552483`*^9, 
   3.7430309970638027`*^9}},ExpressionUUID->"2de70361-dbe4-482f-9c1d-\
f8239a597d0a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rulesT", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Z", "''"}], "[", "r", "]"}], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"F", "'"}], "[", "r", "]"}], 
          SuperscriptBox[
           RowBox[{"F", "[", "r", "]"}], "2"]]}], 
        RowBox[{
         RowBox[{"Z", "'"}], "[", "\[ScriptR]", "]"}]}], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"Z", "''"}], "[", "\[ScriptR]", "]"}], 
        SuperscriptBox[
         RowBox[{"F", "[", "r", "]"}], "2"]]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Z", "'"}], "[", "r", "]"}], "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"Z", "'"}], "[", "\[ScriptR]", "]"}], 
       RowBox[{"F", "[", "r", "]"}]]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7220859027778273`*^9, 3.722085979029941*^9}, {
  3.7220860141209707`*^9, 3.722086018202242*^9}, {3.722094068843202*^9, 
  3.722094097370674*^9}, {3.743030561797768*^9, 
  3.7430305680632687`*^9}},ExpressionUUID->"306d68e4-41f9-4693-bb44-\
d5444ca17eb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "the", " ", "final", " ", "Zerilli", " ", 
    "equation", " ", "written", " ", "in", " ", "the", " ", "tortoise", " ", 
    RowBox[{"coordinate", ".", " ", "The"}], " ", "change", " ", "of", " ", 
    "coordinate", " ", "is", " ", "made", " ", "by", " ", 
    RowBox[{"the", " ", "'"}], 
    RowBox[{"rulesT", "'"}], " ", "replacement"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Zerillir", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"F", "[", "r", "]"}], "Zerilli1"}], "//.", "rulesT"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Z", "''"}], "[", "\[ScriptR]", "]"}], ",", 
       RowBox[{"Z", "[", "r", "]"}], ",", "\[Omega]", ",", 
       RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], "}"}], ",", 
     "Simplify"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.722094120425044*^9, 3.7220941356497087`*^9}, {
  3.722094191440975*^9, 3.7220941970709963`*^9}, {3.722102329368558*^9, 
  3.722102332162112*^9}, {3.7221037219906693`*^9, 3.722103726307385*^9}, {
  3.722375007796363*^9, 3.722375008668194*^9}, {3.743017031376333*^9, 
  3.743017086533031*^9}, {3.743017950852001*^9, 3.743017952263851*^9}, {
  3.7430305720772676`*^9, 
  3.743030573277422*^9}},ExpressionUUID->"b7a9067f-3b43-4075-a39a-\
ba31d79bdcdb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["M", "3"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["M", "2"], " ", "r", " ", "\[CapitalLambda]"}], "+", 
         
         RowBox[{"3", " ", "M", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[CapitalLambda]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[CapitalLambda]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[CapitalLambda]"}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "M"}], "+", 
          RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], "2"]}]], "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
   RowBox[{"Z", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"3", " ", "M"}], "+", 
    RowBox[{"r", " ", "\[CapitalLambda]"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", "\[Pi]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], "2"], " ", 
    RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "\[CapitalLambda]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "M"}], "+", 
      RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SqrtBox["2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}]}], 
   SqrtBox[
    RowBox[{"\[CapitalLambda]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[CapitalLambda]"}], ")"}]}]]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"8", " ", 
       SqrtBox["2"], " ", "M", " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "M"}], "-", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", "\[CapitalLambda]"}], ")"}]}]}], ")"}], " ", 
       RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}]}], 
      RowBox[{"r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "M"}], "+", 
          RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], "2"]}]]}], "-", 
    FractionBox[
     RowBox[{"4", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", 
            SuperscriptBox["M", "2"]}], "+", 
           RowBox[{"3", " ", "M", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "\[CapitalLambda]"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["r", "2"], " ", 
            SuperscriptBox["\[CapitalLambda]", "2"]}]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "M"}], "+", 
           RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["2"], " ", 
            SqrtBox[
             RowBox[{"1", "+", "\[CapitalLambda]"}]], " ", 
            RowBox[{
             SuperscriptBox["\[ScriptCapitalA]1", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[ScriptCapitalB]0", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
       ")"}]}], 
     RowBox[{"r", " ", 
      SqrtBox[
       RowBox[{"1", "+", "\[CapitalLambda]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "M"}], "+", 
         RowBox[{"r", " ", "\[CapitalLambda]"}]}], ")"}], "2"]}]]}], 
   "\[Omega]"], "+", 
  RowBox[{
   SuperscriptBox["Z", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "\[ScriptR]", "]"}]}]], "Output",
 CellChangeTimes->{{3.722094125846506*^9, 3.722094127998989*^9}, {
   3.722094170932856*^9, 3.722094197634387*^9}, 3.722094322599669*^9, 
   3.722102093200035*^9, 3.722102333519665*^9, 3.722103727456417*^9, 
   3.7221063409975452`*^9, 3.7223303409791393`*^9, 3.722365452531495*^9, {
   3.722374917691697*^9, 3.7223749573632812`*^9}, 3.722375009771248*^9, {
   3.722375055538309*^9, 3.722375063428301*^9}, 3.722375096762747*^9, 
   3.7224157407944107`*^9, 3.7224222266715517`*^9, 3.7224222576730537`*^9, 
   3.7225775207630653`*^9, 3.7225859220032253`*^9, 3.72258606155147*^9, 
   3.722586111107759*^9, 3.723112563612678*^9, 3.723112680812965*^9, 
   3.723113706317268*^9, 3.732091447616282*^9, 3.732091571903943*^9, 
   3.7320922238858013`*^9, {3.732093243838066*^9, 3.732093271635236*^9}, 
   3.732094759177849*^9, 3.732096691045718*^9, 3.732096929384301*^9, 
   3.743016493774279*^9, 3.743016996536653*^9, {3.7430179507449703`*^9, 
   3.743017953165889*^9}, 3.743030575714624*^9, 3.743030963741543*^9, 
   3.743031002183964*^9},ExpressionUUID->"eedee84c-98f0-43bc-9c69-\
0edc259cb4a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "everything"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Polar_GR.m\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "Polareq1", ",", "Polareq2", ",", "sH2", ",", "Zerilli1", ",", 
      "Zerilli2", ",", "Zerillir"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.722415947503566*^9, 3.72241597637927*^9}, {
   3.722416032419753*^9, 3.722416033478458*^9}, {3.7231122545607843`*^9, 
   3.723112255935237*^9}, 3.7430165117648687`*^9, 3.7430170204100533`*^9, {
   3.743017089347632*^9, 3.743017090082985*^9}, {3.743039237730448*^9, 
   3.743039245081592*^9}},ExpressionUUID->"4a464233-fbb4-43cc-9ef7-\
c58402953ef8"],

Cell[BoxData["\<\"Polar_GR.m\"\>"], "Output",
 CellChangeTimes->{
  3.722416034887545*^9, 3.7225859314410963`*^9, 3.7225861129535933`*^9, 
   3.723112563725656*^9, 3.723112685263801*^9, 3.7231137064500523`*^9, 
   3.732091447697033*^9, 3.732091572014289*^9, 3.732092223997023*^9, {
   3.7320932439601603`*^9, 3.732093271728449*^9}, 3.732094759274029*^9, 
   3.7320969305864563`*^9, 3.743017090492552*^9, 3.743017966870249*^9, 
   3.743030579204768*^9, 
   3.74303100503202*^9},ExpressionUUID->"3bfe46b7-aa49-443d-9a3b-\
1c4f34f0027d"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1021, 749},
WindowMargins->{{89, Automatic}, {7, Automatic}},
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 330, 7, 160, "Title",ExpressionUUID->"e168f81b-5a28-4bfd-8462-fe9e95f53356"],
Cell[913, 31, 227, 5, 30, "Input",ExpressionUUID->"4eaac8f0-168c-40d2-a1b3-23243a790dc6"],
Cell[1143, 38, 1431, 32, 115, "Input",ExpressionUUID->"96414fa7-5495-488a-83f9-a390a5aa4ecb"],
Cell[CellGroupData[{
Cell[2599, 74, 542, 12, 52, "Input",ExpressionUUID->"52bd16fd-d6b3-4f3f-83a7-794660fcd830"],
Cell[3144, 88, 7458, 106, 24, "Print",ExpressionUUID->"d84e5235-423b-41dd-afeb-34d1cd98c61d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10639, 199, 179, 3, 67, "Section",ExpressionUUID->"fabf640a-00b2-48d3-af84-61732c19ce93"],
Cell[CellGroupData[{
Cell[10843, 206, 467, 9, 54, "Subsection",ExpressionUUID->"a8bd15ea-9f5d-414d-9f73-08a7ae5b7998"],
Cell[11313, 217, 245, 6, 35, "Item",ExpressionUUID->"181f4e91-7c05-49c6-ae47-ceb7a05320af"],
Cell[11561, 225, 10364, 313, 503, "Input",ExpressionUUID->"203f779d-ed50-4ac4-89bf-259d7e53999a"],
Cell[21928, 540, 206, 5, 35, "Item",ExpressionUUID->"6196eb92-c97c-42de-b82b-385984f59205"],
Cell[22137, 547, 1926, 48, 73, "Input",ExpressionUUID->"440e02ea-38ea-4e5d-a646-b57a2a7f96bd"],
Cell[24066, 597, 283, 6, 35, "Item",ExpressionUUID->"d00a41e1-bd43-46a5-95a3-24522bb1f5c3"],
Cell[24352, 605, 3670, 113, 160, "Input",ExpressionUUID->"90533c90-a0cf-4f1a-8002-c48e900ddb20"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28059, 723, 331, 5, 54, "Subsection",ExpressionUUID->"8db395b1-910a-4ab1-b06d-6f8d63f42705"],
Cell[28393, 730, 322, 7, 30, "Input",ExpressionUUID->"6c9dce83-ebb8-472c-8352-aaa8a06a0abe"],
Cell[28718, 739, 7449, 144, 240, "Input",ExpressionUUID->"92e16bb5-6f1c-4ed5-9ecc-74cc60d7e71e"],
Cell[36170, 885, 2720, 50, 89, "Input",ExpressionUUID->"c5e6dd16-db42-4e5c-a1f7-a04c51102ebb"],
Cell[38893, 937, 876, 20, 47, "Input",ExpressionUUID->"44cd571b-7c70-459e-aaa2-b708157d0205"],
Cell[CellGroupData[{
Cell[39794, 961, 1128, 20, 52, "Input",ExpressionUUID->"eb64f440-8946-446d-889a-5eb313f18886"],
Cell[40925, 983, 623, 10, 34, "Output",ExpressionUUID->"ecec48f7-def2-49a1-9be2-fea6585c73a3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41597, 999, 231, 4, 38, "Subsection",ExpressionUUID->"3c4eafdb-8e57-4d45-abc6-c5a273f4c0fa"],
Cell[41831, 1005, 269, 6, 30, "Input",ExpressionUUID->"fed6a889-4630-4fa4-9366-b3a6b0bd8587"],
Cell[CellGroupData[{
Cell[42125, 1015, 1503, 37, 52, "Input",ExpressionUUID->"79034a09-fee6-4e67-b4f9-ccdd079680e9"],
Cell[43631, 1054, 1634, 26, 50, "Output",ExpressionUUID->"b2d4a6cc-d9aa-4564-a617-c7ea238a1e94"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45302, 1085, 416, 12, 45, "Subsubsection",ExpressionUUID->"133baa33-de4c-4e2e-9954-fbf957f0a50a"],
Cell[45721, 1099, 413, 9, 30, "Input",ExpressionUUID->"b74164af-52e4-4c4d-b546-406715c9c683"],
Cell[46137, 1110, 31225, 904, 995, "Input",ExpressionUUID->"98e86cda-99e5-4a97-9a4b-67747cb95ebe"]
}, Closed]],
Cell[CellGroupData[{
Cell[77399, 2019, 301, 4, 37, "Subsubsection",ExpressionUUID->"5e2f12fa-a10c-421c-8f3e-eaec701e14ee"],
Cell[77703, 2025, 923, 21, 73, "Input",ExpressionUUID->"512fd927-3831-4e0c-8dc7-99a29c3d385d"],
Cell[78629, 2048, 226, 6, 30, "Input",ExpressionUUID->"5d7ce6b7-eaaf-4293-8da9-950047738d6d"],
Cell[CellGroupData[{
Cell[78880, 2058, 2183, 54, 81, "Input",ExpressionUUID->"9225f7c9-e838-4a5e-a0e0-b786871f5bef"],
Cell[81066, 2114, 4157, 88, 73, "Output",ExpressionUUID->"9f70ec5b-4402-4b6e-8e4d-eded32bb8d7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85260, 2207, 1998, 56, 81, "Input",ExpressionUUID->"5b5b58ec-a05d-4473-a617-7b4a5dd4c2be"],
Cell[87261, 2265, 3089, 73, 68, "Output",ExpressionUUID->"744d8e03-58a0-44a0-8391-8200e171996d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90387, 2343, 1461, 42, 50, "Input",ExpressionUUID->"8953c7a4-4e4f-431c-93e9-a7564ebf333e"],
Cell[91851, 2387, 2782, 62, 68, "Output",ExpressionUUID->"69871cdb-0760-4937-bc68-e974b62f8fba"]
}, Open  ]],
Cell[94648, 2452, 347, 10, 30, "Input",ExpressionUUID->"63d0ae0f-e0cc-4798-a6c1-a87f80be97c6"],
Cell[CellGroupData[{
Cell[95020, 2466, 1414, 41, 50, "Input",ExpressionUUID->"78267c2c-ec20-4be5-b10c-5d90b25c07dd"],
Cell[96437, 2509, 2921, 75, 76, "Output",ExpressionUUID->"6f580163-9b39-493d-b221-8632acfe86b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99395, 2589, 1418, 41, 50, "Input",ExpressionUUID->"85916127-36c9-4ac9-97a0-e949b24ea540"],
Cell[100816, 2632, 2474, 63, 60, "Output",ExpressionUUID->"94a65827-9b0c-401a-ad29-c353d30c50c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103327, 2700, 1388, 41, 50, "Input",ExpressionUUID->"6d2db3ba-5c96-4af3-9895-474e3e3f6c1a"],
Cell[104718, 2743, 4062, 100, 123, "Output",ExpressionUUID->"71d882e6-58f4-4e66-a371-4b9b709e2323"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108817, 2848, 1439, 41, 50, "Input",ExpressionUUID->"7a877874-da37-4250-bd5a-f9382abece52"],
Cell[110259, 2891, 2070, 50, 68, "Output",ExpressionUUID->"4fa42de4-9809-4fc3-bd65-6dafb5fc6096"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112366, 2946, 1390, 41, 50, "Input",ExpressionUUID->"0f8bc419-5d7f-4de2-8323-9235a34fb962"],
Cell[113759, 2989, 3725, 105, 133, "Output",ExpressionUUID->"fcc459b9-4efc-4cfc-9a8f-7414a5d41cce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117521, 3099, 1486, 42, 50, "Input",ExpressionUUID->"99190072-154c-4b59-8236-9ef74d137ad1"],
Cell[119010, 3143, 1646, 36, 68, "Output",ExpressionUUID->"5f0b2fb6-29a6-4e99-952b-f0417c6b65b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120693, 3184, 1975, 54, 83, "Input",ExpressionUUID->"1ee55b8c-5976-436f-b862-0cfb4ecb4ddd"],
Cell[122671, 3240, 5805, 145, 116, "Output",ExpressionUUID->"06f3bc0b-94b4-46ce-a902-6e9e2efe32ba"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[128537, 3392, 365, 5, 38, "Subsection",ExpressionUUID->"e30245dd-966b-4303-9a1e-bd2eaa7e3d3d"],
Cell[128905, 3399, 799, 24, 37, "Item",ExpressionUUID->"1f76fd98-90cc-4075-932a-2780fffa9ac2"],
Cell[CellGroupData[{
Cell[129729, 3427, 1932, 45, 56, "Input",ExpressionUUID->"536678a3-4f01-45a4-a6a9-7d656ce5148b"],
Cell[131664, 3474, 2951, 65, 66, "Output",ExpressionUUID->"d7baddd6-3ba0-46fd-8899-dc6c5823481e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134652, 3544, 1822, 42, 56, "Input",ExpressionUUID->"2b85b2d6-f5cb-4055-a4df-ee74612f66c2"],
Cell[136477, 3588, 2601, 58, 66, "Output",ExpressionUUID->"36f4096c-e14e-486b-bba2-9e495b143285"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139115, 3651, 1428, 33, 49, "Input",ExpressionUUID->"5dbd577f-8420-46bb-a778-99552453f465"],
Cell[140546, 3686, 2291, 51, 66, "Output",ExpressionUUID->"3fffdf34-277c-4c82-83be-ab890cc58567"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142874, 3742, 246, 4, 45, "Subsubsection",ExpressionUUID->"05fb57f9-6201-419b-bc49-ab41fcf545a4"],
Cell[143123, 3748, 1653, 50, 70, "Input",ExpressionUUID->"59ec22c5-a6bd-497d-931c-8dbcecd55a47"],
Cell[CellGroupData[{
Cell[144801, 3802, 1070, 28, 52, "Input",ExpressionUUID->"a926918b-a06f-4c5c-b3a2-f2768d9109c7"],
Cell[145874, 3832, 1938, 47, 66, "Output",ExpressionUUID->"5023a930-1574-4115-859f-03d473a4a46d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147849, 3884, 1518, 38, 52, "Input",ExpressionUUID->"8fb4fc6e-c6fd-450c-9000-f052f05503bb"],
Cell[149370, 3924, 3682, 102, 129, "Output",ExpressionUUID->"44936e09-53e2-4c3f-b08a-d8ba6d5e5d6c"]
}, Open  ]],
Cell[153067, 4029, 466, 11, 30, "Input",ExpressionUUID->"d7c28f68-88d0-4234-8cce-c9ad564a061b"],
Cell[153536, 4042, 1302, 36, 51, "Input",ExpressionUUID->"f1f58e2d-dc03-48ed-a5fd-8367835c459c"],
Cell[CellGroupData[{
Cell[154863, 4082, 1224, 28, 30, "Input",ExpressionUUID->"7bec4c36-2bff-4876-9726-579404f62408"],
Cell[156090, 4112, 3518, 94, 124, "Output",ExpressionUUID->"fa2ff00e-19d8-4652-9551-65929a09bd06"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159645, 4211, 383, 8, 30, "Input",ExpressionUUID->"cd0f69bc-6b36-46a2-88a9-6572c60f43e0"],
Cell[160031, 4221, 439, 7, 34, "Output",ExpressionUUID->"f71fe644-c867-4ac1-b00b-c346a02141ed"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[160531, 4235, 295, 4, 38, "Subsection",ExpressionUUID->"098ef589-5353-4101-9145-fc17f1d0816d"],
Cell[CellGroupData[{
Cell[160851, 4243, 169, 3, 45, "Subsubsection",ExpressionUUID->"4385ff42-81a6-4a7d-9f6a-492d73ca386b"],
Cell[161023, 4248, 765, 26, 36, "Item",ExpressionUUID->"c0000f17-efe0-4373-9c31-6846ad781ac7"],
Cell[CellGroupData[{
Cell[161813, 4278, 1811, 39, 56, "Input",ExpressionUUID->"b804f3c3-a64d-4fd0-9357-be750b109b18"],
Cell[163627, 4319, 3855, 91, 54, "Output",ExpressionUUID->"1cbb1a1f-5a18-4d60-ba41-96c7dfaa7b79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167519, 4415, 920, 25, 33, "Input",ExpressionUUID->"fe821992-b231-42fe-8bf5-64716d9f02f7"],
Cell[168442, 4442, 1731, 42, 52, "Output",ExpressionUUID->"cd9e0b3c-4ce8-4e8d-b4db-a5a427fc64f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170210, 4489, 1057, 28, 56, "Input",ExpressionUUID->"85a1fd9b-e6b1-4da5-a81d-26abdc716476"],
Cell[171270, 4519, 2542, 72, 59, "Output",ExpressionUUID->"28678355-a19c-427c-b5ba-d9f9bb7dcdce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173849, 4596, 1230, 34, 56, "Input",ExpressionUUID->"d8c4c77d-bd31-4f92-accb-06f0770be219"],
Cell[175082, 4632, 1497, 35, 59, "Output",ExpressionUUID->"cc3ddf2f-ff04-4203-94aa-d2ca1f107989"]
}, Open  ]],
Cell[CellGroupData[{
Cell[176616, 4672, 1320, 36, 56, "Input",ExpressionUUID->"b629654e-10a6-4c83-a21e-a864becaea2f"],
Cell[177939, 4710, 1955, 54, 59, "Output",ExpressionUUID->"c49f8cd3-f0ad-49f5-bfa7-10e7f675896f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179931, 4769, 946, 24, 33, "Input",ExpressionUUID->"61e358da-e6df-41c2-bc3d-21fd69f63d1a"],
Cell[180880, 4795, 1207, 28, 60, "Output",ExpressionUUID->"50cf3fd7-139d-4ce3-9e33-eb951b7a3331"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182124, 4828, 1264, 34, 77, "Input",ExpressionUUID->"a398370e-b2a4-4673-9b28-fd6db3a3591d"],
Cell[183391, 4864, 3254, 93, 98, "Output",ExpressionUUID->"7523e372-b713-45f5-85d7-0293aa1d9489"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[186694, 4963, 172, 3, 37, "Subsubsection",ExpressionUUID->"d664c91a-7373-4e61-84f9-2587f1854be6"],
Cell[CellGroupData[{
Cell[186891, 4970, 1010, 27, 52, "Input",ExpressionUUID->"93d1a78a-16ca-4ce3-8cc9-84cab3ede549"],
Cell[187904, 4999, 1454, 36, 57, "Output",ExpressionUUID->"55e3a03e-c23d-49e1-b094-158ec706a66e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189395, 5040, 1080, 28, 52, "Input",ExpressionUUID->"7c446c9e-3820-41bb-a6f2-d0f171aaa361"],
Cell[190478, 5070, 1713, 42, 60, "Output",ExpressionUUID->"3fb3c7d9-034e-4ba2-8ca2-a068c7e641bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192228, 5117, 658, 18, 52, "Input",ExpressionUUID->"b0062bd7-fa25-4463-b726-b4b921219d57"],
Cell[192889, 5137, 1265, 31, 60, "Output",ExpressionUUID->"032860d7-6145-4c03-8158-ed9a9efd227e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194191, 5173, 1894, 48, 73, "Input",ExpressionUUID->"9e5ec370-7e0e-40d7-bb7a-d495cb212732"],
Cell[196088, 5223, 3059, 87, 101, "Output",ExpressionUUID->"9330f2ea-af77-4928-a5ac-34003f28aab7"]
}, Open  ]],
Cell[199162, 5313, 291, 7, 30, "Input",ExpressionUUID->"366b2e05-1190-4c7f-8eb4-34f4e22bf7b5"],
Cell[CellGroupData[{
Cell[199478, 5324, 1296, 35, 52, "Input",ExpressionUUID->"f1d0120a-cc4e-4a76-9295-8234f899cac4"],
Cell[200777, 5361, 1981, 50, 57, "Output",ExpressionUUID->"a84a2898-5b08-4591-8967-0b0dc2d79670"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202795, 5416, 1540, 39, 56, "Input",ExpressionUUID->"0ced29ef-52d8-46b1-82ef-6a86c460123c"],
Cell[204338, 5457, 3032, 84, 106, "Output",ExpressionUUID->"bea86432-bbce-4ee9-ae5e-420e28a0527c"]
}, Open  ]],
Cell[207385, 5544, 550, 11, 52, "Input",ExpressionUUID->"4feaae96-7cbb-4d69-a634-994009c3ee03"],
Cell[CellGroupData[{
Cell[207960, 5559, 912, 23, 30, "Input",ExpressionUUID->"0518c060-c6a1-47e4-8f04-c887bf0fd53c"],
Cell[208875, 5584, 3838, 112, 106, "Output",ExpressionUUID->"dc7ec035-9bed-4595-b207-8ecd223e0249"]
}, Open  ]],
Cell[212728, 5699, 522, 12, 30, "Input",ExpressionUUID->"0cb6c0b1-655e-4f5d-9238-03dc7d67c16c"],
Cell[CellGroupData[{
Cell[213275, 5715, 1005, 22, 30, "Input",ExpressionUUID->"c878273c-e584-419d-abaa-38743a0f3ebe"],
Cell[214283, 5739, 4166, 125, 108, "Output",ExpressionUUID->"0af36abe-1185-4698-98d3-8cb8b737d350"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218486, 5869, 915, 21, 30, "Input",ExpressionUUID->"1e3d1839-c675-4bd6-8d47-6896fafa5ed8"],
Cell[219404, 5892, 4711, 137, 109, "Output",ExpressionUUID->"fc384a06-0b10-407b-b2e3-667c08219002"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[224164, 6035, 258, 5, 37, "Subsubsection",ExpressionUUID->"388901a3-318c-4f8e-b52f-335c83e9f381"],
Cell[CellGroupData[{
Cell[224447, 6044, 1109, 27, 68, "Input",ExpressionUUID->"603b4c58-f3bc-4e12-8bec-ea5a6d0a4741"],
Cell[225559, 6073, 3819, 108, 108, "Output",ExpressionUUID->"2e8b8bf8-ed7e-4dfd-a171-781ce7cefe57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[229415, 6186, 1130, 28, 68, "Input",ExpressionUUID->"ae07ebff-665d-4810-9652-1a39f01247c3"],
Cell[230548, 6216, 4477, 123, 109, "Output",ExpressionUUID->"8a866805-f830-40f6-8272-dbb6a6947953"]
}, Open  ]],
Cell[235040, 6342, 2005, 53, 74, "Input",ExpressionUUID->"d45bbced-6bba-4f28-a330-5caf9f198bfa"],
Cell[237048, 6397, 1060, 28, 51, "Input",ExpressionUUID->"9cafac55-53be-4a18-8d84-543a0b19361b"],
Cell[238111, 6427, 1536, 48, 51, "Input",ExpressionUUID->"77361130-3bd6-4a9f-bb0a-c721c2c12f3b"],
Cell[239650, 6477, 7679, 210, 192, "Input",ExpressionUUID->"6530f05e-8390-4056-bec8-76fddc0d76b3"],
Cell[247332, 6689, 1922, 38, 30, "Input",ExpressionUUID->"46277630-793e-46f8-aa0c-dc6061afd5dc"],
Cell[249257, 6729, 937, 25, 30, "Input",ExpressionUUID->"2de70361-dbe4-482f-9c1d-f8239a597d0a"],
Cell[250197, 6756, 1158, 34, 51, "Input",ExpressionUUID->"306d68e4-41f9-4693-bb44-d5444ca17eb1"],
Cell[CellGroupData[{
Cell[251380, 6794, 1566, 34, 73, "Input",ExpressionUUID->"b7a9067f-3b43-4075-a39a-ba31d79bdcdb"],
Cell[252949, 6830, 5965, 162, 171, "Output",ExpressionUUID->"eedee84c-98f0-43bc-9c69-0edc259cb4a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[258951, 6997, 730, 16, 52, "Input",ExpressionUUID->"4a464233-fbb4-43cc-9ef7-c58402953ef8"],
Cell[259684, 7015, 534, 9, 34, "Output",ExpressionUUID->"3bfe46b7-aa49-443d-9a3b-1c4f34f0027d"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

