(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     37708,       1013]
NotebookOptionsPosition[     35546,        974]
NotebookOutlinePosition[     35936,        991]
CellTagsIndexPosition[     35893,        988]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Tensor harmonic decomposition of the stress energy tenor [I use the \
definition of Sago et al. PRD 67, 10 (2003)]\
\>", "Title",
 CellChangeTimes->{{3.722026108833889*^9, 3.722026133002123*^9}, {
  3.722063827267627*^9, 3.722063838046527*^9}, {3.7430144054961233`*^9, 
  3.743014406101254*^9}, {3.743141311378474*^9, 3.743141324475316*^9}, {
  3.743149280201743*^9, 
  3.743149287957755*^9}},ExpressionUUID->"e168f81b-5a28-4bfd-8462-\
fe9e95f53356"],

Cell[BoxData[
 RowBox[{"Exit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.72198799897161*^9, 3.72198799990344*^9}, {
  3.743016558004128*^9, 
  3.7430165586531563`*^9}},ExpressionUUID->"4eaac8f0-168c-40d2-a1b3-\
23243a790dc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{"M", ">", "0"}], ",", 
     RowBox[{"l", ">=", "0"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"L", ",", "Integers"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"m", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"\[Gamma]", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"u0", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"ur", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"\[Phi]", "[", "t", "]"}], ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"\[Delta]", "[", 
        RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}], "]"}], ",", 
       "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{
       RowBox[{"\[Delta]", "[", 
        RowBox[{"r", "-", "rp"}], "]"}], ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"l", ",", "Integers"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.717417827152334*^9, 3.717417827545067*^9}, {
   3.720525806525712*^9, 3.72052580687288*^9}, {3.720960445169264*^9, 
   3.72096044584095*^9}, {3.721032400106536*^9, 3.721032401314507*^9}, 
   3.722585389504361*^9, {3.724767015218999*^9, 3.724767015946599*^9}, {
   3.724767570416555*^9, 3.7247675708351393`*^9}, {3.724768211416267*^9, 
   3.72476822262503*^9}, {3.7247869373512907`*^9, 3.724786939953195*^9}, {
   3.7258011818217373`*^9, 3.725801182345151*^9}, {3.743014362739792*^9, 
   3.74301438172966*^9}, {3.7430151467686777`*^9, 3.7430151474379272`*^9}, 
   3.743043716425914*^9, {3.743085247427491*^9, 3.743085312550449*^9}, {
   3.743085343868717*^9, 3.743085367726759*^9}, {3.743139144685206*^9, 
   3.743139174882268*^9}, {3.743146362787766*^9, 3.743146400150372*^9}, 
   3.743146520220755*^9, {3.743149297130035*^9, 
   3.743149297875462*^9}},ExpressionUUID->"96414fa7-5495-488a-83f9-\
a390a5aa4ecb"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "This", " ", "is", " ", "the", " ", "general", " ", "form", " ", "of", " ", 
   "the", " ", "tensorial", " ", "harmonics"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743078054527278*^9, 
  3.743078067320856*^9}},ExpressionUUID->"f91663c2-968c-4aff-8901-\
126d2ee241c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalY]", "=", 
   RowBox[{"SphericalHarmonicY", "[", 
    RowBox[{"l", ",", "m", ",", "\[Theta]", ",", 
     RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.743149240470027*^9},ExpressionUUID->"ad50bbdc-2a5c-426f-806a-\
c051b6475e5e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[ScriptCapitalY]", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{
    FractionBox["I", 
     RowBox[{"Sqrt", "[", "2", "]"}]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "\[ScriptCapitalY]", ",", "0", ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\[ScriptCapitalY]", ",", "0", ",", "0", ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[ScriptCapitalY]", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b0", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"I", " ", "r"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", 
          RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}], ",", "0", ",",
         "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", 
          RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}], ",", "0", ",", "0", ",",
         "0"}], "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    FractionBox["r", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", 
          RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}], ",", "0", ",",
         "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", 
          RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}], ",", "0", ",", "0"}], 
       "}"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0", "=", 
   RowBox[{
    FractionBox["r", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "S\[Theta]", ",", "S\[Phi]"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"S\[Theta]", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"S\[Phi]", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"I", " ", "r"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "S\[Theta]", ",", "S\[Phi]"}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"0", ",", "S\[Theta]", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "S\[Phi]", ",", "0", ",", "0"}], "}"}]}], "}"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"I", " ", 
       SuperscriptBox["r", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "l", 
         RowBox[{"(", 
          RowBox[{"l", "+", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"l", "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"l", "+", "2"}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "2"}]]]}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", 
         FractionBox["X", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "W"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "W"}], ",", 
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "X"}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["r", "2"], 
     RowBox[{"Sqrt", "[", "2", "]"}]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "\[ScriptCapitalY]", ",", "0"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], 
         "\[ScriptCapitalY]"}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["r", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "l", 
        RowBox[{"(", 
         RowBox[{"l", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"l", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"l", "+", "2"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "2"}]]], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "W", ",", "X"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "X", ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "W"}]}], "}"}]}], 
     "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7219967315908012`*^9, 3.721996767646525*^9}, {
   3.721996803121952*^9, 3.721996833120118*^9}, {3.722001499332003*^9, 
   3.722001500931719*^9}, {3.722014586063696*^9, 3.722014603990048*^9}, 
   3.7220155408044853`*^9, {3.72201562220982*^9, 3.722015718196847*^9}, {
   3.722017307911832*^9, 3.722017375976766*^9}, {3.722017435818725*^9, 
   3.7220176066663427`*^9}, {3.722017637221691*^9, 3.722017644898293*^9}, 
   3.722022261194623*^9, {3.743143298679494*^9, 3.743143302917068*^9}, {
   3.7431433704125013`*^9, 
   3.743143453986491*^9}},ExpressionUUID->"203f779d-ed50-4ac4-89bf-\
259d7e53999a"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Axial", " ", "and", " ", "Polar", " ", "components", " ", "of", " ", "the",
    " ", "stress", " ", "energy", " ", "tensor"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7430780718721447`*^9, 
  3.743078098412644*^9}},ExpressionUUID->"41465dda-12b7-4b08-af9f-\
c55513a7f796"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Delta]TA", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"\[ScriptCapitalQ]0", "[", "r", "]"}], "c0"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalQ]", "[", "r", "]"}], "c"}], "+", 
      RowBox[{
       RowBox[{"\[ScriptCapitalD]", "[", "r", "]"}], "d"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]TP", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalA]0", "[", "r", "]"}], "a0"}], "+", 
     RowBox[{
      RowBox[{"\[ScriptCapitalA]1", "[", "r", "]"}], "a1"}], "+", 
     RowBox[{
      RowBox[{"\[ScriptCapitalA]", "[", "r", "]"}], "a"}], "+", 
     RowBox[{
      RowBox[{"\[ScriptCapitalB]0", "[", "r", "]"}], "b0"}], "+", 
     RowBox[{
      RowBox[{"\[ScriptCapitalB]", "[", "r", "]"}], "b"}], "+", 
     RowBox[{
      RowBox[{"\[ScriptCapitalG]", "[", "r", "]"}], "g"}], "+", 
     RowBox[{
      RowBox[{"\[ScriptCapitalF]", "[", "r", "]"}], "f"}]}], ")"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.721997197972341*^9, 3.721997297190443*^9}, {
   3.721997560941536*^9, 3.7219975841694517`*^9}, {3.722000088677917*^9, 
   3.722000091009444*^9}, {3.72200263539139*^9, 3.7220026401269712`*^9}, {
   3.7220184739630613`*^9, 3.722018541451301*^9}, 3.722018591044235*^9, {
   3.7220208056287193`*^9, 3.7220208408907433`*^9}, {3.722421167440812*^9, 
   3.7224211711318617`*^9}, {3.722585397840612*^9, 3.7225854001822433`*^9}, {
   3.7320912748540277`*^9, 3.7320912799201612`*^9}, {3.732091766552846*^9, 
   3.732091768297843*^9}, {3.7430783980131607`*^9, 
   3.743078399766634*^9}},ExpressionUUID->"31dd3f7a-f65b-4153-8219-\
0c511bd09573"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]T", "=", 
   RowBox[{"\[Delta]TA", "+", "\[Delta]TP"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743078102368733*^9, 
  3.743078120035186*^9}},ExpressionUUID->"05bf97d7-0967-4eb0-a596-\
a3f8258bfbaa"],

Cell[CellGroupData[{

Cell["\<\
Projection on the spherical harmonics to find the coefficients of the \
decomposition\
\>", "Subsubsection",
 CellChangeTimes->{{3.732104140297338*^9, 3.732104148506465*^9}, {
  3.7430814355682993`*^9, 3.743081479843699*^9}, {3.743149760422682*^9, 
  3.7431497622560663`*^9}},ExpressionUUID->"79404e4e-f297-4fce-8d17-\
508944f2dab9"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Spherical", " ", 
    RowBox[{"Harmonics", ".", " ", "I"}], " ", "actually", " ", "leave", " ", 
    "them", " ", "without", " ", "specifying", " ", "the", " ", "values", " ",
     "of", " ", "l", " ", "and", " ", "m"}], ",", " ", 
   RowBox[{
   "since", " ", "the", " ", "results", " ", "has", " ", "to", " ", "be", " ",
     "general"}]}], "  ", "*)"}]], "Input",
 CellChangeTimes->{{3.743139872451557*^9, 
  3.743139918168522*^9}},ExpressionUUID->"58c5c882-a346-4fd9-8ef7-\
e04a79ff5e82"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"S\[Theta]", ",", "S\[Phi]"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"D", "[", 
       RowBox[{"\[ScriptCapitalY]", ",", 
        RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
      RowBox[{"D", "[", 
       RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"X", ",", "W"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}], ",", 
          RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}]}], "-", 
       RowBox[{"2", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Cot", "[", "\[Theta]", "]"}], "\[ScriptCapitalY]"}], ",", 
          
          RowBox[{"\[Phi]", "[", "t", "]"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"\[ScriptCapitalY]", ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "2"}], "}"}]}], "]"}], "-", 
       RowBox[{
        RowBox[{"Cot", "[", "\[Theta]", "]"}], 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", "\[Theta]"}], "]"}]}], "-", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
        RowBox[{"D", "[", 
         RowBox[{"\[ScriptCapitalY]", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\[Phi]", "[", "t", "]"}], ",", "2"}], "}"}]}], "]"}]}]}],
       "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.732103962820665*^9, 3.732103985372451*^9}, {
   3.732104085204912*^9, 3.7321040996541567`*^9}, {3.7430860060809317`*^9, 
   3.743086069410095*^9}, 3.743086106113225*^9, {3.7431391935260143`*^9, 
   3.743139194529022*^9}, {3.743143110960881*^9, 3.743143190988963*^9}, {
   3.7431433144018517`*^9, 3.743143359172611*^9}, 
   3.7431492351547823`*^9},ExpressionUUID->"1ff5c95f-896c-46e1-8896-\
ebe5f75233e5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Eta]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox["1", 
        SuperscriptBox["r", "2"]], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["r", "2"], 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[ScriptG]0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", 
           RowBox[{"M", "/", "r"}]}]}], ")"}]}], ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", 
           RowBox[{"M", "/", "r"}]}]}], ")"}]], ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       SuperscriptBox["r", "2"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", 
       RowBox[{
        SuperscriptBox["r", "2"], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.732099611788273*^9, 3.732099641547619*^9}, 
   3.7321041589116907`*^9, {3.743138907294696*^9, 3.743138925457258*^9}, {
   3.743145558534256*^9, 
   3.743145562586051*^9}},ExpressionUUID->"3b13be2a-ce5f-4dfd-a1b4-\
70c75c75933e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "velocity", " ", "inside", " ", "the", " ", "definition", " ", "of", " ", 
    "the", " ", "stress", " ", "energy", " ", "tensor", " ", 
    RowBox[{"(", 
     RowBox[{
     "it", " ", "is", " ", "in", " ", "the", " ", "pdf", " ", "as", " ", 
      RowBox[{"well", ".", " ", "Note"}], " ", "that", " ", 
      "\[IndentingNewLine]", "this", " ", "is", " ", 
      RowBox[{
       SuperscriptBox["dx", "\[Mu]"], "/", "dt"}], " ", "not", " ", 
      RowBox[{
       SuperscriptBox["dx", "\[Mu]"], "/", "d\[Tau]"}]}], " "}]}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "I", " ", "just", " ", "repalced", " ", "the", " ", "component", " ", 
     "of", " ", "the", " ", "\[Phi]", " ", "component", " ", "of", " ", "the",
      " ", "velocity", " ", "in", " ", "order", " ", "to", " ", "match", " ", 
     "the", " ", "results", " ", "by", " ", "Sago", " ", "et", " ", 
     RowBox[{"al", ".", " ", "At"}], " ", "the", " ", "same", " ", "time", 
     " ", "dR", " ", "is", " ", "a", " ", "shorthand", " ", "for", " ", 
     FractionBox[
      SubscriptBox["dr", "p"], "dt"]}], "=", 
    RowBox[{
     SuperscriptBox["v", "r"], "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "dR", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"I", "/", "m"}], "/", 
         RowBox[{"\[ScriptCapitalY]", "\[Conjugate]"}]}], " ", 
        "d\[ScriptCapitalY]dt"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{"mp", " ", "\[Gamma]", " ", 
      RowBox[{"Outer", "[", 
       RowBox[{"Times", ",", "v", ",", "v"}], "]"}], 
      FractionBox[
       RowBox[{
        RowBox[{"DiracDelta", "[", 
         RowBox[{"r", "-", "rp"}], "]"}], " ", 
        RowBox[{"DiracDelta", "[", 
         RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}], "]"}]}], 
       SuperscriptBox["r", "2"]]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.732099962559976*^9, 3.732099970631249*^9}, {
  3.7321016725665073`*^9, 3.732101711839978*^9}, {3.732101757926355*^9, 
  3.7321017841983852`*^9}, {3.743083726141893*^9, 3.743083759311646*^9}, {
  3.7430849654790487`*^9, 3.743085008088973*^9}, {3.74308507234214*^9, 
  3.743085085338368*^9}, {3.7431388056731157`*^9, 3.7431388321612053`*^9}, {
  3.743139706411685*^9, 3.743139708857716*^9}, {3.743139850409808*^9, 
  3.74313986261325*^9}, {3.743141469574397*^9, 3.743141475336808*^9}, {
  3.7431428924790993`*^9, 3.74314293203366*^9}, {3.743143052438376*^9, 
  3.743143052678316*^9}, {3.743147458782848*^9, 3.7431474592699347`*^9}, {
  3.743147599765725*^9, 3.743147634497573*^9}, {3.743148790055769*^9, 
  3.743148845881797*^9}},ExpressionUUID->"2f9b98a1-dcfc-4f30-8a53-\
d4fd230ed4d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Write", " ", "the", " ", "fully", " ", "covariant", " ", "form", " ", 
    "of", " ", 
    SubscriptBox["T", "\[Alpha]\[Beta]"]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Tdn", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[ScriptG]0", "[", 
          RowBox[{"[", 
           RowBox[{"l1", ",", "l3"}], "]"}], "]"}], 
         RowBox[{"\[ScriptG]0", "[", 
          RowBox[{"[", 
           RowBox[{"l2", ",", "l4"}], "]"}], "]"}], 
         RowBox[{"T", "[", 
          RowBox[{"[", 
           RowBox[{"l3", ",", "l4"}], "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"l3", ",", "1", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"l4", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"l1", ",", "1", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l2", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";"}]}]], "Input",\

 CellChangeTimes->{{3.732100418197832*^9, 3.732100459505525*^9}, {
   3.743085021011389*^9, 3.743085043231668*^9}, 3.743138897493514*^9, {
   3.7431391172437963`*^9, 3.743139119303615*^9}, {3.743139839287222*^9, 
   3.7431398397061*^9}},ExpressionUUID->"1a3fa1d3-79b5-41af-bd4d-\
7f5b3a5146b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "it", " ", "to", " ", "find", " ", "the", " ", "norm", " ", 
     "of", " ", "the", " ", "specific", " ", "tensor", " ", 
     RowBox[{"hamronic", ".", " ", "I"}], " ", "use", " ", "a", " ", 
     "specific", " ", "value", " ", "of", " ", "l", " ", "and", " ", "m", " ",
      "otherwise", " ", "mathematica", " ", "does", " ", "not", " ", "do", 
     " ", "the", " ", "intergral"}], ",", " ", 
    RowBox[{
    "but", " ", "the", " ", "result", " ", "is", " ", "independent", " ", 
     "of", " ", "the", " ", "multipole", " ", "index"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"norm", "[", "A_", "]"}], ":=", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SP", "[", 
          RowBox[{"A", ",", "A"}], "]"}], "//.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"l", "\[Rule]", "2"}], ",", 
           RowBox[{"m", "\[Rule]", "0"}]}], "}"}]}], ")"}], 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", "0", ",", 
        RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "make", " ", "the", " ", "scalar", " ", "product", " ", 
     "inside", " ", "the", " ", "integral", " ", "for", " ", "the", " ", 
     "projection", " ", "into", " ", "the", " ", "tensor", " ", "hamronics", 
     " ", "basis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SP", "[", 
     RowBox[{"A_", ",", "B_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Eta]", "[", 
         RowBox[{"[", 
          RowBox[{"l1", ",", "l3"}], "]"}], "]"}], 
        RowBox[{"\[Eta]", "[", 
         RowBox[{"[", 
          RowBox[{"l2", ",", "l4"}], "]"}], "]"}], 
        RowBox[{"Conjugate", "[", 
         RowBox[{"A", "[", 
          RowBox[{"[", 
           RowBox[{"l1", ",", "l2"}], "]"}], "]"}], "]"}], 
        RowBox[{"B", "[", 
         RowBox[{"[", 
          RowBox[{"l3", ",", "l4"}], "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"l1", ",", "1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l2", ",", "1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l3", ",", "1", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"l4", ",", "1", ",", "4"}], "}"}]}], "]"}], "//", 
     "Simplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.732099759316918*^9, 3.732099809821965*^9}, {
   3.743085848972699*^9, 3.743085873605975*^9}, 3.743085976973062*^9, 
   3.743117215972336*^9, {3.743139128223284*^9, 3.743139129203083*^9}, {
   3.743141213278442*^9, 3.743141218184339*^9}, {3.743141598955963*^9, 
   3.743141603863349*^9}, 3.7431429559035263`*^9, {3.74314557273505*^9, 
   3.7431456059276743`*^9}, {3.743146088253545*^9, 3.7431461142921333`*^9}, {
   3.743146580457986*^9, 3.743146580750589*^9}, {3.7431473416693583`*^9, 
   3.743147422794763*^9}, {3.743149767971019*^9, 
   3.743149806884522*^9}},ExpressionUUID->"dddd9daa-55a1-4e2a-a39b-\
d994dba26ec5"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "The", " ", "equation", " ", "shoud", " ", "be", " ", "integrated", " ", 
   "on", " ", "the", " ", "solid", " ", 
   RowBox[{"angle", ".", " ", "This"}], " ", "remove", " ", "the", " ", 
   "\[Delta]", 
   RowBox[{"(", 
    RowBox[{"\[CapitalOmega]", "-", 
     SubscriptBox["\[CapitalOmega]", "p"]}], ")"}], " ", "and", " ", "make", 
   " ", "the", " ", "Spherical", " ", "Harmonics", " ", "variables", " ", 
   "computed", " ", "at", " ", "the", " ", "values", " ", "of", " ", 
   SubscriptBox["\[Theta]", "p"], " ", "and", " ", 
   SubscriptBox["\[Phi]", "p"]}]}]], "Input",
 CellChangeTimes->{{3.743139734550055*^9, 3.743139806824112*^9}, 
   3.7431497707451773`*^9},ExpressionUUID->"9fe58e4b-5ff2-4bb1-8cf0-\
ea0e2191aefc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TableForm", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"norm", "[", "a0", "]"}], 
       RowBox[{"SP", "[", 
        RowBox[{"a0", ",", "Tdn"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"norm", "[", "a", "]"}], 
       RowBox[{"SP", "[", 
        RowBox[{"a", ",", "Tdn"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"norm", "[", "a1", "]"}], 
       RowBox[{"SP", "[", 
        RowBox[{"a1", ",", "Tdn"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"norm", "[", "b0", "]"}], 
       RowBox[{"SP", "[", 
        RowBox[{"b0", ",", "Tdn"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"norm", "[", "b", "]"}], 
       RowBox[{"SP", "[", 
        RowBox[{"b", ",", "Tdn"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"TableAlignments", "\[Rule]", "Center"}], ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\[ScriptCapitalA]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(\[ScriptCapitalA]\), \((0)\)]\)\>\"", 
         ",", "\"\<\!\(\*SuperscriptBox[\(\[ScriptCapitalA]\), \
\((1)\)]\)\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(\[ScriptCapitalB]\), \((0)\)]\)\>\"", 
         ",", "\"\<\[ScriptCapitalB]\>\""}], "}"}], ",", "None"}], "}"}]}]}], 
   "]"}], "//", "TraditionalForm"}]], "Input",
 CellChangeTimes->{{3.74308523697294*^9, 3.743085238358265*^9}, {
   3.7430852966770353`*^9, 3.7430852976197653`*^9}, 3.7430863560851297`*^9, {
   3.743139715698578*^9, 3.743139721987049*^9}, {3.74314122271716*^9, 
   3.7431412265879507`*^9}, 3.743142959402453*^9, {3.7431456091172132`*^9, 
   3.743145609710765*^9}, {3.743146116867649*^9, 3.743146119983493*^9}, {
   3.74314663634478*^9, 3.7431466876001177`*^9}, 3.743146731424754*^9, {
   3.743146798433085*^9, 3.743146955486023*^9}, {3.7431474313578978`*^9, 
   3.7431474406691523`*^9}, {3.743147482627843*^9, 
   3.743147552400175*^9}},ExpressionUUID->"2fda54e3-806f-4da2-aa9e-\
dc120299ae57"],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {
       TagBox["\<\"\[ScriptCapitalA]\"\>",
        HoldForm], 
       FractionBox[
        RowBox[{"\[Gamma]", " ", "mp", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", 
            RowBox[{"2", " ", "M"}]}], ")"}], "2"], " ", 
         TemplateBox[{RowBox[{
             RowBox[{"r", "-", "rp"}]}]},
          "DiracDeltaSeq"], " ", 
         TemplateBox[{RowBox[{
             RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}]}]},
          "DiracDeltaSeq"], " ", 
         TemplateBox[{RowBox[{
             SubsuperscriptBox["Y", "l", "m"], "(", 
             RowBox[{"\[Theta]", ",", 
               RowBox[{"\[Phi]", "(", "t", ")"}]}], ")"}]},
          "Conjugate"]}], 
        SuperscriptBox["r", "4"]]},
      {
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(\[ScriptCapitalA]\\), \
\\((0)\\)]\\)\"\>",
        HoldForm], 
       FractionBox[
        RowBox[{"\[Gamma]", " ", 
         SuperscriptBox["dR", "2"], " ", "mp", " ", 
         TemplateBox[{RowBox[{
             RowBox[{"r", "-", "rp"}]}]},
          "DiracDeltaSeq"], " ", 
         TemplateBox[{RowBox[{
             RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}]}]},
          "DiracDeltaSeq"], " ", 
         TemplateBox[{RowBox[{
             SubsuperscriptBox["Y", "l", "m"], "(", 
             RowBox[{"\[Theta]", ",", 
               RowBox[{"\[Phi]", "(", "t", ")"}]}], ")"}]},
          "Conjugate"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"2", " ", "M"}]}], ")"}], "2"]]},
      {
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(\[ScriptCapitalA]\\), \
\\((1)\\)]\\)\"\>",
        HoldForm], 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["2"], " ", "\[Gamma]", " ", "dR", " ", "mp", " ", 
         TemplateBox[{RowBox[{
             RowBox[{"r", "-", "rp"}]}]},
          "DiracDeltaSeq"], " ", 
         TemplateBox[{RowBox[{
             RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}]}]},
          "DiracDeltaSeq"], " ", 
         TemplateBox[{RowBox[{
             SubsuperscriptBox["Y", "l", "m"], "(", 
             RowBox[{"\[Theta]", ",", 
               RowBox[{"\[Phi]", "(", "t", ")"}]}], ")"}]},
          "Conjugate"]}], 
        SuperscriptBox["r", "2"]]},
      {
       TagBox["\<\"\\!\\(\\*SuperscriptBox[\\(\[ScriptCapitalB]\\), \
\\((0)\\)]\\)\"\>",
        HoldForm], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["2"], " ", "\[Gamma]", " ", "d\[ScriptCapitalY]dt", " ", 
          "mp", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
          TemplateBox[{RowBox[{
              RowBox[{"r", "-", "rp"}]}]},
           "DiracDeltaSeq"], " ", 
          TemplateBox[{RowBox[{
              RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}]}]},
           "DiracDeltaSeq"]}], 
         RowBox[{
          SqrtBox[
           RowBox[{"l", " ", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}]}]], " ", 
          SuperscriptBox["r", "2"]}]]}]},
      {
       TagBox["\<\"\[ScriptCapitalB]\"\>",
        HoldForm], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SqrtBox["2"], " ", "\[Gamma]", " ", "dR", " ", 
          "d\[ScriptCapitalY]dt", " ", "mp", " ", 
          TemplateBox[{RowBox[{
              RowBox[{"r", "-", "rp"}]}]},
           "DiracDeltaSeq"], " ", 
          TemplateBox[{RowBox[{
              RowBox[{"\[CapitalOmega]", "-", "\[CapitalOmega]p"}]}]},
           "DiracDeltaSeq"]}], 
         RowBox[{
          SqrtBox[
           RowBox[{"l", " ", 
            RowBox[{"(", 
             RowBox[{"l", "+", "1"}], ")"}]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "M"}], "-", "r"}], ")"}]}]]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{False}}, "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    OutputFormsDump`HeadedColumn],
   Function[BoxForm`e$, 
    TableForm[
    BoxForm`e$, TableAlignments -> Center, 
     TableHeadings -> {{
       "\[ScriptCapitalA]", 
        "\!\(\*SuperscriptBox[\(\[ScriptCapitalA]\), \((0)\)]\)", 
        "\!\(\*SuperscriptBox[\(\[ScriptCapitalA]\), \((1)\)]\)", 
        "\!\(\*SuperscriptBox[\(\[ScriptCapitalB]\), \((0)\)]\)", 
        "\[ScriptCapitalB]"}, None}]]], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.74314686698175*^9, {3.743146922649321*^9, 3.743146941866411*^9}, 
   3.743147263871463*^9, {3.743147398649588*^9, 3.7431474055160522`*^9}, {
   3.743147442760003*^9, 3.74314746717803*^9}, 3.743147522673118*^9, 
   3.743147553368558*^9, 3.743147638591435*^9, 
   3.743148850640003*^9},ExpressionUUID->"42023c2b-f1ff-4ad7-9be0-\
d2b692344bd8"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1333, 719},
WindowMargins->{{25, Automatic}, {Automatic, 0}},
Magnification:>1.25 Inherited,
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 460, 9, 277, "Title",ExpressionUUID->"e168f81b-5a28-4bfd-8462-fe9e95f53356"],
Cell[1043, 33, 227, 5, 37, "Input",ExpressionUUID->"4eaac8f0-168c-40d2-a1b3-23243a790dc6"],
Cell[1273, 40, 2094, 45, 64, "Input",ExpressionUUID->"96414fa7-5495-488a-83f9-a390a5aa4ecb"],
Cell[3370, 87, 321, 7, 37, "Input",ExpressionUUID->"f91663c2-968c-4aff-8901-126d2ee241c4"],
Cell[3694, 96, 319, 8, 37, "Input",ExpressionUUID->"ad50bbdc-2a5c-426f-806a-c051b6475e5e"],
Cell[4016, 106, 8454, 254, 543, "Input",ExpressionUUID->"203f779d-ed50-4ac4-89bf-259d7e53999a"],
Cell[12473, 362, 326, 7, 37, "Input",ExpressionUUID->"41465dda-12b7-4b08-af9f-c55513a7f796"],
Cell[12802, 371, 1718, 41, 90, "Input",ExpressionUUID->"31dd3f7a-f65b-4153-8219-0c511bd09573"],
Cell[14523, 414, 243, 6, 37, "Input",ExpressionUUID->"05bf97d7-0967-4eb0-a596-a3f8258bfbaa"],
Cell[CellGroupData[{
Cell[14791, 424, 343, 7, 56, "Subsubsection",ExpressionUUID->"79404e4e-f297-4fce-8d17-508944f2dab9"],
Cell[15137, 433, 550, 12, 64, "Input",ExpressionUUID->"58c5c882-a346-4fd9-8ef7-e04a79ff5e82"],
Cell[15690, 447, 2329, 65, 149, "Input",ExpressionUUID->"1ff5c95f-896c-46e1-8896-ebe5f75233e5"],
Cell[18022, 514, 1820, 56, 114, "Input",ExpressionUUID->"3b13be2a-ce5f-4dfd-a1b4-70c75c75933e"],
Cell[19845, 572, 2868, 62, 228, "Input",ExpressionUUID->"2f9b98a1-dcfc-4f30-8a53-d4fd230ed4d1"],
Cell[22716, 636, 1352, 37, 65, "Input",ExpressionUUID->"1a3fa1d3-79b5-41af-bd4d-7f5b3a5146b2"],
Cell[24071, 675, 3310, 80, 194, "Input",ExpressionUUID->"dddd9daa-55a1-4e2a-a39b-d994dba26ec5"],
Cell[27384, 757, 777, 16, 69, "Input",ExpressionUUID->"9fe58e4b-5ff2-4bb1-8cf0-ea0e2191aefc"],
Cell[CellGroupData[{
Cell[28186, 777, 2006, 48, 69, "Input",ExpressionUUID->"2fda54e3-806f-4da2-aa9e-dc120299ae57"],
Cell[30195, 827, 5311, 142, 239, "Output",ExpressionUUID->"42023c2b-f1ff-4ad7-9be0-d2b692344bd8"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

