(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     77498,       1758]
NotebookOptionsPosition[     73570,       1686]
NotebookOutlinePosition[     73931,       1702]
CellTagsIndexPosition[     73888,       1699]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Scalar perturbations on Schwarzschild background with \
gaussian initial data",
 FontSize->36]], "Title",
 CellChangeTimes->{{3.722026108833889*^9, 3.722026133002123*^9}, {
   3.722063827267627*^9, 3.722063838046527*^9}, {3.7430144054961233`*^9, 
   3.743014406101254*^9}, {3.743043391265998*^9, 3.7430433943509912`*^9}, {
   3.743168772483803*^9, 3.743168792889501*^9}, 
   3.743172094814611*^9},ExpressionUUID->"a893aa8d-e120-4316-b312-\
36ac0a6454d4"],

Cell[BoxData[
 RowBox[{"Exit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.72198799897161*^9, 3.72198799990344*^9}, {
  3.743016558004128*^9, 
  3.7430165586531563`*^9}},ExpressionUUID->"b7cb238b-0af9-4761-b44f-\
94cf57b81ced"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"r", "\[GreaterEqual]", "0"}], ",", 
      RowBox[{"M", ">", "0"}], ",", 
      RowBox[{"Element", "[", 
       RowBox[{"L", ",", "Integers"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "set", " ", "up", " ", "the", " ", "working", " ", 
    "directory", " ", "of", " ", "the", " ", 
    RowBox[{"notebook", "."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "path", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.717417827152334*^9, 3.717417827545067*^9}, {
   3.720525806525712*^9, 3.72052580687288*^9}, {3.720960445169264*^9, 
   3.72096044584095*^9}, {3.721032400106536*^9, 3.721032401314507*^9}, 
   3.722585389504361*^9, {3.724767015218999*^9, 3.724767015946599*^9}, {
   3.724767570416555*^9, 3.7247675708351393`*^9}, {3.724768211416267*^9, 
   3.72476822262503*^9}, {3.7247869373512907`*^9, 3.724786939953195*^9}, {
   3.7258011818217373`*^9, 3.725801182345151*^9}, {3.743014362739792*^9, 
   3.74301438172966*^9}, {3.7430151467686777`*^9, 
   3.7430151474379272`*^9}},ExpressionUUID->"6e6b942d-4ccd-46ce-a2a3-\
cb33cb44a2e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", " ", "This"}]}], " ", "is", " ", "the", " ", "master", " ",
     "equation", " ", "in", " ", "the", " ", "tortoise", " ", "coordinate", 
    " ", "for", " ", "the", " ", "homogeneous", " ", 
    RowBox[{
     RowBox[{"case", " ", "--"}], "--"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"master", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Omega]", "2"], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "M"}], 
           SuperscriptBox["r", "3"]], "+", 
          FractionBox[
           RowBox[{"l", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "l"}], ")"}]}], 
           SuperscriptBox["r", "2"]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"\[Psi]", "[", "r", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[Psi]", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "\[ScriptR]", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7427381644276333`*^9, 3.7427381911121597`*^9}, {
  3.742738248698216*^9, 3.7427382606882153`*^9}, {3.7431659686500797`*^9, 
  3.7431659768765917`*^9}, {3.743168151344699*^9, 3.7431681570318727`*^9}, {
  3.743168190439898*^9, 
  3.743168192905205*^9}},ExpressionUUID->"d04d4f0b-bcca-4a51-919d-\
4a25b5342125"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "M"}], 
          SuperscriptBox["r", "3"]], "+", 
         FractionBox[
          RowBox[{"l", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "l"}], ")"}]}], 
          SuperscriptBox["r", "2"]]}], ")"}]}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", " ", "M"}], "r"]}], ")"}]}], "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
   RowBox[{"\[Psi]", "[", "r", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[Psi]", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "\[ScriptR]", "]"}]}]], "Output",
 CellChangeTimes->{{3.742738170007515*^9, 3.742738191440455*^9}, 
   3.742738548304597*^9, 3.7427392749467993`*^9, 3.742739861431926*^9, 
   3.742741593392465*^9, 3.74274179429836*^9, 3.742741845511847*^9, 
   3.7427419165225782`*^9, 3.742741950366692*^9, 3.7427424768209*^9, 
   3.742743071215352*^9, 3.742743365053576*^9, 3.743056893916535*^9, 
   3.743057135182002*^9, 3.7431659772596893`*^9, 3.7431681583040743`*^9, {
   3.743168746402896*^9, 3.7431687674703283`*^9}, {3.743168834395258*^9, 
   3.743168864388091*^9}, 
   3.743235716899963*^9},ExpressionUUID->"48d6aabc-dc26-4e07-bf28-\
bf43aa70f924"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"--", 
    RowBox[{"--", " ", 
     SubscriptBox["dr", "*"]}]}], " ", "=", " ", 
   RowBox[{
    SuperscriptBox["f", 
     RowBox[{"-", "1"}]], 
    RowBox[{
     RowBox[{"dr", " ", "--"}], "--"}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.742738265741994*^9, 
  3.74273828072736*^9}},ExpressionUUID->"f3d30b18-246e-4af7-b017-\
735bf759a4c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"drs", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", 
       RowBox[{"M", "/", "r"}]}]}], ")"}], 
    RowBox[{"-", "1"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.742738234991255*^9, 
  3.7427382435753403`*^9}},ExpressionUUID->"8d676438-986d-4ddf-b251-\
601831f15be1"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"--", 
    RowBox[{"--", " ", "Writing"}]}], " ", "the", " ", "master", " ", 
   "equation", " ", "as", " ", "a", " ", "function", " ", "of", " ", 
   "standard", " ", 
   RowBox[{
    RowBox[{"r", " ", "--"}], "--"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.742738287790061*^9, 3.7427382991918793`*^9}, {
  3.743056901424842*^9, 
  3.743056902740328*^9}},ExpressionUUID->"3b8cb415-dbfa-4258-aa3a-\
6c03bd802371"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"master2", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"master", "//.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Psi]", "''"}], "[", "\[ScriptR]", "]"}], "\[Rule]", 
       RowBox[{
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["drs", "2"]], 
         RowBox[{
          RowBox[{"\[Psi]", "''"}], "[", "r", "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "drs"], 
         RowBox[{"D", "[", 
          RowBox[{
           FractionBox["1", "drs"], ",", "r"}], "]"}], 
         RowBox[{
          RowBox[{"\[Psi]", "'"}], "[", "r", "]"}]}]}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]", "''"}], "[", "r", "]"}], ",", 
      RowBox[{
       RowBox[{"\[Psi]", "'"}], "[", "r", "]"}], ",", 
      RowBox[{"\[Psi]", "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.742738230052162*^9, {3.742738303095085*^9, 3.742738325699967*^9}, {
   3.742742577800832*^9, 3.742742577964574*^9}, {3.7431681967998867`*^9, 
   3.743168206696299*^9}},ExpressionUUID->"0437ef7c-3e60-4250-8706-\
140a25cff739"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "M"}], "+", 
         RowBox[{"l", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "l"}], ")"}], " ", "r"}]}], ")"}]}], 
      SuperscriptBox["r", "4"]], "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
   RowBox[{"\[Psi]", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "M"}], "+", "r"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["\[Psi]", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "3"]], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", " ", "M"}], "r"]}], ")"}], "2"], " ", 
   RowBox[{
    SuperscriptBox["\[Psi]", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.742738321594449*^9, 3.742738334291111*^9}, 
   3.7427385511704473`*^9, 3.7427392776538057`*^9, 3.7427398654830933`*^9, 
   3.7427415983023987`*^9, 3.742741795457081*^9, 3.7427418466962433`*^9, 
   3.7427419167707863`*^9, 3.742741953073369*^9, 3.742742479485721*^9, 
   3.742743076555957*^9, 3.742743367569933*^9, 3.7430568980875807`*^9, 
   3.743057137712624*^9, 3.743165980449635*^9, 3.743168160918227*^9, {
   3.743168749463998*^9, 3.743168770765685*^9}, 3.743168837192706*^9, 
   3.7431688682498093`*^9, {3.743235720572988*^9, 
   3.743235724553247*^9}},ExpressionUUID->"b8019389-4dad-4ce7-9cab-\
aecae944e3b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boundary Conditions for the homogeneous integration", "Subsection",
 CellChangeTimes->{
  3.72470087666232*^9, 3.724788628215098*^9, {3.726151403358302*^9, 
   3.7261514066276207`*^9}, {3.7430434930994463`*^9, 
   3.7430434961860743`*^9}, {3.74316887125132*^9, 
   3.74316887605739*^9}},ExpressionUUID->"b03a8a0b-066c-40b4-a2a2-\
c10ee52cd8e2"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "In", " ", "this", " ", "section", " ", "I", " ", "find", " ", "the", " ", 
   "series", " ", "expansion", " ", "at", " ", "the", " ", "horizon", " ", 
   "and", " ", "at", " ", "infinity", " ", "to", " ", "start", " ", "the", 
   " ", "numerical", " ", "integration"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.743039353995512*^9, 3.743039381283182*^9}, 
   3.743043599409782*^9},ExpressionUUID->"e158e823-72d6-4dba-a992-\
ae0aa5345c03"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Series", " ", "expansion", " ", "at", " ", "the", " ", 
    RowBox[{"horizon", ".", " ", "In"}], " ", "this", " ", "case", " ", "we", 
    " ", "consider", " ", "10", " ", 
    RowBox[{"coefficients", ".", " ", "You"}], " ", "can", " ", "try", " ", 
    "to", " ", "vary", " ", "to", " ", "see", " ", "the", " ", "effect"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"order", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Psi]", "[", "r_", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "I"}], " ", "\[Omega]", " ", 
          RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
        RowBox[{"b", "[", "i", "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", 
           RowBox[{"2", "M"}]}], ")"}], "i"]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.72441882639495*^9, 3.724418850321383*^9}, {
   3.724768181255518*^9, 3.7247681950955973`*^9}, {3.724768235179481*^9, 
   3.7247682446574717`*^9}, {3.7247682914184427`*^9, 3.724768293100586*^9}, {
   3.724768336639626*^9, 3.7247683632224617`*^9}, {3.724790890725099*^9, 
   3.724790891106776*^9}, {3.7247918943044567`*^9, 3.7247918946983356`*^9}, 
   3.725800324275676*^9, {3.725800700448306*^9, 3.725800700722814*^9}, {
   3.725801192307542*^9, 3.725801192805964*^9}, {3.7259513624476223`*^9, 
   3.725951362989707*^9}, {3.725951618479066*^9, 3.72595161859839*^9}, {
   3.7259517214207983`*^9, 3.725951724850251*^9}, {3.726159013431026*^9, 
   3.726159013722302*^9}, {3.743017192348927*^9, 3.743017201138445*^9}, 
   3.743030637098709*^9, {3.7430310642826138`*^9, 3.743031071738914*^9}, {
   3.7430393287200727`*^9, 3.743039328845504*^9}, 3.743039383135004*^9, {
   3.743040452516469*^9, 3.743040454032215*^9}, 3.7430435982129307`*^9, {
   3.7430560667216053`*^9, 3.7430560840734253`*^9}, 3.7431681713884487`*^9, {
   3.743168458021975*^9, 3.743168458822258*^9}, 
   3.743168759849936*^9},ExpressionUUID->"b0ae9d26-8dfe-401e-a0f8-\
d96f9c11d895"],

Cell[BoxData[
 RowBox[{
  RowBox[{"seriesH", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"master2", "//.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"rt", "[", "r", "]"}], "\[Rule]", "0"}], ",", 
          RowBox[{"m", "\[Rule]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"rt", "'"}], "[", "r", "]"}], "\[Rule]", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              FractionBox[
               RowBox[{"2", "M"}], "r"]}], ")"}], 
            RowBox[{"-", "1"}]]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"rt", "''"}], "[", "r", "]"}], "\[Rule]", 
           RowBox[{"D", "[", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"2", "M"}], "r"]}], ")"}], 
              RowBox[{"-", "1"}]], ",", "r"}], "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"2", "M"}], ",", 
         RowBox[{"order", "+", "2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"r", "-", 
      RowBox[{"2", "M"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743017207980054*^9, 3.743017214756978*^9}, {
   3.743017274706307*^9, 3.7430172749665003`*^9}, {3.743030104446576*^9, 
   3.743030115116406*^9}, {3.743039325827941*^9, 3.743039326440339*^9}, 
   3.743168845307766*^9},ExpressionUUID->"8936405c-674b-457e-a098-\
294d43f917f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"seriesH", ",", 
   RowBox[{"r", "-", 
    RowBox[{"2", "M"}]}], ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.743168890664358*^9, 
  3.743168907073114*^9}},ExpressionUUID->"d955a6fa-b1d8-4753-b811-\
33f6aabf3445"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"b", "[", "0", "]"}]}], "-", 
   RowBox[{"l", " ", 
    RowBox[{"b", "[", "0", "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["l", "2"], " ", 
    RowBox[{"b", "[", "0", "]"}]}], "+", 
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"b", "[", "1", "]"}]}], "-", 
   RowBox[{"8", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["M", "2"], " ", "\[Omega]", " ", 
    RowBox[{"b", "[", "1", "]"}]}]}], 
  RowBox[{"8", " ", 
   SuperscriptBox["M", "3"]}]]], "Output",
 CellChangeTimes->{{3.743168891852188*^9, 3.74316890730271*^9}, 
   3.743235739669757*^9},ExpressionUUID->"49aff7d6-fe5d-414b-86b3-\
ca2dd47773b0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"b", "[", "i", "]"}], "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"seriesH", ",", 
            RowBox[{"r", "-", 
             RowBox[{"2", "M"}]}], ",", "i"}], "]"}], "\[Equal]", "0"}], ",", 
         
         RowBox[{"b", "[", "i", "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "order"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.743018091827241*^9, {3.743168911795167*^9, 
   3.743168920094831*^9}},ExpressionUUID->"aa791daf-1cba-4840-8ae2-\
c4073da968d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]H", "[", "r_", "]"}], "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "\[Omega]", " ", 
         RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
       RowBox[{"b", "[", "i", "]"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "-", 
          RowBox[{"2", "M"}]}], ")"}], "i"]}], "//.", 
      RowBox[{
       RowBox[{"rt", "[", "r", "]"}], "\[Rule]", 
       RowBox[{"r", "+", 
        RowBox[{"2", "M", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           FractionBox["r", 
            RowBox[{"2", "M"}]], "-", "1"}], "]"}]}]}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{
  3.743031035032631*^9, {3.743039511233699*^9, 3.7430395119027357`*^9}, 
   3.743168179249793*^9, 
   3.7431684653066187`*^9},ExpressionUUID->"331aa690-4ffe-4ba7-9d82-\
f8c52774f281"],

Cell[BoxData[
 RowBox[{"Clear", "[", "\[Psi]", "]"}]], "Input",
 CellChangeTimes->{{3.726159082257277*^9, 3.72615908394706*^9}, {
   3.743017361585918*^9, 3.7430173630986967`*^9}, 3.7430180996624527`*^9, {
   3.743031037361425*^9, 3.7430310392483683`*^9}, {3.743052755190703*^9, 
   3.743052755710794*^9}, 
   3.7431684727203617`*^9},ExpressionUUID->"66bf3b95-e049-4d69-b9e1-\
e3bb4e4fcac7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Series", " ", "expansion", " ", "at", " ", "infinity"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Psi]", "[", "r_", "]"}], ":=", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Omega]", " ", 
         RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
       RowBox[{"c", "[", "i", "]"}], 
       FractionBox["1", 
        SuperscriptBox["r", "i"]]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.7232088203906927`*^9, 3.723208870411315*^9}, {
   3.7232089021147842`*^9, 3.723208907881666*^9}, {3.7232089545586042`*^9, 
   3.723208954938642*^9}, {3.723211765365138*^9, 3.7232117710716257`*^9}, 
   3.7232320213644257`*^9, {3.723268670036603*^9, 3.723268672353324*^9}, {
   3.72327352884249*^9, 3.723273530944786*^9}, {3.723273646709928*^9, 
   3.72327366779589*^9}, {3.723273747635375*^9, 3.723273752190074*^9}, {
   3.723273877270441*^9, 3.723273897639797*^9}, 3.723273976915277*^9, {
   3.7233193697198763`*^9, 3.723319370222378*^9}, {3.723323564838928*^9, 
   3.7233235766393557`*^9}, {3.724418890295128*^9, 3.7244189065680647`*^9}, {
   3.724420181875193*^9, 3.724420181921259*^9}, {3.724421336849634*^9, 
   3.724421336963005*^9}, {3.72475439412987*^9, 3.724754394209181*^9}, {
   3.724768171802198*^9, 3.724768202519023*^9}, {3.72476825480882*^9, 
   3.724768273400465*^9}, {3.724768322326231*^9, 3.724768374463746*^9}, {
   3.724769529277561*^9, 3.7247695305042887`*^9}, {3.724769982903966*^9, 
   3.72476998303477*^9}, {3.724770096536563*^9, 3.7247700966410637`*^9}, {
   3.725951631908907*^9, 3.725951631991503*^9}, {3.725951727369562*^9, 
   3.725951727844051*^9}, {3.726159075863649*^9, 3.726159088466996*^9}, {
   3.743017370945675*^9, 3.74301737253685*^9}, 3.743031042118396*^9, {
   3.743039340068426*^9, 3.743039340592225*^9}, 3.743039385735318*^9, 
   3.743043589778413*^9, 3.7431681832067347`*^9, 
   3.743168473832617*^9},ExpressionUUID->"df696704-d574-4d68-b729-\
1f189daea8c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"series\[Infinity]", "=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"master2", "//.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"rt", "[", "r", "]"}], "\[Rule]", "0"}], ",", 
            RowBox[{"m", "\[Rule]", "0"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"rt", "'"}], "[", "r", "]"}], "\[Rule]", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"2", "M"}], "r"]}], ")"}], 
              RowBox[{"-", "1"}]]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"rt", "''"}], "[", "r", "]"}], "\[Rule]", 
             RowBox[{"D", "[", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  FractionBox[
                   RowBox[{"2", "M"}], "r"]}], ")"}], 
                RowBox[{"-", "1"}]], ",", "r"}], "]"}]}]}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "\[Infinity]", ",", 
          RowBox[{"order", "+", "2"}]}], "}"}]}], "]"}], "]"}], ",", "r", ",",
      "Simplify"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743017381542041*^9, 3.743017385131069*^9}, {
   3.743031092616909*^9, 3.743031095469961*^9}, {3.743039346669862*^9, 
   3.743039347332695*^9}, 
   3.743168934598637*^9},ExpressionUUID->"320b975f-afb8-4e6e-8f42-\
f28537b57af3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "[", 
      RowBox[{"i", "-", "1"}], "]"}], "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"series\[Infinity]", ",", "r", ",", 
            RowBox[{"-", "i"}]}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{"c", "[", 
          RowBox[{"i", "-", "1"}], "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "order"}], "}"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.743017390116887*^9, 
  3.743017390585949*^9}},ExpressionUUID->"509d1bc7-427c-492e-b3ca-\
8721e8487c41"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]\[Infinity]", "[", "r_", "]"}], "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Omega]", " ", 
         RowBox[{"rt", "[", "r", "]"}]}], "]"}], 
       RowBox[{"c", "[", "i", "]"}], 
       FractionBox["1", 
        SuperscriptBox["r", "i"]]}], "//.", 
      RowBox[{
       RowBox[{"rt", "[", "r", "]"}], "\[Rule]", 
       RowBox[{"r", "+", 
        RowBox[{"2", "M", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           FractionBox["r", 
            RowBox[{"2", "M"}]], "-", "1"}], "]"}]}]}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", 
       RowBox[{"order", "-", "1"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.743031121639982*^9, 3.74303112344582*^9}, 
   3.743039508562723*^9, {3.743168477112774*^9, 
   3.7431684772563877`*^9}},ExpressionUUID->"b147c48b-11b7-4902-9b8d-\
f50a917414fd"],

Cell[BoxData[
 RowBox[{"Clear", "[", "\[Psi]", "]"}]], "Input",
 CellChangeTimes->{{3.7431687403977537`*^9, 
  3.7431687421827583`*^9}},ExpressionUUID->"d778f676-b3d7-4305-ac91-\
4d93b55bc0b2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numerical routine for the integration", "Subsection",
 CellChangeTimes->{
  3.7430435065571537`*^9},ExpressionUUID->"a7516cdf-297d-4aff-afe5-\
d6a150f3df01"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Source", " ", 
    RowBox[{"term", ".", " ", "r0"}], " ", "and", " ", "\[Sigma]", " ", "are",
     " ", "the", " ", "parameters", " ", "of", " ", "the", " ", "gaussian"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Sigma]", ",", "r0"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[ScriptCapitalS]", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", "/", "r"}]}], ")"}], 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "+", 
            RowBox[{"2", " ", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"r", "/", "2"}], "-", "1"}], "]"}]}], "-", "r0"}], 
           ")"}], "^", "2"}]}], "/", 
        RowBox[{"\[Sigma]", "^", "2"}]}], "]"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.7430175616583643`*^9, {3.743039427043767*^9, 3.743039438953926*^9}, 
   3.743040466633399*^9, 3.743041336849598*^9, 3.743043580424882*^9, {
   3.743168690010622*^9, 3.743168723081552*^9}, {3.7431704918365297`*^9, 
   3.743170506035686*^9}, {3.743170546893222*^9, 3.74317056332154*^9}, {
   3.7431707666797113`*^9, 3.7431707801514807`*^9}, {3.743171005716138*^9, 
   3.7431710073454437`*^9}, {3.7431710926119337`*^9, 3.743171094432873*^9}, 
   3.743171190610701*^9, {3.74323569682904*^9, 
   3.7432357015687113`*^9}},ExpressionUUID->"5808347c-4dba-4835-9f63-\
21503c0aff9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"\[ScriptCapitalS]", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Lucida Grande\>\""}], ",", 
      "Italic", ",", "10", ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<S\>\"", ",", "26"}], "]"}], ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<r\>\"", ",", "26"}], "]"}], ",", "None"}], "}"}]}], 
     "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{"16", ",", 
      RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
      RowBox[{"FontFamily", "->", "\"\<Lucida Grande\>\""}], ",", "Italic", 
      ",", 
      RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.743170509695665*^9, 3.743170540206581*^9}, {
  3.7431706153160048`*^9, 3.743170623813448*^9}, {3.743170788097022*^9, 
  3.743170806878533*^9}},ExpressionUUID->"41e4cb15-4684-430e-b0cb-\
152f94675c05"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3k0Ve8Xxq9Z6Etm7jXP8x2UkuxdhgxlSIgkZEyZCUlCpogkQyoJEaKk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       "]]},
     Annotation[#, "Charting`Private`Tag$2867#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.0000351814679096`, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      StyleBox["\"S\"", 26, StripOnInput -> False], TraditionalForm], None}, {
    
     FormBox[
      StyleBox["\"r\"", 26, StripOnInput -> False], TraditionalForm], None}},
  FrameStyle->Directive[16, 
    GrayLevel[0], FontFamily -> "Lucida Grande", Italic, 
    AbsoluteThickness[1.1]],
  FrameTicks->FrontEndValueCache[{{Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
      Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.15, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.1, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {-0.05, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.05, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.1, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.15, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.25, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.3, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.35, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.45, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.55, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.65, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.7, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.75, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {0.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}, {Automatic, {{5., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {10., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {15., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {20., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
         AbsoluteThickness[0.1]}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {3., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {7., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {8., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {9., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {11., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {12., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {13., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {14., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {16., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {17., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {18., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {19., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {21., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {22., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {23., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {24., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}, {25., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         AbsoluteThickness[0.1]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{FontFamily -> "Lucida Grande", Italic, 10, 
    GrayLevel[0]},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.743170509982976*^9, 3.743170564535307*^9}, {
   3.7431707753281307`*^9, 3.743170808085844*^9}, 3.743171008456732*^9, 
   3.74317109605803*^9, 3.743171191942731*^9, 3.743235703120534*^9, 
   3.743235747349955*^9},ExpressionUUID->"413dc5fb-f5b7-4eea-83b3-\
af688ccc41b1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"\[CapitalOmega]_", ",", "\[ScriptL]_", ",", "r2_"}], "]"}], ":=", 
  
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"l", "=", "\[ScriptL]"}], ",", "dEd\[Sigma]", ",", "Aout", ",", 
      "S", ",", 
      RowBox[{"\[Omega]", "=", "\[CapitalOmega]"}], ",", "r", ",", 
      RowBox[{"M", "=", "1"}], ",", "m", ",", "r1", ",", 
      RowBox[{"\[Epsilon]", "=", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], ",", "eq", ",", "eqS", ",", "\[Psi]HI", ",", 
      "d\[Psi]HI", ",", "b0", ",", "c0", ",", "\[Psi]\[Infinity]I", ",", 
      "d\[Psi]\[Infinity]I", ",", "\[Psi]", ",", "W", ",", "drt", ",", "b", 
      ",", "c", ",", "Y\[Infinity]", ",", "YH"}], "}"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "First", " ", "find", " ", "the", " ", "homogenoeous", " ", "solution"}],
      " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eq", "=", "master2"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"r1", "=", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Epsilon]"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Initial", " ", "conditions", " ", "to", " ", "start", " ", "the", " ", 
       "numerical", " ", "integration", " ", "at", " ", "the", " ", "horizon",
        " ", "and", " ", "at", " ", "infinity"}], "  ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Psi]HI", "[", "b0_", "]"}], "=", 
      RowBox[{
       RowBox[{"\[Psi]H", "[", "r1", "]"}], "//.", 
       RowBox[{
        RowBox[{"b", "[", "0", "]"}], "\[Rule]", "b0"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d\[Psi]HI", "[", "b0_", "]"}], "=", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Psi]H", "[", "r", "]"}], ",", "r"}], "]"}], "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "[", "0", "]"}], "\[Rule]", "b0"}], ",", 
         RowBox[{"r", "\[Rule]", "r1"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Psi]\[Infinity]I", "[", "c0_", "]"}], "=", 
      RowBox[{
       RowBox[{"\[Psi]\[Infinity]", "[", "r2", "]"}], "//.", 
       RowBox[{
        RowBox[{"c", "[", "0", "]"}], "\[Rule]", "c0"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d\[Psi]\[Infinity]I", "[", "c0_", "]"}], "=", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Psi]\[Infinity]", "[", "r", "]"}], ",", "r"}], "]"}], "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"c", "[", "0", "]"}], "\[Rule]", "c0"}], ",", 
         RowBox[{"r", "\[Rule]", "r2"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Forward", " ", "integration", " ", "from", " ", "the", " ", 
       "horizon"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"YH", "=", " ", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"eq", "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"\[Psi]", "[", "r1", "]"}], "\[Equal]", 
            RowBox[{"\[Psi]HI", "[", "1", "]"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Psi]", "'"}], "[", "r1", "]"}], "\[Equal]", 
            RowBox[{"d\[Psi]HI", "[", "1", "]"}]}]}], "}"}], ",", "\[Psi]", 
         ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "r1", ",", "r2"}], "}"}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Inward", " ", "integartion", " ", "from", " ", "the", " ", "horizon"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Y\[Infinity]", "=", " ", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"eq", "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"\[Psi]", "[", "r2", "]"}], "\[Equal]", 
            RowBox[{"\[Psi]\[Infinity]I", "[", "1", "]"}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Psi]", "'"}], "[", "r2", "]"}], "\[Equal]", 
            RowBox[{"d\[Psi]\[Infinity]I", "[", "1", "]"}]}]}], "}"}], ",", 
         "\[Psi]", ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "r2", ",", "r1"}], "}"}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "12"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"drt", "=", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", 
          RowBox[{"M", "/", "r"}]}]}], ")"}], 
       RowBox[{"-", "1"}]]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Define", " ", "the", " ", "worknskian"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"W", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Psi]", "[", "r", "]"}], "//.", "YH"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Psi]", "'"}], "[", "r", "]"}], "//.", 
             "Y\[Infinity]"}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Psi]", "[", "r", "]"}], "//.", "Y\[Infinity]"}], 
            ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Psi]", "'"}], "[", "r", "]"}], "//.", "YH"}], 
            ")"}]}]}], ")"}], "/", "drt"}], "//.", 
       RowBox[{"r", "\[Rule]", "r2"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"eqS", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Psi]", "[", "r", "]"}], "//.", "YH"}], ")"}], 
       "\[ScriptCapitalS]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Integrate", " ", "the", " ", "source", " ", 
        RowBox[{"equation", ".", " ", "I"}], " ", "restrict", " ", "the", " ",
         "interval"}], ",", " ", 
       RowBox[{
       "so", " ", "r2", " ", "because", " ", "the", " ", "source", " ", 
        "terms", " ", "dies", " ", "after", " ", "a", " ", "certain", " ", 
        "point", " ", 
        RowBox[{"(", 
         RowBox[{
         "look", " ", "at", " ", "the", " ", "plot", " ", "on", " ", "top"}], 
         ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Aout", "=", 
      RowBox[{
       SuperscriptBox["W", 
        RowBox[{"-", "1"}]], 
       RowBox[{"NIntegrate", "[", 
        RowBox[{
         RowBox[{"drt", " ", "eqS"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "r1", ",", "25"}], "}"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"PrintTemporary", "[", 
      RowBox[{
      "\"\<\[Omega] = \>\"", ",", "\[Omega]", ",", "\"\< - Aout = \>\"", ",", 
       "Aout"}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Return", " ", "the", " ", "energy", " ", "spectrum", " ", "and", " ", 
       "the", " ", "function", " ", "Z", 
       RowBox[{"(", "\[Omega]", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"dEd\[Sigma]", "=", 
      RowBox[{
       SuperscriptBox["\[CapitalOmega]", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", "Aout", "]"}], "2"]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{"\[CapitalOmega]", ",", "dEd\[Sigma]"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.724768498587306*^9, 3.7247686710795*^9}, {
   3.7247687326949244`*^9, 3.724768984785458*^9}, {3.7247694899585876`*^9, 
   3.724769516598543*^9}, {3.724769950798635*^9, 3.724770006612638*^9}, {
   3.724770062374753*^9, 3.724770083338993*^9}, {3.724770149798287*^9, 
   3.7247702088919992`*^9}, {3.724770265013832*^9, 3.7247702653632393`*^9}, {
   3.724770394372386*^9, 3.724770395258748*^9}, {3.724770500089625*^9, 
   3.724770505682715*^9}, {3.7247916382103024`*^9, 3.724791639114998*^9}, {
   3.724791974133151*^9, 3.724791977803754*^9}, {3.7247920226068773`*^9, 
   3.724792024647929*^9}, {3.7247921780534143`*^9, 3.724792178986762*^9}, 
   3.7247922408697157`*^9, {3.7247923050503893`*^9, 3.724792371017132*^9}, {
   3.724792661509844*^9, 3.724792704637842*^9}, {3.724792759076735*^9, 
   3.7247927722705193`*^9}, 3.724792831696617*^9, {3.724792886334564*^9, 
   3.724792901418271*^9}, {3.72479297490727*^9, 3.7247929932244053`*^9}, {
   3.72479310519748*^9, 3.724793107649996*^9}, {3.724793696158334*^9, 
   3.724793705953959*^9}, {3.7247937556148167`*^9, 3.724793756719881*^9}, {
   3.725109190731885*^9, 3.725109195632186*^9}, {3.725109245003395*^9, 
   3.7251092456576138`*^9}, {3.725109315176772*^9, 3.7251093232434273`*^9}, {
   3.725109428879888*^9, 3.725109457667696*^9}, {3.725202477895034*^9, 
   3.725202500121375*^9}, {3.725797100944029*^9, 3.7257971282881327`*^9}, {
   3.725797163364642*^9, 3.725797198115736*^9}, {3.725797242136516*^9, 
   3.725797257223091*^9}, {3.725797307366084*^9, 3.725797451084343*^9}, {
   3.725797633579781*^9, 3.7257976421433*^9}, {3.7257977759695597`*^9, 
   3.725797945973195*^9}, {3.7257979960998507`*^9, 3.725798044697617*^9}, {
   3.725798077359771*^9, 3.725798190424212*^9}, {3.7257982230456877`*^9, 
   3.725798223642589*^9}, {3.725798265348753*^9, 3.72579829900382*^9}, {
   3.7257983368704557`*^9, 3.725798393265017*^9}, {3.725798463507456*^9, 
   3.725798486446344*^9}, {3.72579859544333*^9, 3.725798646713793*^9}, {
   3.725798976784927*^9, 3.7257989860134563`*^9}, {3.725799572096339*^9, 
   3.725799589836933*^9}, {3.7257996354165916`*^9, 3.7257997101908484`*^9}, {
   3.7257999849448633`*^9, 3.725799998460129*^9}, {3.725800396535681*^9, 
   3.7258003968793497`*^9}, {3.725800895982051*^9, 3.7258010056470957`*^9}, {
   3.72580133004078*^9, 3.72580135988307*^9}, {3.725801406463676*^9, 
   3.725801411651352*^9}, {3.7258921885068407`*^9, 3.7258922670114594`*^9}, {
   3.725892334265792*^9, 3.725892380383306*^9}, {3.72589247832513*^9, 
   3.725892490769178*^9}, {3.725951559035853*^9, 3.725951561995089*^9}, {
   3.7259520292399883`*^9, 3.725952031113431*^9}, {3.7259523715977097`*^9, 
   3.725952373491517*^9}, {3.72595298770614*^9, 3.7259530285518217`*^9}, {
   3.725953151960245*^9, 3.725953352677723*^9}, {3.725953480583198*^9, 
   3.7259534923736143`*^9}, {3.72595459793608*^9, 3.72595469154909*^9}, {
   3.725955122133013*^9, 3.725955122411673*^9}, {3.725955368953464*^9, 
   3.725955374579615*^9}, {3.725956234214658*^9, 3.7259562544092293`*^9}, 
   3.7259564275492287`*^9, {3.72595655802597*^9, 3.725956558688135*^9}, {
   3.725956962105254*^9, 3.725956980324066*^9}, {3.725957169030012*^9, 
   3.725957199599337*^9}, {3.725957265858824*^9, 3.725957281571145*^9}, {
   3.725957438612307*^9, 3.725957453908967*^9}, {3.725957538957943*^9, 
   3.72595754573053*^9}, {3.725957684005094*^9, 3.725957715976783*^9}, {
   3.725957762316812*^9, 3.725957822838521*^9}, {3.725957875490622*^9, 
   3.725957875907555*^9}, {3.7259579440848293`*^9, 3.725957947685974*^9}, {
   3.725958003899941*^9, 3.7259580267412987`*^9}, {3.725958117888383*^9, 
   3.725958169052638*^9}, {3.725958217684476*^9, 3.725958218288598*^9}, {
   3.7260723674616213`*^9, 3.7260723850046043`*^9}, {3.726072458891646*^9, 
   3.726072537140562*^9}, {3.72607257196598*^9, 3.726072572177771*^9}, {
   3.726151385305572*^9, 3.726151385718861*^9}, {3.7261591232708693`*^9, 
   3.726159210037941*^9}, {3.726213863953673*^9, 3.726213881857132*^9}, {
   3.726214083947076*^9, 3.726214084050321*^9}, {3.7262143793648443`*^9, 
   3.726214380266157*^9}, 3.730109815377658*^9, {3.730109849631976*^9, 
   3.730109849717567*^9}, {3.730109884783886*^9, 3.7301099222663727`*^9}, {
   3.730109993669586*^9, 3.730110023175556*^9}, {3.730110680718218*^9, 
   3.730110680942313*^9}, {3.730110718856748*^9, 3.730110733624135*^9}, 
   3.730110776023671*^9, {3.730110827195953*^9, 3.730110835304528*^9}, {
   3.743018123768683*^9, 3.743018145711194*^9}, {3.74301819289469*^9, 
   3.743018210021003*^9}, {3.7430182454858227`*^9, 3.743018267436067*^9}, {
   3.743018311599687*^9, 3.7430183312343283`*^9}, {3.7430183672975197`*^9, 
   3.743018373255432*^9}, {3.743031167579401*^9, 3.7430312696967382`*^9}, {
   3.7430313329290857`*^9, 3.743031404733794*^9}, {3.7430395239771023`*^9, 
   3.743039623844244*^9}, {3.743040038485939*^9, 3.743040051714652*^9}, {
   3.743040101765561*^9, 3.743040113853709*^9}, {3.743040145677631*^9, 
   3.7430401646491547`*^9}, {3.74304048394499*^9, 3.7430405178286257`*^9}, {
   3.743040596812376*^9, 3.743040674796831*^9}, {3.74304086828794*^9, 
   3.7430409041099033`*^9}, {3.743040981244215*^9, 3.7430409955678177`*^9}, {
   3.743041060699882*^9, 3.743041060911591*^9}, {3.743041107965131*^9, 
   3.7430411086636543`*^9}, {3.743041344515197*^9, 3.743041344699745*^9}, {
   3.743043553022192*^9, 3.743043575528442*^9}, {3.743053482828905*^9, 
   3.743053517296921*^9}, {3.743053861498027*^9, 3.743053934331059*^9}, {
   3.743054299668108*^9, 3.743054300637689*^9}, {3.743056134931283*^9, 
   3.7430561585783052`*^9}, {3.743056193143025*^9, 3.743056198582944*^9}, {
   3.743056267101973*^9, 3.743056267386436*^9}, {3.743056328253923*^9, 
   3.7430563362162457`*^9}, {3.743168487424724*^9, 3.74316859273593*^9}, {
   3.7431686270953503`*^9, 3.743168648304846*^9}, {3.743168730647848*^9, 
   3.743168731026538*^9}, {3.743168985969523*^9, 3.743169083831662*^9}, {
   3.743169471972619*^9, 3.7431695287292137`*^9}, {3.743169611430694*^9, 
   3.7431696115891733`*^9}, 3.743170032668437*^9, 3.743170145965988*^9, {
   3.743170273722288*^9, 3.74317027388369*^9}, {3.743170375073497*^9, 
   3.7431703769261217`*^9}, {3.7431705772161427`*^9, 3.743170605627768*^9}, {
   3.7431708587739*^9, 3.743170867945608*^9}, {3.743171013031391*^9, 
   3.743171013149732*^9}, {3.743171100507008*^9, 3.743171100972674*^9}, {
   3.74323578613103*^9, 3.7432358025950823`*^9}, {3.743235892437686*^9, 
   3.7432360584646606`*^9}},ExpressionUUID->"0cfbaa34-da18-44df-906d-\
852ab82dcad9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{"0.1", ",", "2", ",", 
   RowBox[{"200", "/", "0.3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.743170291796815*^9, 3.743170291939571*^9}, {
  3.74317083035436*^9, 
  3.743170921724248*^9}},ExpressionUUID->"d1e3a886-cb0b-48c2-bea2-\
4a6f3e7b1c47"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1`", ",", "0.0318513714452578`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.743170292950913*^9, {3.7431708256132603`*^9, 3.743170923785468*^9}, 
   3.743171015649712*^9, 3.743171199408482*^9, 3.7432357838622503`*^9, 
   3.743235917270084*^9, 3.743235949587123*^9, {3.743235984429255*^9, 
   3.743236000948062*^9}, 
   3.74323606067352*^9},ExpressionUUID->"f883959e-2e7c-4f0e-89ec-\
78b093d43f3d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"\[Omega]", ",", "1", ",", 
       RowBox[{"200", "/", "\[Omega]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "0.01", ",", "1", ",", "0.01"}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7257985073304234`*^9, 3.72579857816532*^9}, {
   3.72579869345931*^9, 3.725798694084251*^9}, {3.7257987659424877`*^9, 
   3.7257987879729853`*^9}, 3.7257989328817472`*^9, {3.725798967139399*^9, 
   3.725798967962421*^9}, 3.725799229753242*^9, 3.725800647038714*^9, {
   3.72580103141223*^9, 3.725801031948202*^9}, {3.725801385106715*^9, 
   3.725801385444378*^9}, 3.7258923314853563`*^9, {3.725892392856716*^9, 
   3.725892393016553*^9}, {3.725892505915653*^9, 3.725892509456854*^9}, {
   3.725952057450488*^9, 3.725952057898395*^9}, {3.725952320297303*^9, 
   3.725952320753213*^9}, {3.725952432326009*^9, 3.725952432919186*^9}, {
   3.725953038858581*^9, 3.725953039074831*^9}, {3.725953365547579*^9, 
   3.725953365869282*^9}, {3.7259535387790203`*^9, 3.7259535390849733`*^9}, {
   3.725955475755569*^9, 3.725955493993338*^9}, {3.725957232052437*^9, 
   3.725957232576826*^9}, {3.72595745619275*^9, 3.7259574576993093`*^9}, {
   3.726213800409387*^9, 3.726213809289029*^9}, {3.726213938337317*^9, 
   3.726213938562071*^9}, {3.730110082167653*^9, 3.7301100824779367`*^9}, {
   3.74303984060392*^9, 3.7430398581083403`*^9}, {3.743039929560564*^9, 
   3.743039930688793*^9}, {3.7430535138080072`*^9, 3.743053522301796*^9}, {
   3.74305376987846*^9, 3.743053769992531*^9}, {3.7430542778239326`*^9, 
   3.7430542786486187`*^9}, {3.743056382279593*^9, 3.7430563939199266`*^9}, {
   3.743056440099988*^9, 3.743056448038096*^9}, {3.743169629308964*^9, 
   3.743169631728043*^9}, 3.743170154314382*^9, {3.74317029806078*^9, 
   3.743170301764533*^9}, {3.743170924406851*^9, 3.7431709245040417`*^9}, {
   3.743171288084889*^9, 
   3.743171291339587*^9}},ExpressionUUID->"d95c078b-6218-45af-8078-\
0c1f1f09622f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "the", " ", "power"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", "data", "}"}], ",", 
    RowBox[{"Joined", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False", ",", "False"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "600"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Lucida Grande\>\""}], ",", 
       "Italic", ",", "10", ",", 
       RowBox[{"GrayLevel", "[", "0", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\< \>\"", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\[FilledSmallCircle]\>\"", ",", "26"}], "}"}]}], "}"}]}],
     ",", 
    RowBox[{"FrameStyle", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"16", ",", 
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
       RowBox[{"FontFamily", "->", "\"\<Lucida Grande\>\""}], ",", "Italic", 
       ",", 
       RowBox[{"AbsoluteThickness", "[", "1.1", "]"}]}], "]"}]}], ",", 
    RowBox[{"FrameLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<dE/d\[Omega]\>\"", ",", "26"}], "]"}], ",", "None"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<M\[Omega]\>\"", ",", "26"}], "]"}], ",", "None"}], 
        "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.725951573663952*^9, 3.7259515749335003`*^9}, {
   3.726213827798477*^9, 3.726213840985426*^9}, {3.7262139085971003`*^9, 
   3.7262139253606863`*^9}, {3.726215046166108*^9, 3.7262150463066874`*^9}, {
   3.726215080984563*^9, 3.726215291009939*^9}, {3.7301103408506327`*^9, 
   3.7301103413103952`*^9}, {3.730110985739067*^9, 3.730110985946588*^9}, {
   3.730111961814014*^9, 3.730111982735468*^9}, {3.743039680472281*^9, 
   3.743039681599774*^9}, {3.743039884004706*^9, 3.743039916603087*^9}, {
   3.7430409540167828`*^9, 3.743040960053616*^9}, {3.743041392400819*^9, 
   3.7430414170194798`*^9}, {3.743043522612887*^9, 3.743043535733303*^9}, 
   3.743053643760955*^9, {3.7430547150015717`*^9, 3.743054729192955*^9}, {
   3.743169929235937*^9, 3.74316994720331*^9}, {3.743170476206321*^9, 
   3.743170476420204*^9}, {3.743171304651066*^9, 3.7431713088900137`*^9}, 
   3.743174848628386*^9},ExpressionUUID->"2adc78e3-bafa-4de9-bb07-\
c92cdb6933fc"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwtkwlQEwcUhhHFaUEb65V2BFMQL6oIQgGd2n9rOWxHtILYIlEmiHhUizrQ
IA6gyFGrIiqIICpOvECLByoEbRRBESo3GOQyIQmQBAKlRhGLKcm+N7Ozs9d7
7/+/f21Dwv02m5uZmYWOHsbzvqn5PvLoBHDio4LL+Z+BvU7DDR9u+hxpIIpm
JmrXFJ1D7n7FTZn3AXp+EdN5FlcuFGUjK9NYuVg7xq9zQdBtiE3v52Pjl/dX
VDWWYvRi9M4t+A8sPvudVQN9fwfKn11vOzySwVIq2rXMshD1V+VC5UEtTO0y
xThurvjWR6DHfP6xx/p5DyAMcFT1iQ20jwRB0iFnrwvjmYujX0tFj7Bp/UCQ
lzOH6TXNK8ENsadT/supjKuLsUph99GaPVNsZjDs/DLkXnso37LIlinVzxud
8ATppwWfmHvNZqxM+5Rj3+lxolvF8xk/08BnOCaSOAyFOzKs3gpw4rh5WWec
mc5oY8NKOFaqVMkaF4bd9zl4dzMepZu5MbuN6+2qgmHhfu+UO+4M6081KiQX
a4JbPRgzU9WifXn5thjfJaSnFs4zBUd26jyYFXLjgDokXw7JD7rrTvrqwN9/
1UlT8BWT+tgooB6Xn1ob0rgujEmuSwOyTkcNfjzLiTHJkTbAJWYtZ5BxIP2N
yBr3e1qsyJ7hGdeZ2YRVDROE707wyI8m/BlT++ukv7jMljBjvQBncPiJ4Nmn
5I8U299GxO35YMkYu03Nl6Ja7Fi+8gsL8qsZljveaDtWjGHeGNvpm7F1rM2L
7MIRystLaBZl3024M4xvTAFowcSlUTtPVg6B9bMF8lrz0MjItzCtl9gKnut6
bk7wG8pDG2r8TrxOWKdH1XNjtSGkRHxzG/MarN/t8I/0Xd005V9MMy3YgYdW
yQXudf9QPjugPHhOGRA7AFM7/iuk3oNrmLcOLA8Zulf/8H5JqhasHhk4Adql
XHUPWD4yIElgN3dDF1h9MkxRN7dG6hVgeclx1jwhb0KRnPTK8X2VbsH5H1+B
5SdHS8kRj76UVtLfifGTnU5xHZrB8uzE6o0J1iWjXNh2ndgdNfxAtaUeLF8F
YPl05VhDDfmjwAdXdTJP8jdYPAr0eb6uazKUk19KTL/01M62sIz+PyVe8NoS
sqQl5J8SLSnmWv41Cdg8qGBp+/lIuG8x+anC9cR9bZPj74HNhwozjh76UOte
QP52IfRQ1yWL4Jtg89KFnEGZRNhwjfzugiEiwHtaxhX637uRYjEp5tWgiPzv
hjr7P7f1DTlg89QNe+3yslOrsolHDyw8bRsNkgzi0QPr83MD5rSfJB49qDk8
FBJ9PJV49KA6LOJWesph4qFGRbG9TtOcRDzUsJ4xK2lZZzzxUENf7Sh+YhNH
PDRwi9lan3p0L/HQ4LFX3ubpmgjKpwaL1iUOLebsJh5a5NYI+cL7vxAPLaI9
nwkrI8OIhxY78wSxEbwQ4tGLXeMcR2LtNhCPXjQGjmzI8v+JePRir54fJMr0
Ix59CLR5Nzv1kC/x6MNv2/O2HQ30IR59GI46sLYgeDnx0OH8kdDNtuVfEw8d
5sd3qf13uBEPHTIVmyonCpyJRz8Wvrf6o63CgXj0Y8e76+HvE+2JRz+0Kw3H
A8AjHgM4E5d0eUEOF/8Da84K6Q==
       "]]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[6], 
      AbsoluteThickness[1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\<\" \"\>",
         StripOnInput->False,
         FontSize->2], {0., 0.}], CompressedData["
1:eJwtk3lQU2cUxRHFaUEb65Z2BFMQN6oIQgGd2vNq2doRrSC2SJQJIi7Vog40
iAMostSqCAoiiIoTN9DiggtRG8UNobKDQTYTkgBJIFBqFLGYJnn3znx/vO3e
e87vPPvwqMANoy0sLCKMZ5TxWBrP7snFfvK4ZHCSYsPK+Z+Bvc7CFT9u9ixp
CEqnp2hXlp5C4R7FVZnvXnp+FlN5VhfOlOYjL9dUhVg1KrBzXuh1iM3vF2Pd
l3f9qxofwXhhvHMNQQMLT35n00Df34DyZ/frTg9ksJaKti+xvo36i3Khcp8W
5na5YmRaKr71E+gxl3/4oX7OPQiDnVV9YgPtI0GodMjV58xY5qzxa6noAdav
GQj1ceUwveZ5Zbgi9nYpfjmZcXcz1SM4fLRy5yS7aQw7/zEKL92Xb1xgzzzS
zzFOeILs44JPLH1mMjbmfcqx+/gY0bU7c5lA88BnOCySOA1FOTOs3gpwErlF
eSdcmc44U8NKOFeqVGkaN4bd9zl4N3MeZFt4MDtM622vgmH+Ht/0G54M6081
KiRna8JavRgLc9WifWn55viARaSnFq7TBQe36bwYf7lpQB3SzocXh970JH11
4O+56KIp+YrJeGgSUI/zT20NWVw3xizXrQF5x2MHP57hwpjlSBvgFr+KM8g4
kf5G5I35PStB5MjwTOtMb8LyhnHCd0d45EcT/oyv/XXCX1xmY6SpXoAzOPxE
8OxT8keKLW+jE3d+sGZM3SYXS1Etdi5f9oUV+dUM661vtB3+o5g3pnb6Zmwa
bfci//YI5eUlNAvybybfGMY35gC0YPzi2G1HK4fA+tkCea1lREzMW5jXS2kF
z30NtyDsDeWhDTWBR14nr9aj6rmp2hBeJr66mXkN1u92BMUErGia9C+mmBfs
wH2btBLPun8onx1Q7julDE4YgLkd/xUybsE90lcHlocM3St+eL8oQwtWjwyc
YO1irroHLB8ZkCpwmL22C6w+GSapm1tj9AqwvOQ4aZlcNK5UTnrl+L5KN+/0
j6/A8pOjpeygV196K+nvxNiJLse4Ts1geXZixbpk2zIjF7ZdJ3bEDt9TbawH
y1cBWD9dNtpQQ/4o8MFdncaT/A0WjwJ93q/rmgzl5JcSU889dbC//Zj+PyVe
8NqS86Rl5J8SLemWWv4lCdg8qGBt//lIVMAd8lOFyym72yYm3QKbDxWmHdr/
odazhPztQsT+rnNWYVfB5qULBYMyibDhEvndBUN0sO+UnAv0v3cj3WpC/KtB
EfnfDXX+fx5rGgrA5qkbjtqlj48tzycePbDytm80SHKIRw9sT88OntV+lHj0
oObAUHhcZgbx6EF1ZPS17PQDxEONijuOOk1zKvFQw3bajNQlnUnEQw19tbP4
iV0i8dDAI35TfcahXcRDg4c+RRumaqIpnxosWJ0ytJCzg3hoUVgj5Avv/kI8
tIjzfiasjIkkHlpsKxIkRPPCiUcvto9xHklwWEs8etEYMrI2L+gn4tGLXXp+
qCg3kHj0IcTu3cyM/QHEow+/bSnafCjEj3j0YTh276qSsKXEQ4fTByM22Jd/
TTx0mJvUpQ7a6kE8dMhVrK8cL3AlHv2Y/97mj7YKJ+LRj63vLke9T3EkHv3Q
LjNkBoNHPAZwIjH1/LwCLv4HgKYK6w==
       "]]}, {}}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      StyleBox["\"dE/d\[Omega]\"", 26, StripOnInput -> False], 
      TraditionalForm], None}, {
     FormBox[
      StyleBox["\"M\[Omega]\"", 26, StripOnInput -> False], TraditionalForm], 
     None}},
  FrameStyle->Directive[16, 
    GrayLevel[0], FontFamily -> "Lucida Grande", Italic, 
    AbsoluteThickness[1.1]],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->600,
  LabelStyle->{FontFamily -> "Lucida Grande", Italic, 10, 
    GrayLevel[0]},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.}, {0, 25.302694903514624`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.725953599612053*^9, 3.725955354855295*^9, 3.7259563982094*^9, 
   3.725956551361567*^9, 3.725956953315666*^9, 3.7259571587380466`*^9, 
   3.725957427194881*^9, 3.725957524644965*^9, 3.725957659861898*^9, 
   3.72595786908287*^9, 3.7259579316445637`*^9, {3.726213906203987*^9, 
   3.7262139257434807`*^9}, 3.726214051280369*^9, {3.726215039814579*^9, 
   3.7262150492665157`*^9}, {3.72621509541294*^9, 3.7262151337622013`*^9}, 
   3.726215166256917*^9, {3.726215200057818*^9, 3.726215236981886*^9}, {
   3.7262152772094603`*^9, 3.7262152917506113`*^9}, 3.730111390456421*^9, 
   3.730111944717856*^9, {3.7301119752409267`*^9, 3.73011198319034*^9}, 
   3.743039682212022*^9, 3.743039809940332*^9, 3.743039916836825*^9, 
   3.7430399717335987`*^9, {3.7430409449916143`*^9, 3.743040960616864*^9}, 
   3.743041048797798*^9, 3.743041103261795*^9, 3.7430414185181704`*^9, {
   3.7430435313636703`*^9, 3.743043536278305*^9}, 3.743045238809957*^9, 
   3.743053644336074*^9, 3.743053952284769*^9, {3.743054713034856*^9, 
   3.7430547296076803`*^9}, 3.7430567246119003`*^9, {3.7431699420211277`*^9, 
   3.743169947562984*^9}, 3.7431701232682123`*^9, 3.743170264048882*^9, 
   3.743170367057781*^9, {3.743170465459643*^9, 3.7431704768405857`*^9}, 
   3.743170985412026*^9, 3.743171076590329*^9, 3.7431711844641657`*^9, {
   3.743171262003281*^9, 3.743171281837632*^9}, 3.743171403644161*^9, 
   3.743171434190117*^9, 
   3.743236191642543*^9},ExpressionUUID->"0f7b117f-90f9-47d6-917f-\
116b8d313f87"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1108, 742},
WindowMargins->{{93, Automatic}, {-23, Automatic}},
FrontEndVersion->"11.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 478, 8, 136, "Title",ExpressionUUID->"a893aa8d-e120-4316-b312-36ac0a6454d4"],
Cell[903, 25, 227, 5, 30, "Input",ExpressionUUID->"b7cb238b-0af9-4761-b44f-94cf57b81ced"],
Cell[1133, 32, 1425, 32, 115, "Input",ExpressionUUID->"6e6b942d-4ccd-46ce-a2a3-cb33cb44a2e9"],
Cell[CellGroupData[{
Cell[2583, 68, 1511, 41, 70, "Input",ExpressionUUID->"d04d4f0b-bcca-4a51-919d-4a25b5342125"],
Cell[4097, 111, 1371, 35, 52, "Output",ExpressionUUID->"48d6aabc-dc26-4e07-bf28-bf43aa70f924"]
}, Open  ]],
Cell[5483, 149, 406, 13, 30, "Input",ExpressionUUID->"f3d30b18-246e-4af7-b017-735bf759a4c3"],
Cell[5892, 164, 343, 11, 30, "Input",ExpressionUUID->"8d676438-986d-4ddf-b251-601831f15be1"],
Cell[6238, 177, 477, 12, 30, "Input",ExpressionUUID->"3b8cb415-dbfa-4258-aa3a-6c03bd802371"],
Cell[CellGroupData[{
Cell[6740, 193, 1174, 34, 49, "Input",ExpressionUUID->"0437ef7c-3e60-4250-8706-140a25cff739"],
Cell[7917, 229, 1741, 47, 52, "Output",ExpressionUUID->"b8019389-4dad-4ce7-9cab-aecae944e3b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9695, 281, 350, 6, 54, "Subsection",ExpressionUUID->"b03a8a0b-066c-40b4-a2a2-c10ee52cd8e2"],
Cell[10048, 289, 490, 9, 52, "Input",ExpressionUUID->"e158e823-72d6-4dba-a992-ae0aa5345c03"],
Cell[10541, 300, 2268, 47, 96, "Input",ExpressionUUID->"b0ae9d26-8dfe-401e-a0f8-d96f9c11d895"],
Cell[12812, 349, 1567, 43, 47, "Input",ExpressionUUID->"8936405c-674b-457e-a098-294d43f917f2"],
Cell[CellGroupData[{
Cell[14404, 396, 273, 7, 30, "Input",ExpressionUUID->"d955a6fa-b1d8-4753-b811-33f6aabf3445"],
Cell[14680, 405, 673, 19, 55, "Output",ExpressionUUID->"49aff7d6-fe5d-414b-86b3-ca2dd47773b0"]
}, Open  ]],
Cell[15368, 427, 814, 24, 30, "Input",ExpressionUUID->"aa791daf-1cba-4840-8ae2-c4073da968d7"],
Cell[16185, 453, 1031, 32, 45, "Input",ExpressionUUID->"331aa690-4ffe-4ba7-9d82-f8c52774f281"],
Cell[17219, 487, 391, 7, 30, "Input",ExpressionUUID->"66bf3b95-e049-4d69-b9e1-e3bb4e4fcac7"],
Cell[17613, 496, 2137, 41, 70, "Input",ExpressionUUID->"df696704-d574-4d68-b729-1f189daea8c2"],
Cell[19753, 539, 1632, 44, 98, "Input",ExpressionUUID->"320b975f-afb8-4e6e-8f42-f28537b57af3"],
Cell[21388, 585, 812, 23, 30, "Input",ExpressionUUID->"509d1bc7-427c-492e-b3ca-8721e8487c41"],
Cell[22203, 610, 980, 28, 49, "Input",ExpressionUUID->"b147c48b-11b7-4902-9b8d-f50a917414fd"],
Cell[23186, 640, 193, 4, 30, "Input",ExpressionUUID->"d778f676-b3d7-4305-ac91-4d93b55bc0b2"]
}, Closed]],
Cell[CellGroupData[{
Cell[23416, 649, 163, 3, 38, "Subsection",ExpressionUUID->"a7516cdf-297d-4aff-afe5-d6a150f3df01"],
Cell[23582, 654, 1631, 41, 73, "Input",ExpressionUUID->"5808347c-4dba-4835-9f63-21503c0aff9a"],
Cell[CellGroupData[{
Cell[25238, 699, 1383, 36, 73, "Input",ExpressionUUID->"41e4cb15-4684-430e-b0cb-152f94675c05"],
Cell[26624, 737, 19922, 385, 259, "Output",ExpressionUUID->"413dc5fb-f5b7-4eea-83b3-af688ccc41b1"]
}, Open  ]],
Cell[46561, 1125, 14717, 299, 917, "Input",ExpressionUUID->"0cfbaa34-da18-44df-906d-852ab82dcad9"],
Cell[CellGroupData[{
Cell[61303, 1428, 293, 7, 30, "Input",ExpressionUUID->"d1e3a886-cb0b-48c2-bea2-4a6f3e7b1c47"],
Cell[61599, 1437, 439, 9, 34, "Output",ExpressionUUID->"f883959e-2e7c-4f0e-89ec-78b093d43f3d"]
}, Open  ]],
Cell[62053, 1449, 2061, 35, 30, "Input",ExpressionUUID->"d95c078b-6218-45af-8078-0c1f1f09622f"],
Cell[CellGroupData[{
Cell[64139, 1488, 2706, 61, 115, "Input",ExpressionUUID->"2adc78e3-bafa-4de9-bb07-c92cdb6933fc"],
Cell[66848, 1551, 6682, 130, 408, "Output",ExpressionUUID->"0f7b117f-90f9-47d6-917f-116b8d313f87"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

