from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
#fp=open("test.txt","w")

print ""
print " ____  _____  ___  ___  __    ____  ____ "
print "(  _ \(  _  )/ __)/ __)(  )  ( ___)(  _ \ "
print " )   / )(_)( \__ \\\\__ \ )(__  )__)  )   /"
print "(_)\_)(_____)(___/(___/(____)(____)(_)\_)"
print ""

def rossler_solv():
	global t_max
	global h	
	t_max=400
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)

	print t_tot

	def ros(u,t):
		x,y,z=u
#		sig,r,b=10,28,8/3
		a,b,c=float(e1.get()),float(e2.get()),float(e3.get())
		xd=-y-z
		yd=x+a*y
		zd=b+z*(x-c)
		return[xd,yd,zd]
	u0=[0.2,.5,.8]
	t=np.arange(0,t_max,h)
	print("Running ODEINT()...")
	u=odeint(ros,u0,t)		

	print "Handling Data..."
	#-----To print only one column along with times------
	#====================================================
	#data=np.hstack ((np.expand_dims (t,1),u))
	#np.savetxt("ros_time.dat", data)
	#====================================================

	#-----To print all columns along with times--------
	#====================================================
	tt=np.vstack(t) # stacks row-wise
	global data
	data=np.hstack((tt,u)) # stacks column-wise

	print("Plotting Data...")
	plt.figure(0)
	plt.subplot2grid((3, 3), (0, 0), colspan=2)
	plt.plot(data[:,0],data[:,1],color='red')
	plt.xlabel("$t$")
	plt.ylabel("$x(t)$")
	
	plt.subplot2grid((3, 3), (1, 0), colspan=2)
	plt.plot(data[:,0],data[:,2],color='green')
	plt.xlabel("$t$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (2, 0), colspan=2)
	plt.plot(data[:,0],data[:,3],color='blue')
	plt.xlabel("$t$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (0, 2), rowspan=1)
	plt.plot(data[:,1],data[:,2],color='red')
	plt.xlabel("$x(t)$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (1, 2), rowspan=1)
	plt.plot(data[:,2],data[:,3],color='green')
	plt.xlabel("$y(t)$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (2, 2), rowspan=1)
	plt.plot(data[:,1],data[:,3],color='blue')
	plt.xlabel("$x(t)$")
	plt.ylabel("$z(t)$")

	plt.show()

#	print("Plotting...")
#	plt.subplot(211)
#	plt.plot(data[:,0],data[:,1])
#	plt.xlabel("$t$")
#	plt.ylabel("$x(t),y(t),z(t)$")

#	plt.subplot(212)
#	plt.plot(data[:,1],data[:,2])
#	plt.xlabel("$x(t)$")
#	plt.ylabel("$y(t)$")

#	plt.show()
def rossler_save_data():
	datt='ros_time.dat'
	np.savetxt(datt, data)
	print "Data is saved as : "+datt
	#====================================================
	#print "data="
	#print data

	#----To print data using for loop------------------
	#====================================================
	#for i in np.arange(0,t_tot):
	#	fp.write("{}\t{}\t{}\n".format(i*0.01,u[i,0],u[i,1]))
	#print u

def rossler_save():
	figg='ros.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#------------BIFURCATION a---------------------------
def rossler_bif_a():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)
	global resol_a
	resol_a=float(s1.get())
	us=[]
	usi=[]
	usig=[]

	for a1 in np.arange(0,0.35,resol_a):
		def ros(u,t):
			x,y,z=u
	#		sig,r,b=10,28,8/3
			global a
			a,b,c=a1,float(e2.get()),float(e3.get())
			xd=-y-z
			yd=x+a*y
			zd=b+z*(x-c)
			return[xd,yd,zd]
		u0=[0.2,.5,.8]
		t=np.arange(0,t_max,h)
		print "Running ODEINT() for a = ",a1
		u=odeint(ros,u0,t)

#		print u
#		exit(1)
		for i in np.arange(6000,t_tot-1,1):
			if u[i,0]>u[i-1,0] and u[i,0]>u[i+1,0]:
#				if i>t_tot-4000:
				us.append(u[i,0])
				usi.append(a)
#				print uu
			elif u[i,0]==u[i-1,0] and u[i,0]==u[i+1,0]:
				us.append(u[i,0])
				usi.append(a)
		usig=np.hstack((np.vstack(usi),np.vstack(us)))
#		
	print "Plotting Data..."
	plt.figure(1)
	plt.plot(usig[:,0],usig[:,1],".",color="red")
	plt.xlabel("$a$")
	plt.ylabel("$x_{max}$")
	plt.show()

def rossler_save_bif_a():
	datt='ros_bif_a.dat'
	np.savetxt(datt, usig)
	print "Data is saved as : "+datt
def rossler_save_fig_bif_a():
	figg='ros_bif_a.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#------------BIFURCATION b---------------------------
def rossler_bif_b():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)
	global resol_b
	resol_b=float(s2.get())
	ur=[]
	urr=[]
	urrr=[]

	for b1 in np.arange(0.05,0.5,resol_b):
		def ros(u,t):
			x,y,z=u
	#		sig,r,b=10,28,8/3
			global b
			a,b,c=float(e1.get()),b1,float(e3.get())
			xd=-y-z
			yd=x+a*y
			zd=b+z*(x-c)
			return[xd,yd,zd]
		u0=[0.2,.5,.8]
		t=np.arange(0,t_max,h)
		print "Running ODEINT() for b = ",b1
		u=odeint(ros,u0,t)

#		print u
#		exit(1)
		for i in np.arange(6000,t_tot-1,1):
			if u[i,0]>u[i-1,0] and u[i,0]>u[i+1,0]:
#				if i>t_tot-4000:
				ur.append(u[i,0])
				urr.append(b)
#				print uu
			elif u[i,0]==u[i-1,0] and u[i,0]==u[i+1,0]:
				ur.append(u[i,0])
				urr.append(b)
		urrr=np.hstack((np.vstack(urr),np.vstack(ur)))
#		
	print "Plotting Data..."
	plt.figure(2)
	plt.plot(urrr[:,0],urrr[:,1],".",color="red")
	plt.xlabel("$b$")
	plt.ylabel("$x_{max}$")
	plt.show()

def rossler_save_bif_b():
	datt='ros_bif_b.dat'
	np.savetxt(datt, urrr)
	print "Data is saved as : "+datt
def rossler_save_fig_bif_b():
	figg='ros_bif_b.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#------------BIFURCATION c---------------------------
def rossler_bif_c():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)
	global resol_c
	resol_c=float(s3.get())
	uu=[]
	ub=[]
	ubb=[]

	for c1 in np.arange(0.5,7,resol_c):
		def ros(u,t):
			x,y,z=u
	#		sig,r,b=10,28,8/3
			global c
			a,b,c=float(e1.get()),float(e2.get()),c1
			xd=-y-z
			yd=x+a*y
			zd=b+z*(x-c)
			return[xd,yd,zd]
		u0=[0.2,.5,.8]
		t=np.arange(0,t_max,h)
		print "Running ODEINT() for c = ",c1
		u=odeint(ros,u0,t)

#		print u
#		exit(1)
		for i in np.arange(6000,t_tot-1,1):
			if u[i,0]>u[i-1,0] and u[i,0]>u[i+1,0]:
#				if i>t_tot-4000:
				uu.append(u[i,0])
				ub.append(c)
#				print uu
			elif u[i,0]==u[i-1,0] and u[i,0]==u[i+1,0]:
				uu.append(u[i,0])
				ub.append(c)
		ubb=np.hstack((np.vstack(ub),np.vstack(uu)))
#		
	print "Plotting Data..."
	plt.figure(3)
	plt.plot(ubb[:,0],ubb[:,1],".",color="red")
	plt.xlabel("$c$")
	plt.ylabel("$x_{max}$")
	plt.show()

def rossler_save_bif_c():
	datt='ros_bif_c.dat'
	np.savetxt(datt, ubb)
	print "Data is saved as : "+datt
def rossler_save_fig_bif_c():
	figg='ros_bif_c.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#**************GUI Data Entry********************************
win=Tk()

win.title("It's Rossler System man!")

Label(win,text="Solve Rossler Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=0)
Label(win,text=" the Rossler system, a system of three non-linear\n ordinary differential equations originally\n studied by Otto Rossler. These differential \nequations define a continuous-time dynamical\n system that exhibits chaotic dynamics associated \nwith the fractal properties of the attractor.\n The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=0)
Label(win,text="x'=-y-z\n y'=x+a*y\n z'=b+z*(x-c).",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=0)
Label(win,text="The system shows chaos for a=0.2, b=0.2, c=5.7",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=0)

#Label(win,text="Enter a (0.2):").grid(row=1)
#Label(win,text="Enter b (0.2): ").grid(row=2)
#Label(win,text="Enter c (5.7):").grid(row=3)

global e1
global e2
global e3

e1=Scale(win, from_=0, to=1,length=400, resolution=0.01, label="Enter a:", activebackground="green", orient=HORIZONTAL)
e1.set(0.2)
e2=Scale(win, from_=0, to=1,length=400, resolution=0.01, label="Enter b:",activebackground="green", orient=HORIZONTAL)
e2.set(0.2)
e3=Scale(win, from_=0.5, to=10,length=400, resolution=0.01, label="Enter c:",activebackground="green",  orient=HORIZONTAL)
e3.set(5.7)
#w2.pack()

e1.grid(row=4, column=0)
e2.grid(row=5, column=0)
e3.grid(row=6, column=0)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=7, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=rossler_save_data,bg="Cyan",fg="Blue").grid(row=7, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=rossler_save,bg="Cyan",fg="Blue").grid(row=7, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=rossler_solv,bg="Yellow",fg="Blue").grid(row=7, column=3, sticky=W, pady=4)

Label(win,text="Bifurcations!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=8,column=0)

Button(win,text='Bif wrt a',command=rossler_bif_a,bg="Yellow",fg="Blue").grid(row=9, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=rossler_save_bif_a,bg="Cyan",fg="Blue").grid(row=9, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=rossler_save_fig_bif_a,bg="Cyan",fg="Blue").grid(row=9, column=2, sticky=W, pady=4)

global s1
Label(win,text="Enter a resolution:").grid(row=9)
s1=Entry(win)
s1.insert(10,'0.01')
s1.grid(row=10)

Button(win,text='Bif wrt b',command=rossler_bif_b,bg="Yellow",fg="Blue").grid(row=11, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=rossler_save_bif_b,bg="Cyan",fg="Blue").grid(row=11, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=rossler_save_fig_bif_b,bg="Cyan",fg="Blue").grid(row=11, column=2, sticky=W, pady=4)

global s2
Label(win,text="Enter b resolution(0.01):").grid(row=11)
s2=Entry(win)
s2.insert(10,'0.01')
s2.grid(row=12)

Button(win,text='Bif wrt c',command=rossler_bif_c,bg="Yellow",fg="Blue").grid(row=13, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=rossler_save_bif_c,bg="Cyan",fg="Blue").grid(row=13, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=rossler_save_fig_bif_c,bg="Cyan",fg="Blue").grid(row=13, column=2, sticky=W, pady=4)

global s3
Label(win,text="Enter c resolution(0.05):").grid(row=13)
s3=Entry(win)
s3.insert(10,'0.05')
s3.grid(row=14)

win.mainloop()

