from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
#fp=open("test.txt","w")

def rossler_solv():
	t_max=400
	h=0.01
	#t_tot = int(t_max/h)
	print("Maximum time = "+str(t_max))

	def ros(u,t):
		x,y,z=u
#		sig,r,b=10,28,8/3
		a,b,c=float(e1.get()),float(e2.get()),float(e3.get())
		xd=-y-z
		yd=x+a*y
		zd=b+z*(x-c)
		return[xd,yd,zd]
	u0=[0.2,.5,.8]
	t=np.arange(0,t_max,h)
	print("Running ODEINT()...")
	u=odeint(ros,u0,t)

	print("Handling Data...")
	#-----To print only one column along with times------
	#====================================================
	#data=np.hstack ((np.expand_dims (t,1),u))
	#np.savetxt("ros_time.dat", data)
	#====================================================

	#-----To print all columns along with times--------
	#====================================================
	tt=np.vstack(t) # stacks row-wise
	global data
	data=np.hstack((tt,u)) # stacks column-wise

	print("Plotting Data...")
	plt.figure(0)
	plt.subplot2grid((3, 3), (0, 0), colspan=2)
	plt.plot(data[:,0],data[:,1],color='red')
	plt.xlabel("$t$")
	plt.ylabel("$x(t)$")
	
	plt.subplot2grid((3, 3), (1, 0), colspan=2)
	plt.plot(data[:,0],data[:,2],color='green')
	plt.xlabel("$t$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (2, 0), colspan=2)
	plt.plot(data[:,0],data[:,3],color='blue')
	plt.xlabel("$t$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (0, 2), rowspan=1)
	plt.plot(data[:,1],data[:,2],color='red')
	plt.xlabel("$x(t)$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (1, 2), rowspan=1)
	plt.plot(data[:,2],data[:,3],color='green')
	plt.xlabel("$y(t)$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (2, 2), rowspan=1)
	plt.plot(data[:,1],data[:,3],color='blue')
	plt.xlabel("$x(t)$")
	plt.ylabel("$z(t)$")

	plt.show()

#	print("Plotting...")
#	plt.subplot(211)
#	plt.plot(data[:,0],data[:,1])
#	plt.xlabel("$t$")
#	plt.ylabel("$x(t),y(t),z(t)$")

#	plt.subplot(212)
#	plt.plot(data[:,1],data[:,2])
#	plt.xlabel("$x(t)$")
#	plt.ylabel("$y(t)$")

#	plt.show()

def rossler_save_data():
	datt='ros_time.dat'
	np.savetxt(datt, data)
	print("Data is saved as : "+datt)
	#====================================================
	#print "data="
	#print data

	#----To print data using for loop------------------
	#====================================================
	#for i in np.arange(0,t_tot):
	#	fp.write("{}\t{}\t{}\n".format(i*0.01,u[i,0],u[i,1]))
	#print u
	
def rossler_save():
	figg='ros.png'
	plt.savefig(figg)
	print("Figure is saved as : "+figg)

#**************GUI Data Entry********************************
win=Tk()

Label(win,text="Solve Rossler Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)
Label(win,text=" the Rossler system, a system of three non-linear ordinary differential equations originally\n studied by Otto Rossler. These differential equations define a continuous-time dynamical\n system that exhibits chaotic dynamics associated with the fractal properties of the attractor.\n The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=1)
Label(win,text="x'=-y-z\n y'=x+a*y\n z'=b+z*(x-c).",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=1)
Label(win,text="The system shows chaos for a=0.2, b=0.2, c=5.7",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=1)

#Label(win,text="Enter a (0.2):").grid(row=1)
#Label(win,text="Enter b (0.2): ").grid(row=2)
#Label(win,text="Enter c (5.7):").grid(row=3)

global e1
global e2
global e3

e1=Scale(win, from_=0, to=1,length=600, resolution=0.01, label="Enter a:", activebackground="green", orient=HORIZONTAL)
e1.set(0.2)
e2=Scale(win, from_=0, to=1,length=600, resolution=0.01, label="Enter b:",activebackground="green", orient=HORIZONTAL)
e2.set(0.2)
e3=Scale(win, from_=0, to=10,length=600, resolution=0.01, label="Enter c:",activebackground="green",  orient=HORIZONTAL)
e3.set(5.7)
#w2.pack()

e1.grid(row=4, column=1)
e2.grid(row=5, column=1)
e3.grid(row=6, column=1)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=7, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=rossler_save_data,bg="Cyan",fg="Blue").grid(row=7, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=rossler_save,bg="Cyan",fg="Blue").grid(row=7, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=rossler_solv,bg="Yellow",fg="Blue").grid(row=7, column=3, sticky=W, pady=4)

win.mainloop()

