from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

print ""
print " __    _____  ____  _  _    __   "
print "(  )  (  _  )(_  _)( )/ )  /__\  "
print " )(__  )(_)(   )(   )  (  /(__)\ "
print "(____)(_____) (__) (_)\_)(__)(__)"
print ""

def pp_solv():
	a,b,c,d = float(e1.get()),float(e2.get()),1,1
	t_int=0
	t_fin=100
	h=0.01
	NN=(t_fin-t_int)/h

	def dP_dt(P, t):
	    return [P[0]*(a - b*P[1]), -P[1]*(c - d*P[0])]

	ts = np.linspace(0, t_fin, NN)
	P0 = [1.5, 1.0]
	Ps = odeint(dP_dt, P0, ts)
	prey = Ps[:,0]
	predators = Ps[:,1]

	print("Handling Data...")
	tt=np.vstack(ts) # stacks row-wise
	#print tt
	global data
	data=np.hstack((tt,Ps)) # stacks column-wise

	print("Plotting Data...")
	plt.figure(0)
	plt.subplot2grid((2, 2), (0, 0), colspan=1)
	plt.plot(ts, predators, color='red')
	plt.xlabel("Time")
	plt.ylabel("Foxes")

	plt.subplot2grid((2, 2), (1, 0), colspan=1)	
	plt.plot(ts, prey, color='green', label="Rabbits")
	plt.xlabel("Time")
	plt.ylabel("Population")

	plt.subplot2grid((2, 2), (0, 1), rowspan=2)
	plt.plot(prey, predators, "-", color="blue")
	plt.xlabel("Rabbits")
	plt.ylabel("Foxes")
	plt.title("Rabbits vs Foxes");

	plt.show()

def pp_save_data():
	datt='predator_prey_time.dat'
	np.savetxt(datt, data)
	print("Data is saved as : "+datt)

def pp_save():
	figg='predator_prey.png'
	plt.savefig(figg)
	print("Figure is saved as : "+figg)

#**************GUI Data Entry********************************
win=Tk()

win.title("It's Lotka-Volterra System man!")

Label(win,text="Solve Lotka-Volterra Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)
Label(win,text="The Lotka-Volterra equations, also known as the predator-prey equations,\n are a pair of first-order, nonlinear, differential equations frequently\n used to describe the dynamics of biological systems in which two species\n interact, one as a predator and the other as prey.The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=1)
Label(win,text="x'=-a*x-b*x*y\n y'=c*x*y-d*y,",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=1)
Label(win,text="For a=2/3, b=4/3, c=1=d.",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=1)

global e1
global e2

Label(win,text="Enter a:").grid(row=1)
e1=Scale(win, from_=0, to=2,length=400, resolution=0.01, activebackground="green", orient=HORIZONTAL)
e1.set(0.67)

Label(win,text="Enter b: ").grid(row=2)
e2=Scale(win, from_=0, to=2,length=400, resolution=0.1, activebackground="green", orient=HORIZONTAL)
e2.set(1.33)

e1.grid(row=4, column=1)
e2.grid(row=5, column=1)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=6, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=pp_save_data,bg="Cyan",fg="Blue").grid(row=6, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=pp_save,bg="Cyan",fg="Blue").grid(row=6, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=pp_solv,bg="Yellow",fg="Blue").grid(row=6, column=3, sticky=W, pady=4)

win.mainloop()




