from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
#fp=open("test.txt","w")

print ""
print " __    _____  ____  ____  _  _  ____ "
print "(  )  (  _  )(  _ \( ___)( \( )(_   )"
print " )(__  )(_)(  )   / )__)  )  (  / /_ "
print "(____)(_____)(_)\_)(____)(_)\_)(____)"
print ""

def lorenz_solv():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)

	print t_tot

	def lor(u,t):
		x,y,z=u
#		sig,r,b=10,28,8/3
		sig,r,b=float(e1.get()),float(e2.get()),float(e3.get())
		xd=sig*(y-x)
		yd=r*x-x*z-y
		zd=-b*z+x*y
		return[xd,yd,zd]
	u0=[0.2,.5,.8]
	t=np.arange(0,t_max,h)
	print "Running ODEINT()..." 
	u=odeint(lor,u0,t)		

	print "Handling Data..."
	#-----To print only one column along with times------
	#====================================================
	#data=np.hstack ((np.expand_dims (t,1),u))
	#np.savetxt("lor_time.dat", data)
	#====================================================

	#-----To print all columns along with times--------
	#====================================================
	tt=np.vstack(t) # stacks row-wise
	#print tt
	global data
	data=np.hstack((tt,u)) # stacks column-wise

	print("Plotting Data...")
	plt.figure(0)
	plt.subplot2grid((3, 3), (0, 0), colspan=2)
	plt.plot(data[:,0],data[:,1],color='red')
	plt.xlabel("$t$")
	plt.ylabel("$x(t)$")
	
	plt.subplot2grid((3, 3), (1, 0), colspan=2)
	plt.plot(data[:,0],data[:,2],color='green')
	plt.xlabel("$t$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (2, 0), colspan=2)
	plt.plot(data[:,0],data[:,3],color='blue')
	plt.xlabel("$t$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (0, 2), rowspan=1)
	plt.plot(data[:,1],data[:,2],color='red')
	plt.xlabel("$x(t)$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (1, 2), rowspan=1)
	plt.plot(data[:,2],data[:,3],color='green')
	plt.xlabel("$y(t)$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (2, 2), rowspan=1)
	plt.plot(data[:,1],data[:,3],color='blue')
	plt.xlabel("$x(t)$")
	plt.ylabel("$z(t)$")

	plt.show()

#	print("Plotting...")
#	plt.subplot(211)
#	plt.plot(data[:,0],data[:,1])
#	plt.xlabel("$t$")
#	plt.ylabel("$x(t),y(t),z(t)$")

#	plt.subplot(212)
#	plt.plot(data[:,1],data[:,2])
#	plt.xlabel("$x(t)$")
#	plt.ylabel("$y(t)$")

#	plt.show()
def lorenz_save_data():
	datt='lor_time.dat'
	np.savetxt(datt, data)
	print "Data is saved as : "+datt
	#====================================================
	#print "data="
	#print data

	#----To print data using for loop------------------
	#====================================================
	#for i in np.arange(0,t_tot):
	#	fp.write("{}\t{}\t{}\n".format(i*0.01,u[i,0],u[i,1]))
	#print u

def lorenz_save():
	figg='lor.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#------------BIFURCATION sigma---------------------------
def lorenz_bif_sig():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)
	global resol_sig
	resol_sig=float(s1.get())
	us=[]
	usi=[]
	usig=[]

	for sig1 in np.arange(4,10,resol_sig):
		def lor(u,t):
			x,y,z=u
	#		sig,r,b=10,28,8/3
			global sig
			sig,r,b=sig1,float(e2.get()),float(e3.get())
			xd=sig*(y-x)
			yd=r*x-x*z-y
			zd=-b*z+x*y
			return[xd,yd,zd]
		u0=[0.2,.5,.8]
		t=np.arange(0,t_max,h)
		print "Running ODEINT() for sig =",sig1
		u=odeint(lor,u0,t)

#		print u
#		exit(1)
		for i in np.arange(6000,t_tot-1,1):
			if u[i,0]>u[i-1,0] and u[i,0]>u[i+1,0]:
#				if i>t_tot-4000:
				us.append(u[i,0])
				usi.append(sig)
#				print uu
			elif u[i,0]==u[i-1,0] and u[i,0]==u[i+1,0]:
				us.append(u[i,0])
				usi.append(sig)
		usig=np.hstack((np.vstack(usi),np.vstack(us)))
#		
	print "Plotting Data..."
	plt.figure(1)
	plt.plot(usig[:,0],usig[:,1],".",color="red")
	plt.xlabel("$sigma$")
	plt.ylabel("$x_{max}$")
	plt.show()

def lorenz_save_bif_sig():
	datt='lor_bif_sig.dat'
	np.savetxt(datt, usig)
	print "Data is saved as : "+datt
def lorenz_save_fig_bif_sig():
	figg='lor_bif_sig.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#------------BIFURCATION r---------------------------
def lorenz_bif_r():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)
	global resol_r
	resol_r=float(s2.get())
	ur=[]
	urr=[]
	urrr=[]

	for r1 in np.arange(23,29,resol_r):
		def lor(u,t):
			x,y,z=u
	#		sig,r,b=10,28,8/3
			global r
			sig,r,b=float(e1.get()),r1,float(e3.get())
			xd=sig*(y-x)
			yd=r*x-x*z-y
			zd=-b*z+x*y
			return[xd,yd,zd]
		u0=[0.2,.5,.8]
		t=np.arange(0,t_max,h)
		print "Running ODEINT() for r =",r1
		u=odeint(lor,u0,t)

#		print u
#		exit(1)
		for i in np.arange(6000,t_tot-1,1):
			if u[i,0]>u[i-1,0] and u[i,0]>u[i+1,0]:
#				if i>t_tot-4000:
				ur.append(u[i,0])
				urr.append(r)
#				print uu
			elif u[i,0]==u[i-1,0] and u[i,0]==u[i+1,0]:
				ur.append(u[i,0])
				urr.append(r)
		urrr=np.hstack((np.vstack(urr),np.vstack(ur)))
#		
	print "Plotting Data..."
	plt.figure(2)
	plt.plot(urrr[:,0],urrr[:,1],".",color="red")
	plt.xlabel("$r$")
	plt.ylabel("$x_{max}$")
	plt.show()

def lorenz_save_bif_r():
	datt='lor_bif_r.dat'
	np.savetxt(datt, urrr)
	print "Data is saved as : "+datt
def lorenz_save_fig_bif_r():
	figg='lor_bif_r.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg

#------------BIFURCATION B---------------------------
def lorenz_bif_b():
	global t_max
	global h	
	t_max=100
	h=0.01
	global t_tot
	t_tot = int(t_max/h)
	print "Maximum time = "+str(t_max)
	global resol_b
	resol_b=float(s3.get())
	uu=[]
	ub=[]
	ubb=[]

	for b1 in np.arange(0.01,3,resol_b):
		def lor(u,t):
			x,y,z=u
	#		sig,r,b=10,28,8/3
			global b
			sig,r,b=float(e1.get()),float(e2.get()),b1
			xd=sig*(y-x)
			yd=r*x-x*z-y
			zd=-b*z+x*y
			return[xd,yd,zd]
		u0=[0.2,.5,.8]
		t=np.arange(0,t_max,h)
		print "Running ODEINT() for b =",b1
		u=odeint(lor,u0,t)

#		print u
#		exit(1)
		for i in np.arange(6000,t_tot-1,1):
			if u[i,0]>u[i-1,0] and u[i,0]>u[i+1,0]:
#				if i>t_tot-4000:
				uu.append(u[i,0])
				ub.append(b)
#				print uu
			elif u[i,0]==u[i-1,0] and u[i,0]==u[i+1,0]:
				uu.append(u[i,0])
				ub.append(b)
		ubb=np.hstack((np.vstack(ub),np.vstack(uu)))
#		
	print "Plotting Data..."
	plt.figure(3)
	plt.plot(ubb[:,0],ubb[:,1],".",color="red")
	plt.xlabel("$b$")
	plt.ylabel("$x_{max}$")
	plt.show()

def lorenz_save_bif_b():
	datt='lor_bif_b.dat'
	np.savetxt(datt, ubb)
	print "Data is saved as : "+datt
def lorenz_save_fig_bif_b():
	figg='lor_bif_b.png'
	plt.savefig(figg)
	print "Figure is saved as : "+figg


#**************GUI Data Entry********************************
win=Tk()

win.title("It's Lorenz System man!")

Label(win,text="Solve Lorenz Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=0)
Label(win,text="The simplified mathematical model for atmospheric\n convection developed by Edward Lorenz.\n The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=0)
Label(win,text="x'=sigma*(y-x)\n y'=r*(1-z)*x-y\n z'=-b*z+x*y,",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=0)
Label(win,text="sigma=10, r=28 and b=2.67 produce chaos in the system.",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=0)

#Label(win,text="Enter sigma (10):").grid(row=2)
#Label(win,text="Enter r (28): ").grid(row=3)
#Label(win,text="Enter b (2.67):").grid(row=4)

global e1
global e2
global e3

e1=Scale(win, from_=0, to=20,length=400, resolution=0.1, label="Enter sigma:", activebackground="green", orient=HORIZONTAL)
e1.set(10)
e2=Scale(win, from_=0, to=35,length=400, resolution=0.1, label="Enter r:", activebackground="green", orient=HORIZONTAL)
e2.set(28)
e3=Scale(win, from_=0, to=5,length=400, resolution=0.01, label="Enter b:", activebackground="green",  orient=HORIZONTAL)
e3.set(2.67)
#w2.pack()

e1.grid(row=4, column=0)
e2.grid(row=5, column=0)
e3.grid(row=6, column=0)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=7, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=lorenz_save_data,bg="Cyan",fg="Blue").grid(row=7, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=lorenz_save,bg="Cyan",fg="Blue").grid(row=7, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=lorenz_solv,bg="Yellow",fg="Blue").grid(row=7, column=3, sticky=W, pady=4)

Label(win,text="Bifurcations!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=8,column=0)

Button(win,text='Bif wrt sigma',command=lorenz_bif_sig,bg="Yellow",fg="Blue").grid(row=9, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=lorenz_save_bif_sig,bg="Cyan",fg="Blue").grid(row=9, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=lorenz_save_fig_bif_sig,bg="Cyan",fg="Blue").grid(row=9, column=2, sticky=W, pady=4)

global s1
Label(win,text="Enter sigma resolution:").grid(row=9)
s1=Entry(win)
s1.insert(10,'0.1')
s1.grid(row=10)

Button(win,text='Bif wrt r',command=lorenz_bif_r,bg="Yellow",fg="Blue").grid(row=11, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=lorenz_save_bif_r,bg="Cyan",fg="Blue").grid(row=11, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=lorenz_save_fig_bif_r,bg="Cyan",fg="Blue").grid(row=11, column=2, sticky=W, pady=4)

global s2
Label(win,text="Enter r resolution:").grid(row=11)
s2=Entry(win)
s2.insert(10,'0.1')
s2.grid(row=12)

Button(win,text='Bif wrt b',command=lorenz_bif_b,bg="Yellow",fg="Blue").grid(row=13, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=lorenz_save_bif_b,bg="Cyan",fg="Blue").grid(row=13, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=lorenz_save_fig_bif_b,bg="Cyan",fg="Blue").grid(row=13, column=2, sticky=W, pady=4)

global s3
Label(win,text="Enter b resolution:").grid(row=13)
s3=Entry(win)
s3.insert(10,'0.05')
s3.grid(row=14)

win.mainloop()

