from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
#fp=open("test.txt","w")

def lorenz_solv():
	t_max=100
	h=0.01
	#t_tot = int(t_max/h)
	print("Maximum time = "+str(t_max))

	def lor(u,t):
		x,y,z=u
#		sig,r,b=10,28,8/3
		sig,r,b=float(e1.get()),float(e2.get()),float(e3.get())
		xd=sig*(y-x)
		print xd
		yd=r*x-x*z-y
		zd=-b*z+x*y
		return[xd,yd,zd]
	u0=[0.2,.5,.8]
	t=np.arange(0,t_max,h)
	print("Running ODEINT()...")
	u=odeint(lor,u0,t)

	print("Handling Data...")
	#-----To print only one column along with times------
	#====================================================
	#data=np.hstack ((np.expand_dims (t,1),u))
	#np.savetxt("lor_time.dat", data)
	#====================================================

	#-----To print all columns along with times--------
	#====================================================
	tt=np.vstack(t) # stacks row-wise
	#print tt
	global data
	data=np.hstack((tt,u)) # stacks column-wise

	print("Plotting Data...")
	plt.figure(0)
	plt.subplot2grid((3, 3), (0, 0), colspan=2)
	plt.plot(data[:,0],data[:,1],color='red')
	plt.xlabel("$t$")
	plt.ylabel("$x(t)$")
	
	plt.subplot2grid((3, 3), (1, 0), colspan=2)
	plt.plot(data[:,0],data[:,2],color='green')
	plt.xlabel("$t$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (2, 0), colspan=2)
	plt.plot(data[:,0],data[:,3],color='blue')
	plt.xlabel("$t$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (0, 2), rowspan=1)
	plt.plot(data[:,1],data[:,2],color='red')
	plt.xlabel("$x(t)$")
	plt.ylabel("$y(t)$")

	plt.subplot2grid((3, 3), (1, 2), rowspan=1)
	plt.plot(data[:,2],data[:,3],color='green')
	plt.xlabel("$y(t)$")
	plt.ylabel("$z(t)$")

	plt.subplot2grid((3, 3), (2, 2), rowspan=1)
	plt.plot(data[:,1],data[:,3],color='blue')
	plt.xlabel("$x(t)$")
	plt.ylabel("$z(t)$")

	plt.show()

#	print("Plotting...")
#	plt.subplot(211)
#	plt.plot(data[:,0],data[:,1])
#	plt.xlabel("$t$")
#	plt.ylabel("$x(t),y(t),z(t)$")

#	plt.subplot(212)
#	plt.plot(data[:,1],data[:,2])
#	plt.xlabel("$x(t)$")
#	plt.ylabel("$y(t)$")

#	plt.show()

def lorenz_save_data():
	datt='lor_time.dat'
	np.savetxt(datt, data)
	print("Data is saved as : "+datt)
	#====================================================
	#print "data="
	#print data

	#----To print data using for loop------------------
	#====================================================
	#for i in np.arange(0,t_tot):
	#	fp.write("{}\t{}\t{}\n".format(i*0.01,u[i,0],u[i,1]))
	#print u

	
def lorenz_save():
	figg='lor.png'
	plt.savefig(figg)
	print("Figure is saved as : "+figg)

#**************GUI Data Entry********************************
win=Tk()

Label(win,text="Solve Lorenz Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)
Label(win,text="The simplified mathematical model for atmospheric convection developed by Edward Lorenz.\n The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=1)
Label(win,text="x'=sigma*(y-x)\n y'=r*(1-z)*x-y\n z'=-b*z+x*y,",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=1)
Label(win,text="sigma=10, r=28 and b=2.67 produce chaos in the system.",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=1)

#Label(win,text="Enter sigma (10):").grid(row=2)
#Label(win,text="Enter r (28): ").grid(row=3)
#Label(win,text="Enter b (2.67):").grid(row=4)

global e1
global e2
global e3

e1=Scale(win, from_=0, to=20,length=600, resolution=0.1, label="Enter sigma:", activebackground="green", orient=HORIZONTAL)
e1.set(10)
e2=Scale(win, from_=0, to=35,length=600, resolution=0.1, label="Enter r:", activebackground="green", orient=HORIZONTAL)
e2.set(28)
e3=Scale(win, from_=0, to=5,length=600, resolution=0.01, label="Enter b:", activebackground="green",  orient=HORIZONTAL)
e3.set(2.67)
#w2.pack()

e1.grid(row=4, column=1)
e2.grid(row=5, column=1)
e3.grid(row=6, column=1)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=7, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=lorenz_save_data,bg="Cyan",fg="Blue").grid(row=7, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=lorenz_save,bg="Cyan",fg="Blue").grid(row=7, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=lorenz_solv,bg="Yellow",fg="Blue").grid(row=7, column=3, sticky=W, pady=4)

win.mainloop()

