'''DYNASYS 
written by 
	Dr. Debabrata Biswas
	Department of Physics
	Rampurhat College
	Email-debbisrs@gmail.com
'''

from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

#***********************************************
def my_new_syst():
    global param
    param=[]
    for pp in range(parnum):
        param.append(par[pp].get())
    print(param)

    # Toplevel popup window to show variables---------------------------------------
    def vis():
        top = Toplevel()
        top.title("Visuals variables")
        global ts
        ts=IntVar()
        Checkbutton(top,text="Time Series",variable=ts,bg="violet",fg="black",font = "Helvetica 12 bold italic").grid(row=0,column=0)
        global pplot
        global pplotT
        pplot=[]
        pplotT=[]
        for dimm in range(dim):
            pplot.append("pplott"+str(dimm))
            pplotT.append("pplottT"+str(dimm))
            pplot[dimm] = IntVar()
            pplotT[dimm] = IntVar()
            Checkbutton(top, text="x"+str(dimm), variable=pplot[dimm],font = "Helvetica 12 bold italic").grid(row=dimm+1, column=0, sticky=W)
            Checkbutton(top, text="x"+str(dimm)+"_"+str(dela.get()), variable=pplotT[dimm],font = "Helvetica 12 bold italic").grid(row=dimm+2, column=0, sticky=W)

#        Label(top,text="Phase Space",bg="yellow",fg="black",font = "Helvetica 12 italic").grid(row=0,column=2)
        global phh
        phh=IntVar()
        Checkbutton(top,text="Phase Space",variable=phh,bg="yellow",fg="black",font = "Helvetica 12 bold italic").grid(row=0, column=1, sticky=W)
        global phplot
        global phplotT
        phplot=[]
        phplotT=[]
        for dm in range(dim):
            phplot.append("ph"+str(dm))
            phplotT.append("phT"+str(dm))
            phplot[dm]=IntVar()
            phplotT[dm]=IntVar()
            Checkbutton(top,text="x"+str(dm),variable=phplot[dm],font = "Helvetica 12 bold italic").grid(row=dm+1, column=1, sticky=W)
            Checkbutton(top,text="x"+str(dm)+"_"+str(dela.get()),variable=phplotT[dm],font = "Helvetica 12 bold italic").grid(row=dm+2, column=1, sticky=W)

        button = Button(top, text="Dismiss", command=top.destroy, bg="Red",fg="White", relief=RAISED,borderwidth=4).grid(row=dim+3)
#-------------------------------------------------------------------------------

# Program to write python file in the my_program.py-----------------------------
    def my_prog():
#       var=u
       with open('systems/new_system_dde/file_write_dde/my_program_dde.py', 'w') as fp:
            fp.write('from Tkinter import *\n')
            fp.write('import numpy as np\n')
            fp.write('from pydelay import dde23\n')
            fp.write('import matplotlib.pyplot as plt\n')
            fp.write('import matplotlib.gridspec as gridspec\n')
            fp.write("\n")
            fp.write("tfinal="+str(float(tottim.get()))+"\n")
            fp.write("t_trans="+str(float(transient.get()))+"\n")
            fp.write("h="+str(float(steph.get()))+"\n")
            fp.write("t_instant=t_trans+"+str(float(delaytau.get()))+"\n") #??????????replace dela
            fp.write("t_delayed=tfinal-"+str(float(delaytau.get()))+"\n") #???????????replace dela
            #t_tot = int(t_max/h)
            fp.write("print(\"Maximum time = \"+str(tfinal))\n")

            fp.write("\n")

            fp.write("eqns = {\n")

            #equation------------
            for xx in range(dim):
                if xx < dim-1:
                    fp.write("    \'x"+str(xx)+"\' : ")
                    fp.write("\'"+eeqq[xx].get()+"\',\n")
                else:
                    fp.write("    \'x"+str(xx)+"\' : ")
                    fp.write("\'"+eeqq[xx].get()+"\'\n")
            fp.write("    }\n")

            #To write parameters---------------
            fp.write("params = {\n")
            fp.write("    \'"+str(dela.get())+"\':"+str(float(delaytau.get()))+",\n")
#            fp.write("    ")
            for pp1 in range(parnum):
                pparr=str(param[pp1])
                pparr_val=float(paramid[pp1].get())
                if pp1 < parnum-1:
                    fp.write("    \'"+pparr+"\' : "+str(pparr_val)+",\n")
                else:
                    fp.write("    \'"+pparr+"\' : "+str(pparr_val)+"\n")
            fp.write("    }\n\n")

            fp.write("dde = dde23(eqns=eqns, params=params)\n")
            fp.write("dde.set_sim_params(tfinal, dtmax=1.0)\n\n")

            fp.write("histfunc = {\n")
            for dd in range(dim):
                if dd < dim-1:
                    fp.write("    \'x"+str(dd)+"\': lambda t: "+str(float(inita[dd].get()))+",\n")
                else:
                    fp.write("    \'x"+str(dd)+"\': lambda t: "+str(float(inita[dd].get()))+"\n")
            fp.write("    }\n\n")

            fp.write("dde.hist_from_funcs(histfunc, 500)\n\n")
        
            fp.write("dde.run()\n\n")

            fp.write("sol1 = dde.sample(t_instant,tfinal,h)\n")
            for d1 in range(dim):
                fp.write("x"+str(d1)+"sol1=sol1[\'x"+str(d1)+"\']\n")
            fp.write("t=sol1[\'t\']\n\n")

            fp.write("sol2 = dde.sample(t_trans,t_delayed,h)\n")
            for d2 in range(dim):
                fp.write("x"+str(d2)+"Tsol2=sol2[\'x"+str(d2)+"\']\n\n")

            #Data Handling -------------------------------
            fp.write("print(\"Handling Data...\")\n")
            fp.write("global data\n")
            fp.write("data=np.hstack((np.vstack(t),")
            for ddi in range(dim):
                fp.write("np.vstack(x"+str(ddi)+"sol1),")
                if ddi<dim-1:
                    fp.write("np.vstack(x"+str(ddi)+"Tsol2),")
                else:
                    fp.write("np.vstack(x"+str(ddi)+"Tsol2)")
            fp.write("))\n\n")

            if str(int(transient.get()))>0:
                fp.write("for i in range("+str(int(float(transient.get())/float(steph.get())))+"):\n") 
                fp.write("    data=np.delete(data,0,0)\n\n") 

           #Plotting---------------------------------------
            fp.write("print(\"Plotting Data...\")\n")
            fp.write("plt.figure(0)\n")
            if ts.get()==1 and phh.get()==0:
                fp.write("plt.subplot2grid((1, 1), (0, 0))\n")
                for di in range(dim):
                    print("visual="+str(int(pplot[di].get())))
                    if pplot[di].get()==1 and phplot[di].get()==0:                     
                        fp.write("plt.plot(data[:,0],data[:,"+str(di+1)+"])\n")
                    if pplotT[di].get()==1 and phplot[di].get()==0:                     
                        fp.write("plt.plot(data[:,0],data[:,"+str(di+2)+"])\n")
            if dim==1 and ts.get()==0 and phh.get()==1:
                fp.write("plt.subplot2grid((1, 1), (0, 0))\n")
                fp.write("plt.plot(data[:,"+str(1)+"],data[:,"+str(2)+"])\n")   
            elif dim>1 and ts.get()==0 and phh.get()==1:
                fp.write("plt.subplot2grid((1, 1), (0, 0))\n")
                fp.write("plt.plot(")
                for di in range(dim):
                    if pplot[di].get()==0 and phplot[di].get()==1: 
                        if di<dim-1:
                            fp.write("data[:,"+str(di+1)+"],")
                        else:
                            fp.write("data[:,"+str(di+1)+"]")
                fp.write(")\n")
                fp.write("plt.plot(")
                for di in range(dim):
                    if pplot[di].get()==0 and phplotT[di].get()==1: 
                        if di<dim-1:
                            fp.write("data[:,"+str(di+2)+"],")
                        else:
                            fp.write("data[:,"+str(di+2)+"]")
                fp.write(")\n\n")

            if dim==1 and ts.get()==1 and phh.get()==1:
                fp.write("plt.subplot2grid((1, 3), (0, 0), colspan=2)\n")
                if pplot[0].get()==1 and pplotT[0].get()==0:
                    fp.write("plt.plot(data[:,0],data[:,"+str(1)+"])\n")
                elif pplot[0].get()==1 and pplotT[0].get()==1:
                    fp.write("plt.plot(data[:,0],data[:,"+str(1)+"])\n")
                    fp.write("plt.plot(data[:,0],data[:,"+str(2)+"])\n")
                fp.write("plt.subplot2grid((1, 3), (0, 2),rowspan=1)\n")
                if phplot[0].get()==1:
                   fp.write("plt.plot(data[:,"+str(1)+"],data[:,"+str(2)+"])\n") 
            elif dim>1 and ts.get()==1 and phh.get()==1:
                fp.write("plt.subplot2grid((1, 3), (0, 0), colspan=2)\n")
                for di in range(dim):
                    if pplot[di].get()==1:                     
                        fp.write("plt.plot(data[:,0],data[:,"+str(di+1)+"])\n")
                fp.write("plt.subplot2grid((1, 3), (0, 2),rowspan=1)\n")
                fp.write("plt.plot(")
                for di in range(dim):
                    if phplot[di].get()==1: 
                        if di<dim-1:
                            fp.write("data[:,"+str(di+1)+"],")
                        else:
                            fp.write("data[:,"+str(di+1)+"]")
                fp.write(")\n\n")
                    
#            fp.write("plt.xlabel(\"$t$\")\n")
#            fp.write("plt.ylabel(\"$x(t)$\")\n")

            fp.write("\n")
            fp.write("plt.show()\n")
            
            di=0
            print("file has been written now RUN")
#-------------------------------------------------------------------------------

    def execute_file():
        execfile("systems/new_system_dde/file_write_dde/my_program_dde.py")

    def new_save_data():
        ddat = Toplevel()
        ddat.title("Data File")
        Label(ddat,text="Name:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=0,column=0,sticky=W)
        datt=Entry(ddat)
        datt.insert(10,"dde_timeseries.dat")
        datt.grid(row=0, column=1,sticky=W)
        def save_dat():
	    np.savetxt(str(datt.get()), data)
	    print("Data is saved as : \""+str(datt.get())+"\"")
        Button(ddat, text="Save", command=save_dat, bg="Green",fg="White", relief=RAISED,borderwidth=4).grid(row=1, column=0)
        Button(ddat, text="Close", command=ddat.destroy, bg="Red",fg="White", relief=RAISED,borderwidth=4).grid(row=1, column=1)

    def new_save_figure():
        ffig = Toplevel()
        ffig.title("Figure Name")
        Label(ffig,text="Fig. Name:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=0,column=0,sticky=W)
        figg=Entry(ffig)
        figg.insert(10,"dde_timeseries.png")
        figg.grid(row=0, column=1,sticky=W)
        def save_ffig():
            plt.savefig(str(figg.get()))
            print("Figure is saved as : \""+str(figg.get())+"\"")

        Button(ffig, text="Save", command=save_ffig, bg="Green",fg="White", relief=RAISED,borderwidth=4).grid(row=1, column=0)
        Button(ffig, text="Close", command=ffig.destroy, bg="Red",fg="White", relief=RAISED,borderwidth=4).grid(row=1, column=1)

#**************************************
    winn=Tk()

    winn.title("4. My System!")
    Label(winn,text="Solve My Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=0)

    global tottim
    global steph
    global transient

    #  plotting visualization------------
    Button(winn,text='Visuals',command=vis,bg="Green",fg="White", relief=RAISED,borderwidth=4).grid(row=1, sticky=W, pady=4)
    Button(winn,text='Data',command=new_save_data,bg="Orange",fg="Black",font = "Helvetica 12 bold", relief=RAISED,borderwidth=4).grid(row=1, column=2, sticky=W, pady=4)
    Button(winn,text='Save figure',command=new_save_figure,bg="Cyan",fg="Black",font = "Helvetica 12 bold", relief=RAISED,borderwidth=4).grid(row=1, column=4, sticky=W, pady=4)
    
    #----    
    Label(winn,text="Total Time:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=2,column=0)
    tottim=Entry(winn)
    tottim.insert(10,"100")
    Label(winn,text="Step Size:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=2,column=2)
    steph=Entry(winn)
    steph.insert(10,"0.01")
    Label(winn,text="Transients:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=2,column=4)
    transient=Entry(winn)
    transient.insert(10,"0")

    tottim.grid(row=2, column=1)
    steph.grid(row=2, column=3)
    transient.grid(row=2, column=5)

    global paramid
    paramid=[]
    for pp1 in range(parnum):
        paramid.append("e"+str(pp1))
        parr1=str(param[pp1])
        parrlo=float(parlo[pp1].get())
        parrhi=float(parhi[pp1].get())
        print parrlo,parrhi, parr1
        paramid[pp1]=Scale(winn, from_=parrlo, to=parrhi, resolution=0.01, label=parr1, activebackground="green", orient=HORIZONTAL)
        paramid[pp1].grid(row=pp1+4, column=0,columnspan=6,sticky=W+E)

    global delaytau
    delaytau=Scale(winn,from_=str(delalo.get()),to=str(delahi.get()),resolution=0.01,label=str(dela.get()),activebackground="green",orient=HORIZONTAL)
    delaytau.grid(row=parnum+5,column=0,columnspan=6,sticky=W+E)

    Button(winn,text='QUIT',command=winn.destroy,bg="Red",fg="White", relief=RAISED,borderwidth=4).grid(row=pp1+4+parnum+1+dim, column=0, sticky=W, pady=4)
#    Button(winn,text='SAVE_Data',command=lorenz_save_data,bg="Cyan",fg="Blue").grid(row=7, column=1, sticky=W, pady=4)
#    Button(winn,text='SAVE_Fig',command=lorenz_save,bg="Cyan",fg="Blue").grid(row=7, column=2, sticky=W, pady=4)
    Button(winn,text='ACCEPT',command=my_prog,bg="Yellow",fg="Blue", relief=RAISED,borderwidth=4).grid(row=pp1+4+parnum+1+dim, column=2, sticky=W, pady=4)
    Button(winn,text='RUN',command=execute_file,bg="Yellow",fg="Blue", relief=RAISED,borderwidth=4).grid(row=pp1+4+parnum+1+dim, column=3, sticky=W, pady=4)

    winn.mainloop()

#**********Parameter(s) and Equation Entry Window***************
def new_syst():
    global my_new_syst
    try:
        global dim
        dim=int(e1.get())#page-104
        global parnum
        parnum=int(e2.get())
    except ValueError as err:
        print("Error: Enter both Dimension and/or No. of Parameters")

    #************New Window****************
    wind=Tk()
    wind.title("3. Parameter(s) and Equation Entry Window!")

    Label(wind,text="This is your system!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)

    Label(wind,text="Parameters' name(s)!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=1,column=0,sticky=W)
    Label(wind,text="Parameters' range(s)!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=1,column=3)

    global par,parlo,parhi
    par=[]
    parlo=[]
    parhi=[]
    for ent1 in range(parnum):
        par.append("ee"+str(ent1))
        parlo.append("eelo"+str(ent1))
        parhi.append("eehi"+str(ent1))
#    print par, parlo,parhi        

    for ent in range(parnum):
	parr="Par_"+str(ent)
        Label(wind,text=parr,bg="white",fg="black",font = "Helvetica 12 italic").grid(row=ent+2,column=0)
        par[ent]=Entry(wind)
        par[ent].grid(row=ent+2, column=1)

        Label(wind,text=",from->",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=ent+2,column=2)
        parlo[ent]=Entry(wind)
        parlo[ent].grid(row=ent+2, column=3)

        Label(wind,text=",to->",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=ent+2,column=4)
        parhi[ent]=Entry(wind)
        parhi[ent].grid(row=ent+2, column=5)

    #delay entry--------------------------------------
    Label(wind,text="    Delay -->",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=parnum+2,column=0,sticky=W)
    Label(wind,text="Delay Range!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=parnum+2,column=3)

    global dela,delalo,delahi
    Label(wind, text="Delay",bg="white",fg="black",font="Helvetica 12 italic").grid(row=parnum+3,column=0)
    dela=Entry(wind)
    dela.grid(row=parnum+3,column=1)

    Label(wind,text=",from->",bg="white",fg="black",font="Helvetical 12 italic").grid(row=parnum+3,column=2)
    delalo=Entry(wind)
    delalo.grid(row=parnum+3,column=3)

    Label(wind,text=",to->",bg="white",fg="black",font="Helvetica 12 italic").grid(row=parnum+3,column=4)
    delahi=Entry(wind)
    delahi.grid(row=parnum+3,column=5)
    #--------------------------------------------------

    Label(wind,text="Equations with parameters!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=parnum+4,column=0,sticky=W)
    Label(wind,text="History function!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=parnum+4,column=4)

    #******************Eqution Entry*****************
    global eeqq,inita
    eeqq=[]
    inita=[]
    for eqs1 in range(dim):
        eeqq.append("eeq"+str(eqs1))
        inita.append("init"+str(eqs1))
#        print eeq
#        print "arr=", eeqq
    #************************************************
    for eqs in range(dim):
        nam="Eq_"+str(eqs)
        naminit="Init_x"+str(eqs)
        Label(wind,text=nam,bg="white",fg="black",font="Helvetica 12 italic").grid(row=eqs+parnum+5,column=0)
        eeqq[eqs]=Entry(wind)
        eeqq[eqs].grid(row=eqs+parnum+5,column=1,columnspan=3,sticky=W+E)  
        Label(wind,text=naminit,bg="white",fg="black",font="Helvetica 12 italic").grid(row=eqs+parnum+5,column=4)
        inita[eqs]=Entry(wind)      
    	inita[eqs].grid(row=eqs+parnum+5,column=5)

    Button(wind,text='QUIT',command=wind.destroy,bg="Red",fg="White", relief=RAISED,borderwidth=4).grid(row=dim+parnum+7, column=0, sticky=W, pady=4)
    Button(wind,text='ACCEPT',command=my_new_syst,bg="Yellow",fg="Blue", relief=RAISED,borderwidth=4).grid(row=dim+parnum+7, column=3, sticky=W, pady=4)
    
    wind.mainloop()

#**************Dimension and Parameter Window********************************
win_new=Tk()

win_new.title("2. Dimension and Parameter Window!")

Label(win_new,text="This is your system!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)

global e1
global e2
global e3
Label(win_new,text="Dimension:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=4,column=0)
e1=Entry(win_new)
#w2.pack()
Label(win_new,text="No. of Parameters:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=5,column=0)
e2=Entry(win_new)
Label(win_new,text="No. of Delay:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=6,column=0)
e3=Entry(win_new)
e3.insert(10,"1")

e1.grid(row=4, column=1)
e2.grid(row=5, column=1)
e3.grid(row=6, column=1)

Button(win_new,text='QUIT',command=quit,bg="Red",fg="White", relief=RAISED,borderwidth=4).grid(row=8, column=0, sticky=W, pady=4)
Button(win_new,text='ACCEPT',command=new_syst,bg="Yellow",fg="Blue", relief=RAISED,borderwidth=4).grid(row=8, column=3, sticky=W, pady=4)

win_new.mainloop()
