from Tkinter import *
import numpy as np
from pydelay import dde23
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

tfinal=300.0
t_trans=0.0
h=0.01
t_instant=t_trans+2.06
t_delayed=tfinal-2.06
print("Maximum time = "+str(tfinal))

eqns = {
    'x0' : '-a*x0+b*(-n*x0(t-tau)+m*tanh(l*x0(t-tau)))'
    }
params = {
    'tau':2.06,
    'a' : 1.0,
    'b' : 1.0,
    'n' : 2.2,
    'm' : 1.0,
    'l' : 10.0
    }

dde = dde23(eqns=eqns, params=params)
dde.set_sim_params(tfinal, dtmax=1.0)

histfunc = {
    'x0': lambda t: 0.9
    }

dde.hist_from_funcs(histfunc, 500)

dde.run()

sol1 = dde.sample(t_instant,tfinal,h)
x0sol1=sol1['x0']
t=sol1['t']

sol2 = dde.sample(t_trans,t_delayed,h)
x0Tsol2=sol2['x0']


print("Handling Data...")
global data
data=np.hstack((np.vstack(t),np.vstack(x0sol1),np.vstack(x0Tsol2)))

print data

print("Plotting Data...")
plt.figure(0)
plt.subplot2grid((1, 3), (0, 0), colspan=2)
plt.plot(t,x0sol1)
plt.subplot2grid((1, 3), (0, 2), rowspan=1)
plt.plot(x0sol1,x0Tsol2)
#plt.xlabel("$t$")
#plt.ylabel("$x(t)$")

plt.show()
