from Tkinter import *
import numpy as np
from pydelay import dde23
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

tfinal=200.0
t_trans=20.0
h=0.01
t_instant=t_trans+4.0
t_delayed=tfinal-4.0
print("Maximum time = "+str(tfinal))

eqns = {
    'x0' : '-x0+b*(-2.2*x0(t-tau)+1*tanh(10*x0(t-tau)))'
    }
params = {
    'tau':4.0,
    'b' : 0.89
    }

dde = dde23(eqns=eqns, params=params)
dde.set_sim_params(tfinal, dtmax=1.0)

histfunc = {
    'x0': lambda t: 0.8
    }

dde.hist_from_funcs(histfunc, 500)

dde.run()

sol1 = dde.sample(t_instant,tfinal,h)
x0sol1=sol1['x0']
t=sol1['t']

sol2 = dde.sample(t_trans,t_delayed,h)
x0Tsol2=sol2['x0']

print("Handling Data...")
global data
data=np.hstack((np.vstack(t),np.vstack(x0sol1),np.vstack(x0Tsol2)))

for i in range(2000):
    data=np.delete(data,0,0)

print("Plotting Data...")
plt.figure(0)
plt.subplot2grid((1, 3), (0, 0), colspan=2)
plt.plot(data[:,0],data[:,1])
plt.plot(data[:,0],data[:,2])
plt.subplot2grid((1, 3), (0, 2),rowspan=1)
plt.plot(data[:,1],data[:,2])

plt.show()
