from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

t_max=100.0
h=0.01
print("Maximum time = "+str(t_max))

def system(u,t):
    x0,x1=u
    w=2.56
    x0d=x1
    x1d=-w*x0
    return[x0d,x1d]

u0=[0.5,0.3]
t=np.arange(0,t_max,h)
print("Running ODEINT()...")
u=odeint(system,u0,t)

print("Handling Data...")
tt=np.vstack(t) # stacks row-wise
global data
data=np.hstack((tt,u))

for i in range(0):
    data=np.delete(data,0,0)

print("Plotting Data...")
plt.figure(0)
plt.subplot2grid((1, 1), (0, 0))
plt.plot(data[:,1],data[:,2])

plt.xlabel("$t$")
plt.ylabel("$x(t)$")

plt.show()
