from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

t_max=100
h=1.0
print("Maximum time = "+str(t_max))
t=np.linspace(0,t_max,t_max)
r=3.56
x0=np.zeros(t_max)
x0[0]=0.1
for k in range(0,t_max-1,1):
    x0[k+1]=r*x0[k]*(1-x0[k])

print("Handling Data...")
global data
data=np.hstack((np.vstack(t),np.vstack(x0)))

for i in range(20):
    data=np.delete(data,0,0)

print("Plotting Data...")
plt.figure(0)
plt.subplot2grid((1, 1), (0, 0))
plt.plot(data[:,0],data[:,1])
plt.xlabel("$t$")
plt.ylabel("$x(t)$")

plt.show()
