from Tkinter import *
import numpy as np
from scipy.integrate import odeint
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
#fp=open("test.txt","w")

print ""
print " __    _____   ___  ____  ___  ____  ____   ___ "
print "(  )  (  _  ) / __)(_  _)/ __)(_  _)(_  _) / __)"
print " )(__  )(_)( ( (_-. _)(_ \__ \  )(   _)(_ ( (__ "
print "(____)(_____) \___/(____)(___/ (__) (____) \___)"
print ""

def logistic_solv():
	t_tot=100
	r=float(e1.get())
	t=np.linspace(0,t_tot,t_tot)	

	x=np.zeros(t_tot)

	x[0]=0.1

	for k in range(0,t_tot-1,1):
		x[k+1]=r*x[k]*(1-x[k])

	print("Handling Data...")
	tt=np.vstack(t) # stacks row-wise
	xx=np.vstack(x)
	#print tt
	global data
	data=np.hstack((tt,xx)) # stacks column-wise

	print("Plotting...")
	plt.plot(data[:,0],data[:,1],marker='o')
	plt.xlabel("$t$")
	plt.ylabel("$x_n(t)$")

	plt.hold(False)

	plt.show()

def logistic_save_data():
	datt='log_time.dat'
	np.savetxt(datt, data)
	print("Data is saved as : "+datt)

def logistic_save_data():
	datt='log_time.dat'
	np.savetxt(datt, data)
	print("Data is saved as : "+datt)
	
def logistic_save():
	figg='lor.png'
	plt.savefig(figg)
	print("Figure is saved as : "+figg)

#**************GUI Data Entry********************************
win=Tk()

win.title("It's Logistic Map man!")

Label(win,text="Solve logistic Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)
Label(win,text="The simplified mathematical model for atmospheric convection developed by Edward logistic.\n The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=1)
Label(win,text="x_(n+1)=r*x_n*(1-x_n),",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=1)
Label(win,text="Chaotic for r=3.6.",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=1)

global e1

e1=Scale(win, from_=0, to=4,length=400, resolution=0.01, label="Enter r:", activebackground="green", orient=HORIZONTAL)
e1.set(3.6)
#w2.pack()

e1.grid(row=4, column=1)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=7, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=logistic_save_data,bg="Cyan",fg="Blue").grid(row=7, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=logistic_save,bg="Cyan",fg="Blue").grid(row=7, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=logistic_solv,bg="Yellow",fg="Blue").grid(row=7, column=3, sticky=W, pady=4)

win.mainloop()

