from Tkinter import *
import numpy as np
from matplotlib import *
from scipy import *
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

#np.fp=open("ddex.txt", "w")
print ""
print " ____   ____   ____  _  _ "
print "(  _ \ (  _ \ ( ___)( \/ )"
print " )(_) ) )(_) ) )__)  )  ( "
print "(____/ (____/ (____)(_/\_)"
print ""

def dde_solv():
	#parameters
	a=1
	n=2.2
	m=1
	l=10
	# Get from GUI
	b=float(e1.get())
	tau=float(e2.get())
	print("b = %f,\ttau = %f"%(b,tau))

	#Them the time interval and the step size
	t_ini=0
	t_fin=1000
	h=0.01
	numsteps=int((t_fin-t_ini)/h)
	delay=int(tau/h)
	print "Total number=", numsteps, "\t delay points=", delay

	#using this parameters we build the time.
	global linspace
	t=np.linspace(t_ini,t_fin,numsteps)
#	print t
#	t=[]
#	for ttt in arange(t_ini,t_fin+h,h):
#		t.append(ttt)

#	print t

	x=np.zeros(numsteps)
	y=np.zeros(numsteps)
	x1=np.zeros(numsteps)
	y1=np.zeros(numsteps)

	#function definition
	def fn_ddex(x_n,y_n,a,b,n,m,l):
		f1=-a*x_n+b*(-n*y_n+m*np.tanh(l*y_n))
		return f1

	#RK4 k's
	def num_ddex(x_n,y_n,h,a,b,n,m,l):
		k1=h*fn_ddex(x_n,y_n,a,b,n,m,l)
		m1=h*fn_ddex(x_n,y_n,a,b,n,m,l)

		k2=h*fn_ddex(x_n+0.5*k1,y_n+0.5*m1,a,b,n,m,l)
		m2=h*fn_ddex(x_n+0.5*k1,y_n+0.5*m1,a,b,n,m,l)

		k3=h*fn_ddex(x_n+0.5*k2,y_n+0.5*m2,a,b,n,m,l)
		m3=h*fn_ddex(x_n+0.5*k2,y_n+0.5*m2,a,b,n,m,l)

		k4=h*fn_ddex(x_n+k3,y_n+m3,a,b,n,m,l)
		m4=h*fn_ddex(x_n+k3,y_n+m3,a,b,n,m,l)

	    	x_n1=x_n+(k1+2*(k2+k3)+k4)/6
	    	y_n1=y_n+(m1+2*(m2+m3)+m4)/6  
	    	return x_n1,y_n1

	#We set the initial conditions
	for k in range(delay-1):
		x[k]=0.9

	#main loop
	print "Started RK4 method..."
	for k in range(delay,x.size-1):
		y[k]=x[k-delay-1]
		[x[k+1],y[k+1]]=num_ddex(x[k],y[k],t[k+1]-t[k],a,b,n,m,l)
		if k>=20000:#to leave the transients
			x1[k]=x[k]
			y1[k]=y[k]
			#np.fp.write("{}\t{}\t{}\n".format(t[k+1],x[k+1],y[k+1]))
	print "Completed RK4 method..."

	print("Handling Data...")
	tt=np.vstack(t) # stacks row-wise
	xx=np.vstack(x)
	yy=np.vstack(y)
	#print tt
	global data
	data=np.hstack((tt,xx,yy))

	print("Plotting...")
	plt.figure(0)
	plt.subplot2grid((2, 2), (0, 0), colspan=1)
	plt.plot(t,x,color='red',lw=1,label='x(t)')
	plt.xlabel("$t$")
	plt.ylabel("$x(t)$")
	plt.legend()
	plt.axis((600,t_fin,min(x),max(x)))

	plt.subplot2grid((2, 2), (1, 0), colspan=1)
	plt.plot(t,y,color='green',lw=1,label='x_T(t)')
	plt.xlabel("$t$")
	plt.ylabel("$y(t)$")
	plt.legend()
	plt.axis((600,t_fin,min(y),max(y)))

	plt.subplot2grid((2, 2), (0, 1), rowspan=2)
	plt.plot(x1,y1,color='green',lw=1,label='x(t)-x_T(t)')
	plt.xlabel("$x(t)$")
	plt.ylabel("$x_T(t)$")
	plt.legend()
	plt.axis((min(x),max(x),min(y),max(y)))

	plt.show()

#	fig = figure()
#	ax1 = fig.add_axes([0.1, 0.6, 0.4, 0.3]) #[left,bottom,width,height] in 0-1 relative figure coordinates
#	ax2 = fig.add_axes([0.1, 0.2, 0.4, 0.3])
#	ax3 = fig.add_axes([0.57, 0.25, 0.37, 0.5])

#	#And we add vectors to each plot
#	ax1.plot(t, x,color='red',lw=1,label='x(t)')
#	ax1.set_xlabel('t')
#	ax1.set_ylabel('x(t)')
#	ax1.legend()
#	ax1.axis((600,t_fin,min(x),max(x)))

#	ax2.plot(t, y,color='green',lw=1,label='x_T(t)')
#	ax2.set_xlabel('t')
#	ax2.set_ylabel('x_T(t)')
#	ax2.legend()
#	ax2.axis((600,t_fin,min(y),max(y)))

#	ax3.plot(x1, y1,color='blue',lw=1,label='x-x_T')
#	ax3.set_xlabel('x(t)')
#	ax3.set_ylabel('x_T(t)')
#	ax3.legend()
#	ax3.axis((min(x),max(x),min(y),max(y)))

#	print "Congrats....! All went well....!\n"
#	#When finished we show the figure with all the plots.
#	show()

def dde_save_data():
	datt='dde_time.dat'
	np.savetxt(datt, data)
	print("Data is saved as : "+datt)

def dde_save():
	figg='dde.png'
	plt.savefig(figg)
	print("Figure is saved as : "+figg)

#**************GUI Data Entry********************************
win=Tk()

win.title("It's DDEX System man!")

Label(win,text="Solve Mackey-Glass Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=0)
Label(win,text="The mathematical model for blood production in patients with leukemia\n is given by Mackey-Glass model Tanmoy Banerjee and Debabrata Biswas\n modelled a similar system that can produce a qualitatively equivalent \nsystem that corresponds to MG system. The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=0)
Label(win,text="x'=-a*x(t)+b*[-n*x(t-tau)+m*tanh(l*x(t-tau))],",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=0)
Label(win,text="Chaos is observed for a=1, b=1 tau=4, n=2.2, m=1 and l=10.",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=0)

global e1
global e2

#Label(win,text="Enter b:").grid(row=1)
e1=Scale(win, from_=0, to=1,length=400, resolution=0.01, label="Enter b:", activebackground="green", orient=HORIZONTAL)
e1.set(1)

#Label(win,text="Enter tau: ").grid(row=2)
e2=Scale(win, from_=0, to=10,length=400, resolution=0.1, label="Enter tau:", activebackground="green", orient=HORIZONTAL)
e2.set(4)

e1.grid(row=4, column=0)
e2.grid(row=5, column=0)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=6, column=0, sticky=W, pady=4)
Button(win,text='SAVE_Data',command=dde_save_data,bg="Cyan",fg="Blue").grid(row=6, column=1, sticky=W, pady=4)
Button(win,text='SAVE_Fig',command=dde_save,bg="Cyan",fg="Blue").grid(row=6, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=dde_solv,bg="Yellow",fg="Blue").grid(row=6, column=3, sticky=W, pady=4)

win.mainloop()





