# import pydelay and numpy and pylab
from Tkinter import *
import numpy as np
#import pylab as pl
from pydelay import dde23
import matplotlib.pyplot as plt

print ""
print " ____   ____   ____  _   _  _    _ "
print "(  _ \ (  _ \ ( ___)( )_( )( \/\/ )"
print " )(_) ) )(_) ) )__)  ) _ (  )    ( "
print "(____/ (____/ (____)(_) (_)(__/\__)"
print ""

def ddehw_solv():
	t_trans=9000
	tfinal=10000
	t_instant=t_trans+float(e2.get())
	t_delayed=tfinal-float(e2.get())
	h=0.01
	# define the equations

	print "Calculating..."
	eqns = {
	    'x' : '-a*x-b*(-0.5*n*(fabs(x(t-tau))+x(t-tau))+m*tanh(l*x(t-tau)))'
	    }

	#define the parameters
	params = {
	    'tau': float(e2.get()),
	    'a'  : 1,
	    'b'  : float(e1.get()),
	    'n'  : 1.15,
	    'm'  : 0.97,
	    'l'  : 2.19
	    }

	# Initialise the solver
	dde = dde23(eqns=eqns, params=params)

	# set the simulation parameters
	# (solve from t=0 to t=1000 and limit the maximum step size to 1.0)
	dde.set_sim_params(tfinal, dtmax=1.0)

	# set the history of to the constant function 0.5 (using a python lambda function)
	histfunc = {
	    'x': lambda t: 0.2
	    }
	dde.hist_from_funcs(histfunc, 51)

	# run the simulator
	dde.run()

	# Make a plot of x(t) vs x(t-tau):
	# Sample the solution twice with a stepsize of dt=0.1:

	# once in the interval [517, 1000]
	sol1 = dde.sample(t_instant,tfinal,h)
	x1 = sol1['x']
	t  = sol1['t']
#	print t

	# and once between [500, 1000-15]
	sol2 = dde.sample(t_trans,t_delayed, h)
	x2 = sol2['x']

#	#====================================================
#	tt=np.vstack(t) # stacks row-wise
#	#print tt
#	global data
#	data=np.hstack((tt,x1)) # stacks column-wise
##	global data1
##	data1=np.hstack((data,x2))

	print "Plotting Data..."
	plt.figure(0)
	plt.subplot(2,1,1)
	plt.plot(t,x1,color="red")
#	plt.plot(t,x2)
	plt.xlabel('$t$')
	plt.ylabel('$x(t),x(t-tau)$')
	plt.axis((9850,tfinal,min(x1),max(x1)))

	plt.hold(False)

	plt.subplot(2,1,2)
	plt.plot(x1, x2)
	plt.xlabel('$x(t)$')
	plt.ylabel('$x(t-tau)$')

	plt.hold(False)
	plt.show()

#**************GUI Data Entry********************************
win=Tk()

win.title("It's DDEHW System man!")

Label(win,text="Solve Mackey-Glass Equation!",bg="Green",fg="white",font = "Helvetica 12 bold italic").grid(row=0,column=1)
Label(win,text="The mathematical model invented by Tanmoy Banerjee and Debabrata Biswas.\n The mathematical form is given as:",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=1,column=1)
Label(win,text="x'=-a*x-b*(-0.5*n*(fabs(x(t-tau))+x(t-tau))+m*tanh(l*x(t-tau))),",bg="white",fg="blue",font = "Helvetica 12 italic").grid(row=2,column=1)
Label(win,text="Chaos is observed for a=1, b=1.7 tau=3, n=1.15, m=0.97 and l=2.19..",bg="white",fg="black",font = "Helvetica 12 italic").grid(row=3,column=1)

global e1
global e2

e1=Scale(win, from_=0, to=3,length=400, resolution=0.01, activebackground="green", label="Enter b:", orient=HORIZONTAL)
e1.set(2)

e2=Scale(win, from_=0, to=5,length=400, resolution=0.1, activebackground="green", label="Enter tau:", orient=HORIZONTAL)
e2.set(3)

e1.grid(row=4, column=1)
e2.grid(row=5, column=1)

Button(win,text='QUIT',command=quit,bg="Red",fg="White").grid(row=6, column=0, sticky=W, pady=4)
#Button(win,text='SAVE_Data',command=dde_save_data,bg="Cyan",fg="Blue").grid(row=6, column=1, sticky=W, pady=4)
#Button(win,text='SAVE_Fig',command=dde_save,bg="Cyan",fg="Blue").grid(row=6, column=2, sticky=W, pady=4)
Button(win,text='RUN',command=ddehw_solv,bg="Yellow",fg="Blue").grid(row=6, column=3, sticky=W, pady=4)

win.mainloop()
